/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Arrays;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class StylesheetFunctionLibrary
implements FunctionLibrary {
    private PrincipalStylesheetModule stylesheet;
    private boolean overriding;

    public StylesheetFunctionLibrary(PrincipalStylesheetModule sheet, boolean overriding) {
        this.stylesheet = sheet;
        this.overriding = overriding;
    }

    public boolean isOverriding() {
        return this.overriding;
    }

    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        XSLFunction fn = this.stylesheet.getFunction(functionName, arity);
        if (fn != null) {
            if (arity < 0) {
                arity = fn.getNumberOfArguments();
            }
            Object[] sig = new SequenceType[arity + 1];
            UserFunction uf = fn.getCompiledFunction();
            if (uf == null) {
                Arrays.fill(sig, SequenceType.ANY_SEQUENCE);
            } else {
                UserFunctionParameter[] params = uf.getParameterDefinitions();
                sig[0] = uf.getResultType(this.stylesheet.getPreparedStylesheet().getConfiguration().getTypeHierarchy());
                for (int i = 0; i < params.length; ++i) {
                    sig[i + 1] = params[i].getRequiredType();
                }
            }
            return sig;
        }
        return null;
    }

    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        XSLFunction fn = this.stylesheet.getFunction(functionName, staticArgs.length);
        if (fn == null) {
            return null;
        }
        if (fn.isOverriding() != this.overriding) {
            return null;
        }
        UserFunctionCall fc = new UserFunctionCall();
        fn.registerReference(fc);
        fc.setFunctionName(functionName);
        fc.setArguments(staticArgs);
        fc.setContainer(container);
        return fc;
    }

    public FunctionLibrary copy() {
        return this;
    }
}

