/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Type;

public abstract class Aggregate
extends Type {
    private final int type;
    private final int size;
    private final int align;
    private final long handle;
    private volatile boolean disposed = false;

    public Aggregate(long handle) {
        if (handle == 0L) {
            throw new NullPointerException("Invalid ffi_type handle");
        }
        this.handle = handle;
        this.type = Foreign.getInstance().getTypeType(handle);
        this.size = Foreign.getInstance().getTypeSize(handle);
        this.align = Foreign.getInstance().getTypeAlign(handle);
    }

    final long handle() {
        return this.handle;
    }

    public final int type() {
        return this.type;
    }

    public final int size() {
        return this.size;
    }

    public final int alignment() {
        return this.align;
    }

    public final synchronized void dispose() {
        if (this.disposed) {
            throw new RuntimeException("native handle already freed");
        }
        this.disposed = true;
        Foreign.getInstance().freeAggregate(this.handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.disposed) {
                this.dispose();
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            super.finalize();
        }
    }
}

