/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLOtherwise;
import com.icl.saxon.style.XSLWhen;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLChoose
extends StyleElement {
    private StyleElement otherwise;

    public boolean isInstruction() {
        return true;
    }

    public boolean doesPostProcessing() {
        return false;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            this.checkUnknownAttribute(n2);
            ++n;
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        NodeImpl nodeImpl = null;
        NodeImpl nodeImpl2 = (NodeImpl)this.getFirstChild();
        while (nodeImpl2 != null) {
            if (nodeImpl2 instanceof XSLWhen) {
                if (this.otherwise != null) {
                    this.compileError("xsl:otherwise must come last");
                }
                nodeImpl = nodeImpl2;
            } else if (nodeImpl2 instanceof XSLOtherwise) {
                if (this.otherwise != null) {
                    this.compileError("Only one xsl:otherwise allowed in an xsl:choose");
                } else {
                    this.otherwise = (StyleElement)nodeImpl2;
                }
            } else {
                this.compileError("Only xsl:when and xsl:otherwise are allowed here");
            }
            nodeImpl2 = (NodeImpl)nodeImpl2.getNextSibling();
        }
        if (nodeImpl == null) {
            this.compileError("xsl:choose must contain at least one xsl:when");
        }
    }

    public void process(Context context) throws TransformerException {
        boolean bl = context.getController().isTracing();
        StyleElement styleElement = (StyleElement)this.getFirstChild();
        while (styleElement != null) {
            boolean bl2 = styleElement instanceof XSLWhen ? ((XSLWhen)styleElement).getCondition().evaluateAsBoolean(context) : true;
            if (bl2) {
                if (bl) {
                    TraceListener traceListener = context.getController().getTraceListener();
                    traceListener.enter(styleElement, context);
                    styleElement.process(context);
                    traceListener.leave(styleElement, context);
                } else {
                    styleElement.process(context);
                }
                styleElement = null;
                continue;
            }
            styleElement = (StyleElement)styleElement.getNextSibling();
        }
    }
}

