/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.helpers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

public abstract class FileURI {
    protected static Logger logger = Logger.getLogger("org.xmlresolver");

    protected FileURI() {
    }

    public static URI makeURI(String pathname) {
        String userdir = System.getProperty("user.dir");
        userdir = userdir.replace('\\', '/');
        String sep = "/";
        if (userdir.endsWith("/")) {
            sep = "";
        }
        try {
            if (pathname.startsWith("/")) {
                return new URI("file://" + pathname);
            }
            URI file = null;
            file = userdir.startsWith("/") ? new URI("file://" + userdir + sep + pathname) : new URI("file:///" + userdir + sep + pathname);
            return file;
        }
        catch (URISyntaxException use) {
            logger.warning("Invalid URI syntax in base URI: " + pathname + " (in " + userdir + " with \"" + sep + "\")");
            return null;
        }
    }
}

