/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.om.Name;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.XSLStringConstructor;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLProcessingInstruction
extends XSLStringConstructor {
    Expression name;

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
        } else {
            this.name = this.makeAttributeValueTemplate(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.optimize();
    }

    public void process(Context context) throws TransformerException {
        String string = this.name.evaluateAsString(context);
        if (!Name.isNCName(string) || string.equalsIgnoreCase("xml")) {
            context.getController().reportRecoverableError("Processing instruction name is invalid: " + string, this);
            return;
        }
        String string2 = this.expandChildren(context);
        int n = string2.indexOf("?>");
        if (n >= 0) {
            context.getController().reportRecoverableError("Invalid characters (?>) in processing instruction", this);
            string2 = string2.substring(0, n + 1) + " " + string2.substring(n + 1);
        }
        context.getOutputter().writePI(string, string2);
    }
}

