/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.PrecisionDecimalValue;

public abstract class Calculator
implements Serializable {
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int TIMES = 2;
    public static final int DIV = 3;
    public static final int MOD = 4;
    public static final int IDIV = 5;
    public static final Calculator[] ANY_ANY = new Calculator[]{new AnyPlusAny(), new AnyMinusAny(), new AnyTimesAny(), new AnyDivAny(), new AnyModAny(), new AnyIdivAny()};
    public static final Calculator[] DOUBLE_DOUBLE = new Calculator[]{new DoublePlusDouble(), new DoubleMinusDouble(), new DoubleTimesDouble(), new DoubleDivDouble(), new DoubleModDouble(), new DoubleIdivDouble()};
    public static final Calculator[] DOUBLE_FLOAT = DOUBLE_DOUBLE;
    public static final Calculator[] DOUBLE_DECIMAL = DOUBLE_DOUBLE;
    public static final Calculator[] DOUBLE_PDECIMAL = DOUBLE_DOUBLE;
    public static final Calculator[] DOUBLE_INTEGER = DOUBLE_DOUBLE;
    public static final Calculator[] FLOAT_DOUBLE = DOUBLE_DOUBLE;
    public static final Calculator[] FLOAT_FLOAT = new Calculator[]{new FloatPlusFloat(), new FloatMinusFloat(), new FloatTimesFloat(), new FloatDivFloat(), new FloatModFloat(), new FloatIdivFloat()};
    public static final Calculator[] FLOAT_DECIMAL = FLOAT_FLOAT;
    public static final Calculator[] FLOAT_PDECIMAL = FLOAT_FLOAT;
    public static final Calculator[] FLOAT_INTEGER = FLOAT_FLOAT;
    public static final Calculator[] DECIMAL_DOUBLE = DOUBLE_DOUBLE;
    public static final Calculator[] DECIMAL_FLOAT = FLOAT_FLOAT;
    public static final Calculator[] DECIMAL_DECIMAL = new Calculator[]{new DecimalPlusDecimal(), new DecimalMinusDecimal(), new DecimalTimesDecimal(), new DecimalDivDecimal(), new DecimalModDecimal(), new DecimalIdivDecimal()};
    public static final Calculator[] DECIMAL_INTEGER = DECIMAL_DECIMAL;
    public static final Calculator[] INTEGER_DOUBLE = DOUBLE_DOUBLE;
    public static final Calculator[] INTEGER_FLOAT = FLOAT_FLOAT;
    public static final Calculator[] INTEGER_DECIMAL = DECIMAL_DECIMAL;
    public static final Calculator[] INTEGER_INTEGER = new Calculator[]{new IntegerPlusInteger(), new IntegerMinusInteger(), new IntegerTimesInteger(), new IntegerDivInteger(), new IntegerModInteger(), new IntegerIdivInteger()};
    public static final Calculator[] PDECIMAL_DOUBLE = DOUBLE_DOUBLE;
    public static final Calculator[] PDECIMAL_FLOAT = FLOAT_FLOAT;
    public static final Calculator[] PDECIMAL_PDECIMAL = new Calculator[]{new PDecimalPlusPDecimal(), new PDecimalMinusPDecimal(), new PDecimalTimesPDecimal(), new PDecimalDivPDecimal(), new PDecimalModPDecimal(), new DecimalIdivDecimal()};
    public static final Calculator[] PDECIMAL_DECIMAL = PDECIMAL_PDECIMAL;
    public static final Calculator[] PDECIMAL_INTEGER = PDECIMAL_PDECIMAL;
    public static final Calculator[] DECIMAL_PDECIMAL = PDECIMAL_PDECIMAL;
    public static final Calculator[] DATETIME_DATETIME = new Calculator[]{null, new DateTimeMinusDateTime(), null, null, null, null};
    public static final Calculator[] DATETIME_DURATION = new Calculator[]{new DateTimePlusDuration(), new DateTimeMinusDuration(), null, null, null, null};
    public static final Calculator[] DURATION_DATETIME = new Calculator[]{new DurationPlusDateTime(), null, null, null, null, null};
    public static final Calculator[] DURATION_DURATION = new Calculator[]{new DurationPlusDuration(), new DurationMinusDuration(), null, new DurationDivDuration(), null, null};
    public static final Calculator[] DURATION_NUMERIC = new Calculator[]{null, null, new DurationTimesNumeric(), new DurationDivNumeric(), null, null};
    public static final Calculator[] NUMERIC_DURATION = new Calculator[]{null, null, new NumericTimesDuration(), null, null, null};
    private static IntHashMap<Calculator[]> table = new IntHashMap(100);
    private static IntHashMap<String> nameTable = new IntHashMap(100);

    private static void def(int typeA, int typeB, Calculator[] calculatorSet, String setName) {
        int key = (typeA & 0xFFFF) << 16 | typeB & 0xFFFF;
        table.put(key, calculatorSet);
        nameTable.put(key, setName);
        if (typeA == 518) {
            Calculator.def(634, typeB, calculatorSet, setName);
            Calculator.def(633, typeB, calculatorSet, setName);
        }
        if (typeB == 518) {
            Calculator.def(typeA, 634, calculatorSet, setName);
            Calculator.def(typeA, 633, calculatorSet, setName);
        }
        if (typeA == 519) {
            Calculator.def(521, typeB, calculatorSet, setName);
            Calculator.def(520, typeB, calculatorSet, setName);
        }
        if (typeB == 519) {
            Calculator.def(typeA, 521, calculatorSet, setName);
            Calculator.def(typeA, 520, calculatorSet, setName);
        }
        if (typeA == 517) {
            Calculator.def(631, typeB, calculatorSet, setName);
        }
        if (typeB == 517) {
            Calculator.def(typeA, 631, calculatorSet, setName);
        }
    }

    public static Calculator getCalculator(int typeA, int typeB, int operator, boolean mustResolve) {
        int key = (typeA & 0xFFFF) << 16 | typeB & 0xFFFF;
        Calculator[] set = table.get(key);
        if (set == null) {
            if (mustResolve) {
                return null;
            }
            return ANY_ANY[operator];
        }
        return set[operator];
    }

    public static String getCalculatorSetName(int typeA, int typeB) {
        int key = (typeA & 0xFFFF) << 16 | typeB & 0xFFFF;
        return nameTable.get(key);
    }

    public abstract AtomicValue compute(AtomicValue var1, AtomicValue var2, XPathContext var3) throws XPathException;

    public abstract AtomicType getResultType(AtomicType var1, AtomicType var2);

    public static DecimalValue decimalDivide(NumericValue a, NumericValue b) throws XPathException {
        BigDecimal A = a.getDecimalValue();
        BigDecimal B = b.getDecimalValue();
        int scale = Math.max(18, Math.max(A.scale(), B.scale()));
        try {
            BigDecimal result = A.divide(B, scale, 5);
            return new DecimalValue(result);
        }
        catch (ArithmeticException err) {
            if (b.compareTo(0L) == 0) {
                throw new XPathException("Decimal divide by zero", "FOAR0001");
            }
            throw err;
        }
    }

    static {
        Calculator.def(517, 517, DOUBLE_DOUBLE, "DOUBLE_DOUBLE");
        Calculator.def(517, 516, DOUBLE_FLOAT, "DOUBLE_FLOAT");
        Calculator.def(517, 515, DOUBLE_DECIMAL, "DOUBLE_DECIMAL");
        Calculator.def(517, 532, DOUBLE_PDECIMAL, "DOUBLE_PDECIMAL");
        Calculator.def(517, 533, DOUBLE_INTEGER, "DOUBLE_INTEGER");
        Calculator.def(516, 517, FLOAT_DOUBLE, "FLOAT_DOUBLE");
        Calculator.def(516, 516, FLOAT_FLOAT, "FLOAT_FLOAT");
        Calculator.def(516, 515, FLOAT_DECIMAL, "FLOAT_DECIMAL");
        Calculator.def(516, 532, FLOAT_PDECIMAL, "FLOAT_PDECIMAL");
        Calculator.def(516, 533, FLOAT_INTEGER, "FLOAT_INTEGER");
        Calculator.def(515, 517, DECIMAL_DOUBLE, "DECIMAL_DOUBLE");
        Calculator.def(515, 516, DECIMAL_FLOAT, "DECIMAL_FLOAT");
        Calculator.def(515, 515, DECIMAL_DECIMAL, "DECIMAL_DECIMAL");
        Calculator.def(515, 532, DECIMAL_PDECIMAL, "DECIMAL_PDECIMAL");
        Calculator.def(515, 533, DECIMAL_INTEGER, "DECIMAL_INTEGER");
        Calculator.def(533, 517, INTEGER_DOUBLE, "INTEGER_DOUBLE");
        Calculator.def(533, 516, INTEGER_FLOAT, "INTEGER_FLOAT");
        Calculator.def(533, 515, INTEGER_DECIMAL, "INTEGER_DECIMAL");
        Calculator.def(533, 533, INTEGER_INTEGER, "INTEGER_INTEGER");
        Calculator.def(532, 517, PDECIMAL_DOUBLE, "PDECIMAL_DOUBLE");
        Calculator.def(532, 516, PDECIMAL_FLOAT, "PDECIMAL_FLOAT");
        Calculator.def(532, 515, PDECIMAL_DECIMAL, "PDECIMAL_DECIMAL");
        Calculator.def(532, 532, PDECIMAL_PDECIMAL, "PDECIMAL_PDECIMAL");
        Calculator.def(532, 533, PDECIMAL_INTEGER, "PDECIMAL_INTEGER");
        Calculator.def(519, 519, DATETIME_DATETIME, "DATETIME_DATETIME");
        Calculator.def(519, 518, DATETIME_DURATION, "DATETIME_DURATION");
        Calculator.def(518, 519, DURATION_DATETIME, "DURATION_DATETIME");
        Calculator.def(518, 518, DURATION_DURATION, "DURATION_DURATION");
        Calculator.def(518, 517, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.def(518, 516, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.def(518, 515, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.def(518, 533, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.def(517, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.def(516, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.def(515, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.def(532, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.def(533, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
    }

    private static class DurationDivNumeric
    extends Calculator {
        private DurationDivNumeric() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            double d = 1.0 / ((NumericValue)b).getDoubleValue();
            return ((DurationValue)a).multiply(d);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeA;
        }
    }

    private static class NumericTimesDuration
    extends Calculator {
        private NumericTimesDuration() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((DurationValue)b).multiply(((NumericValue)a).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeB;
        }
    }

    private static class DurationTimesNumeric
    extends Calculator {
        private DurationTimesNumeric() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((DurationValue)a).multiply(((NumericValue)b).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeA;
        }
    }

    private static class DurationDivDuration
    extends Calculator {
        private DurationDivDuration() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((DurationValue)a).divide((DurationValue)b);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DurationMinusDuration
    extends Calculator {
        private DurationMinusDuration() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((DurationValue)a).subtract((DurationValue)b);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeA;
        }
    }

    private static class DurationPlusDuration
    extends Calculator {
        private DurationPlusDuration() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((DurationValue)a).add((DurationValue)b);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeA;
        }
    }

    private static class DurationPlusDateTime
    extends Calculator {
        private DurationPlusDateTime() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((CalendarValue)b).add((DurationValue)a);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeB;
        }
    }

    private static class DateTimeMinusDuration
    extends Calculator {
        private DateTimeMinusDuration() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((CalendarValue)a).add(((DurationValue)b).multiply(-1.0));
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeA;
        }
    }

    private static class DateTimePlusDuration
    extends Calculator {
        private DateTimePlusDuration() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((CalendarValue)a).add((DurationValue)b);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return typeA;
        }
    }

    private static class DateTimeMinusDateTime
    extends Calculator {
        private DateTimeMinusDateTime() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((CalendarValue)a).subtract((CalendarValue)b, c);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DAY_TIME_DURATION;
        }
    }

    private static class IntegerIdivInteger
    extends Calculator {
        private IntegerIdivInteger() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((IntegerValue)a).idiv((IntegerValue)b);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class IntegerModInteger
    extends Calculator {
        private IntegerModInteger() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((IntegerValue)a).mod((IntegerValue)b);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class IntegerDivInteger
    extends Calculator {
        private IntegerDivInteger() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((IntegerValue)a).div((IntegerValue)b);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class IntegerTimesInteger
    extends Calculator {
        private IntegerTimesInteger() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((IntegerValue)a).times((IntegerValue)b);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class IntegerMinusInteger
    extends Calculator {
        private IntegerMinusInteger() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((IntegerValue)a).minus((IntegerValue)b);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class IntegerPlusInteger
    extends Calculator {
        private IntegerPlusInteger() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return ((IntegerValue)a).plus((IntegerValue)b);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class PDecimalModPDecimal
    extends Calculator {
        private PDecimalModPDecimal() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).mod((IntegerValue)b);
            }
            if (a.isNaN() || b.isNaN()) {
                return PrecisionDecimalValue.NaN;
            }
            if (a instanceof PrecisionDecimalValue && ((PrecisionDecimalValue)a).isInfinite() || b instanceof PrecisionDecimalValue && ((PrecisionDecimalValue)b).isInfinite()) {
                return new PrecisionDecimalValue(((DoubleValue)DOUBLE_DOUBLE[4].compute(a, b, c)).getDoubleValue());
            }
            BigDecimal A = ((NumericValue)a).getDecimalValue();
            BigDecimal B = ((NumericValue)b).getDecimalValue();
            try {
                BigDecimal quotient = A.divide(B, 0, 1);
                BigDecimal remainder = A.subtract(quotient.multiply(B));
                return new PrecisionDecimalValue(remainder);
            }
            catch (ArithmeticException err) {
                if (((NumericValue)b).compareTo(0L) == 0) {
                    throw new XPathException("Decimal modulo zero", "FOAR0001", c);
                }
                throw err;
            }
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class PDecimalDivPDecimal
    extends Calculator {
        private PDecimalDivPDecimal() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a.isNaN() || b.isNaN()) {
                return PrecisionDecimalValue.NaN;
            }
            if (a instanceof PrecisionDecimalValue && ((PrecisionDecimalValue)a).isInfinite() || b instanceof PrecisionDecimalValue && ((PrecisionDecimalValue)b).isInfinite()) {
                return new PrecisionDecimalValue(((DoubleValue)DOUBLE_DOUBLE[3].compute(a, b, c)).getDoubleValue());
            }
            BigDecimal A = ((NumericValue)a).getDecimalValue();
            BigDecimal B = ((NumericValue)b).getDecimalValue();
            int scale = Math.max(18, Math.max(A.scale(), B.scale()));
            try {
                BigDecimal result = A.divide(B, scale, 5);
                return new PrecisionDecimalValue(result);
            }
            catch (ArithmeticException err) {
                if (((NumericValue)b).compareTo(0L) == 0) {
                    throw new XPathException("PrecisionDecimal divide by zero", "FOAR0001", c);
                }
                throw err;
            }
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class PDecimalTimesPDecimal
    extends Calculator {
        private PDecimalTimesPDecimal() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).times((IntegerValue)b);
            }
            if (a.isNaN() || b.isNaN()) {
                return PrecisionDecimalValue.NaN;
            }
            if (a instanceof PrecisionDecimalValue && ((PrecisionDecimalValue)a).isInfinite() || b instanceof PrecisionDecimalValue && ((PrecisionDecimalValue)b).isInfinite()) {
                return new PrecisionDecimalValue(((DoubleValue)DOUBLE_DOUBLE[2].compute(a, b, c)).getDoubleValue());
            }
            return new PrecisionDecimalValue(((NumericValue)a).getDecimalValue().multiply(((NumericValue)b).getDecimalValue()));
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.PRECISION_DECIMAL;
        }
    }

    private static class PDecimalMinusPDecimal
    extends Calculator {
        private PDecimalMinusPDecimal() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).minus((IntegerValue)b);
            }
            if (a.isNaN() || b.isNaN()) {
                return PrecisionDecimalValue.NaN;
            }
            if (a instanceof PrecisionDecimalValue && ((PrecisionDecimalValue)a).isInfinite() || b instanceof PrecisionDecimalValue && ((PrecisionDecimalValue)b).isInfinite()) {
                return new PrecisionDecimalValue(((DoubleValue)DOUBLE_DOUBLE[1].compute(a, b, c)).getDoubleValue());
            }
            return new PrecisionDecimalValue(((NumericValue)a).getDecimalValue().subtract(((NumericValue)b).getDecimalValue()));
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.PRECISION_DECIMAL;
        }
    }

    private static class PDecimalPlusPDecimal
    extends Calculator {
        private PDecimalPlusPDecimal() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).plus((IntegerValue)b);
            }
            if (a.isNaN() || b.isNaN()) {
                return PrecisionDecimalValue.NaN;
            }
            if (a instanceof PrecisionDecimalValue && ((PrecisionDecimalValue)a).isInfinite() || b instanceof PrecisionDecimalValue && ((PrecisionDecimalValue)b).isInfinite()) {
                return new PrecisionDecimalValue(((DoubleValue)DOUBLE_DOUBLE[0].compute(a, b, c)).getDoubleValue());
            }
            return new PrecisionDecimalValue(((NumericValue)a).getDecimalValue().add(((NumericValue)b).getDecimalValue()));
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.PRECISION_DECIMAL;
        }
    }

    private static class DecimalIdivDecimal
    extends Calculator {
        private DecimalIdivDecimal() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).idiv((IntegerValue)b);
            }
            BigDecimal A = ((NumericValue)a).getDecimalValue();
            BigDecimal B = ((NumericValue)b).getDecimalValue();
            if (B.signum() == 0) {
                throw new XPathException("Integer division by zero", "FOAR0001", c);
            }
            BigInteger quot = A.divideToIntegralValue(B).toBigInteger();
            return BigIntegerValue.makeIntegerValue(quot);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class DecimalModDecimal
    extends Calculator {
        private DecimalModDecimal() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).mod((IntegerValue)b);
            }
            BigDecimal A = ((NumericValue)a).getDecimalValue();
            BigDecimal B = ((NumericValue)b).getDecimalValue();
            try {
                return new DecimalValue(A.remainder(B));
            }
            catch (ArithmeticException err) {
                if (((NumericValue)b).compareTo(0L) == 0) {
                    throw new XPathException("Decimal modulo zero", "FOAR0001", c);
                }
                throw err;
            }
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DecimalDivDecimal
    extends Calculator {
        private DecimalDivDecimal() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return DecimalDivDecimal.decimalDivide((NumericValue)a, (NumericValue)b);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DecimalTimesDecimal
    extends Calculator {
        private DecimalTimesDecimal() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).times((IntegerValue)b);
            }
            return new DecimalValue(((NumericValue)a).getDecimalValue().multiply(((NumericValue)b).getDecimalValue()));
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DecimalMinusDecimal
    extends Calculator {
        private DecimalMinusDecimal() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).minus((IntegerValue)b);
            }
            return new DecimalValue(((NumericValue)a).getDecimalValue().subtract(((NumericValue)b).getDecimalValue()));
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DecimalPlusDecimal
    extends Calculator {
        private DecimalPlusDecimal() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            if (a instanceof IntegerValue && b instanceof IntegerValue) {
                return ((IntegerValue)a).plus((IntegerValue)b);
            }
            return new DecimalValue(((NumericValue)a).getDecimalValue().add(((NumericValue)b).getDecimalValue()));
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class FloatIdivFloat
    extends Calculator {
        private FloatIdivFloat() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            float A = ((NumericValue)a).getFloatValue();
            float B = ((NumericValue)b).getFloatValue();
            if ((double)B == 0.0) {
                throw new XPathException("Integer division by zero", "FOAR0001", c);
            }
            if (Double.isNaN(A) || Double.isInfinite(A)) {
                throw new XPathException("First operand of idiv is NaN or infinity", "FOAR0002", c);
            }
            if (Double.isNaN(B)) {
                throw new XPathException("Second operand of idiv is NaN", "FOAR0002", c);
            }
            return new FloatValue(A / B).convert(BuiltInAtomicType.INTEGER, true, c.getConfiguration().getConversionRules()).asAtomic();
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class FloatModFloat
    extends Calculator {
        private FloatModFloat() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new FloatValue(((NumericValue)a).getFloatValue() % ((NumericValue)b).getFloatValue());
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class FloatDivFloat
    extends Calculator {
        private FloatDivFloat() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new FloatValue(((NumericValue)a).getFloatValue() / ((NumericValue)b).getFloatValue());
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class FloatTimesFloat
    extends Calculator {
        private FloatTimesFloat() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new FloatValue(((NumericValue)a).getFloatValue() * ((NumericValue)b).getFloatValue());
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class FloatMinusFloat
    extends Calculator {
        private FloatMinusFloat() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new FloatValue(((NumericValue)a).getFloatValue() - ((NumericValue)b).getFloatValue());
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class FloatPlusFloat
    extends Calculator {
        private FloatPlusFloat() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new FloatValue(((NumericValue)a).getFloatValue() + ((NumericValue)b).getFloatValue());
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class DoubleIdivDouble
    extends Calculator {
        private DoubleIdivDouble() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            double A = ((NumericValue)a).getDoubleValue();
            double B = ((NumericValue)b).getDoubleValue();
            if (B == 0.0) {
                throw new XPathException("Integer division by zero", "FOAR0001", c);
            }
            if (Double.isNaN(A) || Double.isInfinite(A)) {
                throw new XPathException("First operand of idiv is NaN or infinity", "FOAR0002", c);
            }
            if (Double.isNaN(B)) {
                throw new XPathException("Second operand of idiv is NaN", "FOAR0002", c);
            }
            return new DoubleValue(A / B).convert(BuiltInAtomicType.INTEGER, true, c.getConfiguration().getConversionRules()).asAtomic();
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class DoubleModDouble
    extends Calculator {
        private DoubleModDouble() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new DoubleValue(((NumericValue)a).getDoubleValue() % ((NumericValue)b).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DoubleDivDouble
    extends Calculator {
        private DoubleDivDouble() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new DoubleValue(((NumericValue)a).getDoubleValue() / ((NumericValue)b).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DoubleTimesDouble
    extends Calculator {
        private DoubleTimesDouble() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new DoubleValue(((NumericValue)a).getDoubleValue() * ((NumericValue)b).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DoubleMinusDouble
    extends Calculator {
        private DoubleMinusDouble() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new DoubleValue(((NumericValue)a).getDoubleValue() - ((NumericValue)b).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DoublePlusDouble
    extends Calculator {
        private DoublePlusDouble() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            return new DoubleValue(((NumericValue)a).getDoubleValue() + ((NumericValue)b).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class AnyIdivAny
    extends Calculator {
        private AnyIdivAny() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            TypeHierarchy th = c.getConfiguration().getTypeHierarchy();
            Calculator calc = AnyIdivAny.getCalculator(a.getItemType(th).getPrimitiveType(), b.getItemType(th).getPrimitiveType(), 5, true);
            if (calc == null) {
                throw new XPathException("Unsuitable types for idiv operation (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", c);
            }
            return calc.compute(a, b, c);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyModAny
    extends Calculator {
        private AnyModAny() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            TypeHierarchy th = c.getConfiguration().getTypeHierarchy();
            Calculator calc = AnyModAny.getCalculator(a.getItemType(th).getPrimitiveType(), b.getItemType(th).getPrimitiveType(), 4, true);
            if (calc == null) {
                throw new XPathException("Unsuitable types for mod operation (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", c);
            }
            return calc.compute(a, b, c);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyDivAny
    extends Calculator {
        private AnyDivAny() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            TypeHierarchy th = c.getConfiguration().getTypeHierarchy();
            Calculator calc = AnyDivAny.getCalculator(a.getItemType(th).getPrimitiveType(), b.getItemType(th).getPrimitiveType(), 3, true);
            if (calc == null) {
                throw new XPathException("Unsuitable types for div operation (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", c);
            }
            return calc.compute(a, b, c);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyTimesAny
    extends Calculator {
        private AnyTimesAny() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            TypeHierarchy th = c.getConfiguration().getTypeHierarchy();
            Calculator calc = AnyTimesAny.getCalculator(a.getItemType(th).getPrimitiveType(), b.getItemType(th).getPrimitiveType(), 2, true);
            if (calc == null) {
                throw new XPathException("Unsuitable types for * operation (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", c);
            }
            return calc.compute(a, b, c);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyMinusAny
    extends Calculator {
        private AnyMinusAny() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            TypeHierarchy th = c.getConfiguration().getTypeHierarchy();
            Calculator calc = AnyMinusAny.getCalculator(a.getItemType(th).getPrimitiveType(), b.getItemType(th).getPrimitiveType(), 1, true);
            if (calc == null) {
                throw new XPathException("Unsuitable types for - operation (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", c);
            }
            return calc.compute(a, b, c);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyPlusAny
    extends Calculator {
        private AnyPlusAny() {
        }

        public AtomicValue compute(AtomicValue a, AtomicValue b, XPathContext c) throws XPathException {
            TypeHierarchy th = c.getConfiguration().getTypeHierarchy();
            Calculator calc = AnyPlusAny.getCalculator(a.getItemType(th).getPrimitiveType(), b.getItemType(th).getPrimitiveType(), 0, true);
            if (calc == null) {
                throw new XPathException("Unsuitable types for + operation (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ")", "XPTY0004", c);
            }
            return calc.compute(a, b, c);
        }

        public AtomicType getResultType(AtomicType typeA, AtomicType typeB) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }
}

