//*
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//*
// These .proto interfaces are private and stable.
// Please see http://wiki.apache.org/hadoop/Compatibility
// for what changes are allowed for a *stable* .proto interface.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.4
// source: RpcHeader.proto

package hadoop_common

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

//*
// RpcKind determine the rpcEngine and the serialization of the rpc request
type RpcKindProto int32

const (
	RpcKindProto_RPC_BUILTIN         RpcKindProto = 0 // Used for built in calls by tests
	RpcKindProto_RPC_WRITABLE        RpcKindProto = 1 // Use WritableRpcEngine
	RpcKindProto_RPC_PROTOCOL_BUFFER RpcKindProto = 2 // Use ProtobufRpcEngine
)

// Enum value maps for RpcKindProto.
var (
	RpcKindProto_name = map[int32]string{
		0: "RPC_BUILTIN",
		1: "RPC_WRITABLE",
		2: "RPC_PROTOCOL_BUFFER",
	}
	RpcKindProto_value = map[string]int32{
		"RPC_BUILTIN":         0,
		"RPC_WRITABLE":        1,
		"RPC_PROTOCOL_BUFFER": 2,
	}
)

func (x RpcKindProto) Enum() *RpcKindProto {
	p := new(RpcKindProto)
	*p = x
	return p
}

func (x RpcKindProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RpcKindProto) Descriptor() protoreflect.EnumDescriptor {
	return file_RpcHeader_proto_enumTypes[0].Descriptor()
}

func (RpcKindProto) Type() protoreflect.EnumType {
	return &file_RpcHeader_proto_enumTypes[0]
}

func (x RpcKindProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *RpcKindProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = RpcKindProto(num)
	return nil
}

// Deprecated: Use RpcKindProto.Descriptor instead.
func (RpcKindProto) EnumDescriptor() ([]byte, []int) {
	return file_RpcHeader_proto_rawDescGZIP(), []int{0}
}

type RpcRequestHeaderProto_OperationProto int32

const (
	RpcRequestHeaderProto_RPC_FINAL_PACKET        RpcRequestHeaderProto_OperationProto = 0 // The final RPC Packet
	RpcRequestHeaderProto_RPC_CONTINUATION_PACKET RpcRequestHeaderProto_OperationProto = 1 // not implemented yet
	RpcRequestHeaderProto_RPC_CLOSE_CONNECTION    RpcRequestHeaderProto_OperationProto = 2 // close the rpc connection
)

// Enum value maps for RpcRequestHeaderProto_OperationProto.
var (
	RpcRequestHeaderProto_OperationProto_name = map[int32]string{
		0: "RPC_FINAL_PACKET",
		1: "RPC_CONTINUATION_PACKET",
		2: "RPC_CLOSE_CONNECTION",
	}
	RpcRequestHeaderProto_OperationProto_value = map[string]int32{
		"RPC_FINAL_PACKET":        0,
		"RPC_CONTINUATION_PACKET": 1,
		"RPC_CLOSE_CONNECTION":    2,
	}
)

func (x RpcRequestHeaderProto_OperationProto) Enum() *RpcRequestHeaderProto_OperationProto {
	p := new(RpcRequestHeaderProto_OperationProto)
	*p = x
	return p
}

func (x RpcRequestHeaderProto_OperationProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RpcRequestHeaderProto_OperationProto) Descriptor() protoreflect.EnumDescriptor {
	return file_RpcHeader_proto_enumTypes[1].Descriptor()
}

func (RpcRequestHeaderProto_OperationProto) Type() protoreflect.EnumType {
	return &file_RpcHeader_proto_enumTypes[1]
}

func (x RpcRequestHeaderProto_OperationProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *RpcRequestHeaderProto_OperationProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = RpcRequestHeaderProto_OperationProto(num)
	return nil
}

// Deprecated: Use RpcRequestHeaderProto_OperationProto.Descriptor instead.
func (RpcRequestHeaderProto_OperationProto) EnumDescriptor() ([]byte, []int) {
	return file_RpcHeader_proto_rawDescGZIP(), []int{2, 0}
}

type RpcResponseHeaderProto_RpcStatusProto int32

const (
	RpcResponseHeaderProto_SUCCESS RpcResponseHeaderProto_RpcStatusProto = 0 // RPC succeeded
	RpcResponseHeaderProto_ERROR   RpcResponseHeaderProto_RpcStatusProto = 1 // RPC or error - connection left open for future calls
	RpcResponseHeaderProto_FATAL   RpcResponseHeaderProto_RpcStatusProto = 2 // Fatal error - connection closed
)

// Enum value maps for RpcResponseHeaderProto_RpcStatusProto.
var (
	RpcResponseHeaderProto_RpcStatusProto_name = map[int32]string{
		0: "SUCCESS",
		1: "ERROR",
		2: "FATAL",
	}
	RpcResponseHeaderProto_RpcStatusProto_value = map[string]int32{
		"SUCCESS": 0,
		"ERROR":   1,
		"FATAL":   2,
	}
)

func (x RpcResponseHeaderProto_RpcStatusProto) Enum() *RpcResponseHeaderProto_RpcStatusProto {
	p := new(RpcResponseHeaderProto_RpcStatusProto)
	*p = x
	return p
}

func (x RpcResponseHeaderProto_RpcStatusProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RpcResponseHeaderProto_RpcStatusProto) Descriptor() protoreflect.EnumDescriptor {
	return file_RpcHeader_proto_enumTypes[2].Descriptor()
}

func (RpcResponseHeaderProto_RpcStatusProto) Type() protoreflect.EnumType {
	return &file_RpcHeader_proto_enumTypes[2]
}

func (x RpcResponseHeaderProto_RpcStatusProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *RpcResponseHeaderProto_RpcStatusProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = RpcResponseHeaderProto_RpcStatusProto(num)
	return nil
}

// Deprecated: Use RpcResponseHeaderProto_RpcStatusProto.Descriptor instead.
func (RpcResponseHeaderProto_RpcStatusProto) EnumDescriptor() ([]byte, []int) {
	return file_RpcHeader_proto_rawDescGZIP(), []int{3, 0}
}

type RpcResponseHeaderProto_RpcErrorCodeProto int32

const (
	// Non-fatal Rpc error - connection left open for future rpc calls
	RpcResponseHeaderProto_ERROR_APPLICATION          RpcResponseHeaderProto_RpcErrorCodeProto = 1 // RPC Failed - rpc app threw exception
	RpcResponseHeaderProto_ERROR_NO_SUCH_METHOD       RpcResponseHeaderProto_RpcErrorCodeProto = 2 // Rpc error - no such method
	RpcResponseHeaderProto_ERROR_NO_SUCH_PROTOCOL     RpcResponseHeaderProto_RpcErrorCodeProto = 3 // Rpc error - no such protocol
	RpcResponseHeaderProto_ERROR_RPC_SERVER           RpcResponseHeaderProto_RpcErrorCodeProto = 4 // Rpc error on server side
	RpcResponseHeaderProto_ERROR_SERIALIZING_RESPONSE RpcResponseHeaderProto_RpcErrorCodeProto = 5 // error serializign response
	RpcResponseHeaderProto_ERROR_RPC_VERSION_MISMATCH RpcResponseHeaderProto_RpcErrorCodeProto = 6 // Rpc protocol version mismatch
	// Fatal Server side Rpc error - connection closed
	RpcResponseHeaderProto_FATAL_UNKNOWN                   RpcResponseHeaderProto_RpcErrorCodeProto = 10 // unknown Fatal error
	RpcResponseHeaderProto_FATAL_UNSUPPORTED_SERIALIZATION RpcResponseHeaderProto_RpcErrorCodeProto = 11 // IPC layer serilization type invalid
	RpcResponseHeaderProto_FATAL_INVALID_RPC_HEADER        RpcResponseHeaderProto_RpcErrorCodeProto = 12 // fields of RpcHeader are invalid
	RpcResponseHeaderProto_FATAL_DESERIALIZING_REQUEST     RpcResponseHeaderProto_RpcErrorCodeProto = 13 // could not deserilize rpc request
	RpcResponseHeaderProto_FATAL_VERSION_MISMATCH          RpcResponseHeaderProto_RpcErrorCodeProto = 14 // Ipc Layer version mismatch
	RpcResponseHeaderProto_FATAL_UNAUTHORIZED              RpcResponseHeaderProto_RpcErrorCodeProto = 15 // Auth failed
)

// Enum value maps for RpcResponseHeaderProto_RpcErrorCodeProto.
var (
	RpcResponseHeaderProto_RpcErrorCodeProto_name = map[int32]string{
		1:  "ERROR_APPLICATION",
		2:  "ERROR_NO_SUCH_METHOD",
		3:  "ERROR_NO_SUCH_PROTOCOL",
		4:  "ERROR_RPC_SERVER",
		5:  "ERROR_SERIALIZING_RESPONSE",
		6:  "ERROR_RPC_VERSION_MISMATCH",
		10: "FATAL_UNKNOWN",
		11: "FATAL_UNSUPPORTED_SERIALIZATION",
		12: "FATAL_INVALID_RPC_HEADER",
		13: "FATAL_DESERIALIZING_REQUEST",
		14: "FATAL_VERSION_MISMATCH",
		15: "FATAL_UNAUTHORIZED",
	}
	RpcResponseHeaderProto_RpcErrorCodeProto_value = map[string]int32{
		"ERROR_APPLICATION":               1,
		"ERROR_NO_SUCH_METHOD":            2,
		"ERROR_NO_SUCH_PROTOCOL":          3,
		"ERROR_RPC_SERVER":                4,
		"ERROR_SERIALIZING_RESPONSE":      5,
		"ERROR_RPC_VERSION_MISMATCH":      6,
		"FATAL_UNKNOWN":                   10,
		"FATAL_UNSUPPORTED_SERIALIZATION": 11,
		"FATAL_INVALID_RPC_HEADER":        12,
		"FATAL_DESERIALIZING_REQUEST":     13,
		"FATAL_VERSION_MISMATCH":          14,
		"FATAL_UNAUTHORIZED":              15,
	}
)

func (x RpcResponseHeaderProto_RpcErrorCodeProto) Enum() *RpcResponseHeaderProto_RpcErrorCodeProto {
	p := new(RpcResponseHeaderProto_RpcErrorCodeProto)
	*p = x
	return p
}

func (x RpcResponseHeaderProto_RpcErrorCodeProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RpcResponseHeaderProto_RpcErrorCodeProto) Descriptor() protoreflect.EnumDescriptor {
	return file_RpcHeader_proto_enumTypes[3].Descriptor()
}

func (RpcResponseHeaderProto_RpcErrorCodeProto) Type() protoreflect.EnumType {
	return &file_RpcHeader_proto_enumTypes[3]
}

func (x RpcResponseHeaderProto_RpcErrorCodeProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *RpcResponseHeaderProto_RpcErrorCodeProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = RpcResponseHeaderProto_RpcErrorCodeProto(num)
	return nil
}

// Deprecated: Use RpcResponseHeaderProto_RpcErrorCodeProto.Descriptor instead.
func (RpcResponseHeaderProto_RpcErrorCodeProto) EnumDescriptor() ([]byte, []int) {
	return file_RpcHeader_proto_rawDescGZIP(), []int{3, 1}
}

type RpcSaslProto_SaslState int32

const (
	RpcSaslProto_SUCCESS   RpcSaslProto_SaslState = 0
	RpcSaslProto_NEGOTIATE RpcSaslProto_SaslState = 1
	RpcSaslProto_INITIATE  RpcSaslProto_SaslState = 2
	RpcSaslProto_CHALLENGE RpcSaslProto_SaslState = 3
	RpcSaslProto_RESPONSE  RpcSaslProto_SaslState = 4
	RpcSaslProto_WRAP      RpcSaslProto_SaslState = 5
)

// Enum value maps for RpcSaslProto_SaslState.
var (
	RpcSaslProto_SaslState_name = map[int32]string{
		0: "SUCCESS",
		1: "NEGOTIATE",
		2: "INITIATE",
		3: "CHALLENGE",
		4: "RESPONSE",
		5: "WRAP",
	}
	RpcSaslProto_SaslState_value = map[string]int32{
		"SUCCESS":   0,
		"NEGOTIATE": 1,
		"INITIATE":  2,
		"CHALLENGE": 3,
		"RESPONSE":  4,
		"WRAP":      5,
	}
)

func (x RpcSaslProto_SaslState) Enum() *RpcSaslProto_SaslState {
	p := new(RpcSaslProto_SaslState)
	*p = x
	return p
}

func (x RpcSaslProto_SaslState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RpcSaslProto_SaslState) Descriptor() protoreflect.EnumDescriptor {
	return file_RpcHeader_proto_enumTypes[4].Descriptor()
}

func (RpcSaslProto_SaslState) Type() protoreflect.EnumType {
	return &file_RpcHeader_proto_enumTypes[4]
}

func (x RpcSaslProto_SaslState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *RpcSaslProto_SaslState) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = RpcSaslProto_SaslState(num)
	return nil
}

// Deprecated: Use RpcSaslProto_SaslState.Descriptor instead.
func (RpcSaslProto_SaslState) EnumDescriptor() ([]byte, []int) {
	return file_RpcHeader_proto_rawDescGZIP(), []int{4, 0}
}

//*
// Used to pass through the information necessary to continue
// a trace after an RPC is made. All we need is the traceid
// (so we know the overarching trace this message is a part of), and
// the id of the current span when this message was sent, so we know
// what span caused the new span we will create when this message is received.
type RPCTraceInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TraceId  *int64 `protobuf:"varint,1,opt,name=traceId" json:"traceId,omitempty"`   // parentIdHigh
	ParentId *int64 `protobuf:"varint,2,opt,name=parentId" json:"parentId,omitempty"` // parentIdLow
}

func (x *RPCTraceInfoProto) Reset() {
	*x = RPCTraceInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_RpcHeader_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RPCTraceInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RPCTraceInfoProto) ProtoMessage() {}

func (x *RPCTraceInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_RpcHeader_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RPCTraceInfoProto.ProtoReflect.Descriptor instead.
func (*RPCTraceInfoProto) Descriptor() ([]byte, []int) {
	return file_RpcHeader_proto_rawDescGZIP(), []int{0}
}

func (x *RPCTraceInfoProto) GetTraceId() int64 {
	if x != nil && x.TraceId != nil {
		return *x.TraceId
	}
	return 0
}

func (x *RPCTraceInfoProto) GetParentId() int64 {
	if x != nil && x.ParentId != nil {
		return *x.ParentId
	}
	return 0
}

//*
// Used to pass through the call context entry after an RPC is made.
type RPCCallerContextProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Context   *string `protobuf:"bytes,1,req,name=context" json:"context,omitempty"`
	Signature []byte  `protobuf:"bytes,2,opt,name=signature" json:"signature,omitempty"`
}

func (x *RPCCallerContextProto) Reset() {
	*x = RPCCallerContextProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_RpcHeader_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RPCCallerContextProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RPCCallerContextProto) ProtoMessage() {}

func (x *RPCCallerContextProto) ProtoReflect() protoreflect.Message {
	mi := &file_RpcHeader_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RPCCallerContextProto.ProtoReflect.Descriptor instead.
func (*RPCCallerContextProto) Descriptor() ([]byte, []int) {
	return file_RpcHeader_proto_rawDescGZIP(), []int{1}
}

func (x *RPCCallerContextProto) GetContext() string {
	if x != nil && x.Context != nil {
		return *x.Context
	}
	return ""
}

func (x *RPCCallerContextProto) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

type RpcRequestHeaderProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RpcKind  *RpcKindProto                         `protobuf:"varint,1,opt,name=rpcKind,enum=hadoop.common.RpcKindProto" json:"rpcKind,omitempty"`
	RpcOp    *RpcRequestHeaderProto_OperationProto `protobuf:"varint,2,opt,name=rpcOp,enum=hadoop.common.RpcRequestHeaderProto_OperationProto" json:"rpcOp,omitempty"`
	CallId   *int32                                `protobuf:"zigzag32,3,req,name=callId" json:"callId,omitempty"`  // a sequence number that is sent back in response
	ClientId []byte                                `protobuf:"bytes,4,req,name=clientId" json:"clientId,omitempty"` // Globally unique client ID
	// clientId + callId uniquely identifies a request
	// retry count, 1 means this is the first retry
	RetryCount    *int32                 `protobuf:"zigzag32,5,opt,name=retryCount,def=-1" json:"retryCount,omitempty"`
	TraceInfo     *RPCTraceInfoProto     `protobuf:"bytes,6,opt,name=traceInfo" json:"traceInfo,omitempty"`         // tracing info
	CallerContext *RPCCallerContextProto `protobuf:"bytes,7,opt,name=callerContext" json:"callerContext,omitempty"` // call context
	StateId       *int64                 `protobuf:"varint,8,opt,name=stateId" json:"stateId,omitempty"`            // The last seen Global State ID
}

// Default values for RpcRequestHeaderProto fields.
const (
	Default_RpcRequestHeaderProto_RetryCount = int32(-1)
)

func (x *RpcRequestHeaderProto) Reset() {
	*x = RpcRequestHeaderProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_RpcHeader_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RpcRequestHeaderProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RpcRequestHeaderProto) ProtoMessage() {}

func (x *RpcRequestHeaderProto) ProtoReflect() protoreflect.Message {
	mi := &file_RpcHeader_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RpcRequestHeaderProto.ProtoReflect.Descriptor instead.
func (*RpcRequestHeaderProto) Descriptor() ([]byte, []int) {
	return file_RpcHeader_proto_rawDescGZIP(), []int{2}
}

func (x *RpcRequestHeaderProto) GetRpcKind() RpcKindProto {
	if x != nil && x.RpcKind != nil {
		return *x.RpcKind
	}
	return RpcKindProto_RPC_BUILTIN
}

func (x *RpcRequestHeaderProto) GetRpcOp() RpcRequestHeaderProto_OperationProto {
	if x != nil && x.RpcOp != nil {
		return *x.RpcOp
	}
	return RpcRequestHeaderProto_RPC_FINAL_PACKET
}

func (x *RpcRequestHeaderProto) GetCallId() int32 {
	if x != nil && x.CallId != nil {
		return *x.CallId
	}
	return 0
}

func (x *RpcRequestHeaderProto) GetClientId() []byte {
	if x != nil {
		return x.ClientId
	}
	return nil
}

func (x *RpcRequestHeaderProto) GetRetryCount() int32 {
	if x != nil && x.RetryCount != nil {
		return *x.RetryCount
	}
	return Default_RpcRequestHeaderProto_RetryCount
}

func (x *RpcRequestHeaderProto) GetTraceInfo() *RPCTraceInfoProto {
	if x != nil {
		return x.TraceInfo
	}
	return nil
}

func (x *RpcRequestHeaderProto) GetCallerContext() *RPCCallerContextProto {
	if x != nil {
		return x.CallerContext
	}
	return nil
}

func (x *RpcRequestHeaderProto) GetStateId() int64 {
	if x != nil && x.StateId != nil {
		return *x.StateId
	}
	return 0
}

//*
// Rpc Response Header
// +------------------------------------------------------------------+
// | Rpc total response length in bytes (4 bytes int)                 |
// |  (sum of next two parts)                                         |
// +------------------------------------------------------------------+
// | RpcResponseHeaderProto - serialized delimited ie has len         |
// +------------------------------------------------------------------+
// | if request is successful:                                        |
// |   - RpcResponse -  The actual rpc response  bytes follow         |
// |     the response header                                          |
// |     This response is serialized based on RpcKindProto            |
// | if request fails :                                               |
// |   The rpc response header contains the necessary info            |
// +------------------------------------------------------------------+
//
// Note that rpc response header is also used when connection setup fails.
// Ie the response looks like a rpc response with a fake callId.
type RpcResponseHeaderProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CallId              *uint32                                   `protobuf:"varint,1,req,name=callId" json:"callId,omitempty"` // callId used in Request
	Status              *RpcResponseHeaderProto_RpcStatusProto    `protobuf:"varint,2,req,name=status,enum=hadoop.common.RpcResponseHeaderProto_RpcStatusProto" json:"status,omitempty"`
	ServerIpcVersionNum *uint32                                   `protobuf:"varint,3,opt,name=serverIpcVersionNum" json:"serverIpcVersionNum,omitempty"`                                             // Sent if success or fail
	ExceptionClassName  *string                                   `protobuf:"bytes,4,opt,name=exceptionClassName" json:"exceptionClassName,omitempty"`                                                // if request fails
	ErrorMsg            *string                                   `protobuf:"bytes,5,opt,name=errorMsg" json:"errorMsg,omitempty"`                                                                    // if request fails, often contains strack trace
	ErrorDetail         *RpcResponseHeaderProto_RpcErrorCodeProto `protobuf:"varint,6,opt,name=errorDetail,enum=hadoop.common.RpcResponseHeaderProto_RpcErrorCodeProto" json:"errorDetail,omitempty"` // in case of error
	ClientId            []byte                                    `protobuf:"bytes,7,opt,name=clientId" json:"clientId,omitempty"`                                                                    // Globally unique client ID
	RetryCount          *int32                                    `protobuf:"zigzag32,8,opt,name=retryCount,def=-1" json:"retryCount,omitempty"`
	StateId             *int64                                    `protobuf:"varint,9,opt,name=stateId" json:"stateId,omitempty"` // The last written Global State ID
}

// Default values for RpcResponseHeaderProto fields.
const (
	Default_RpcResponseHeaderProto_RetryCount = int32(-1)
)

func (x *RpcResponseHeaderProto) Reset() {
	*x = RpcResponseHeaderProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_RpcHeader_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RpcResponseHeaderProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RpcResponseHeaderProto) ProtoMessage() {}

func (x *RpcResponseHeaderProto) ProtoReflect() protoreflect.Message {
	mi := &file_RpcHeader_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RpcResponseHeaderProto.ProtoReflect.Descriptor instead.
func (*RpcResponseHeaderProto) Descriptor() ([]byte, []int) {
	return file_RpcHeader_proto_rawDescGZIP(), []int{3}
}

func (x *RpcResponseHeaderProto) GetCallId() uint32 {
	if x != nil && x.CallId != nil {
		return *x.CallId
	}
	return 0
}

func (x *RpcResponseHeaderProto) GetStatus() RpcResponseHeaderProto_RpcStatusProto {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return RpcResponseHeaderProto_SUCCESS
}

func (x *RpcResponseHeaderProto) GetServerIpcVersionNum() uint32 {
	if x != nil && x.ServerIpcVersionNum != nil {
		return *x.ServerIpcVersionNum
	}
	return 0
}

func (x *RpcResponseHeaderProto) GetExceptionClassName() string {
	if x != nil && x.ExceptionClassName != nil {
		return *x.ExceptionClassName
	}
	return ""
}

func (x *RpcResponseHeaderProto) GetErrorMsg() string {
	if x != nil && x.ErrorMsg != nil {
		return *x.ErrorMsg
	}
	return ""
}

func (x *RpcResponseHeaderProto) GetErrorDetail() RpcResponseHeaderProto_RpcErrorCodeProto {
	if x != nil && x.ErrorDetail != nil {
		return *x.ErrorDetail
	}
	return RpcResponseHeaderProto_ERROR_APPLICATION
}

func (x *RpcResponseHeaderProto) GetClientId() []byte {
	if x != nil {
		return x.ClientId
	}
	return nil
}

func (x *RpcResponseHeaderProto) GetRetryCount() int32 {
	if x != nil && x.RetryCount != nil {
		return *x.RetryCount
	}
	return Default_RpcResponseHeaderProto_RetryCount
}

func (x *RpcResponseHeaderProto) GetStateId() int64 {
	if x != nil && x.StateId != nil {
		return *x.StateId
	}
	return 0
}

type RpcSaslProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version *uint32                  `protobuf:"varint,1,opt,name=version" json:"version,omitempty"`
	State   *RpcSaslProto_SaslState  `protobuf:"varint,2,req,name=state,enum=hadoop.common.RpcSaslProto_SaslState" json:"state,omitempty"`
	Token   []byte                   `protobuf:"bytes,3,opt,name=token" json:"token,omitempty"`
	Auths   []*RpcSaslProto_SaslAuth `protobuf:"bytes,4,rep,name=auths" json:"auths,omitempty"`
}

func (x *RpcSaslProto) Reset() {
	*x = RpcSaslProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_RpcHeader_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RpcSaslProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RpcSaslProto) ProtoMessage() {}

func (x *RpcSaslProto) ProtoReflect() protoreflect.Message {
	mi := &file_RpcHeader_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RpcSaslProto.ProtoReflect.Descriptor instead.
func (*RpcSaslProto) Descriptor() ([]byte, []int) {
	return file_RpcHeader_proto_rawDescGZIP(), []int{4}
}

func (x *RpcSaslProto) GetVersion() uint32 {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return 0
}

func (x *RpcSaslProto) GetState() RpcSaslProto_SaslState {
	if x != nil && x.State != nil {
		return *x.State
	}
	return RpcSaslProto_SUCCESS
}

func (x *RpcSaslProto) GetToken() []byte {
	if x != nil {
		return x.Token
	}
	return nil
}

func (x *RpcSaslProto) GetAuths() []*RpcSaslProto_SaslAuth {
	if x != nil {
		return x.Auths
	}
	return nil
}

type RpcSaslProto_SaslAuth struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Method    *string `protobuf:"bytes,1,req,name=method" json:"method,omitempty"`
	Mechanism *string `protobuf:"bytes,2,req,name=mechanism" json:"mechanism,omitempty"`
	Protocol  *string `protobuf:"bytes,3,opt,name=protocol" json:"protocol,omitempty"`
	ServerId  *string `protobuf:"bytes,4,opt,name=serverId" json:"serverId,omitempty"`
	Challenge []byte  `protobuf:"bytes,5,opt,name=challenge" json:"challenge,omitempty"`
}

func (x *RpcSaslProto_SaslAuth) Reset() {
	*x = RpcSaslProto_SaslAuth{}
	if protoimpl.UnsafeEnabled {
		mi := &file_RpcHeader_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RpcSaslProto_SaslAuth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RpcSaslProto_SaslAuth) ProtoMessage() {}

func (x *RpcSaslProto_SaslAuth) ProtoReflect() protoreflect.Message {
	mi := &file_RpcHeader_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RpcSaslProto_SaslAuth.ProtoReflect.Descriptor instead.
func (*RpcSaslProto_SaslAuth) Descriptor() ([]byte, []int) {
	return file_RpcHeader_proto_rawDescGZIP(), []int{4, 0}
}

func (x *RpcSaslProto_SaslAuth) GetMethod() string {
	if x != nil && x.Method != nil {
		return *x.Method
	}
	return ""
}

func (x *RpcSaslProto_SaslAuth) GetMechanism() string {
	if x != nil && x.Mechanism != nil {
		return *x.Mechanism
	}
	return ""
}

func (x *RpcSaslProto_SaslAuth) GetProtocol() string {
	if x != nil && x.Protocol != nil {
		return *x.Protocol
	}
	return ""
}

func (x *RpcSaslProto_SaslAuth) GetServerId() string {
	if x != nil && x.ServerId != nil {
		return *x.ServerId
	}
	return ""
}

func (x *RpcSaslProto_SaslAuth) GetChallenge() []byte {
	if x != nil {
		return x.Challenge
	}
	return nil
}

var File_RpcHeader_proto protoreflect.FileDescriptor

var file_RpcHeader_proto_rawDesc = []byte{
	0x0a, 0x0f, 0x52, 0x70, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x0d, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x22, 0x49, 0x0a, 0x11, 0x52, 0x50, 0x43, 0x54, 0x72, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x0a, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x1a, 0x0a, 0x08, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x08, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0x4f, 0x0a, 0x15, 0x52,
	0x50, 0x43, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1c,
	0x0a, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0xf6, 0x03, 0x0a,
	0x15, 0x52, 0x70, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x35, 0x0a, 0x07, 0x72, 0x70, 0x63, 0x4b, 0x69, 0x6e,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x70, 0x63, 0x4b, 0x69, 0x6e, 0x64, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x07, 0x72, 0x70, 0x63, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x49, 0x0a,
	0x05, 0x72, 0x70, 0x63, 0x4f, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x70, 0x63,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x05, 0x72, 0x70, 0x63, 0x4f, 0x70, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x61, 0x6c, 0x6c,
	0x49, 0x64, 0x18, 0x03, 0x20, 0x02, 0x28, 0x11, 0x52, 0x06, 0x63, 0x61, 0x6c, 0x6c, 0x49, 0x64,
	0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x18, 0x04, 0x20, 0x02,
	0x28, 0x0c, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x11,
	0x3a, 0x02, 0x2d, 0x31, 0x52, 0x0a, 0x72, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x3e, 0x0a, 0x09, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x50, 0x43, 0x54, 0x72, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x4a, 0x0a, 0x0d, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x50, 0x43, 0x43, 0x61, 0x6c, 0x6c, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0d, 0x63,
	0x61, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x18, 0x0a, 0x07,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x49, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x49, 0x64, 0x22, 0x5d, 0x0a, 0x0e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x50, 0x43, 0x5f,
	0x46, 0x49, 0x4e, 0x41, 0x4c, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x00, 0x12, 0x1b,
	0x0a, 0x17, 0x52, 0x50, 0x43, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x49, 0x4e, 0x55, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x52,
	0x50, 0x43, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0xca, 0x06, 0x0a, 0x16, 0x52, 0x70, 0x63, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x16, 0x0a, 0x06, 0x63, 0x61, 0x6c, 0x6c, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0d,
	0x52, 0x06, 0x63, 0x61, 0x6c, 0x6c, 0x49, 0x64, 0x12, 0x4c, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x70, 0x63, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x52, 0x70, 0x63, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x30, 0x0a, 0x13, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x49, 0x70, 0x63, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x70, 0x63, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x12, 0x2e, 0x0a, 0x12, 0x65, 0x78, 0x63, 0x65,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x4d, 0x73, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x4d, 0x73, 0x67, 0x12, 0x59, 0x0a, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x70, 0x63, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x52, 0x70, 0x63, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12,
	0x1a, 0x0a, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x11, 0x3a,
	0x02, 0x2d, 0x31, 0x52, 0x0a, 0x72, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x18, 0x0a, 0x07, 0x73, 0x74, 0x61, 0x74, 0x65, 0x49, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x07, 0x73, 0x74, 0x61, 0x74, 0x65, 0x49, 0x64, 0x22, 0x33, 0x0a, 0x0e, 0x52, 0x70, 0x63,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0b, 0x0a, 0x07, 0x53,
	0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x41, 0x54, 0x41, 0x4c, 0x10, 0x02, 0x22, 0xe1,
	0x02, 0x0a, 0x11, 0x52, 0x70, 0x63, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x41, 0x50,
	0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x5f, 0x4e, 0x4f, 0x5f, 0x53, 0x55, 0x43, 0x48, 0x5f, 0x4d, 0x45, 0x54,
	0x48, 0x4f, 0x44, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x4e,
	0x4f, 0x5f, 0x53, 0x55, 0x43, 0x48, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x10,
	0x03, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x52, 0x50, 0x43, 0x5f, 0x53,
	0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x04, 0x12, 0x1e, 0x0a, 0x1a, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x5f, 0x53, 0x45, 0x52, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x45, 0x53,
	0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x05, 0x12, 0x1e, 0x0a, 0x1a, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x5f, 0x52, 0x50, 0x43, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x49, 0x53,
	0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x46, 0x41, 0x54, 0x41, 0x4c,
	0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x0a, 0x12, 0x23, 0x0a, 0x1f, 0x46, 0x41,
	0x54, 0x41, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f,
	0x53, 0x45, 0x52, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0b, 0x12,
	0x1c, 0x0a, 0x18, 0x46, 0x41, 0x54, 0x41, 0x4c, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44,
	0x5f, 0x52, 0x50, 0x43, 0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x0c, 0x12, 0x1f, 0x0a,
	0x1b, 0x46, 0x41, 0x54, 0x41, 0x4c, 0x5f, 0x44, 0x45, 0x53, 0x45, 0x52, 0x49, 0x41, 0x4c, 0x49,
	0x5a, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x0d, 0x12, 0x1a,
	0x0a, 0x16, 0x46, 0x41, 0x54, 0x41, 0x4c, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x0e, 0x12, 0x16, 0x0a, 0x12, 0x46, 0x41,
	0x54, 0x41, 0x4c, 0x5f, 0x55, 0x4e, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x45, 0x44,
	0x10, 0x0f, 0x22, 0xae, 0x03, 0x0a, 0x0c, 0x52, 0x70, 0x63, 0x53, 0x61, 0x73, 0x6c, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x70, 0x63,
	0x53, 0x61, 0x73, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x61, 0x73, 0x6c, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x3a, 0x0a, 0x05, 0x61, 0x75, 0x74, 0x68, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x52, 0x70, 0x63, 0x53, 0x61, 0x73, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x61, 0x73,
	0x6c, 0x41, 0x75, 0x74, 0x68, 0x52, 0x05, 0x61, 0x75, 0x74, 0x68, 0x73, 0x1a, 0x96, 0x01, 0x0a,
	0x08, 0x53, 0x61, 0x73, 0x6c, 0x41, 0x75, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x18, 0x02,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x12,
	0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c,
	0x65, 0x6e, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6c,
	0x6c, 0x65, 0x6e, 0x67, 0x65, 0x22, 0x5c, 0x0a, 0x09, 0x53, 0x61, 0x73, 0x6c, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x4e, 0x45, 0x47, 0x4f, 0x54, 0x49, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09,
	0x43, 0x48, 0x41, 0x4c, 0x4c, 0x45, 0x4e, 0x47, 0x45, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x52,
	0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x57, 0x52, 0x41,
	0x50, 0x10, 0x05, 0x2a, 0x4a, 0x0a, 0x0c, 0x52, 0x70, 0x63, 0x4b, 0x69, 0x6e, 0x64, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x50, 0x43, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x54,
	0x49, 0x4e, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x50, 0x43, 0x5f, 0x57, 0x52, 0x49, 0x54,
	0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x50, 0x43, 0x5f, 0x50, 0x52,
	0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x42, 0x55, 0x46, 0x46, 0x45, 0x52, 0x10, 0x02, 0x42,
	0x72, 0x0a, 0x1e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x69, 0x70, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x42, 0x0f, 0x52, 0x70, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x5a, 0x3c, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63,
	0x6f, 0x6c, 0x69, 0x6e, 0x6d, 0x61, 0x72, 0x63, 0x2f, 0x68, 0x64, 0x66, 0x73, 0x2f, 0x76, 0x32,
	0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x2f, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0xa0, 0x01, 0x01,
}

var (
	file_RpcHeader_proto_rawDescOnce sync.Once
	file_RpcHeader_proto_rawDescData = file_RpcHeader_proto_rawDesc
)

func file_RpcHeader_proto_rawDescGZIP() []byte {
	file_RpcHeader_proto_rawDescOnce.Do(func() {
		file_RpcHeader_proto_rawDescData = protoimpl.X.CompressGZIP(file_RpcHeader_proto_rawDescData)
	})
	return file_RpcHeader_proto_rawDescData
}

var file_RpcHeader_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_RpcHeader_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_RpcHeader_proto_goTypes = []interface{}{
	(RpcKindProto)(0),                             // 0: hadoop.common.RpcKindProto
	(RpcRequestHeaderProto_OperationProto)(0),     // 1: hadoop.common.RpcRequestHeaderProto.OperationProto
	(RpcResponseHeaderProto_RpcStatusProto)(0),    // 2: hadoop.common.RpcResponseHeaderProto.RpcStatusProto
	(RpcResponseHeaderProto_RpcErrorCodeProto)(0), // 3: hadoop.common.RpcResponseHeaderProto.RpcErrorCodeProto
	(RpcSaslProto_SaslState)(0),                   // 4: hadoop.common.RpcSaslProto.SaslState
	(*RPCTraceInfoProto)(nil),                     // 5: hadoop.common.RPCTraceInfoProto
	(*RPCCallerContextProto)(nil),                 // 6: hadoop.common.RPCCallerContextProto
	(*RpcRequestHeaderProto)(nil),                 // 7: hadoop.common.RpcRequestHeaderProto
	(*RpcResponseHeaderProto)(nil),                // 8: hadoop.common.RpcResponseHeaderProto
	(*RpcSaslProto)(nil),                          // 9: hadoop.common.RpcSaslProto
	(*RpcSaslProto_SaslAuth)(nil),                 // 10: hadoop.common.RpcSaslProto.SaslAuth
}
var file_RpcHeader_proto_depIdxs = []int32{
	0,  // 0: hadoop.common.RpcRequestHeaderProto.rpcKind:type_name -> hadoop.common.RpcKindProto
	1,  // 1: hadoop.common.RpcRequestHeaderProto.rpcOp:type_name -> hadoop.common.RpcRequestHeaderProto.OperationProto
	5,  // 2: hadoop.common.RpcRequestHeaderProto.traceInfo:type_name -> hadoop.common.RPCTraceInfoProto
	6,  // 3: hadoop.common.RpcRequestHeaderProto.callerContext:type_name -> hadoop.common.RPCCallerContextProto
	2,  // 4: hadoop.common.RpcResponseHeaderProto.status:type_name -> hadoop.common.RpcResponseHeaderProto.RpcStatusProto
	3,  // 5: hadoop.common.RpcResponseHeaderProto.errorDetail:type_name -> hadoop.common.RpcResponseHeaderProto.RpcErrorCodeProto
	4,  // 6: hadoop.common.RpcSaslProto.state:type_name -> hadoop.common.RpcSaslProto.SaslState
	10, // 7: hadoop.common.RpcSaslProto.auths:type_name -> hadoop.common.RpcSaslProto.SaslAuth
	8,  // [8:8] is the sub-list for method output_type
	8,  // [8:8] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_RpcHeader_proto_init() }
func file_RpcHeader_proto_init() {
	if File_RpcHeader_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_RpcHeader_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RPCTraceInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_RpcHeader_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RPCCallerContextProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_RpcHeader_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RpcRequestHeaderProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_RpcHeader_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RpcResponseHeaderProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_RpcHeader_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RpcSaslProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_RpcHeader_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RpcSaslProto_SaslAuth); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_RpcHeader_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_RpcHeader_proto_goTypes,
		DependencyIndexes: file_RpcHeader_proto_depIdxs,
		EnumInfos:         file_RpcHeader_proto_enumTypes,
		MessageInfos:      file_RpcHeader_proto_msgTypes,
	}.Build()
	File_RpcHeader_proto = out.File
	file_RpcHeader_proto_rawDesc = nil
	file_RpcHeader_proto_goTypes = nil
	file_RpcHeader_proto_depIdxs = nil
}
