package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGatewayRouteTableEntries invokes the vpc.ListGatewayRouteTableEntries API synchronously
func (client *Client) ListGatewayRouteTableEntries(request *ListGatewayRouteTableEntriesRequest) (response *ListGatewayRouteTableEntriesResponse, err error) {
	response = CreateListGatewayRouteTableEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListGatewayRouteTableEntriesWithChan invokes the vpc.ListGatewayRouteTableEntries API asynchronously
func (client *Client) ListGatewayRouteTableEntriesWithChan(request *ListGatewayRouteTableEntriesRequest) (<-chan *ListGatewayRouteTableEntriesResponse, <-chan error) {
	responseChan := make(chan *ListGatewayRouteTableEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGatewayRouteTableEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGatewayRouteTableEntriesWithCallback invokes the vpc.ListGatewayRouteTableEntries API asynchronously
func (client *Client) ListGatewayRouteTableEntriesWithCallback(request *ListGatewayRouteTableEntriesRequest, callback func(response *ListGatewayRouteTableEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGatewayRouteTableEntriesResponse
		var err error
		defer close(result)
		response, err = client.ListGatewayRouteTableEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGatewayRouteTableEntriesRequest is the request struct for api ListGatewayRouteTableEntries
type ListGatewayRouteTableEntriesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NextToken            string           `position:"Query" name:"NextToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DestinationCidrBlock string           `position:"Query" name:"DestinationCidrBlock"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	GatewayRouteTableId  string           `position:"Query" name:"GatewayRouteTableId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	MaxResults           requests.Integer `position:"Query" name:"MaxResults"`
}

// ListGatewayRouteTableEntriesResponse is the response struct for api ListGatewayRouteTableEntries
type ListGatewayRouteTableEntriesResponse struct {
	*responses.BaseResponse
	NextToken               string                        `json:"NextToken" xml:"NextToken"`
	RequestId               string                        `json:"RequestId" xml:"RequestId"`
	TotalCount              string                        `json:"TotalCount" xml:"TotalCount"`
	GatewayRouteEntryModels []GatewayRouteEntryModelsItem `json:"GatewayRouteEntryModels" xml:"GatewayRouteEntryModels"`
}

// CreateListGatewayRouteTableEntriesRequest creates a request to invoke ListGatewayRouteTableEntries API
func CreateListGatewayRouteTableEntriesRequest() (request *ListGatewayRouteTableEntriesRequest) {
	request = &ListGatewayRouteTableEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListGatewayRouteTableEntries", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGatewayRouteTableEntriesResponse creates a response to parse from ListGatewayRouteTableEntries response
func CreateListGatewayRouteTableEntriesResponse() (response *ListGatewayRouteTableEntriesResponse) {
	response = &ListGatewayRouteTableEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
