package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertRenewInfo invokes the trademark.InsertRenewInfo API synchronously
// api document: https://help.aliyun.com/api/trademark/insertrenewinfo.html
func (client *Client) InsertRenewInfo(request *InsertRenewInfoRequest) (response *InsertRenewInfoResponse, err error) {
	response = CreateInsertRenewInfoResponse()
	err = client.DoAction(request, response)
	return
}

// InsertRenewInfoWithChan invokes the trademark.InsertRenewInfo API asynchronously
// api document: https://help.aliyun.com/api/trademark/insertrenewinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertRenewInfoWithChan(request *InsertRenewInfoRequest) (<-chan *InsertRenewInfoResponse, <-chan error) {
	responseChan := make(chan *InsertRenewInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertRenewInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertRenewInfoWithCallback invokes the trademark.InsertRenewInfo API asynchronously
// api document: https://help.aliyun.com/api/trademark/insertrenewinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertRenewInfoWithCallback(request *InsertRenewInfoRequest, callback func(response *InsertRenewInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertRenewInfoResponse
		var err error
		defer close(result)
		response, err = client.InsertRenewInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertRenewInfoRequest is the request struct for api InsertRenewInfo
type InsertRenewInfoRequest struct {
	*requests.RpcRequest
	EngName      string           `position:"Query" name:"EngName"`
	Address      string           `position:"Query" name:"Address"`
	RegisterTime requests.Integer `position:"Query" name:"RegisterTime"`
	EngAddress   string           `position:"Query" name:"EngAddress"`
	Name         string           `position:"Query" name:"Name"`
}

// InsertRenewInfoResponse is the response struct for api InsertRenewInfo
type InsertRenewInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        int64  `json:"Id" xml:"Id"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateInsertRenewInfoRequest creates a request to invoke InsertRenewInfo API
func CreateInsertRenewInfoRequest() (request *InsertRenewInfoRequest) {
	request = &InsertRenewInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "InsertRenewInfo", "trademark", "openAPI")
	return
}

// CreateInsertRenewInfoResponse creates a response to parse from InsertRenewInfo response
func CreateInsertRenewInfoResponse() (response *InsertRenewInfoResponse) {
	response = &InsertRenewInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
