package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCMSIdByForeignId invokes the scsp.GetCMSIdByForeignId API synchronously
func (client *Client) GetCMSIdByForeignId(request *GetCMSIdByForeignIdRequest) (response *GetCMSIdByForeignIdResponse, err error) {
	response = CreateGetCMSIdByForeignIdResponse()
	err = client.DoAction(request, response)
	return
}

// GetCMSIdByForeignIdWithChan invokes the scsp.GetCMSIdByForeignId API asynchronously
func (client *Client) GetCMSIdByForeignIdWithChan(request *GetCMSIdByForeignIdRequest) (<-chan *GetCMSIdByForeignIdResponse, <-chan error) {
	responseChan := make(chan *GetCMSIdByForeignIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCMSIdByForeignId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCMSIdByForeignIdWithCallback invokes the scsp.GetCMSIdByForeignId API asynchronously
func (client *Client) GetCMSIdByForeignIdWithCallback(request *GetCMSIdByForeignIdRequest, callback func(response *GetCMSIdByForeignIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCMSIdByForeignIdResponse
		var err error
		defer close(result)
		response, err = client.GetCMSIdByForeignId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCMSIdByForeignIdRequest is the request struct for api GetCMSIdByForeignId
type GetCMSIdByForeignIdRequest struct {
	*requests.RpcRequest
	Nick       string           `position:"Query"`
	SourceId   requests.Integer `position:"Query"`
	ForeignId  string           `position:"Query"`
	InstanceId string           `position:"Query"`
}

// GetCMSIdByForeignIdResponse is the response struct for api GetCMSIdByForeignId
type GetCMSIdByForeignIdResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetCMSIdByForeignIdRequest creates a request to invoke GetCMSIdByForeignId API
func CreateGetCMSIdByForeignIdRequest() (request *GetCMSIdByForeignIdRequest) {
	request = &GetCMSIdByForeignIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GetCMSIdByForeignId", "", "")
	request.Method = requests.POST
	return
}

// CreateGetCMSIdByForeignIdResponse creates a response to parse from GetCMSIdByForeignId response
func CreateGetCMSIdByForeignIdResponse() (response *GetCMSIdByForeignIdResponse) {
	response = &GetCMSIdByForeignIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
