package openanalytics

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEndPointByDomain invokes the openanalytics.GetEndPointByDomain API synchronously
// api document: https://help.aliyun.com/api/openanalytics/getendpointbydomain.html
func (client *Client) GetEndPointByDomain(request *GetEndPointByDomainRequest) (response *GetEndPointByDomainResponse, err error) {
	response = CreateGetEndPointByDomainResponse()
	err = client.DoAction(request, response)
	return
}

// GetEndPointByDomainWithChan invokes the openanalytics.GetEndPointByDomain API asynchronously
// api document: https://help.aliyun.com/api/openanalytics/getendpointbydomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetEndPointByDomainWithChan(request *GetEndPointByDomainRequest) (<-chan *GetEndPointByDomainResponse, <-chan error) {
	responseChan := make(chan *GetEndPointByDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEndPointByDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEndPointByDomainWithCallback invokes the openanalytics.GetEndPointByDomain API asynchronously
// api document: https://help.aliyun.com/api/openanalytics/getendpointbydomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetEndPointByDomainWithCallback(request *GetEndPointByDomainRequest, callback func(response *GetEndPointByDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEndPointByDomainResponse
		var err error
		defer close(result)
		response, err = client.GetEndPointByDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEndPointByDomainRequest is the request struct for api GetEndPointByDomain
type GetEndPointByDomainRequest struct {
	*requests.RpcRequest
	UserID    requests.Integer `position:"Body" name:"UserID"`
	DomainURL string           `position:"Body" name:"DomainURL"`
}

// GetEndPointByDomainResponse is the response struct for api GetEndPointByDomain
type GetEndPointByDomainResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	RegionId     string       `json:"RegionId" xml:"RegionId"`
	EndPointInfo EndPointInfo `json:"EndPointInfo" xml:"EndPointInfo"`
}

// CreateGetEndPointByDomainRequest creates a request to invoke GetEndPointByDomain API
func CreateGetEndPointByDomainRequest() (request *GetEndPointByDomainRequest) {
	request = &GetEndPointByDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics", "2018-03-01", "GetEndPointByDomain", "openanalytics", "openAPI")
	return
}

// CreateGetEndPointByDomainResponse creates a response to parse from GetEndPointByDomain response
func CreateGetEndPointByDomainResponse() (response *GetEndPointByDomainResponse) {
	response = &GetEndPointByDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
