package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceConfiguration invokes the idrsservice.GetServiceConfiguration API synchronously
func (client *Client) GetServiceConfiguration(request *GetServiceConfigurationRequest) (response *GetServiceConfigurationResponse, err error) {
	response = CreateGetServiceConfigurationResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceConfigurationWithChan invokes the idrsservice.GetServiceConfiguration API asynchronously
func (client *Client) GetServiceConfigurationWithChan(request *GetServiceConfigurationRequest) (<-chan *GetServiceConfigurationResponse, <-chan error) {
	responseChan := make(chan *GetServiceConfigurationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceConfiguration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceConfigurationWithCallback invokes the idrsservice.GetServiceConfiguration API asynchronously
func (client *Client) GetServiceConfigurationWithCallback(request *GetServiceConfigurationRequest, callback func(response *GetServiceConfigurationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceConfigurationResponse
		var err error
		defer close(result)
		response, err = client.GetServiceConfiguration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceConfigurationRequest is the request struct for api GetServiceConfiguration
type GetServiceConfigurationRequest struct {
	*requests.RpcRequest
	UserId string `position:"Query" name:"UserId"`
}

// GetServiceConfigurationResponse is the response struct for api GetServiceConfiguration
type GetServiceConfigurationResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetServiceConfigurationRequest creates a request to invoke GetServiceConfiguration API
func CreateGetServiceConfigurationRequest() (request *GetServiceConfigurationRequest) {
	request = &GetServiceConfigurationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "GetServiceConfiguration", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetServiceConfigurationResponse creates a response to parse from GetServiceConfiguration response
func CreateGetServiceConfigurationResponse() (response *GetServiceConfigurationResponse) {
	response = &GetServiceConfigurationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
