package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCallTask invokes the dyvmsapi.ListCallTask API synchronously
func (client *Client) ListCallTask(request *ListCallTaskRequest) (response *ListCallTaskResponse, err error) {
	response = CreateListCallTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ListCallTaskWithChan invokes the dyvmsapi.ListCallTask API asynchronously
func (client *Client) ListCallTaskWithChan(request *ListCallTaskRequest) (<-chan *ListCallTaskResponse, <-chan error) {
	responseChan := make(chan *ListCallTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCallTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCallTaskWithCallback invokes the dyvmsapi.ListCallTask API asynchronously
func (client *Client) ListCallTaskWithCallback(request *ListCallTaskRequest, callback func(response *ListCallTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCallTaskResponse
		var err error
		defer close(result)
		response, err = client.ListCallTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCallTaskRequest is the request struct for api ListCallTask
type ListCallTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TaskName             string           `position:"Query" name:"TaskName"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	TemplateName         string           `position:"Query" name:"TemplateName"`
	TaskId               string           `position:"Query" name:"TaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	BizType              string           `position:"Query" name:"BizType"`
	Status               string           `position:"Query" name:"Status"`
}

// ListCallTaskResponse is the response struct for api ListCallTask
type ListCallTaskResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Code       string     `json:"Code" xml:"Code"`
	PageNumber int64      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64      `json:"PageSize" xml:"PageSize"`
	Total      int64      `json:"Total" xml:"Total"`
	Data       []DataItem `json:"Data" xml:"Data"`
}

// CreateListCallTaskRequest creates a request to invoke ListCallTask API
func CreateListCallTaskRequest() (request *ListCallTaskRequest) {
	request = &ListCallTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "ListCallTask", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCallTaskResponse creates a response to parse from ListCallTask response
func CreateListCallTaskResponse() (response *ListCallTaskResponse) {
	response = &ListCallTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
