package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAntChainTransactionStatistics invokes the baas.DescribeAntChainTransactionStatistics API synchronously
// api document: https://help.aliyun.com/api/baas/describeantchaintransactionstatistics.html
func (client *Client) DescribeAntChainTransactionStatistics(request *DescribeAntChainTransactionStatisticsRequest) (response *DescribeAntChainTransactionStatisticsResponse, err error) {
	response = CreateDescribeAntChainTransactionStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAntChainTransactionStatisticsWithChan invokes the baas.DescribeAntChainTransactionStatistics API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchaintransactionstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainTransactionStatisticsWithChan(request *DescribeAntChainTransactionStatisticsRequest) (<-chan *DescribeAntChainTransactionStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeAntChainTransactionStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAntChainTransactionStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAntChainTransactionStatisticsWithCallback invokes the baas.DescribeAntChainTransactionStatistics API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchaintransactionstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainTransactionStatisticsWithCallback(request *DescribeAntChainTransactionStatisticsRequest, callback func(response *DescribeAntChainTransactionStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAntChainTransactionStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAntChainTransactionStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAntChainTransactionStatisticsRequest is the request struct for api DescribeAntChainTransactionStatistics
type DescribeAntChainTransactionStatisticsRequest struct {
	*requests.RpcRequest
	Start      requests.Integer `position:"Body" name:"Start"`
	AntChainId string           `position:"Body" name:"AntChainId"`
	End        requests.Integer `position:"Body" name:"End"`
}

// DescribeAntChainTransactionStatisticsResponse is the response struct for api DescribeAntChainTransactionStatistics
type DescribeAntChainTransactionStatisticsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateDescribeAntChainTransactionStatisticsRequest creates a request to invoke DescribeAntChainTransactionStatistics API
func CreateDescribeAntChainTransactionStatisticsRequest() (request *DescribeAntChainTransactionStatisticsRequest) {
	request = &DescribeAntChainTransactionStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeAntChainTransactionStatistics", "baas", "openAPI")
	return
}

// CreateDescribeAntChainTransactionStatisticsResponse creates a response to parse from DescribeAntChainTransactionStatistics response
func CreateDescribeAntChainTransactionStatisticsResponse() (response *DescribeAntChainTransactionStatisticsResponse) {
	response = &DescribeAntChainTransactionStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
