//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// `NSScrubberLayoutAttributes`describes the layout of a single
    /// `NSScrubber`item.
    ///
    /// `NSScrubberLayout`objects transact in terms of
    /// `NSScrubberLayoutAttributes.``NSScrubberLayoutAttributes`can be subclassed if a layout object wants to include more layout information than the base implementation provides. Subclasses of
    /// `NSScrubberLayoutAttributes`must implement
    /// `isEqual:,``hash,`and the
    /// `NSCopying`protocol.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrubberlayoutattributes?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSScrubberLayoutAttributes;
);

extern_conformance!(
    unsafe impl NSCopying for NSScrubberLayoutAttributes {}
);

unsafe impl CopyingHelper for NSScrubberLayoutAttributes {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSScrubberLayoutAttributes {}
);

impl NSScrubberLayoutAttributes {
    extern_methods!(
        #[unsafe(method(itemIndex))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemIndex(&self) -> NSInteger;

        /// Setter for [`itemIndex`][Self::itemIndex].
        #[unsafe(method(setItemIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setItemIndex(&self, item_index: NSInteger);

        #[unsafe(method(frame))]
        #[unsafe(method_family = none)]
        pub unsafe fn frame(&self) -> NSRect;

        /// Setter for [`frame`][Self::frame].
        #[unsafe(method(setFrame:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFrame(&self, frame: NSRect);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(alpha))]
        #[unsafe(method_family = none)]
        pub unsafe fn alpha(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`alpha`][Self::alpha].
        #[unsafe(method(setAlpha:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlpha(&self, alpha: CGFloat);

        #[unsafe(method(layoutAttributesForItemAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutAttributesForItemAtIndex(index: NSInteger) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSScrubberLayoutAttributes {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// `NSScrubberLayout`is an abstract class that describes the layout of items within a
    /// `NSScrubber`control.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrubberlayout?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSScrubberLayout;
);

extern_conformance!(
    unsafe impl NSCoding for NSScrubberLayout {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSScrubberLayout {}
);

impl NSScrubberLayout {
    extern_methods!(
        /// Specifies a class for describing layout attributes. By default, this is
        /// `NSScrubberLayoutAttributes,`but subclasses may override this method to use a custom subclass of
        /// `NSScrubberLayoutAttributes.`
        #[unsafe(method(layoutAttributesClass))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutAttributesClass(mtm: MainThreadMarker) -> &'static AnyClass;

        #[cfg(all(feature = "NSResponder", feature = "NSScrubber", feature = "NSView"))]
        /// The NSScrubber control that this layout is assigned to, or
        /// `nil`if the receiver is not assigned to a scrubber.
        #[unsafe(method(scrubber))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrubber(&self) -> Option<Retained<NSScrubber>>;

        /// The currently visible rectangle, in the coordinate space of the scrubber content. Returns
        /// `NSZeroRect`if the receiver is not assigned to a scrubber.
        #[unsafe(method(visibleRect))]
        #[unsafe(method_family = none)]
        pub unsafe fn visibleRect(&self) -> NSRect;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        /// Signals that layout has been invalidated and the NSScrubber should run a fresh layout pass. Subclasses may define more granular invalidation methods suitable for their own data structures, but those methods should always call up to -invalidateLayout.
        #[unsafe(method(invalidateLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn invalidateLayout(&self);

        /// Following any invalidation in layout,
        /// `NSScrubber`will call
        /// `prepareLayout`on its layout object prior to requesting any other layout information. Subclasses should use this method to perform upfront calculations and caching. The base implementation of this method does nothing.
        #[unsafe(method(prepareLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn prepareLayout(&self);

        /// Returns the content size for all elements within the scrubber. The base implementation returns
        /// `NSZeroSize.`
        #[unsafe(method(scrubberContentSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrubberContentSize(&self) -> NSSize;

        /// Returns the layout attributes for a single item within the scrubber. The base implementation returns
        /// `nil.`
        #[unsafe(method(layoutAttributesForItemAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutAttributesForItemAtIndex(
            &self,
            index: NSInteger,
        ) -> Option<Retained<NSScrubberLayoutAttributes>>;

        /// Returns the set of layout attributes for all items within the provided rectangle. The base implementation returns an empty set.
        #[unsafe(method(layoutAttributesForItemsInRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutAttributesForItemsInRect(
            &self,
            rect: NSRect,
        ) -> Retained<NSSet<NSScrubberLayoutAttributes>>;

        /// If
        /// `YES,`the scrubber will invalidate its layout when the selection changes. The default value is
        /// `NO.`Subclasses should return
        /// `YES`if the selection index affects the item layout.
        #[unsafe(method(shouldInvalidateLayoutForSelectionChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldInvalidateLayoutForSelectionChange(&self) -> bool;

        /// If
        /// `YES,`the scrubber will invalidate its layout when an item is highlighted. The default value is
        /// `NO.`Subclasses should return
        /// `YES`if the highlight state affects the item layout.
        #[unsafe(method(shouldInvalidateLayoutForHighlightChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldInvalidateLayoutForHighlightChange(&self) -> bool;

        /// If
        /// `YES,`the scrubber will invalidate its layout in response to a change in the visible region. The default value is
        /// `NO.`Subclasses which rely on the size or origin of the visible region should return
        /// `YES.`
        #[unsafe(method(shouldInvalidateLayoutForChangeFromVisibleRect:toVisibleRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldInvalidateLayoutForChangeFromVisibleRect_toVisibleRect(
            &self,
            from_visible_rect: NSRect,
            to_visible_rect: NSRect,
        ) -> bool;

        /// If
        /// `YES,`the layout object will automatically have its inputs and outputs mirrored in right-to-left interfaces. The default value is
        /// `YES.`Subclasses that wish to handle RTL layout manually should return
        /// `NO.`
        #[unsafe(method(automaticallyMirrorsInRightToLeftLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn automaticallyMirrorsInRightToLeftLayout(&self) -> bool;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSScrubberLayout {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrubberflowlayoutdelegate?language=objc)
    #[cfg(feature = "NSScrubber")]
    pub unsafe trait NSScrubberFlowLayoutDelegate: NSScrubberDelegate {
        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(scrubber:layout:sizeForItemAtIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn scrubber_layout_sizeForItemAtIndex(
            &self,
            scrubber: &NSScrubber,
            layout: &NSScrubberFlowLayout,
            item_index: NSInteger,
        ) -> NSSize;
    }
);

extern_class!(
    /// `NSScrubberFlowLayout`is a concrete layout object that arranges items end-to-end in a linear strip. It supports a fixed inter-item spacing and both fixed- and variable-sized items.
    ///
    /// If the associated scrubber's
    /// `delegate`conforms to
    /// `NSScrubberFlowLayoutDelegate,`and it implements the
    /// `scrubber:layout:sizeForItemAtIndex:`method,
    /// `NSScrubberFlowLayout`will obtain the item size from the delegate. If the delegate does not implement that method, or if the method returns
    /// `NSZeroSize,`it will fall back to using the layout's
    /// `itemSize`property. By default, NSScrubberFlowLayout does not invalidate its layout on selection change, highlight change, or visible rectangle change.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrubberflowlayout?language=objc)
    #[unsafe(super(NSScrubberLayout, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSScrubberFlowLayout;
);

extern_conformance!(
    unsafe impl NSCoding for NSScrubberFlowLayout {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSScrubberFlowLayout {}
);

impl NSScrubberFlowLayout {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        /// The amount of horizontal spacing between items in points. The default value is 0.0.
        #[unsafe(method(itemSpacing))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemSpacing(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`itemSpacing`][Self::itemSpacing].
        #[unsafe(method(setItemSpacing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setItemSpacing(&self, item_spacing: CGFloat);

        /// The frame size for each item, if not provided by the scrubber's delegate. The default value is { 50.0, 30.0 }.
        #[unsafe(method(itemSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemSize(&self) -> NSSize;

        /// Setter for [`itemSize`][Self::itemSize].
        #[unsafe(method(setItemSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setItemSize(&self, item_size: NSSize);

        #[unsafe(method(invalidateLayoutForItemsAtIndexes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn invalidateLayoutForItemsAtIndexes(&self, invalid_item_indexes: &NSIndexSet);
    );
}

/// Methods declared on superclass `NSScrubberLayout`.
impl NSScrubberFlowLayout {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSScrubberFlowLayout {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// `NSScrubberProportionalLayout`is a concrete layout object that sizes each item to some fraction of the scrubber's visible size.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsscrubberproportionallayout?language=objc)
    #[unsafe(super(NSScrubberLayout, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSScrubberProportionalLayout;
);

extern_conformance!(
    unsafe impl NSCoding for NSScrubberProportionalLayout {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSScrubberProportionalLayout {}
);

impl NSScrubberProportionalLayout {
    extern_methods!(
        /// The number of items that should fit within the scrubber's viewport at once.
        #[unsafe(method(numberOfVisibleItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn numberOfVisibleItems(&self) -> NSInteger;

        /// Setter for [`numberOfVisibleItems`][Self::numberOfVisibleItems].
        #[unsafe(method(setNumberOfVisibleItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNumberOfVisibleItems(&self, number_of_visible_items: NSInteger);

        #[unsafe(method(initWithNumberOfVisibleItems:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithNumberOfVisibleItems(
            this: Allocated<Self>,
            number_of_visible_items: NSInteger,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSScrubberLayout`.
impl NSScrubberProportionalLayout {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSScrubberProportionalLayout {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
