// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
#include <arm_neon.h>
// RUN: %clang_cc1        -triple aarch64-none-linux-gnu -target-feature +neon -target-feature +bf16 -target-feature +fp8 -target-feature +fp8fma -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -p mem2reg | FileCheck %s
// RUN: %clang_cc1 -x c++ -triple aarch64-none-linux-gnu -target-feature +neon -target-feature +bf16 -target-feature +fp8 -target-feature +fp8fma -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -p mem2reg | FileCheck %s -check-prefix CHECK-CXX

// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +neon -target-feature +bf16 -target-feature +fp8 -target-feature +fp8fma -disable-O0-optnone -Werror -Wall -S -o /dev/null %s

// REQUIRES: aarch64-registered-target

// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_p8_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <8 x i8> [[V]]
//
// CHECK-CXX-LABEL: define dso_local noundef <8 x i8> @_Z24test_vreinterpret_p8_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <8 x i8> [[V]]
//
poly8x8_t test_vreinterpret_p8_mf8(mfloat8x8_t v) {
  return vreinterpret_p8_mf8(v);
}
// CHECK-LABEL: define dso_local <1 x i64> @test_vreinterpret_p64_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <1 x i64>
// CHECK-NEXT:    ret <1 x i64> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <1 x i64> @_Z25test_vreinterpret_p64_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <1 x i64>
// CHECK-CXX-NEXT:    ret <1 x i64> [[TMP0]]
//
poly64x1_t test_vreinterpret_p64_mf8(mfloat8x8_t v) {
  return vreinterpret_p64_mf8(v);
}
// CHECK-LABEL: define dso_local <4 x i16> @test_vreinterpret_p16_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <4 x i16>
// CHECK-NEXT:    ret <4 x i16> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <4 x i16> @_Z25test_vreinterpret_p16_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <4 x i16>
// CHECK-CXX-NEXT:    ret <4 x i16> [[TMP0]]
//
poly16x4_t test_vreinterpret_p16_mf8(mfloat8x8_t v) {
  return vreinterpret_p16_mf8(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_p8_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <16 x i8> [[V]]
//
// CHECK-CXX-LABEL: define dso_local noundef <16 x i8> @_Z25test_vreinterpretq_p8_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <16 x i8> [[V]]
//
poly8x16_t test_vreinterpretq_p8_mf8(mfloat8x16_t v) {
  return vreinterpretq_p8_mf8(v);
}
// CHECK-LABEL: define dso_local i128 @test_vreinterpretq_p128_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to i128
// CHECK-NEXT:    ret i128 [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef i128 @_Z27test_vreinterpretq_p128_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to i128
// CHECK-CXX-NEXT:    ret i128 [[TMP0]]
//
poly128_t test_vreinterpretq_p128_mf8(mfloat8x16_t v) {
  return vreinterpretq_p128_mf8(v);
}
// CHECK-LABEL: define dso_local <2 x i64> @test_vreinterpretq_p64_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <2 x i64>
// CHECK-NEXT:    ret <2 x i64> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <2 x i64> @_Z26test_vreinterpretq_p64_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <2 x i64>
// CHECK-CXX-NEXT:    ret <2 x i64> [[TMP0]]
//
poly64x2_t test_vreinterpretq_p64_mf8(mfloat8x16_t v) {
  return vreinterpretq_p64_mf8(v);
}
// CHECK-LABEL: define dso_local <8 x i16> @test_vreinterpretq_p16_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <8 x i16>
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <8 x i16> @_Z26test_vreinterpretq_p16_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <8 x i16>
// CHECK-CXX-NEXT:    ret <8 x i16> [[TMP0]]
//
poly16x8_t test_vreinterpretq_p16_mf8(mfloat8x16_t v) {
  return vreinterpretq_p16_mf8(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_u8_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <16 x i8> [[V]]
//
// CHECK-CXX-LABEL: define dso_local noundef <16 x i8> @_Z25test_vreinterpretq_u8_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <16 x i8> [[V]]
//
uint8x16_t test_vreinterpretq_u8_mf8(mfloat8x16_t v) {
  return vreinterpretq_u8_mf8(v);
}
// CHECK-LABEL: define dso_local <4 x i32> @test_vreinterpretq_u32_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <4 x i32>
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <4 x i32> @_Z26test_vreinterpretq_u32_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <4 x i32>
// CHECK-CXX-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vreinterpretq_u32_mf8(mfloat8x16_t v) {
  return vreinterpretq_u32_mf8(v);
}
// CHECK-LABEL: define dso_local <2 x i64> @test_vreinterpretq_u64_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <2 x i64>
// CHECK-NEXT:    ret <2 x i64> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <2 x i64> @_Z26test_vreinterpretq_u64_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <2 x i64>
// CHECK-CXX-NEXT:    ret <2 x i64> [[TMP0]]
//
uint64x2_t test_vreinterpretq_u64_mf8(mfloat8x16_t v) {
  return vreinterpretq_u64_mf8(v);
}
// CHECK-LABEL: define dso_local <8 x i16> @test_vreinterpretq_u16_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <8 x i16>
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <8 x i16> @_Z26test_vreinterpretq_u16_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <8 x i16>
// CHECK-CXX-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vreinterpretq_u16_mf8(mfloat8x16_t v) {
  return vreinterpretq_u16_mf8(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_s8_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <16 x i8> [[V]]
//
// CHECK-CXX-LABEL: define dso_local noundef <16 x i8> @_Z25test_vreinterpretq_s8_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <16 x i8> [[V]]
//
int8x16_t test_vreinterpretq_s8_mf8(mfloat8x16_t v) {
  return vreinterpretq_s8_mf8(v);
}
// CHECK-LABEL: define dso_local <2 x double> @test_vreinterpretq_f64_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <2 x double>
// CHECK-NEXT:    ret <2 x double> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <2 x double> @_Z26test_vreinterpretq_f64_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <2 x double>
// CHECK-CXX-NEXT:    ret <2 x double> [[TMP0]]
//
float64x2_t test_vreinterpretq_f64_mf8(mfloat8x16_t v) {
  return vreinterpretq_f64_mf8(v);
}
// CHECK-LABEL: define dso_local <4 x float> @test_vreinterpretq_f32_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <4 x float>
// CHECK-NEXT:    ret <4 x float> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <4 x float> @_Z26test_vreinterpretq_f32_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <4 x float>
// CHECK-CXX-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t test_vreinterpretq_f32_mf8(mfloat8x16_t v) {
  return vreinterpretq_f32_mf8(v);
}
// CHECK-LABEL: define dso_local <8 x half> @test_vreinterpretq_f16_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <8 x half>
// CHECK-NEXT:    ret <8 x half> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <8 x half> @_Z26test_vreinterpretq_f16_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <8 x half>
// CHECK-CXX-NEXT:    ret <8 x half> [[TMP0]]
//
float16x8_t test_vreinterpretq_f16_mf8(mfloat8x16_t v) {
  return vreinterpretq_f16_mf8(v);
}
// CHECK-LABEL: define dso_local <4 x i32> @test_vreinterpretq_s32_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <4 x i32>
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <4 x i32> @_Z26test_vreinterpretq_s32_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <4 x i32>
// CHECK-CXX-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vreinterpretq_s32_mf8(mfloat8x16_t v) {
  return vreinterpretq_s32_mf8(v);
}
// CHECK-LABEL: define dso_local <2 x i64> @test_vreinterpretq_s64_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <2 x i64>
// CHECK-NEXT:    ret <2 x i64> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <2 x i64> @_Z26test_vreinterpretq_s64_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <2 x i64>
// CHECK-CXX-NEXT:    ret <2 x i64> [[TMP0]]
//
int64x2_t test_vreinterpretq_s64_mf8(mfloat8x16_t v) {
  return vreinterpretq_s64_mf8(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_p8(
// CHECK-SAME: <16 x i8> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <16 x i8> [[V]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z25test_vreinterpretq_mf8_p812__Poly8x16_t(
// CHECK-CXX-SAME: <16 x i8> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <16 x i8> [[V]]
//
mfloat8x16_t test_vreinterpretq_mf8_p8(poly8x16_t v) {
  return vreinterpretq_mf8_p8(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_p128(
// CHECK-SAME: i128 noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast i128 [[V]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z27test_vreinterpretq_mf8_p128o(
// CHECK-CXX-SAME: i128 noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast i128 [[V]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t test_vreinterpretq_mf8_p128(poly128_t v) {
  return vreinterpretq_mf8_p128(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_p64(
// CHECK-SAME: <2 x i64> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[V]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z26test_vreinterpretq_mf8_p6412__Poly64x2_t(
// CHECK-CXX-SAME: <2 x i64> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[V]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t test_vreinterpretq_mf8_p64(poly64x2_t v) {
  return vreinterpretq_mf8_p64(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_p16(
// CHECK-SAME: <8 x i16> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[V]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z26test_vreinterpretq_mf8_p1612__Poly16x8_t(
// CHECK-CXX-SAME: <8 x i16> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[V]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t test_vreinterpretq_mf8_p16(poly16x8_t v) {
  return vreinterpretq_mf8_p16(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_u8(
// CHECK-SAME: <16 x i8> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <16 x i8> [[V]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z25test_vreinterpretq_mf8_u812__Uint8x16_t(
// CHECK-CXX-SAME: <16 x i8> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <16 x i8> [[V]]
//
mfloat8x16_t test_vreinterpretq_mf8_u8(uint8x16_t v) {
  return vreinterpretq_mf8_u8(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_u32(
// CHECK-SAME: <4 x i32> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[V]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z26test_vreinterpretq_mf8_u3212__Uint32x4_t(
// CHECK-CXX-SAME: <4 x i32> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[V]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t test_vreinterpretq_mf8_u32(uint32x4_t v) {
  return vreinterpretq_mf8_u32(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_u64(
// CHECK-SAME: <2 x i64> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[V]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z26test_vreinterpretq_mf8_u6412__Uint64x2_t(
// CHECK-CXX-SAME: <2 x i64> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[V]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t test_vreinterpretq_mf8_u64(uint64x2_t v) {
  return vreinterpretq_mf8_u64(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_u16(
// CHECK-SAME: <8 x i16> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[V]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z26test_vreinterpretq_mf8_u1612__Uint16x8_t(
// CHECK-CXX-SAME: <8 x i16> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[V]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t test_vreinterpretq_mf8_u16(uint16x8_t v) {
  return vreinterpretq_mf8_u16(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_s8(
// CHECK-SAME: <16 x i8> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <16 x i8> [[V]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z25test_vreinterpretq_mf8_s811__Int8x16_t(
// CHECK-CXX-SAME: <16 x i8> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <16 x i8> [[V]]
//
mfloat8x16_t test_vreinterpretq_mf8_s8(int8x16_t v) {
  return vreinterpretq_mf8_s8(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_f64(
// CHECK-SAME: <2 x double> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x double> [[V]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z26test_vreinterpretq_mf8_f6413__Float64x2_t(
// CHECK-CXX-SAME: <2 x double> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <2 x double> [[V]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t test_vreinterpretq_mf8_f64(float64x2_t v) {
  return vreinterpretq_mf8_f64(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_f32(
// CHECK-SAME: <4 x float> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[V]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z26test_vreinterpretq_mf8_f3213__Float32x4_t(
// CHECK-CXX-SAME: <4 x float> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[V]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t test_vreinterpretq_mf8_f32(float32x4_t v) {
  return vreinterpretq_mf8_f32(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_f16(
// CHECK-SAME: <8 x half> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[V]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z26test_vreinterpretq_mf8_f1613__Float16x8_t(
// CHECK-CXX-SAME: <8 x half> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[V]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t test_vreinterpretq_mf8_f16(float16x8_t v) {
  return vreinterpretq_mf8_f16(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_s32(
// CHECK-SAME: <4 x i32> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[V]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z26test_vreinterpretq_mf8_s3211__Int32x4_t(
// CHECK-CXX-SAME: <4 x i32> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[V]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t test_vreinterpretq_mf8_s32(int32x4_t v) {
  return vreinterpretq_mf8_s32(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_s64(
// CHECK-SAME: <2 x i64> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[V]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z26test_vreinterpretq_mf8_s6411__Int64x2_t(
// CHECK-CXX-SAME: <2 x i64> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <2 x i64> [[V]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t test_vreinterpretq_mf8_s64(int64x2_t v) {
  return vreinterpretq_mf8_s64(v);
}
// CHECK-LABEL: define dso_local <16 x i8> @test_vreinterpretq_mf8_s16(
// CHECK-SAME: <8 x i16> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[V]] to <16 x i8>
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <16 x i8> @_Z26test_vreinterpretq_mf8_s1611__Int16x8_t(
// CHECK-CXX-SAME: <8 x i16> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[V]] to <16 x i8>
// CHECK-CXX-NEXT:    ret <16 x i8> [[TMP0]]
//
mfloat8x16_t test_vreinterpretq_mf8_s16(int16x8_t v) {
  return vreinterpretq_mf8_s16(v);
}
// CHECK-LABEL: define dso_local <8 x i16> @test_vreinterpretq_s16_mf8(
// CHECK-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <8 x i16>
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <8 x i16> @_Z26test_vreinterpretq_s16_mf814__Mfloat8x16_t(
// CHECK-CXX-SAME: <16 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[V]] to <8 x i16>
// CHECK-CXX-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vreinterpretq_s16_mf8(mfloat8x16_t v) {
  return vreinterpretq_s16_mf8(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_u8_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <8 x i8> [[V]]
//
// CHECK-CXX-LABEL: define dso_local noundef <8 x i8> @_Z24test_vreinterpret_u8_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <8 x i8> [[V]]
//
uint8x8_t test_vreinterpret_u8_mf8(mfloat8x8_t v) {
  return vreinterpret_u8_mf8(v);
}
// CHECK-LABEL: define dso_local <2 x i32> @test_vreinterpret_u32_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <2 x i32>
// CHECK-NEXT:    ret <2 x i32> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <2 x i32> @_Z25test_vreinterpret_u32_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <2 x i32>
// CHECK-CXX-NEXT:    ret <2 x i32> [[TMP0]]
//
uint32x2_t test_vreinterpret_u32_mf8(mfloat8x8_t v) {
  return vreinterpret_u32_mf8(v);
}
// CHECK-LABEL: define dso_local <1 x i64> @test_vreinterpret_u64_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <1 x i64>
// CHECK-NEXT:    ret <1 x i64> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <1 x i64> @_Z25test_vreinterpret_u64_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <1 x i64>
// CHECK-CXX-NEXT:    ret <1 x i64> [[TMP0]]
//
uint64x1_t test_vreinterpret_u64_mf8(mfloat8x8_t v) {
  return vreinterpret_u64_mf8(v);
}
// CHECK-LABEL: define dso_local <4 x i16> @test_vreinterpret_u16_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <4 x i16>
// CHECK-NEXT:    ret <4 x i16> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <4 x i16> @_Z25test_vreinterpret_u16_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <4 x i16>
// CHECK-CXX-NEXT:    ret <4 x i16> [[TMP0]]
//
uint16x4_t test_vreinterpret_u16_mf8(mfloat8x8_t v) {
  return vreinterpret_u16_mf8(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_s8_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <8 x i8> [[V]]
//
// CHECK-CXX-LABEL: define dso_local noundef <8 x i8> @_Z24test_vreinterpret_s8_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <8 x i8> [[V]]
//
int8x8_t test_vreinterpret_s8_mf8(mfloat8x8_t v) {
  return vreinterpret_s8_mf8(v);
}
// CHECK-LABEL: define dso_local <1 x double> @test_vreinterpret_f64_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <1 x double>
// CHECK-NEXT:    ret <1 x double> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <1 x double> @_Z25test_vreinterpret_f64_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <1 x double>
// CHECK-CXX-NEXT:    ret <1 x double> [[TMP0]]
//
float64x1_t test_vreinterpret_f64_mf8(mfloat8x8_t v) {
  return vreinterpret_f64_mf8(v);
}
// CHECK-LABEL: define dso_local <2 x float> @test_vreinterpret_f32_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <2 x float>
// CHECK-NEXT:    ret <2 x float> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <2 x float> @_Z25test_vreinterpret_f32_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <2 x float>
// CHECK-CXX-NEXT:    ret <2 x float> [[TMP0]]
//
float32x2_t test_vreinterpret_f32_mf8(mfloat8x8_t v) {
  return vreinterpret_f32_mf8(v);
}
// CHECK-LABEL: define dso_local <4 x half> @test_vreinterpret_f16_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <4 x half>
// CHECK-NEXT:    ret <4 x half> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <4 x half> @_Z25test_vreinterpret_f16_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <4 x half>
// CHECK-CXX-NEXT:    ret <4 x half> [[TMP0]]
//
float16x4_t test_vreinterpret_f16_mf8(mfloat8x8_t v) {
  return vreinterpret_f16_mf8(v);
}
// CHECK-LABEL: define dso_local <2 x i32> @test_vreinterpret_s32_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <2 x i32>
// CHECK-NEXT:    ret <2 x i32> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <2 x i32> @_Z25test_vreinterpret_s32_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <2 x i32>
// CHECK-CXX-NEXT:    ret <2 x i32> [[TMP0]]
//
int32x2_t test_vreinterpret_s32_mf8(mfloat8x8_t v) {
  return vreinterpret_s32_mf8(v);
}
// CHECK-LABEL: define dso_local <1 x i64> @test_vreinterpret_s64_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <1 x i64>
// CHECK-NEXT:    ret <1 x i64> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <1 x i64> @_Z25test_vreinterpret_s64_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <1 x i64>
// CHECK-CXX-NEXT:    ret <1 x i64> [[TMP0]]
//
int64x1_t test_vreinterpret_s64_mf8(mfloat8x8_t v) {
  return vreinterpret_s64_mf8(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_p8(
// CHECK-SAME: <8 x i8> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <8 x i8> [[V]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z24test_vreinterpret_mf8_p811__Poly8x8_t(
// CHECK-CXX-SAME: <8 x i8> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <8 x i8> [[V]]
//
mfloat8x8_t test_vreinterpret_mf8_p8(poly8x8_t v) {
  return vreinterpret_mf8_p8(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_p64(
// CHECK-SAME: <1 x i64> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <1 x i64> [[V]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z25test_vreinterpret_mf8_p6412__Poly64x1_t(
// CHECK-CXX-SAME: <1 x i64> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <1 x i64> [[V]] to <8 x i8>
// CHECK-CXX-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_vreinterpret_mf8_p64(poly64x1_t v) {
  return vreinterpret_mf8_p64(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_p16(
// CHECK-SAME: <4 x i16> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[V]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z25test_vreinterpret_mf8_p1612__Poly16x4_t(
// CHECK-CXX-SAME: <4 x i16> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[V]] to <8 x i8>
// CHECK-CXX-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_vreinterpret_mf8_p16(poly16x4_t v) {
  return vreinterpret_mf8_p16(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_u8(
// CHECK-SAME: <8 x i8> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <8 x i8> [[V]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z24test_vreinterpret_mf8_u811__Uint8x8_t(
// CHECK-CXX-SAME: <8 x i8> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <8 x i8> [[V]]
//
mfloat8x8_t test_vreinterpret_mf8_u8(uint8x8_t v) {
  return vreinterpret_mf8_u8(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_u32(
// CHECK-SAME: <2 x i32> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[V]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z25test_vreinterpret_mf8_u3212__Uint32x2_t(
// CHECK-CXX-SAME: <2 x i32> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[V]] to <8 x i8>
// CHECK-CXX-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_vreinterpret_mf8_u32(uint32x2_t v) {
  return vreinterpret_mf8_u32(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_u64(
// CHECK-SAME: <1 x i64> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <1 x i64> [[V]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z25test_vreinterpret_mf8_u6412__Uint64x1_t(
// CHECK-CXX-SAME: <1 x i64> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <1 x i64> [[V]] to <8 x i8>
// CHECK-CXX-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_vreinterpret_mf8_u64(uint64x1_t v) {
  return vreinterpret_mf8_u64(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_u16(
// CHECK-SAME: <4 x i16> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[V]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z25test_vreinterpret_mf8_u1612__Uint16x4_t(
// CHECK-CXX-SAME: <4 x i16> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[V]] to <8 x i8>
// CHECK-CXX-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_vreinterpret_mf8_u16(uint16x4_t v) {
  return vreinterpret_mf8_u16(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_s8(
// CHECK-SAME: <8 x i8> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <8 x i8> [[V]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z24test_vreinterpret_mf8_s810__Int8x8_t(
// CHECK-CXX-SAME: <8 x i8> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    ret <8 x i8> [[V]]
//
mfloat8x8_t test_vreinterpret_mf8_s8(int8x8_t v) {
  return vreinterpret_mf8_s8(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_f64(
// CHECK-SAME: <1 x double> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <1 x double> [[V]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z25test_vreinterpret_mf8_f6413__Float64x1_t(
// CHECK-CXX-SAME: <1 x double> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <1 x double> [[V]] to <8 x i8>
// CHECK-CXX-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_vreinterpret_mf8_f64(float64x1_t v) {
  return vreinterpret_mf8_f64(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_f32(
// CHECK-SAME: <2 x float> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[V]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z25test_vreinterpret_mf8_f3213__Float32x2_t(
// CHECK-CXX-SAME: <2 x float> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[V]] to <8 x i8>
// CHECK-CXX-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_vreinterpret_mf8_f32(float32x2_t v) {
  return vreinterpret_mf8_f32(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_f16(
// CHECK-SAME: <4 x half> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[V]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z25test_vreinterpret_mf8_f1613__Float16x4_t(
// CHECK-CXX-SAME: <4 x half> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[V]] to <8 x i8>
// CHECK-CXX-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_vreinterpret_mf8_f16(float16x4_t v) {
  return vreinterpret_mf8_f16(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_s32(
// CHECK-SAME: <2 x i32> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[V]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z25test_vreinterpret_mf8_s3211__Int32x2_t(
// CHECK-CXX-SAME: <2 x i32> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[V]] to <8 x i8>
// CHECK-CXX-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_vreinterpret_mf8_s32(int32x2_t v) {
  return vreinterpret_mf8_s32(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_s64(
// CHECK-SAME: <1 x i64> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <1 x i64> [[V]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z25test_vreinterpret_mf8_s6411__Int64x1_t(
// CHECK-CXX-SAME: <1 x i64> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <1 x i64> [[V]] to <8 x i8>
// CHECK-CXX-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_vreinterpret_mf8_s64(int64x1_t v) {
  return vreinterpret_mf8_s64(v);
}
// CHECK-LABEL: define dso_local <8 x i8> @test_vreinterpret_mf8_s16(
// CHECK-SAME: <4 x i16> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[V]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z25test_vreinterpret_mf8_s1611__Int16x4_t(
// CHECK-CXX-SAME: <4 x i16> noundef [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[V]] to <8 x i8>
// CHECK-CXX-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_vreinterpret_mf8_s16(int16x4_t v) {
  return vreinterpret_mf8_s16(v);
}
// CHECK-LABEL: define dso_local <4 x i16> @test_vreinterpret_s16_mf8(
// CHECK-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <4 x i16>
// CHECK-NEXT:    ret <4 x i16> [[TMP0]]
//
// CHECK-CXX-LABEL: define dso_local noundef <4 x i16> @_Z25test_vreinterpret_s16_mf813__Mfloat8x8_t(
// CHECK-CXX-SAME: <8 x i8> [[V:%.*]]) #[[ATTR0]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[TMP0:%.*]] = bitcast <8 x i8> [[V]] to <4 x i16>
// CHECK-CXX-NEXT:    ret <4 x i16> [[TMP0]]
//
int16x4_t test_vreinterpret_s16_mf8(mfloat8x8_t v) {
  return vreinterpret_s16_mf8(v);
}
