/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum PublicKeyAlgorithm {
    RSA_GENERAL(1, true, true),
    RSA_ENCRYPT(2, false, true),
    RSA_SIGN(3, true, false),
    ELGAMAL_ENCRYPT(16, false, true),
    DSA(17, true, false),
    EC(18, false, true),
    ECDH(18, false, true),
    ECDSA(19, true, false),
    ELGAMAL_GENERAL(20, true, true),
    DIFFIE_HELLMAN(21, false, true),
    EDDSA(22, true, false);

    private static final Map<Integer, PublicKeyAlgorithm> MAP;
    private final int algorithmId;
    private final boolean signingCapable;
    private final boolean encryptionCapable;

    @Nullable
    public static PublicKeyAlgorithm fromId(int id) {
        return MAP.get(id);
    }

    @Nonnull
    public static PublicKeyAlgorithm requireFromId(int id) {
        PublicKeyAlgorithm algorithm = PublicKeyAlgorithm.fromId(id);
        if (algorithm == null) {
            throw new NoSuchElementException("No PublicKeyAlgorithm found for id " + id);
        }
        return algorithm;
    }

    private PublicKeyAlgorithm(int algorithmId, boolean signingCapable, boolean encryptionCapable) {
        this.algorithmId = algorithmId;
        this.signingCapable = signingCapable;
        this.encryptionCapable = encryptionCapable;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public boolean isSigningCapable() {
        return this.signingCapable;
    }

    public boolean isEncryptionCapable() {
        return this.encryptionCapable;
    }

    static {
        MAP = new ConcurrentHashMap<Integer, PublicKeyAlgorithm>();
        for (PublicKeyAlgorithm p : PublicKeyAlgorithm.values()) {
            MAP.put(p.algorithmId, p);
        }
    }
}

