# This code is part of Qiskit.
#
# (C) Copyright IBM 2021.
#
# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.
"""Sample data for the AQC tests."""

import numpy as np

# Circuit to optimize
ORIGINAL_CIRCUIT = np.asarray(
    [
        [
            -0.07783734 + 0.22716113j,
            -0.00910959 + 0.04320976j,
            -0.21030301 + 0.20425801j,
            -0.59549525 + 0.23857045j,
            0.26052641 - 0.21291574j,
            0.04239446 - 0.51982577j,
            0.11510024 + 0.0862973j,
            -0.14629519 - 0.1248565j,
        ],
        [
            0.36992751 + 0.24267278j,
            -0.24662827 - 0.1550994j,
            0.01884297 - 0.19588483j,
            -0.12679802 - 0.03807062j,
            -0.47228903 - 0.23051667j,
            0.25913925 - 0.07348255j,
            -0.33918991 - 0.31963187j,
            -0.06086797 - 0.30571598j,
        ],
        [
            0.0222799 - 0.19736565j,
            -0.11059812 + 0.005871j,
            -0.09659148 + 0.37062522j,
            0.10305057 + 0.2136938j,
            0.43803384 - 0.18087079j,
            0.2915554 + 0.21651464j,
            -0.5518552 - 0.2278622j,
            -0.07433388 + 0.16384345j,
        ],
        [
            -0.10575111 - 0.20500221j,
            -0.46919823 + 0.28035591j,
            -0.00532403 + 0.18394858j,
            -0.40488016 - 0.02266676j,
            -0.31535024 - 0.20471488j,
            0.04892042 + 0.4144072j,
            0.26845334 + 0.03135037j,
            0.02306506 + 0.24632236j,
        ],
        [
            -0.08478682 + 0.17291421j,
            -0.00175922 + 0.29513196j,
            -0.4834236 + 0.33435023j,
            0.40144427 - 0.05581059j,
            -0.12199095 - 0.10961794j,
            0.03892304 + 0.15557211j,
            0.13831459 + 0.12635286j,
            -0.14552454 - 0.50710571j,
        ],
        [
            0.45282021 - 0.33188642j,
            0.2698306 + 0.52711561j,
            0.10654936 - 0.22260092j,
            -0.10493819 - 0.16484395j,
            0.24892473 - 0.32326511j,
            -0.09647525 + 0.02038148j,
            0.0574283 - 0.07771336j,
            0.07001849 - 0.21125733j,
        ],
        [
            -0.27951269 - 0.31668187j,
            -0.19034985 + 0.03974792j,
            0.07497032 + 0.31316668j,
            0.02401214 - 0.27077229j,
            -0.0952781 + 0.06841821j,
            -0.34445156 - 0.38097419j,
            -0.11546146 - 0.43206826j,
            0.28988791 - 0.21115787j,
        ],
        [
            0.32899805 + 0.12250135j,
            0.32760646 - 0.13874956j,
            -0.17776306 + 0.39125565j,
            -0.26523096 - 0.05930179j,
            -0.157175 + 0.11327617j,
            -0.12985701 + 0.18256439j,
            -0.19442067 + 0.22433888j,
            0.56113453 + 0.03006748j,
        ],
    ]
)


INITIAL_THETAS = np.asarray(
    [
        5.840950175706398,
        1.9878462360990703,
        1.1555959752434493,
        1.2852901366370226,
        3.5671215612441567,
        3.741917727527864,
        6.0602234589642325,
        4.104032738049671,
        4.705519181402343,
        4.106500609750883,
        4.698030703573854,
        6.040068359785516,
        0.05270523037861366,
        0.6688097436989993,
        1.8768107855557548,
        4.124353101010888,
        5.088202331694798,
        5.480042886388346,
        6.061059610413401,
        4.547049138788613,
        4.036791540460537,
        4.507894048871352,
        2.9380112118120447,
        2.045708862158222,
        2.7623685280761947,
        4.584771723524366,
        6.245577841248841,
        4.252922960633062,
        4.9688844247279915,
        1.073885953348928,
        0.16869897515173574,
        5.028874556936197,
        5.678256173892097,
        0.15504520280603118,
        3.0897395261041516,
        3.3065587353199613,
        3.74707815436836,
        0.3264588839853597,
        5.624013371278708,
        4.575831363947143,
        5.141844767695358,
        3.1429922509263313,
        5.090570189425126,
        0.6029880309099467,
        1.3757036977838175,
        1.6255798065519669,
        2.941195195443305,
        2.8863269571102226,
        4.457981426310531,
        1.118740030466607,
        3.339198104910743,
        1.0539555073048037,
        4.830600316082553,
        5.831867556758204,
        3.829561596723921,
        0.9436307270844012,
        3.0764153106528846,
        2.3709282696632825,
        5.331919923390631,
        5.724592720350565,
        2.411792644955149,
        1.9823192246938757,
        3.571325789530997,
        1.1800955180886494,
        0.7906857392089286,
    ]
)


CARTAN_3 = [
    [0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0],
    [1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1],
]


CARTAN_4 = [
    [
        0,
        0,
        0,
        2,
        1,
        2,
        1,
        0,
        0,
        0,
        2,
        1,
        2,
        1,
        0,
        0,
        0,
        2,
        1,
        2,
        1,
        0,
        0,
        0,
        2,
        1,
        2,
        0,
        2,
        1,
        2,
        0,
        0,
        0,
        0,
        2,
        1,
        2,
        1,
        0,
        0,
        0,
        2,
        1,
        2,
        1,
        0,
        0,
        0,
        2,
        1,
        2,
        1,
        0,
        0,
        0,
        2,
        1,
        2,
        0,
        2,
        1,
        2,
        0,
        0,
        0,
        0,
        2,
        1,
        2,
        1,
        0,
        0,
        0,
        2,
        1,
        2,
        1,
        0,
        0,
        0,
        2,
        1,
        2,
        1,
        0,
        0,
        0,
        2,
        1,
        2,
        0,
        2,
        1,
        2,
        0,
        0,
        0,
        0,
        2,
        1,
        2,
        1,
        0,
        0,
        0,
        2,
        1,
        2,
        1,
        0,
        0,
        0,
        2,
        1,
        2,
        1,
        0,
        0,
        0,
    ],
    [
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
        3,
        3,
        3,
        3,
        1,
        1,
        1,
    ],
]
