/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.config.BooleanDefinition;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.DefinitionUtils;
import org.eclipse.californium.elements.config.EnumDefinition;
import org.eclipse.californium.elements.config.IntegerDefinition;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.TimeDefinition;

public final class TcpConfig {
    public static final String MODULE = "TCP.";
    public static final int DEFAULT_TCP_CONNECTION_IDLE_TIMEOUT_IN_SECONDS = 10;
    public static final int DEFAULT_TCP_CONNECT_TIMEOUT_IN_SECONDS = 10;
    public static final int DEFAULT_TLS_HANDSHAKE_TIMEOUT_IN_SECONDS = 10;
    public static final TimeDefinition TCP_CONNECTION_IDLE_TIMEOUT = new TimeDefinition("TCP.CONNECTION_IDLE_TIMEOUT", "TCP connection idle timeout.", 10L, TimeUnit.SECONDS);
    public static final TimeDefinition TCP_CONNECT_TIMEOUT = new TimeDefinition("TCP.CONNECT_TIMEOUT", "TCP connect timeout.", 10L, TimeUnit.SECONDS);
    public static final IntegerDefinition TCP_WORKER_THREADS = new IntegerDefinition("TCP.WORKER_THREADS", "Number of TCP worker threads. 0 to use default of TCP implementation.", 0, 0);
    public static final TimeDefinition TLS_HANDSHAKE_TIMEOUT = new TimeDefinition("TCP.HANDSHAKE_TIMEOUT", "TLS handshake timeout.", 10L, TimeUnit.SECONDS);
    public static final TimeDefinition TLS_SESSION_TIMEOUT = new TimeDefinition("TCP.SESSION_TIMEOUT", "TLS session timeout.", 1L, TimeUnit.HOURS);
    public static final EnumDefinition<CertificateAuthenticationMode> TLS_CLIENT_AUTHENTICATION_MODE = new EnumDefinition("TCP.CLIENT_AUTHENTICATION_MODE", "TLS client authentication mode.", (Enum)CertificateAuthenticationMode.WANTED, (Enum[])CertificateAuthenticationMode.values());
    public static final BooleanDefinition TLS_VERIFY_SERVER_CERTIFICATES_SUBJECT = new BooleanDefinition("TCP.VERIFY_SERVER_CERTIFICATES_SUBJECT", "TLS verifies the server certificate's subjects.", true);
    public static final Configuration.ModuleDefinitionsProvider DEFINITIONS = new Configuration.ModuleDefinitionsProvider(){

        @Override
        public String getModule() {
            return TcpConfig.MODULE;
        }

        @Override
        public void applyDefinitions(Configuration config) {
            config.set(TCP_WORKER_THREADS, 0);
            config.set(TCP_CONNECTION_IDLE_TIMEOUT, 10, TimeUnit.SECONDS);
            config.set(TCP_CONNECT_TIMEOUT, 10, TimeUnit.SECONDS);
            config.set(TLS_HANDSHAKE_TIMEOUT, 10, TimeUnit.SECONDS);
            config.set(TLS_SESSION_TIMEOUT, 1, TimeUnit.HOURS);
            config.set(TLS_CLIENT_AUTHENTICATION_MODE, CertificateAuthenticationMode.WANTED);
            config.set(TLS_VERIFY_SERVER_CERTIFICATES_SUBJECT, true);
            DefinitionUtils.verify(TcpConfig.class, config);
        }
    };

    public static void register() {
        SystemConfig.register();
    }

    static {
        Configuration.addDefaultModule(DEFINITIONS);
    }
}

