/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.unit;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.SystemOfUnits;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.library.dimension.ArealDensity;
import org.openhab.core.library.dimension.DataAmount;
import org.openhab.core.library.dimension.DataTransferRate;
import org.openhab.core.library.dimension.Density;
import org.openhab.core.library.dimension.ElectricConductivity;
import org.openhab.core.library.dimension.EmissionIntensity;
import org.openhab.core.library.dimension.Intensity;
import org.openhab.core.library.dimension.RadiantExposure;
import org.openhab.core.library.dimension.RadiationSpecificActivity;
import org.openhab.core.library.dimension.VolumetricFlowRate;
import org.openhab.core.library.unit.BinaryPrefix;
import org.openhab.core.library.unit.CustomUnits;
import org.openhab.core.library.unit.ImperialUnits;
import org.openhab.core.library.unit.MetricPrefix;
import si.uom.NonSI;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.function.ExpConverter;
import tech.units.indriya.function.LogConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.unit.AlternateUnit;
import tech.units.indriya.unit.BaseUnit;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.UnitDimension;

@NonNullByDefault
public final class Units
extends CustomUnits {
    private static final Units INSTANCE = new Units();
    public static final Unit<Acceleration> METRE_PER_SQUARE_SECOND = Units.addUnit(tech.units.indriya.unit.Units.METRE_PER_SQUARE_SECOND);
    public static final Unit<Acceleration> STANDARD_GRAVITY = Units.addUnit(METRE_PER_SQUARE_SECOND.multiply(9.80665));
    public static final Unit<AmountOfSubstance> MOLE = Units.addUnit(tech.units.indriya.unit.Units.MOLE);
    public static final Unit<Volume> LITRE = Units.addUnit(tech.units.indriya.unit.Units.LITRE);
    public static final Unit<Dimensionless> DEUTSCHE_HAERTE = Units.addUnit(new TransformedUnit("\u00b0dH", MetricPrefix.MILLI(MOLE).divide(LITRE), (UnitConverter)MultiplyConverter.of((double)0.17833)));
    public static final Unit<Angle> DEGREE_ANGLE = Units.addUnit(NonSI.DEGREE_ANGLE);
    public static final Unit<Angle> RADIAN = Units.addUnit(tech.units.indriya.unit.Units.RADIAN);
    public static final Unit<ArealDensity> DOBSON_UNIT = Units.addUnit(new ProductUnit(MetricPrefix.MILLI(tech.units.indriya.unit.Units.MOLE).multiply(0.4462).divide(tech.units.indriya.unit.Units.SQUARE_METRE)));
    public static final Unit<ArealDensity> KILOGRAM_PER_SQUARE_METRE = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.KILOGRAM.divide(tech.units.indriya.unit.Units.SQUARE_METRE)));
    public static final Unit<CatalyticActivity> KATAL = Units.addUnit(tech.units.indriya.unit.Units.KATAL);
    public static final Unit<Density> KILOGRAM_PER_CUBICMETRE = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.KILOGRAM.divide(tech.units.indriya.unit.Units.CUBIC_METRE)));
    public static final Unit<Density> MICROGRAM_PER_CUBICMETRE = Units.addUnit(new TransformedUnit(KILOGRAM_PER_CUBICMETRE, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.ONE, (BigInteger)BigInteger.valueOf(1000000000L))));
    public static final Unit<Dimensionless> ONE = Units.addUnit(AbstractUnit.ONE);
    public static final Unit<Dimensionless> PERCENT = Units.addUnit(tech.units.indriya.unit.Units.PERCENT);
    public static final Unit<Dimensionless> PARTS_PER_BILLION = Units.addUnit(new TransformedUnit(ONE, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.ONE, (BigInteger)BigInteger.valueOf(1000000000L))));
    public static final Unit<Dimensionless> PARTS_PER_MILLION = Units.addUnit(new TransformedUnit(ONE, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.ONE, (BigInteger)BigInteger.valueOf(1000000L))));
    public static final Unit<Dimensionless> DECIBEL = Units.addUnit(ONE.transform(new LogConverter(10.0).inverse().concatenate((UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.ONE, (BigInteger)BigInteger.TEN))));
    public static final Unit<ElectricCurrent> AMPERE = Units.addUnit(tech.units.indriya.unit.Units.AMPERE);
    public static final Unit<ElectricCapacitance> FARAD = Units.addUnit(tech.units.indriya.unit.Units.FARAD);
    public static final Unit<ElectricCharge> COULOMB = Units.addUnit(tech.units.indriya.unit.Units.COULOMB);
    public static final Unit<ElectricCharge> AMPERE_HOUR = Units.addUnit(tech.units.indriya.unit.Units.COULOMB.multiply(3600.0));
    public static final Unit<ElectricCharge> MILLIAMPERE_HOUR = Units.addUnit(MetricPrefix.MILLI(AMPERE_HOUR));
    public static final Unit<ElectricConductance> SIEMENS = Units.addUnit(tech.units.indriya.unit.Units.SIEMENS);
    public static final Unit<ElectricConductivity> SIEMENS_PER_METRE = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.SIEMENS.divide(tech.units.indriya.unit.Units.METRE)));
    public static final Unit<ElectricInductance> HENRY = Units.addUnit(tech.units.indriya.unit.Units.HENRY);
    public static final Unit<ElectricPotential> VOLT = Units.addUnit(tech.units.indriya.unit.Units.VOLT);
    public static final Unit<ElectricResistance> OHM = Units.addUnit(tech.units.indriya.unit.Units.OHM);
    public static final Unit<Energy> JOULE = Units.addUnit(tech.units.indriya.unit.Units.JOULE);
    public static final Unit<Energy> CALORIE = Units.addUnit(JOULE.multiply((Number)new BigDecimal("4.184")));
    public static final Unit<Energy> KILO_CALORIE = Units.addUnit(MetricPrefix.KILO(CALORIE));
    public static final Unit<Energy> WATT_SECOND = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.WATT.multiply(tech.units.indriya.unit.Units.SECOND)));
    public static final Unit<Energy> WATT_HOUR = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.WATT.multiply(tech.units.indriya.unit.Units.HOUR)));
    public static final Unit<Energy> KILOWATT_HOUR = Units.addUnit(MetricPrefix.KILO(WATT_HOUR));
    public static final Unit<Energy> MEGAWATT_HOUR = Units.addUnit(MetricPrefix.MEGA(WATT_HOUR));
    public static final Unit<EmissionIntensity> GRAM_PER_KILOWATT_HOUR = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.GRAM.divide(KILOWATT_HOUR)));
    public static final Unit<Power> VAR = Units.addUnit(new AlternateUnit(tech.units.indriya.unit.Units.WATT, "var"));
    public static final Unit<Power> KILOVAR = Units.addUnit(MetricPrefix.KILO(VAR));
    public static final Unit<Energy> VAR_HOUR = Units.addUnit(new ProductUnit(VAR.multiply(tech.units.indriya.unit.Units.HOUR)), Energy.class);
    public static final Unit<Energy> KILOVAR_HOUR = Units.addUnit(MetricPrefix.KILO(VAR_HOUR));
    public static final Unit<Power> VOLT_AMPERE = Units.addUnit(new AlternateUnit(tech.units.indriya.unit.Units.WATT, "VA"));
    public static final Unit<Power> KILOVOLT_AMPERE = Units.addUnit(MetricPrefix.KILO(VOLT_AMPERE));
    public static final Unit<Energy> VOLT_AMPERE_HOUR = Units.addUnit(new ProductUnit(VOLT_AMPERE.multiply(tech.units.indriya.unit.Units.HOUR)), Energy.class);
    public static final Unit<Force> NEWTON = Units.addUnit(tech.units.indriya.unit.Units.NEWTON);
    public static final Unit<Frequency> HERTZ = Units.addUnit(tech.units.indriya.unit.Units.HERTZ);
    public static final Unit<Frequency> RPM = Units.addUnit(new ProductUnit(AbstractUnit.ONE.divide(tech.units.indriya.unit.Units.MINUTE)));
    public static final Unit<Intensity> IRRADIANCE = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.WATT.divide(tech.units.indriya.unit.Units.SQUARE_METRE)));
    public static final Unit<Intensity> MICROWATT_PER_SQUARE_CENTIMETRE = Units.addUnit(new TransformedUnit(IRRADIANCE, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.ONE, (BigInteger)BigInteger.valueOf(100L))));
    public static final Unit<Illuminance> LUX = Units.addUnit(tech.units.indriya.unit.Units.LUX);
    public static final Unit<LuminousFlux> LUMEN = Units.addUnit(tech.units.indriya.unit.Units.LUMEN);
    public static final Unit<LuminousIntensity> CANDELA = Units.addUnit(tech.units.indriya.unit.Units.CANDELA);
    public static final Unit<MagneticFlux> WEBER = Units.addUnit(tech.units.indriya.unit.Units.WEBER);
    public static final Unit<MagneticFluxDensity> TESLA = Units.addUnit(tech.units.indriya.unit.Units.TESLA);
    public static final Unit<Power> WATT = Units.addUnit(tech.units.indriya.unit.Units.WATT);
    public static final Unit<Power> DECIBEL_MILLIWATTS = new TransformedUnit("dBm", MetricPrefix.MILLI(WATT), new ExpConverter(10.0).concatenate((UnitConverter)MultiplyConverter.of((double)0.1)));
    public static final Unit<Pressure> MILLIMETRE_OF_MERCURY = Units.addUnit(new TransformedUnit("mmHg", tech.units.indriya.unit.Units.PASCAL, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.valueOf(133322368L), (BigInteger)BigInteger.valueOf(1000000L))));
    public static final Unit<Pressure> BAR = Units.addUnit(new TransformedUnit("bar", tech.units.indriya.unit.Units.PASCAL, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.valueOf(100000L), (BigInteger)BigInteger.ONE)));
    public static final Unit<Pressure> MILLIBAR = Units.addUnit(MetricPrefix.MILLI(BAR));
    public static final Unit<Radioactivity> BECQUEREL = Units.addUnit(tech.units.indriya.unit.Units.BECQUEREL);
    public static final Unit<Radioactivity> CURIE = Units.addUnit(BECQUEREL.multiply(3.7E10));
    public static final Unit<Radioactivity> MILLI_CURIE = Units.addUnit(MetricPrefix.MILLI(CURIE));
    public static final Unit<Radioactivity> MICRO_CURIE = Units.addUnit(MetricPrefix.MICRO(CURIE));
    public static final Unit<Radioactivity> NANO_CURIE = Units.addUnit(MetricPrefix.NANO(CURIE));
    public static final Unit<Radioactivity> PICO_CURIE = Units.addUnit(MetricPrefix.PICO(CURIE));
    public static final Unit<RadiationSpecificActivity> BECQUEREL_PER_CUBIC_METRE = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.BECQUEREL.divide(tech.units.indriya.unit.Units.CUBIC_METRE)));
    public static final Unit<RadiationDoseAbsorbed> GRAY = Units.addUnit(tech.units.indriya.unit.Units.GRAY);
    public static final Unit<RadiationDoseEffective> SIEVERT = Units.addUnit(tech.units.indriya.unit.Units.SIEVERT);
    public static final Unit<Speed> MILLIMETRE_PER_HOUR = Units.addUnit(new TransformedUnit("mm/h", tech.units.indriya.unit.Units.KILOMETRE_PER_HOUR, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.ONE, (BigInteger)BigInteger.valueOf(1000000L))));
    public static final Unit<Speed> INCHES_PER_HOUR = Units.addUnit(new TransformedUnit("in/h", ImperialUnits.MILES_PER_HOUR, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.ONE, (BigInteger)BigInteger.valueOf(63360L))));
    public static final Unit<Speed> METRE_PER_SECOND = Units.addUnit(tech.units.indriya.unit.Units.METRE_PER_SECOND);
    public static final Unit<Speed> KNOT = Units.addUnit(new TransformedUnit("kn", tech.units.indriya.unit.Units.KILOMETRE_PER_HOUR, (UnitConverter)MultiplyConverter.ofRational((BigInteger)BigInteger.valueOf(1852L), (BigInteger)BigInteger.valueOf(1000L))));
    public static final Unit<SolidAngle> STERADIAN = Units.addUnit(tech.units.indriya.unit.Units.STERADIAN);
    public static final Unit<RadiantExposure> WATT_HOUR_PER_SQUARE_METRE = Units.addUnit(new ProductUnit(WATT_HOUR.divide(tech.units.indriya.unit.Units.SQUARE_METRE)));
    public static final Unit<RadiantExposure> JOULE_PER_SQUARE_METRE = Units.addUnit(new ProductUnit(JOULE.divide(tech.units.indriya.unit.Units.SQUARE_METRE)));
    public static final Unit<Temperature> KELVIN = Units.addUnit(tech.units.indriya.unit.Units.KELVIN);
    public static final Unit<?> MIRED = Units.addUnit(MetricPrefix.MEGA(tech.units.indriya.unit.Units.KELVIN).inverse());
    public static final Unit<Time> SECOND = Units.addUnit(tech.units.indriya.unit.Units.SECOND);
    public static final Unit<Time> MINUTE = Units.addUnit(tech.units.indriya.unit.Units.MINUTE);
    public static final Unit<Time> HOUR = Units.addUnit(tech.units.indriya.unit.Units.HOUR);
    public static final Unit<Time> DAY = Units.addUnit(tech.units.indriya.unit.Units.DAY);
    public static final Unit<Time> WEEK = Units.addUnit(tech.units.indriya.unit.Units.WEEK);
    public static final Unit<Time> MONTH = Units.addUnit(tech.units.indriya.unit.Units.MONTH);
    public static final Unit<Time> YEAR = Units.addUnit(tech.units.indriya.unit.Units.YEAR);
    public static final Unit<VolumetricFlowRate> LITRE_PER_MINUTE = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.LITRE.divide(tech.units.indriya.unit.Units.MINUTE)));
    public static final Unit<VolumetricFlowRate> CUBICMETRE_PER_SECOND = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.CUBIC_METRE.divide(tech.units.indriya.unit.Units.SECOND)));
    public static final Unit<VolumetricFlowRate> CUBICMETRE_PER_MINUTE = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.CUBIC_METRE.divide(tech.units.indriya.unit.Units.MINUTE)));
    public static final Unit<VolumetricFlowRate> CUBICMETRE_PER_HOUR = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.CUBIC_METRE.divide(tech.units.indriya.unit.Units.HOUR)));
    public static final Unit<VolumetricFlowRate> CUBICMETRE_PER_DAY = Units.addUnit(new ProductUnit(tech.units.indriya.unit.Units.CUBIC_METRE.divide(tech.units.indriya.unit.Units.DAY)));
    public static final Unit<DataAmount> BIT = Units.addUnit(new BaseUnit("bit", UnitDimension.parse((char)'X')));
    public static final Unit<DataAmount> KILOBIT = Units.addUnit(MetricPrefix.KILO(BIT));
    public static final Unit<DataAmount> MEGABIT = Units.addUnit(MetricPrefix.MEGA(BIT));
    public static final Unit<DataAmount> GIGABIT = Units.addUnit(MetricPrefix.GIGA(BIT));
    public static final Unit<DataAmount> TERABIT = Units.addUnit(MetricPrefix.TERA(BIT));
    public static final Unit<DataAmount> PETABIT = Units.addUnit(MetricPrefix.PETA(BIT));
    public static final Unit<DataAmount> BYTE = Units.addUnit(BIT.multiply(8.0));
    public static final Unit<DataAmount> OCTET = Units.addUnit(BIT.multiply(8.0));
    public static final Unit<DataAmount> KILOBYTE = Units.addUnit(MetricPrefix.KILO(BYTE));
    public static final Unit<DataAmount> MEGABYTE = Units.addUnit(MetricPrefix.MEGA(BYTE));
    public static final Unit<DataAmount> GIGABYTE = Units.addUnit(MetricPrefix.GIGA(BYTE));
    public static final Unit<DataAmount> TERABYTE = Units.addUnit(MetricPrefix.TERA(BYTE));
    public static final Unit<DataAmount> PETABYTE = Units.addUnit(MetricPrefix.PETA(BYTE));
    public static final Unit<DataAmount> KIBIBYTE = Units.addUnit(BinaryPrefix.KIBI(BYTE));
    public static final Unit<DataAmount> MEBIBYTE = Units.addUnit(BinaryPrefix.MEBI(BYTE));
    public static final Unit<DataAmount> GIBIBYTE = Units.addUnit(BinaryPrefix.GIBI(BYTE));
    public static final Unit<DataAmount> TEBIBYTE = Units.addUnit(BinaryPrefix.TEBI(BYTE));
    public static final Unit<DataAmount> PEBIBYTE = Units.addUnit(BinaryPrefix.PEBI(BYTE));
    public static final Unit<DataAmount> KIBIOCTET = Units.addUnit(BinaryPrefix.KIBI(OCTET));
    public static final Unit<DataAmount> MEBIOCTET = Units.addUnit(BinaryPrefix.MEBI(OCTET));
    public static final Unit<DataAmount> GIBIOCTET = Units.addUnit(BinaryPrefix.GIBI(OCTET));
    public static final Unit<DataAmount> TEBIOCTET = Units.addUnit(BinaryPrefix.TEBI(OCTET));
    public static final Unit<DataAmount> PEBIOCTET = Units.addUnit(BinaryPrefix.PEBI(OCTET));
    public static final Unit<DataTransferRate> BIT_PER_SECOND = Units.addUnit(new ProductUnit(BIT.divide(tech.units.indriya.unit.Units.SECOND)));
    public static final Unit<DataTransferRate> KILOBIT_PER_SECOND = Units.addUnit(MetricPrefix.KILO(BIT_PER_SECOND));
    public static final Unit<DataTransferRate> MEGABIT_PER_SECOND = Units.addUnit(MetricPrefix.MEGA(BIT_PER_SECOND));
    public static final Unit<DataTransferRate> GIGABIT_PER_SECOND = Units.addUnit(MetricPrefix.GIGA(BIT_PER_SECOND));
    public static final Unit<DataTransferRate> TERABIT_PER_SECOND = Units.addUnit(MetricPrefix.TERA(BIT_PER_SECOND));

    static {
        SimpleUnitFormat.getInstance().label(AMPERE_HOUR, "Ah");
        SimpleUnitFormat.getInstance().label(BAR, BAR.getSymbol());
        SimpleUnitFormat.getInstance().label(BECQUEREL_PER_CUBIC_METRE, "Bq/m\u00b3");
        SimpleUnitFormat.getInstance().label(BIT, BIT.getSymbol());
        SimpleUnitFormat.getInstance().label(BIT_PER_SECOND, "bit/s");
        SimpleUnitFormat.getInstance().label(BYTE, "B");
        SimpleUnitFormat.getInstance().alias(BYTE, "o");
        SimpleUnitFormat.getInstance().label(CALORIE, "cal");
        SimpleUnitFormat.getInstance().label(KILO_CALORIE, "kcal");
        SimpleUnitFormat.getInstance().label(CURIE, "Ci");
        SimpleUnitFormat.getInstance().label(MILLI_CURIE, "mCi");
        SimpleUnitFormat.getInstance().label(MICRO_CURIE, "\u00b5Ci");
        SimpleUnitFormat.getInstance().label(NANO_CURIE, "nCi");
        SimpleUnitFormat.getInstance().label(PICO_CURIE, "pCi");
        SimpleUnitFormat.getInstance().label(CUBICMETRE_PER_DAY, "m\u00b3/d");
        SimpleUnitFormat.getInstance().label(CUBICMETRE_PER_HOUR, "m\u00b3/h");
        SimpleUnitFormat.getInstance().label(CUBICMETRE_PER_MINUTE, "m\u00b3/min");
        SimpleUnitFormat.getInstance().label(CUBICMETRE_PER_SECOND, "m\u00b3/s");
        SimpleUnitFormat.getInstance().label(DECIBEL, "dB");
        SimpleUnitFormat.getInstance().label(DECIBEL_MILLIWATTS, "dBm");
        SimpleUnitFormat.getInstance().label(DEGREE_ANGLE, "\u00b0");
        SimpleUnitFormat.getInstance().label(DEUTSCHE_HAERTE, DEUTSCHE_HAERTE.getSymbol());
        SimpleUnitFormat.getInstance().label(DOBSON_UNIT, "DU");
        SimpleUnitFormat.getInstance().label(GRAM_PER_KILOWATT_HOUR, "g/kWh");
        SimpleUnitFormat.getInstance().label(GIGABYTE, "GB");
        SimpleUnitFormat.getInstance().label(GIBIBYTE, "GiB");
        SimpleUnitFormat.getInstance().alias(GIBIBYTE, "Gio");
        SimpleUnitFormat.getInstance().label(GIGABIT, "Gbit");
        SimpleUnitFormat.getInstance().label(GIGABIT_PER_SECOND, "Gbit/s");
        SimpleUnitFormat.getInstance().label(IRRADIANCE, "W/m\u00b2");
        SimpleUnitFormat.getInstance().label(KILOBYTE, "kB");
        SimpleUnitFormat.getInstance().label(KIBIBYTE, "kiB");
        SimpleUnitFormat.getInstance().alias(KIBIBYTE, "kio");
        SimpleUnitFormat.getInstance().label(KILOBIT, "kbit");
        SimpleUnitFormat.getInstance().label(KILOBIT_PER_SECOND, "kbit/s");
        SimpleUnitFormat.getInstance().label(KILOGRAM_PER_SQUARE_METRE, "kg/m\u00b2");
        SimpleUnitFormat.getInstance().label(KILOVAR, "kvar");
        SimpleUnitFormat.getInstance().label(KILOVAR_HOUR, "kvarh");
        SimpleUnitFormat.getInstance().label(KILOVOLT_AMPERE, "kVA");
        SimpleUnitFormat.getInstance().label(KILOWATT_HOUR, "kWh");
        SimpleUnitFormat.getInstance().label(KNOT, KNOT.getSymbol());
        SimpleUnitFormat.getInstance().label(LITRE_PER_MINUTE, "l/min");
        SimpleUnitFormat.getInstance().label(MEGABYTE, "MB");
        SimpleUnitFormat.getInstance().label(MEBIBYTE, "MiB");
        SimpleUnitFormat.getInstance().alias(MEBIBYTE, "Mio");
        SimpleUnitFormat.getInstance().label(MEGABIT, "Mbit");
        SimpleUnitFormat.getInstance().label(MEGABIT_PER_SECOND, "Mbit/s");
        SimpleUnitFormat.getInstance().label(MEGAWATT_HOUR, "MWh");
        SimpleUnitFormat.getInstance().label(MICROGRAM_PER_CUBICMETRE, "\u00b5g/m\u00b3");
        SimpleUnitFormat.getInstance().label(MICROWATT_PER_SQUARE_CENTIMETRE, "\u00b5W/cm\u00b2");
        SimpleUnitFormat.getInstance().label(MILLIAMPERE_HOUR, "mAh");
        SimpleUnitFormat.getInstance().label(MILLIBAR, "mbar");
        SimpleUnitFormat.getInstance().label(MILLIMETRE_OF_MERCURY, MILLIMETRE_OF_MERCURY.getSymbol());
        SimpleUnitFormat.getInstance().label(MIRED, "MK\u207b\u00b9");
        SimpleUnitFormat.getInstance().alias(MIRED, "mired");
        SimpleUnitFormat.getInstance().alias(MIRED, "mirek");
        SimpleUnitFormat.getInstance().label(PARTS_PER_BILLION, "ppb");
        SimpleUnitFormat.getInstance().label(PARTS_PER_MILLION, "ppm");
        SimpleUnitFormat.getInstance().label(PETABYTE, "PB");
        SimpleUnitFormat.getInstance().label(PEBIBYTE, "PiB");
        SimpleUnitFormat.getInstance().alias(PEBIBYTE, "Pio");
        SimpleUnitFormat.getInstance().label(PETABIT, "Pbit");
        SimpleUnitFormat.getInstance().label(RPM, "rpm");
        SimpleUnitFormat.getInstance().label(STANDARD_GRAVITY, "g\u2099");
        SimpleUnitFormat.getInstance().label(SIEMENS_PER_METRE, "S/m");
        SimpleUnitFormat.getInstance().label(TERABYTE, "TB");
        SimpleUnitFormat.getInstance().label(TEBIBYTE, "TiB");
        SimpleUnitFormat.getInstance().alias(TEBIBYTE, "Tio");
        SimpleUnitFormat.getInstance().label(TERABIT, "Tbit");
        SimpleUnitFormat.getInstance().label(TERABIT_PER_SECOND, "Tbit/s");
        SimpleUnitFormat.getInstance().label(VAR, "var");
        SimpleUnitFormat.getInstance().label(VAR_HOUR, "varh");
        SimpleUnitFormat.getInstance().label(VOLT_AMPERE, "VA");
        SimpleUnitFormat.getInstance().label(VOLT_AMPERE_HOUR, "VAh");
        SimpleUnitFormat.getInstance().label(WATT_HOUR, "Wh");
        SimpleUnitFormat.getInstance().label(WATT_HOUR_PER_SQUARE_METRE, "Wh/m\u00b2");
        SimpleUnitFormat.getInstance().label(WATT_SECOND, "Ws");
        SimpleUnitFormat.getInstance().alias(MONTH, "mo");
        SimpleUnitFormat.getInstance().alias(WEEK, "wk");
        SimpleUnitFormat.getInstance().alias(YEAR, "y");
    }

    private Units() {
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        Units.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        Units.INSTANCE.units.add(unit);
        Units.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }
}

