/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
	"time"
)

// CertificateInfo struct for CertificateInfo
type CertificateInfo struct {
	ExtKeyUsage *[]int64 `json:"ExtKeyUsage,omitempty"`
	// KeyUsage represents the set of actions that are valid for a given key. It's a bitmap of the KeyUsage* constants.
	KeyUsage *int64 `json:"KeyUsage,omitempty"`
	CrlDistributionPoints *[]string `json:"crl_distribution_points,omitempty"`
	DnsNames *[]string `json:"dns_names,omitempty"`
	EmailAddresses *[]string `json:"email_addresses,omitempty"`
	Extensions *[]Extension `json:"extensions,omitempty"`
	IpAddresses *[]string `json:"ip_addresses,omitempty"`
	IsCa *bool `json:"is_ca,omitempty"`
	Issuer *Name `json:"issuer,omitempty"`
	IssuingCertificateUrl *[]string `json:"issuing_certificate_url,omitempty"`
	KeySize *int64 `json:"key_size,omitempty"`
	NotAfter *time.Time `json:"not_after,omitempty"`
	NotBefore *time.Time `json:"not_before,omitempty"`
	OcspServer *[]string `json:"ocsp_server,omitempty"`
	PublicKeyAlgorithmName *string `json:"public_key_algorithm_name,omitempty"`
	SerialNumber *string `json:"serial_number,omitempty"`
	Sha1Fingerprint *string `json:"sha_1_fingerprint,omitempty"`
	Sha256Fingerprint *string `json:"sha_256_fingerprint,omitempty"`
	Signature *string `json:"signature,omitempty"`
	SignatureAlgorithmName *string `json:"signature_algorithm_name,omitempty"`
	Subject *Name `json:"subject,omitempty"`
	SubjectPublicKey *string `json:"subject_public_key,omitempty"`
	Uris *[]string `json:"uris,omitempty"`
	Version *int64 `json:"version,omitempty"`
}

// NewCertificateInfo instantiates a new CertificateInfo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCertificateInfo() *CertificateInfo {
	this := CertificateInfo{}
	return &this
}

// NewCertificateInfoWithDefaults instantiates a new CertificateInfo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCertificateInfoWithDefaults() *CertificateInfo {
	this := CertificateInfo{}
	return &this
}

// GetExtKeyUsage returns the ExtKeyUsage field value if set, zero value otherwise.
func (o *CertificateInfo) GetExtKeyUsage() []int64 {
	if o == nil || o.ExtKeyUsage == nil {
		var ret []int64
		return ret
	}
	return *o.ExtKeyUsage
}

// GetExtKeyUsageOk returns a tuple with the ExtKeyUsage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetExtKeyUsageOk() (*[]int64, bool) {
	if o == nil || o.ExtKeyUsage == nil {
		return nil, false
	}
	return o.ExtKeyUsage, true
}

// HasExtKeyUsage returns a boolean if a field has been set.
func (o *CertificateInfo) HasExtKeyUsage() bool {
	if o != nil && o.ExtKeyUsage != nil {
		return true
	}

	return false
}

// SetExtKeyUsage gets a reference to the given []int64 and assigns it to the ExtKeyUsage field.
func (o *CertificateInfo) SetExtKeyUsage(v []int64) {
	o.ExtKeyUsage = &v
}

// GetKeyUsage returns the KeyUsage field value if set, zero value otherwise.
func (o *CertificateInfo) GetKeyUsage() int64 {
	if o == nil || o.KeyUsage == nil {
		var ret int64
		return ret
	}
	return *o.KeyUsage
}

// GetKeyUsageOk returns a tuple with the KeyUsage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetKeyUsageOk() (*int64, bool) {
	if o == nil || o.KeyUsage == nil {
		return nil, false
	}
	return o.KeyUsage, true
}

// HasKeyUsage returns a boolean if a field has been set.
func (o *CertificateInfo) HasKeyUsage() bool {
	if o != nil && o.KeyUsage != nil {
		return true
	}

	return false
}

// SetKeyUsage gets a reference to the given int64 and assigns it to the KeyUsage field.
func (o *CertificateInfo) SetKeyUsage(v int64) {
	o.KeyUsage = &v
}

// GetCrlDistributionPoints returns the CrlDistributionPoints field value if set, zero value otherwise.
func (o *CertificateInfo) GetCrlDistributionPoints() []string {
	if o == nil || o.CrlDistributionPoints == nil {
		var ret []string
		return ret
	}
	return *o.CrlDistributionPoints
}

// GetCrlDistributionPointsOk returns a tuple with the CrlDistributionPoints field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetCrlDistributionPointsOk() (*[]string, bool) {
	if o == nil || o.CrlDistributionPoints == nil {
		return nil, false
	}
	return o.CrlDistributionPoints, true
}

// HasCrlDistributionPoints returns a boolean if a field has been set.
func (o *CertificateInfo) HasCrlDistributionPoints() bool {
	if o != nil && o.CrlDistributionPoints != nil {
		return true
	}

	return false
}

// SetCrlDistributionPoints gets a reference to the given []string and assigns it to the CrlDistributionPoints field.
func (o *CertificateInfo) SetCrlDistributionPoints(v []string) {
	o.CrlDistributionPoints = &v
}

// GetDnsNames returns the DnsNames field value if set, zero value otherwise.
func (o *CertificateInfo) GetDnsNames() []string {
	if o == nil || o.DnsNames == nil {
		var ret []string
		return ret
	}
	return *o.DnsNames
}

// GetDnsNamesOk returns a tuple with the DnsNames field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetDnsNamesOk() (*[]string, bool) {
	if o == nil || o.DnsNames == nil {
		return nil, false
	}
	return o.DnsNames, true
}

// HasDnsNames returns a boolean if a field has been set.
func (o *CertificateInfo) HasDnsNames() bool {
	if o != nil && o.DnsNames != nil {
		return true
	}

	return false
}

// SetDnsNames gets a reference to the given []string and assigns it to the DnsNames field.
func (o *CertificateInfo) SetDnsNames(v []string) {
	o.DnsNames = &v
}

// GetEmailAddresses returns the EmailAddresses field value if set, zero value otherwise.
func (o *CertificateInfo) GetEmailAddresses() []string {
	if o == nil || o.EmailAddresses == nil {
		var ret []string
		return ret
	}
	return *o.EmailAddresses
}

// GetEmailAddressesOk returns a tuple with the EmailAddresses field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetEmailAddressesOk() (*[]string, bool) {
	if o == nil || o.EmailAddresses == nil {
		return nil, false
	}
	return o.EmailAddresses, true
}

// HasEmailAddresses returns a boolean if a field has been set.
func (o *CertificateInfo) HasEmailAddresses() bool {
	if o != nil && o.EmailAddresses != nil {
		return true
	}

	return false
}

// SetEmailAddresses gets a reference to the given []string and assigns it to the EmailAddresses field.
func (o *CertificateInfo) SetEmailAddresses(v []string) {
	o.EmailAddresses = &v
}

// GetExtensions returns the Extensions field value if set, zero value otherwise.
func (o *CertificateInfo) GetExtensions() []Extension {
	if o == nil || o.Extensions == nil {
		var ret []Extension
		return ret
	}
	return *o.Extensions
}

// GetExtensionsOk returns a tuple with the Extensions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetExtensionsOk() (*[]Extension, bool) {
	if o == nil || o.Extensions == nil {
		return nil, false
	}
	return o.Extensions, true
}

// HasExtensions returns a boolean if a field has been set.
func (o *CertificateInfo) HasExtensions() bool {
	if o != nil && o.Extensions != nil {
		return true
	}

	return false
}

// SetExtensions gets a reference to the given []Extension and assigns it to the Extensions field.
func (o *CertificateInfo) SetExtensions(v []Extension) {
	o.Extensions = &v
}

// GetIpAddresses returns the IpAddresses field value if set, zero value otherwise.
func (o *CertificateInfo) GetIpAddresses() []string {
	if o == nil || o.IpAddresses == nil {
		var ret []string
		return ret
	}
	return *o.IpAddresses
}

// GetIpAddressesOk returns a tuple with the IpAddresses field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetIpAddressesOk() (*[]string, bool) {
	if o == nil || o.IpAddresses == nil {
		return nil, false
	}
	return o.IpAddresses, true
}

// HasIpAddresses returns a boolean if a field has been set.
func (o *CertificateInfo) HasIpAddresses() bool {
	if o != nil && o.IpAddresses != nil {
		return true
	}

	return false
}

// SetIpAddresses gets a reference to the given []string and assigns it to the IpAddresses field.
func (o *CertificateInfo) SetIpAddresses(v []string) {
	o.IpAddresses = &v
}

// GetIsCa returns the IsCa field value if set, zero value otherwise.
func (o *CertificateInfo) GetIsCa() bool {
	if o == nil || o.IsCa == nil {
		var ret bool
		return ret
	}
	return *o.IsCa
}

// GetIsCaOk returns a tuple with the IsCa field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetIsCaOk() (*bool, bool) {
	if o == nil || o.IsCa == nil {
		return nil, false
	}
	return o.IsCa, true
}

// HasIsCa returns a boolean if a field has been set.
func (o *CertificateInfo) HasIsCa() bool {
	if o != nil && o.IsCa != nil {
		return true
	}

	return false
}

// SetIsCa gets a reference to the given bool and assigns it to the IsCa field.
func (o *CertificateInfo) SetIsCa(v bool) {
	o.IsCa = &v
}

// GetIssuer returns the Issuer field value if set, zero value otherwise.
func (o *CertificateInfo) GetIssuer() Name {
	if o == nil || o.Issuer == nil {
		var ret Name
		return ret
	}
	return *o.Issuer
}

// GetIssuerOk returns a tuple with the Issuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetIssuerOk() (*Name, bool) {
	if o == nil || o.Issuer == nil {
		return nil, false
	}
	return o.Issuer, true
}

// HasIssuer returns a boolean if a field has been set.
func (o *CertificateInfo) HasIssuer() bool {
	if o != nil && o.Issuer != nil {
		return true
	}

	return false
}

// SetIssuer gets a reference to the given Name and assigns it to the Issuer field.
func (o *CertificateInfo) SetIssuer(v Name) {
	o.Issuer = &v
}

// GetIssuingCertificateUrl returns the IssuingCertificateUrl field value if set, zero value otherwise.
func (o *CertificateInfo) GetIssuingCertificateUrl() []string {
	if o == nil || o.IssuingCertificateUrl == nil {
		var ret []string
		return ret
	}
	return *o.IssuingCertificateUrl
}

// GetIssuingCertificateUrlOk returns a tuple with the IssuingCertificateUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetIssuingCertificateUrlOk() (*[]string, bool) {
	if o == nil || o.IssuingCertificateUrl == nil {
		return nil, false
	}
	return o.IssuingCertificateUrl, true
}

// HasIssuingCertificateUrl returns a boolean if a field has been set.
func (o *CertificateInfo) HasIssuingCertificateUrl() bool {
	if o != nil && o.IssuingCertificateUrl != nil {
		return true
	}

	return false
}

// SetIssuingCertificateUrl gets a reference to the given []string and assigns it to the IssuingCertificateUrl field.
func (o *CertificateInfo) SetIssuingCertificateUrl(v []string) {
	o.IssuingCertificateUrl = &v
}

// GetKeySize returns the KeySize field value if set, zero value otherwise.
func (o *CertificateInfo) GetKeySize() int64 {
	if o == nil || o.KeySize == nil {
		var ret int64
		return ret
	}
	return *o.KeySize
}

// GetKeySizeOk returns a tuple with the KeySize field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetKeySizeOk() (*int64, bool) {
	if o == nil || o.KeySize == nil {
		return nil, false
	}
	return o.KeySize, true
}

// HasKeySize returns a boolean if a field has been set.
func (o *CertificateInfo) HasKeySize() bool {
	if o != nil && o.KeySize != nil {
		return true
	}

	return false
}

// SetKeySize gets a reference to the given int64 and assigns it to the KeySize field.
func (o *CertificateInfo) SetKeySize(v int64) {
	o.KeySize = &v
}

// GetNotAfter returns the NotAfter field value if set, zero value otherwise.
func (o *CertificateInfo) GetNotAfter() time.Time {
	if o == nil || o.NotAfter == nil {
		var ret time.Time
		return ret
	}
	return *o.NotAfter
}

// GetNotAfterOk returns a tuple with the NotAfter field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetNotAfterOk() (*time.Time, bool) {
	if o == nil || o.NotAfter == nil {
		return nil, false
	}
	return o.NotAfter, true
}

// HasNotAfter returns a boolean if a field has been set.
func (o *CertificateInfo) HasNotAfter() bool {
	if o != nil && o.NotAfter != nil {
		return true
	}

	return false
}

// SetNotAfter gets a reference to the given time.Time and assigns it to the NotAfter field.
func (o *CertificateInfo) SetNotAfter(v time.Time) {
	o.NotAfter = &v
}

// GetNotBefore returns the NotBefore field value if set, zero value otherwise.
func (o *CertificateInfo) GetNotBefore() time.Time {
	if o == nil || o.NotBefore == nil {
		var ret time.Time
		return ret
	}
	return *o.NotBefore
}

// GetNotBeforeOk returns a tuple with the NotBefore field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetNotBeforeOk() (*time.Time, bool) {
	if o == nil || o.NotBefore == nil {
		return nil, false
	}
	return o.NotBefore, true
}

// HasNotBefore returns a boolean if a field has been set.
func (o *CertificateInfo) HasNotBefore() bool {
	if o != nil && o.NotBefore != nil {
		return true
	}

	return false
}

// SetNotBefore gets a reference to the given time.Time and assigns it to the NotBefore field.
func (o *CertificateInfo) SetNotBefore(v time.Time) {
	o.NotBefore = &v
}

// GetOcspServer returns the OcspServer field value if set, zero value otherwise.
func (o *CertificateInfo) GetOcspServer() []string {
	if o == nil || o.OcspServer == nil {
		var ret []string
		return ret
	}
	return *o.OcspServer
}

// GetOcspServerOk returns a tuple with the OcspServer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetOcspServerOk() (*[]string, bool) {
	if o == nil || o.OcspServer == nil {
		return nil, false
	}
	return o.OcspServer, true
}

// HasOcspServer returns a boolean if a field has been set.
func (o *CertificateInfo) HasOcspServer() bool {
	if o != nil && o.OcspServer != nil {
		return true
	}

	return false
}

// SetOcspServer gets a reference to the given []string and assigns it to the OcspServer field.
func (o *CertificateInfo) SetOcspServer(v []string) {
	o.OcspServer = &v
}

// GetPublicKeyAlgorithmName returns the PublicKeyAlgorithmName field value if set, zero value otherwise.
func (o *CertificateInfo) GetPublicKeyAlgorithmName() string {
	if o == nil || o.PublicKeyAlgorithmName == nil {
		var ret string
		return ret
	}
	return *o.PublicKeyAlgorithmName
}

// GetPublicKeyAlgorithmNameOk returns a tuple with the PublicKeyAlgorithmName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetPublicKeyAlgorithmNameOk() (*string, bool) {
	if o == nil || o.PublicKeyAlgorithmName == nil {
		return nil, false
	}
	return o.PublicKeyAlgorithmName, true
}

// HasPublicKeyAlgorithmName returns a boolean if a field has been set.
func (o *CertificateInfo) HasPublicKeyAlgorithmName() bool {
	if o != nil && o.PublicKeyAlgorithmName != nil {
		return true
	}

	return false
}

// SetPublicKeyAlgorithmName gets a reference to the given string and assigns it to the PublicKeyAlgorithmName field.
func (o *CertificateInfo) SetPublicKeyAlgorithmName(v string) {
	o.PublicKeyAlgorithmName = &v
}

// GetSerialNumber returns the SerialNumber field value if set, zero value otherwise.
func (o *CertificateInfo) GetSerialNumber() string {
	if o == nil || o.SerialNumber == nil {
		var ret string
		return ret
	}
	return *o.SerialNumber
}

// GetSerialNumberOk returns a tuple with the SerialNumber field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetSerialNumberOk() (*string, bool) {
	if o == nil || o.SerialNumber == nil {
		return nil, false
	}
	return o.SerialNumber, true
}

// HasSerialNumber returns a boolean if a field has been set.
func (o *CertificateInfo) HasSerialNumber() bool {
	if o != nil && o.SerialNumber != nil {
		return true
	}

	return false
}

// SetSerialNumber gets a reference to the given string and assigns it to the SerialNumber field.
func (o *CertificateInfo) SetSerialNumber(v string) {
	o.SerialNumber = &v
}

// GetSha1Fingerprint returns the Sha1Fingerprint field value if set, zero value otherwise.
func (o *CertificateInfo) GetSha1Fingerprint() string {
	if o == nil || o.Sha1Fingerprint == nil {
		var ret string
		return ret
	}
	return *o.Sha1Fingerprint
}

// GetSha1FingerprintOk returns a tuple with the Sha1Fingerprint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetSha1FingerprintOk() (*string, bool) {
	if o == nil || o.Sha1Fingerprint == nil {
		return nil, false
	}
	return o.Sha1Fingerprint, true
}

// HasSha1Fingerprint returns a boolean if a field has been set.
func (o *CertificateInfo) HasSha1Fingerprint() bool {
	if o != nil && o.Sha1Fingerprint != nil {
		return true
	}

	return false
}

// SetSha1Fingerprint gets a reference to the given string and assigns it to the Sha1Fingerprint field.
func (o *CertificateInfo) SetSha1Fingerprint(v string) {
	o.Sha1Fingerprint = &v
}

// GetSha256Fingerprint returns the Sha256Fingerprint field value if set, zero value otherwise.
func (o *CertificateInfo) GetSha256Fingerprint() string {
	if o == nil || o.Sha256Fingerprint == nil {
		var ret string
		return ret
	}
	return *o.Sha256Fingerprint
}

// GetSha256FingerprintOk returns a tuple with the Sha256Fingerprint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetSha256FingerprintOk() (*string, bool) {
	if o == nil || o.Sha256Fingerprint == nil {
		return nil, false
	}
	return o.Sha256Fingerprint, true
}

// HasSha256Fingerprint returns a boolean if a field has been set.
func (o *CertificateInfo) HasSha256Fingerprint() bool {
	if o != nil && o.Sha256Fingerprint != nil {
		return true
	}

	return false
}

// SetSha256Fingerprint gets a reference to the given string and assigns it to the Sha256Fingerprint field.
func (o *CertificateInfo) SetSha256Fingerprint(v string) {
	o.Sha256Fingerprint = &v
}

// GetSignature returns the Signature field value if set, zero value otherwise.
func (o *CertificateInfo) GetSignature() string {
	if o == nil || o.Signature == nil {
		var ret string
		return ret
	}
	return *o.Signature
}

// GetSignatureOk returns a tuple with the Signature field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetSignatureOk() (*string, bool) {
	if o == nil || o.Signature == nil {
		return nil, false
	}
	return o.Signature, true
}

// HasSignature returns a boolean if a field has been set.
func (o *CertificateInfo) HasSignature() bool {
	if o != nil && o.Signature != nil {
		return true
	}

	return false
}

// SetSignature gets a reference to the given string and assigns it to the Signature field.
func (o *CertificateInfo) SetSignature(v string) {
	o.Signature = &v
}

// GetSignatureAlgorithmName returns the SignatureAlgorithmName field value if set, zero value otherwise.
func (o *CertificateInfo) GetSignatureAlgorithmName() string {
	if o == nil || o.SignatureAlgorithmName == nil {
		var ret string
		return ret
	}
	return *o.SignatureAlgorithmName
}

// GetSignatureAlgorithmNameOk returns a tuple with the SignatureAlgorithmName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetSignatureAlgorithmNameOk() (*string, bool) {
	if o == nil || o.SignatureAlgorithmName == nil {
		return nil, false
	}
	return o.SignatureAlgorithmName, true
}

// HasSignatureAlgorithmName returns a boolean if a field has been set.
func (o *CertificateInfo) HasSignatureAlgorithmName() bool {
	if o != nil && o.SignatureAlgorithmName != nil {
		return true
	}

	return false
}

// SetSignatureAlgorithmName gets a reference to the given string and assigns it to the SignatureAlgorithmName field.
func (o *CertificateInfo) SetSignatureAlgorithmName(v string) {
	o.SignatureAlgorithmName = &v
}

// GetSubject returns the Subject field value if set, zero value otherwise.
func (o *CertificateInfo) GetSubject() Name {
	if o == nil || o.Subject == nil {
		var ret Name
		return ret
	}
	return *o.Subject
}

// GetSubjectOk returns a tuple with the Subject field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetSubjectOk() (*Name, bool) {
	if o == nil || o.Subject == nil {
		return nil, false
	}
	return o.Subject, true
}

// HasSubject returns a boolean if a field has been set.
func (o *CertificateInfo) HasSubject() bool {
	if o != nil && o.Subject != nil {
		return true
	}

	return false
}

// SetSubject gets a reference to the given Name and assigns it to the Subject field.
func (o *CertificateInfo) SetSubject(v Name) {
	o.Subject = &v
}

// GetSubjectPublicKey returns the SubjectPublicKey field value if set, zero value otherwise.
func (o *CertificateInfo) GetSubjectPublicKey() string {
	if o == nil || o.SubjectPublicKey == nil {
		var ret string
		return ret
	}
	return *o.SubjectPublicKey
}

// GetSubjectPublicKeyOk returns a tuple with the SubjectPublicKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetSubjectPublicKeyOk() (*string, bool) {
	if o == nil || o.SubjectPublicKey == nil {
		return nil, false
	}
	return o.SubjectPublicKey, true
}

// HasSubjectPublicKey returns a boolean if a field has been set.
func (o *CertificateInfo) HasSubjectPublicKey() bool {
	if o != nil && o.SubjectPublicKey != nil {
		return true
	}

	return false
}

// SetSubjectPublicKey gets a reference to the given string and assigns it to the SubjectPublicKey field.
func (o *CertificateInfo) SetSubjectPublicKey(v string) {
	o.SubjectPublicKey = &v
}

// GetUris returns the Uris field value if set, zero value otherwise.
func (o *CertificateInfo) GetUris() []string {
	if o == nil || o.Uris == nil {
		var ret []string
		return ret
	}
	return *o.Uris
}

// GetUrisOk returns a tuple with the Uris field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetUrisOk() (*[]string, bool) {
	if o == nil || o.Uris == nil {
		return nil, false
	}
	return o.Uris, true
}

// HasUris returns a boolean if a field has been set.
func (o *CertificateInfo) HasUris() bool {
	if o != nil && o.Uris != nil {
		return true
	}

	return false
}

// SetUris gets a reference to the given []string and assigns it to the Uris field.
func (o *CertificateInfo) SetUris(v []string) {
	o.Uris = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *CertificateInfo) GetVersion() int64 {
	if o == nil || o.Version == nil {
		var ret int64
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateInfo) GetVersionOk() (*int64, bool) {
	if o == nil || o.Version == nil {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *CertificateInfo) HasVersion() bool {
	if o != nil && o.Version != nil {
		return true
	}

	return false
}

// SetVersion gets a reference to the given int64 and assigns it to the Version field.
func (o *CertificateInfo) SetVersion(v int64) {
	o.Version = &v
}

func (o CertificateInfo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ExtKeyUsage != nil {
		toSerialize["ExtKeyUsage"] = o.ExtKeyUsage
	}
	if o.KeyUsage != nil {
		toSerialize["KeyUsage"] = o.KeyUsage
	}
	if o.CrlDistributionPoints != nil {
		toSerialize["crl_distribution_points"] = o.CrlDistributionPoints
	}
	if o.DnsNames != nil {
		toSerialize["dns_names"] = o.DnsNames
	}
	if o.EmailAddresses != nil {
		toSerialize["email_addresses"] = o.EmailAddresses
	}
	if o.Extensions != nil {
		toSerialize["extensions"] = o.Extensions
	}
	if o.IpAddresses != nil {
		toSerialize["ip_addresses"] = o.IpAddresses
	}
	if o.IsCa != nil {
		toSerialize["is_ca"] = o.IsCa
	}
	if o.Issuer != nil {
		toSerialize["issuer"] = o.Issuer
	}
	if o.IssuingCertificateUrl != nil {
		toSerialize["issuing_certificate_url"] = o.IssuingCertificateUrl
	}
	if o.KeySize != nil {
		toSerialize["key_size"] = o.KeySize
	}
	if o.NotAfter != nil {
		toSerialize["not_after"] = o.NotAfter
	}
	if o.NotBefore != nil {
		toSerialize["not_before"] = o.NotBefore
	}
	if o.OcspServer != nil {
		toSerialize["ocsp_server"] = o.OcspServer
	}
	if o.PublicKeyAlgorithmName != nil {
		toSerialize["public_key_algorithm_name"] = o.PublicKeyAlgorithmName
	}
	if o.SerialNumber != nil {
		toSerialize["serial_number"] = o.SerialNumber
	}
	if o.Sha1Fingerprint != nil {
		toSerialize["sha_1_fingerprint"] = o.Sha1Fingerprint
	}
	if o.Sha256Fingerprint != nil {
		toSerialize["sha_256_fingerprint"] = o.Sha256Fingerprint
	}
	if o.Signature != nil {
		toSerialize["signature"] = o.Signature
	}
	if o.SignatureAlgorithmName != nil {
		toSerialize["signature_algorithm_name"] = o.SignatureAlgorithmName
	}
	if o.Subject != nil {
		toSerialize["subject"] = o.Subject
	}
	if o.SubjectPublicKey != nil {
		toSerialize["subject_public_key"] = o.SubjectPublicKey
	}
	if o.Uris != nil {
		toSerialize["uris"] = o.Uris
	}
	if o.Version != nil {
		toSerialize["version"] = o.Version
	}
	return json.Marshal(toSerialize)
}

type NullableCertificateInfo struct {
	value *CertificateInfo
	isSet bool
}

func (v NullableCertificateInfo) Get() *CertificateInfo {
	return v.value
}

func (v *NullableCertificateInfo) Set(val *CertificateInfo) {
	v.value = val
	v.isSet = true
}

func (v NullableCertificateInfo) IsSet() bool {
	return v.isSet
}

func (v *NullableCertificateInfo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCertificateInfo(val *CertificateInfo) *NullableCertificateInfo {
	return &NullableCertificateInfo{value: val, isSet: true}
}

func (v NullableCertificateInfo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCertificateInfo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


