/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// KubeconfigContext struct for KubeconfigContext
type KubeconfigContext struct {
	Cluster *string `json:"cluster,omitempty"`
	Namespace *string `json:"namespace,omitempty"`
	User *string `json:"user,omitempty"`
}

// NewKubeconfigContext instantiates a new KubeconfigContext object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewKubeconfigContext() *KubeconfigContext {
	this := KubeconfigContext{}
	return &this
}

// NewKubeconfigContextWithDefaults instantiates a new KubeconfigContext object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewKubeconfigContextWithDefaults() *KubeconfigContext {
	this := KubeconfigContext{}
	return &this
}

// GetCluster returns the Cluster field value if set, zero value otherwise.
func (o *KubeconfigContext) GetCluster() string {
	if o == nil || o.Cluster == nil {
		var ret string
		return ret
	}
	return *o.Cluster
}

// GetClusterOk returns a tuple with the Cluster field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KubeconfigContext) GetClusterOk() (*string, bool) {
	if o == nil || o.Cluster == nil {
		return nil, false
	}
	return o.Cluster, true
}

// HasCluster returns a boolean if a field has been set.
func (o *KubeconfigContext) HasCluster() bool {
	if o != nil && o.Cluster != nil {
		return true
	}

	return false
}

// SetCluster gets a reference to the given string and assigns it to the Cluster field.
func (o *KubeconfigContext) SetCluster(v string) {
	o.Cluster = &v
}

// GetNamespace returns the Namespace field value if set, zero value otherwise.
func (o *KubeconfigContext) GetNamespace() string {
	if o == nil || o.Namespace == nil {
		var ret string
		return ret
	}
	return *o.Namespace
}

// GetNamespaceOk returns a tuple with the Namespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KubeconfigContext) GetNamespaceOk() (*string, bool) {
	if o == nil || o.Namespace == nil {
		return nil, false
	}
	return o.Namespace, true
}

// HasNamespace returns a boolean if a field has been set.
func (o *KubeconfigContext) HasNamespace() bool {
	if o != nil && o.Namespace != nil {
		return true
	}

	return false
}

// SetNamespace gets a reference to the given string and assigns it to the Namespace field.
func (o *KubeconfigContext) SetNamespace(v string) {
	o.Namespace = &v
}

// GetUser returns the User field value if set, zero value otherwise.
func (o *KubeconfigContext) GetUser() string {
	if o == nil || o.User == nil {
		var ret string
		return ret
	}
	return *o.User
}

// GetUserOk returns a tuple with the User field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KubeconfigContext) GetUserOk() (*string, bool) {
	if o == nil || o.User == nil {
		return nil, false
	}
	return o.User, true
}

// HasUser returns a boolean if a field has been set.
func (o *KubeconfigContext) HasUser() bool {
	if o != nil && o.User != nil {
		return true
	}

	return false
}

// SetUser gets a reference to the given string and assigns it to the User field.
func (o *KubeconfigContext) SetUser(v string) {
	o.User = &v
}

func (o KubeconfigContext) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Cluster != nil {
		toSerialize["cluster"] = o.Cluster
	}
	if o.Namespace != nil {
		toSerialize["namespace"] = o.Namespace
	}
	if o.User != nil {
		toSerialize["user"] = o.User
	}
	return json.Marshal(toSerialize)
}

type NullableKubeconfigContext struct {
	value *KubeconfigContext
	isSet bool
}

func (v NullableKubeconfigContext) Get() *KubeconfigContext {
	return v.value
}

func (v *NullableKubeconfigContext) Set(val *KubeconfigContext) {
	v.value = val
	v.isSet = true
}

func (v NullableKubeconfigContext) IsSet() bool {
	return v.isSet
}

func (v *NullableKubeconfigContext) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableKubeconfigContext(val *KubeconfigContext) *NullableKubeconfigContext {
	return &NullableKubeconfigContext{value: val, isSet: true}
}

func (v NullableKubeconfigContext) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableKubeconfigContext) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


