// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by sidekick. DO NOT EDIT.

#[allow(unused_imports)]
use super::*;

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::Api {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __methods,
            __options,
            __version,
            __source_context,
            __mixins,
            __syntax,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Api")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "methods" => Ok(__FieldTag::__methods),
                            "options" => Ok(__FieldTag::__options),
                            "version" => Ok(__FieldTag::__version),
                            "sourceContext" => Ok(__FieldTag::__source_context),
                            "source_context" => Ok(__FieldTag::__source_context),
                            "mixins" => Ok(__FieldTag::__mixins),
                            "syntax" => Ok(__FieldTag::__syntax),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::Api;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Api")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__methods => {
                            if !fields.insert(__FieldTag::__methods) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for methods",
                                ));
                            }
                            result.methods = map
                                .next_value::<std::option::Option<std::vec::Vec<crate::Method>>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options = map
                                .next_value::<std::option::Option<std::vec::Vec<crate::Option>>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__version => {
                            if !fields.insert(__FieldTag::__version) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for version",
                                ));
                            }
                            result.version = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__source_context => {
                            if !fields.insert(__FieldTag::__source_context) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for source_context",
                                ));
                            }
                            result.source_context =
                                map.next_value::<std::option::Option<crate::SourceContext>>()?;
                        }
                        __FieldTag::__mixins => {
                            if !fields.insert(__FieldTag::__mixins) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for mixins",
                                ));
                            }
                            result.mixins = map
                                .next_value::<std::option::Option<std::vec::Vec<crate::Mixin>>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__syntax => {
                            if !fields.insert(__FieldTag::__syntax) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for syntax",
                                ));
                            }
                            result.syntax = map
                                .next_value::<std::option::Option<crate::Syntax>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::Method {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __request_type_url,
            __request_streaming,
            __response_type_url,
            __response_streaming,
            __options,
            __syntax,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Method")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "requestTypeUrl" => Ok(__FieldTag::__request_type_url),
                            "request_type_url" => Ok(__FieldTag::__request_type_url),
                            "requestStreaming" => Ok(__FieldTag::__request_streaming),
                            "request_streaming" => Ok(__FieldTag::__request_streaming),
                            "responseTypeUrl" => Ok(__FieldTag::__response_type_url),
                            "response_type_url" => Ok(__FieldTag::__response_type_url),
                            "responseStreaming" => Ok(__FieldTag::__response_streaming),
                            "response_streaming" => Ok(__FieldTag::__response_streaming),
                            "options" => Ok(__FieldTag::__options),
                            "syntax" => Ok(__FieldTag::__syntax),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::Method;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Method")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__request_type_url => {
                            if !fields.insert(__FieldTag::__request_type_url) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for request_type_url",
                                ));
                            }
                            result.request_type_url = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__request_streaming => {
                            if !fields.insert(__FieldTag::__request_streaming) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for request_streaming",
                                ));
                            }
                            result.request_streaming = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__response_type_url => {
                            if !fields.insert(__FieldTag::__response_type_url) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for response_type_url",
                                ));
                            }
                            result.response_type_url = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__response_streaming => {
                            if !fields.insert(__FieldTag::__response_streaming) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for response_streaming",
                                ));
                            }
                            result.response_streaming = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options = map
                                .next_value::<std::option::Option<std::vec::Vec<crate::Option>>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__syntax => {
                            if !fields.insert(__FieldTag::__syntax) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for syntax",
                                ));
                            }
                            result.syntax = map
                                .next_value::<std::option::Option<crate::Syntax>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::Mixin {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __root,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Mixin")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "root" => Ok(__FieldTag::__root),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::Mixin;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Mixin")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__root => {
                            if !fields.insert(__FieldTag::__root) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for root",
                                ));
                            }
                            result.root = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::FileDescriptorSet {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __file,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for FileDescriptorSet")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "file" => Ok(__FieldTag::__file),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::FileDescriptorSet;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct FileDescriptorSet")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__file => {
                            if !fields.insert(__FieldTag::__file) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for file",
                                ));
                            }
                            result.file = map.next_value::<std::option::Option<std::vec::Vec<crate::FileDescriptorProto>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::FileDescriptorProto {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __package,
            __dependency,
            __public_dependency,
            __weak_dependency,
            __message_type,
            __enum_type,
            __service,
            __extension,
            __options,
            __source_code_info,
            __syntax,
            __edition,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for FileDescriptorProto")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "package" => Ok(__FieldTag::__package),
                            "dependency" => Ok(__FieldTag::__dependency),
                            "publicDependency" => Ok(__FieldTag::__public_dependency),
                            "public_dependency" => Ok(__FieldTag::__public_dependency),
                            "weakDependency" => Ok(__FieldTag::__weak_dependency),
                            "weak_dependency" => Ok(__FieldTag::__weak_dependency),
                            "messageType" => Ok(__FieldTag::__message_type),
                            "message_type" => Ok(__FieldTag::__message_type),
                            "enumType" => Ok(__FieldTag::__enum_type),
                            "enum_type" => Ok(__FieldTag::__enum_type),
                            "service" => Ok(__FieldTag::__service),
                            "extension" => Ok(__FieldTag::__extension),
                            "options" => Ok(__FieldTag::__options),
                            "sourceCodeInfo" => Ok(__FieldTag::__source_code_info),
                            "source_code_info" => Ok(__FieldTag::__source_code_info),
                            "syntax" => Ok(__FieldTag::__syntax),
                            "edition" => Ok(__FieldTag::__edition),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::FileDescriptorProto;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct FileDescriptorProto")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__package => {
                            if !fields.insert(__FieldTag::__package) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for package",
                                ));
                            }
                            result.package = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__dependency => {
                            if !fields.insert(__FieldTag::__dependency) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for dependency",
                                ));
                            }
                            result.dependency = map.next_value::<std::option::Option<std::vec::Vec<std::string::String>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__public_dependency => {
                            if !fields.insert(__FieldTag::__public_dependency) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for public_dependency",
                                ));
                            }
                            struct __With(std::option::Option<std::vec::Vec<i32>>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::<
                                        std::option::Option<std::vec::Vec<wkt::internal::I32>>,
                                    >::deserialize(deserializer)
                                    .map(__With)
                                }
                            }
                            result.public_dependency =
                                map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__weak_dependency => {
                            if !fields.insert(__FieldTag::__weak_dependency) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for weak_dependency",
                                ));
                            }
                            struct __With(std::option::Option<std::vec::Vec<i32>>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::<
                                        std::option::Option<std::vec::Vec<wkt::internal::I32>>,
                                    >::deserialize(deserializer)
                                    .map(__With)
                                }
                            }
                            result.weak_dependency =
                                map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__message_type => {
                            if !fields.insert(__FieldTag::__message_type) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for message_type",
                                ));
                            }
                            result.message_type = map.next_value::<std::option::Option<std::vec::Vec<crate::DescriptorProto>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__enum_type => {
                            if !fields.insert(__FieldTag::__enum_type) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for enum_type",
                                ));
                            }
                            result.enum_type = map.next_value::<std::option::Option<std::vec::Vec<crate::EnumDescriptorProto>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__service => {
                            if !fields.insert(__FieldTag::__service) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for service",
                                ));
                            }
                            result.service =
                                map.next_value::<std::option::Option<
                                    std::vec::Vec<crate::ServiceDescriptorProto>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__extension => {
                            if !fields.insert(__FieldTag::__extension) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for extension",
                                ));
                            }
                            result.extension = map.next_value::<std::option::Option<std::vec::Vec<crate::FieldDescriptorProto>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options =
                                map.next_value::<std::option::Option<crate::FileOptions>>()?;
                        }
                        __FieldTag::__source_code_info => {
                            if !fields.insert(__FieldTag::__source_code_info) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for source_code_info",
                                ));
                            }
                            result.source_code_info =
                                map.next_value::<std::option::Option<crate::SourceCodeInfo>>()?;
                        }
                        __FieldTag::__syntax => {
                            if !fields.insert(__FieldTag::__syntax) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for syntax",
                                ));
                            }
                            result.syntax = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__edition => {
                            if !fields.insert(__FieldTag::__edition) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for edition",
                                ));
                            }
                            result.edition = map
                                .next_value::<std::option::Option<crate::Edition>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::DescriptorProto {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __field,
            __extension,
            __nested_type,
            __enum_type,
            __extension_range,
            __oneof_decl,
            __options,
            __reserved_range,
            __reserved_name,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for DescriptorProto")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "field" => Ok(__FieldTag::__field),
                            "extension" => Ok(__FieldTag::__extension),
                            "nestedType" => Ok(__FieldTag::__nested_type),
                            "nested_type" => Ok(__FieldTag::__nested_type),
                            "enumType" => Ok(__FieldTag::__enum_type),
                            "enum_type" => Ok(__FieldTag::__enum_type),
                            "extensionRange" => Ok(__FieldTag::__extension_range),
                            "extension_range" => Ok(__FieldTag::__extension_range),
                            "oneofDecl" => Ok(__FieldTag::__oneof_decl),
                            "oneof_decl" => Ok(__FieldTag::__oneof_decl),
                            "options" => Ok(__FieldTag::__options),
                            "reservedRange" => Ok(__FieldTag::__reserved_range),
                            "reserved_range" => Ok(__FieldTag::__reserved_range),
                            "reservedName" => Ok(__FieldTag::__reserved_name),
                            "reserved_name" => Ok(__FieldTag::__reserved_name),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::DescriptorProto;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct DescriptorProto")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__field => {
                            if !fields.insert(__FieldTag::__field) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for field",
                                ));
                            }
                            result.field = map.next_value::<std::option::Option<std::vec::Vec<crate::FieldDescriptorProto>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__extension => {
                            if !fields.insert(__FieldTag::__extension) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for extension",
                                ));
                            }
                            result.extension = map.next_value::<std::option::Option<std::vec::Vec<crate::FieldDescriptorProto>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__nested_type => {
                            if !fields.insert(__FieldTag::__nested_type) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for nested_type",
                                ));
                            }
                            result.nested_type = map.next_value::<std::option::Option<std::vec::Vec<crate::DescriptorProto>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__enum_type => {
                            if !fields.insert(__FieldTag::__enum_type) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for enum_type",
                                ));
                            }
                            result.enum_type = map.next_value::<std::option::Option<std::vec::Vec<crate::EnumDescriptorProto>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__extension_range => {
                            if !fields.insert(__FieldTag::__extension_range) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for extension_range",
                                ));
                            }
                            result.extension_range = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<crate::descriptor_proto::ExtensionRange>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__oneof_decl => {
                            if !fields.insert(__FieldTag::__oneof_decl) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for oneof_decl",
                                ));
                            }
                            result.oneof_decl = map.next_value::<std::option::Option<std::vec::Vec<crate::OneofDescriptorProto>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options =
                                map.next_value::<std::option::Option<crate::MessageOptions>>()?;
                        }
                        __FieldTag::__reserved_range => {
                            if !fields.insert(__FieldTag::__reserved_range) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for reserved_range",
                                ));
                            }
                            result.reserved_range = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<crate::descriptor_proto::ReservedRange>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__reserved_name => {
                            if !fields.insert(__FieldTag::__reserved_name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for reserved_name",
                                ));
                            }
                            result.reserved_name = map.next_value::<std::option::Option<std::vec::Vec<std::string::String>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::descriptor_proto::ExtensionRange {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __start,
            __end,
            __options,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for ExtensionRange")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "start" => Ok(__FieldTag::__start),
                            "end" => Ok(__FieldTag::__end),
                            "options" => Ok(__FieldTag::__options),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::descriptor_proto::ExtensionRange;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct ExtensionRange")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__start => {
                            if !fields.insert(__FieldTag::__start) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for start",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.start = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__end => {
                            if !fields.insert(__FieldTag::__end) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for end",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.end = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options = map
                                .next_value::<std::option::Option<crate::ExtensionRangeOptions>>(
                                )?;
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::descriptor_proto::ReservedRange {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __start,
            __end,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for ReservedRange")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "start" => Ok(__FieldTag::__start),
                            "end" => Ok(__FieldTag::__end),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::descriptor_proto::ReservedRange;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct ReservedRange")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__start => {
                            if !fields.insert(__FieldTag::__start) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for start",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.start = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__end => {
                            if !fields.insert(__FieldTag::__end) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for end",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.end = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::ExtensionRangeOptions {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __uninterpreted_option,
            __declaration,
            __features,
            __verification,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for ExtensionRangeOptions")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "uninterpretedOption" => Ok(__FieldTag::__uninterpreted_option),
                            "uninterpreted_option" => Ok(__FieldTag::__uninterpreted_option),
                            "declaration" => Ok(__FieldTag::__declaration),
                            "features" => Ok(__FieldTag::__features),
                            "verification" => Ok(__FieldTag::__verification),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::ExtensionRangeOptions;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct ExtensionRangeOptions")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__uninterpreted_option => {
                            if !fields.insert(__FieldTag::__uninterpreted_option) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for uninterpreted_option",
                                ));
                            }
                            result.uninterpreted_option = map.next_value::<std::option::Option<std::vec::Vec<crate::UninterpretedOption>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__declaration => {
                            if !fields.insert(__FieldTag::__declaration) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for declaration",
                                ));
                            }
                            result.declaration = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<crate::extension_range_options::Declaration>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__features => {
                            if !fields.insert(__FieldTag::__features) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for features",
                                ));
                            }
                            result.features =
                                map.next_value::<std::option::Option<crate::FeatureSet>>()?;
                        }
                        __FieldTag::__verification => {
                            if !fields.insert(__FieldTag::__verification) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for verification",
                                ));
                            }
                            result.verification = map
                                .next_value::<std::option::Option<
                                    crate::extension_range_options::VerificationState,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::extension_range_options::Declaration {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __number,
            __full_name,
            __type,
            __reserved,
            __repeated,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Declaration")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "number" => Ok(__FieldTag::__number),
                            "fullName" => Ok(__FieldTag::__full_name),
                            "full_name" => Ok(__FieldTag::__full_name),
                            "type" => Ok(__FieldTag::__type),
                            "reserved" => Ok(__FieldTag::__reserved),
                            "repeated" => Ok(__FieldTag::__repeated),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::extension_range_options::Declaration;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Declaration")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__number => {
                            if !fields.insert(__FieldTag::__number) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for number",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.number = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__full_name => {
                            if !fields.insert(__FieldTag::__full_name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for full_name",
                                ));
                            }
                            result.full_name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__type => {
                            if !fields.insert(__FieldTag::__type) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for type",
                                ));
                            }
                            result.r#type = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__reserved => {
                            if !fields.insert(__FieldTag::__reserved) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for reserved",
                                ));
                            }
                            result.reserved = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__repeated => {
                            if !fields.insert(__FieldTag::__repeated) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for repeated",
                                ));
                            }
                            result.repeated = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::FieldDescriptorProto {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __number,
            __label,
            __type,
            __type_name,
            __extendee,
            __default_value,
            __oneof_index,
            __json_name,
            __options,
            __proto3_optional,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for FieldDescriptorProto")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "number" => Ok(__FieldTag::__number),
                            "label" => Ok(__FieldTag::__label),
                            "type" => Ok(__FieldTag::__type),
                            "typeName" => Ok(__FieldTag::__type_name),
                            "type_name" => Ok(__FieldTag::__type_name),
                            "extendee" => Ok(__FieldTag::__extendee),
                            "defaultValue" => Ok(__FieldTag::__default_value),
                            "default_value" => Ok(__FieldTag::__default_value),
                            "oneofIndex" => Ok(__FieldTag::__oneof_index),
                            "oneof_index" => Ok(__FieldTag::__oneof_index),
                            "jsonName" => Ok(__FieldTag::__json_name),
                            "json_name" => Ok(__FieldTag::__json_name),
                            "options" => Ok(__FieldTag::__options),
                            "proto3Optional" => Ok(__FieldTag::__proto3_optional),
                            "proto3_optional" => Ok(__FieldTag::__proto3_optional),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::FieldDescriptorProto;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct FieldDescriptorProto")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__number => {
                            if !fields.insert(__FieldTag::__number) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for number",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.number = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__label => {
                            if !fields.insert(__FieldTag::__label) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for label",
                                ));
                            }
                            result.label = map.next_value::<std::option::Option<crate::field_descriptor_proto::Label>>()?.unwrap_or_default();
                        }
                        __FieldTag::__type => {
                            if !fields.insert(__FieldTag::__type) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for type",
                                ));
                            }
                            result.r#type = map.next_value::<std::option::Option<crate::field_descriptor_proto::Type>>()?.unwrap_or_default();
                        }
                        __FieldTag::__type_name => {
                            if !fields.insert(__FieldTag::__type_name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for type_name",
                                ));
                            }
                            result.type_name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__extendee => {
                            if !fields.insert(__FieldTag::__extendee) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for extendee",
                                ));
                            }
                            result.extendee = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__default_value => {
                            if !fields.insert(__FieldTag::__default_value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for default_value",
                                ));
                            }
                            result.default_value = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__oneof_index => {
                            if !fields.insert(__FieldTag::__oneof_index) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for oneof_index",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.oneof_index = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__json_name => {
                            if !fields.insert(__FieldTag::__json_name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for json_name",
                                ));
                            }
                            result.json_name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options =
                                map.next_value::<std::option::Option<crate::FieldOptions>>()?;
                        }
                        __FieldTag::__proto3_optional => {
                            if !fields.insert(__FieldTag::__proto3_optional) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for proto3_optional",
                                ));
                            }
                            result.proto3_optional = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::OneofDescriptorProto {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __options,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for OneofDescriptorProto")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "options" => Ok(__FieldTag::__options),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::OneofDescriptorProto;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct OneofDescriptorProto")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options =
                                map.next_value::<std::option::Option<crate::OneofOptions>>()?;
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::EnumDescriptorProto {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __value,
            __options,
            __reserved_range,
            __reserved_name,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for EnumDescriptorProto")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "value" => Ok(__FieldTag::__value),
                            "options" => Ok(__FieldTag::__options),
                            "reservedRange" => Ok(__FieldTag::__reserved_range),
                            "reserved_range" => Ok(__FieldTag::__reserved_range),
                            "reservedName" => Ok(__FieldTag::__reserved_name),
                            "reserved_name" => Ok(__FieldTag::__reserved_name),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::EnumDescriptorProto;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct EnumDescriptorProto")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__value => {
                            if !fields.insert(__FieldTag::__value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for value",
                                ));
                            }
                            result.value =
                                map.next_value::<std::option::Option<
                                    std::vec::Vec<crate::EnumValueDescriptorProto>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options =
                                map.next_value::<std::option::Option<crate::EnumOptions>>()?;
                        }
                        __FieldTag::__reserved_range => {
                            if !fields.insert(__FieldTag::__reserved_range) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for reserved_range",
                                ));
                            }
                            result.reserved_range = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<crate::enum_descriptor_proto::EnumReservedRange>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__reserved_name => {
                            if !fields.insert(__FieldTag::__reserved_name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for reserved_name",
                                ));
                            }
                            result.reserved_name = map.next_value::<std::option::Option<std::vec::Vec<std::string::String>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::enum_descriptor_proto::EnumReservedRange {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __start,
            __end,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for EnumReservedRange")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "start" => Ok(__FieldTag::__start),
                            "end" => Ok(__FieldTag::__end),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::enum_descriptor_proto::EnumReservedRange;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct EnumReservedRange")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__start => {
                            if !fields.insert(__FieldTag::__start) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for start",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.start = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__end => {
                            if !fields.insert(__FieldTag::__end) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for end",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.end = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::EnumValueDescriptorProto {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __number,
            __options,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for EnumValueDescriptorProto")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "number" => Ok(__FieldTag::__number),
                            "options" => Ok(__FieldTag::__options),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::EnumValueDescriptorProto;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct EnumValueDescriptorProto")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__number => {
                            if !fields.insert(__FieldTag::__number) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for number",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.number = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options =
                                map.next_value::<std::option::Option<crate::EnumValueOptions>>()?;
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::ServiceDescriptorProto {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __method,
            __options,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for ServiceDescriptorProto")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "method" => Ok(__FieldTag::__method),
                            "options" => Ok(__FieldTag::__options),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::ServiceDescriptorProto;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct ServiceDescriptorProto")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__method => {
                            if !fields.insert(__FieldTag::__method) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for method",
                                ));
                            }
                            result.method =
                                map.next_value::<std::option::Option<
                                    std::vec::Vec<crate::MethodDescriptorProto>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options =
                                map.next_value::<std::option::Option<crate::ServiceOptions>>()?;
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::MethodDescriptorProto {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __input_type,
            __output_type,
            __options,
            __client_streaming,
            __server_streaming,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for MethodDescriptorProto")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "inputType" => Ok(__FieldTag::__input_type),
                            "input_type" => Ok(__FieldTag::__input_type),
                            "outputType" => Ok(__FieldTag::__output_type),
                            "output_type" => Ok(__FieldTag::__output_type),
                            "options" => Ok(__FieldTag::__options),
                            "clientStreaming" => Ok(__FieldTag::__client_streaming),
                            "client_streaming" => Ok(__FieldTag::__client_streaming),
                            "serverStreaming" => Ok(__FieldTag::__server_streaming),
                            "server_streaming" => Ok(__FieldTag::__server_streaming),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::MethodDescriptorProto;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct MethodDescriptorProto")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__input_type => {
                            if !fields.insert(__FieldTag::__input_type) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for input_type",
                                ));
                            }
                            result.input_type = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__output_type => {
                            if !fields.insert(__FieldTag::__output_type) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for output_type",
                                ));
                            }
                            result.output_type = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options =
                                map.next_value::<std::option::Option<crate::MethodOptions>>()?;
                        }
                        __FieldTag::__client_streaming => {
                            if !fields.insert(__FieldTag::__client_streaming) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for client_streaming",
                                ));
                            }
                            result.client_streaming = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__server_streaming => {
                            if !fields.insert(__FieldTag::__server_streaming) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for server_streaming",
                                ));
                            }
                            result.server_streaming = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::FileOptions {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __java_package,
            __java_outer_classname,
            __java_multiple_files,
            __java_generate_equals_and_hash,
            __java_string_check_utf8,
            __optimize_for,
            __go_package,
            __cc_generic_services,
            __java_generic_services,
            __py_generic_services,
            __deprecated,
            __cc_enable_arenas,
            __objc_class_prefix,
            __csharp_namespace,
            __swift_prefix,
            __php_class_prefix,
            __php_namespace,
            __php_metadata_namespace,
            __ruby_package,
            __features,
            __uninterpreted_option,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for FileOptions")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "javaPackage" => Ok(__FieldTag::__java_package),
                            "java_package" => Ok(__FieldTag::__java_package),
                            "javaOuterClassname" => Ok(__FieldTag::__java_outer_classname),
                            "java_outer_classname" => Ok(__FieldTag::__java_outer_classname),
                            "javaMultipleFiles" => Ok(__FieldTag::__java_multiple_files),
                            "java_multiple_files" => Ok(__FieldTag::__java_multiple_files),
                            "javaGenerateEqualsAndHash" => {
                                Ok(__FieldTag::__java_generate_equals_and_hash)
                            }
                            "java_generate_equals_and_hash" => {
                                Ok(__FieldTag::__java_generate_equals_and_hash)
                            }
                            "javaStringCheckUtf8" => Ok(__FieldTag::__java_string_check_utf8),
                            "java_string_check_utf8" => Ok(__FieldTag::__java_string_check_utf8),
                            "optimizeFor" => Ok(__FieldTag::__optimize_for),
                            "optimize_for" => Ok(__FieldTag::__optimize_for),
                            "goPackage" => Ok(__FieldTag::__go_package),
                            "go_package" => Ok(__FieldTag::__go_package),
                            "ccGenericServices" => Ok(__FieldTag::__cc_generic_services),
                            "cc_generic_services" => Ok(__FieldTag::__cc_generic_services),
                            "javaGenericServices" => Ok(__FieldTag::__java_generic_services),
                            "java_generic_services" => Ok(__FieldTag::__java_generic_services),
                            "pyGenericServices" => Ok(__FieldTag::__py_generic_services),
                            "py_generic_services" => Ok(__FieldTag::__py_generic_services),
                            "deprecated" => Ok(__FieldTag::__deprecated),
                            "ccEnableArenas" => Ok(__FieldTag::__cc_enable_arenas),
                            "cc_enable_arenas" => Ok(__FieldTag::__cc_enable_arenas),
                            "objcClassPrefix" => Ok(__FieldTag::__objc_class_prefix),
                            "objc_class_prefix" => Ok(__FieldTag::__objc_class_prefix),
                            "csharpNamespace" => Ok(__FieldTag::__csharp_namespace),
                            "csharp_namespace" => Ok(__FieldTag::__csharp_namespace),
                            "swiftPrefix" => Ok(__FieldTag::__swift_prefix),
                            "swift_prefix" => Ok(__FieldTag::__swift_prefix),
                            "phpClassPrefix" => Ok(__FieldTag::__php_class_prefix),
                            "php_class_prefix" => Ok(__FieldTag::__php_class_prefix),
                            "phpNamespace" => Ok(__FieldTag::__php_namespace),
                            "php_namespace" => Ok(__FieldTag::__php_namespace),
                            "phpMetadataNamespace" => Ok(__FieldTag::__php_metadata_namespace),
                            "php_metadata_namespace" => Ok(__FieldTag::__php_metadata_namespace),
                            "rubyPackage" => Ok(__FieldTag::__ruby_package),
                            "ruby_package" => Ok(__FieldTag::__ruby_package),
                            "features" => Ok(__FieldTag::__features),
                            "uninterpretedOption" => Ok(__FieldTag::__uninterpreted_option),
                            "uninterpreted_option" => Ok(__FieldTag::__uninterpreted_option),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::FileOptions;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct FileOptions")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__java_package => {
                            if !fields.insert(__FieldTag::__java_package) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for java_package",
                                ));
                            }
                            result.java_package = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__java_outer_classname => {
                            if !fields.insert(__FieldTag::__java_outer_classname) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for java_outer_classname",
                                ));
                            }
                            result.java_outer_classname = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__java_multiple_files => {
                            if !fields.insert(__FieldTag::__java_multiple_files) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for java_multiple_files",
                                ));
                            }
                            result.java_multiple_files = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__java_generate_equals_and_hash => {
                            if !fields.insert(__FieldTag::__java_generate_equals_and_hash) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for java_generate_equals_and_hash",
                                ));
                            }
                            result.java_generate_equals_and_hash = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__java_string_check_utf8 => {
                            if !fields.insert(__FieldTag::__java_string_check_utf8) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for java_string_check_utf8",
                                ));
                            }
                            result.java_string_check_utf8 = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__optimize_for => {
                            if !fields.insert(__FieldTag::__optimize_for) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for optimize_for",
                                ));
                            }
                            result.optimize_for = map.next_value::<std::option::Option<crate::file_options::OptimizeMode>>()?.unwrap_or_default();
                        }
                        __FieldTag::__go_package => {
                            if !fields.insert(__FieldTag::__go_package) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for go_package",
                                ));
                            }
                            result.go_package = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__cc_generic_services => {
                            if !fields.insert(__FieldTag::__cc_generic_services) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for cc_generic_services",
                                ));
                            }
                            result.cc_generic_services = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__java_generic_services => {
                            if !fields.insert(__FieldTag::__java_generic_services) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for java_generic_services",
                                ));
                            }
                            result.java_generic_services = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__py_generic_services => {
                            if !fields.insert(__FieldTag::__py_generic_services) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for py_generic_services",
                                ));
                            }
                            result.py_generic_services = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__deprecated => {
                            if !fields.insert(__FieldTag::__deprecated) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for deprecated",
                                ));
                            }
                            result.deprecated = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__cc_enable_arenas => {
                            if !fields.insert(__FieldTag::__cc_enable_arenas) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for cc_enable_arenas",
                                ));
                            }
                            result.cc_enable_arenas = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__objc_class_prefix => {
                            if !fields.insert(__FieldTag::__objc_class_prefix) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for objc_class_prefix",
                                ));
                            }
                            result.objc_class_prefix = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__csharp_namespace => {
                            if !fields.insert(__FieldTag::__csharp_namespace) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for csharp_namespace",
                                ));
                            }
                            result.csharp_namespace = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__swift_prefix => {
                            if !fields.insert(__FieldTag::__swift_prefix) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for swift_prefix",
                                ));
                            }
                            result.swift_prefix = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__php_class_prefix => {
                            if !fields.insert(__FieldTag::__php_class_prefix) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for php_class_prefix",
                                ));
                            }
                            result.php_class_prefix = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__php_namespace => {
                            if !fields.insert(__FieldTag::__php_namespace) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for php_namespace",
                                ));
                            }
                            result.php_namespace = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__php_metadata_namespace => {
                            if !fields.insert(__FieldTag::__php_metadata_namespace) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for php_metadata_namespace",
                                ));
                            }
                            result.php_metadata_namespace = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__ruby_package => {
                            if !fields.insert(__FieldTag::__ruby_package) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for ruby_package",
                                ));
                            }
                            result.ruby_package = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__features => {
                            if !fields.insert(__FieldTag::__features) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for features",
                                ));
                            }
                            result.features =
                                map.next_value::<std::option::Option<crate::FeatureSet>>()?;
                        }
                        __FieldTag::__uninterpreted_option => {
                            if !fields.insert(__FieldTag::__uninterpreted_option) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for uninterpreted_option",
                                ));
                            }
                            result.uninterpreted_option = map.next_value::<std::option::Option<std::vec::Vec<crate::UninterpretedOption>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::MessageOptions {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __message_set_wire_format,
            __no_standard_descriptor_accessor,
            __deprecated,
            __map_entry,
            __deprecated_legacy_json_field_conflicts,
            __features,
            __uninterpreted_option,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for MessageOptions")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "messageSetWireFormat" => Ok(__FieldTag::__message_set_wire_format),
                            "message_set_wire_format" => Ok(__FieldTag::__message_set_wire_format),
                            "noStandardDescriptorAccessor" => {
                                Ok(__FieldTag::__no_standard_descriptor_accessor)
                            }
                            "no_standard_descriptor_accessor" => {
                                Ok(__FieldTag::__no_standard_descriptor_accessor)
                            }
                            "deprecated" => Ok(__FieldTag::__deprecated),
                            "mapEntry" => Ok(__FieldTag::__map_entry),
                            "map_entry" => Ok(__FieldTag::__map_entry),
                            "deprecatedLegacyJsonFieldConflicts" => {
                                Ok(__FieldTag::__deprecated_legacy_json_field_conflicts)
                            }
                            "deprecated_legacy_json_field_conflicts" => {
                                Ok(__FieldTag::__deprecated_legacy_json_field_conflicts)
                            }
                            "features" => Ok(__FieldTag::__features),
                            "uninterpretedOption" => Ok(__FieldTag::__uninterpreted_option),
                            "uninterpreted_option" => Ok(__FieldTag::__uninterpreted_option),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::MessageOptions;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct MessageOptions")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__message_set_wire_format => {
                            if !fields.insert(__FieldTag::__message_set_wire_format) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for message_set_wire_format",
                                ));
                            }
                            result.message_set_wire_format = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__no_standard_descriptor_accessor => {
                            if !fields.insert(__FieldTag::__no_standard_descriptor_accessor) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for no_standard_descriptor_accessor",
                                ));
                            }
                            result.no_standard_descriptor_accessor = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__deprecated => {
                            if !fields.insert(__FieldTag::__deprecated) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for deprecated",
                                ));
                            }
                            result.deprecated = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__map_entry => {
                            if !fields.insert(__FieldTag::__map_entry) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for map_entry",
                                ));
                            }
                            result.map_entry = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__deprecated_legacy_json_field_conflicts => {
                            if !fields.insert(__FieldTag::__deprecated_legacy_json_field_conflicts)
                            {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for deprecated_legacy_json_field_conflicts",
                                ));
                            }
                            result.deprecated_legacy_json_field_conflicts = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__features => {
                            if !fields.insert(__FieldTag::__features) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for features",
                                ));
                            }
                            result.features =
                                map.next_value::<std::option::Option<crate::FeatureSet>>()?;
                        }
                        __FieldTag::__uninterpreted_option => {
                            if !fields.insert(__FieldTag::__uninterpreted_option) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for uninterpreted_option",
                                ));
                            }
                            result.uninterpreted_option = map.next_value::<std::option::Option<std::vec::Vec<crate::UninterpretedOption>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::FieldOptions {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __ctype,
            __packed,
            __jstype,
            __lazy,
            __unverified_lazy,
            __deprecated,
            __weak,
            __debug_redact,
            __retention,
            __targets,
            __edition_defaults,
            __features,
            __feature_support,
            __uninterpreted_option,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for FieldOptions")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "ctype" => Ok(__FieldTag::__ctype),
                            "packed" => Ok(__FieldTag::__packed),
                            "jstype" => Ok(__FieldTag::__jstype),
                            "lazy" => Ok(__FieldTag::__lazy),
                            "unverifiedLazy" => Ok(__FieldTag::__unverified_lazy),
                            "unverified_lazy" => Ok(__FieldTag::__unverified_lazy),
                            "deprecated" => Ok(__FieldTag::__deprecated),
                            "weak" => Ok(__FieldTag::__weak),
                            "debugRedact" => Ok(__FieldTag::__debug_redact),
                            "debug_redact" => Ok(__FieldTag::__debug_redact),
                            "retention" => Ok(__FieldTag::__retention),
                            "targets" => Ok(__FieldTag::__targets),
                            "editionDefaults" => Ok(__FieldTag::__edition_defaults),
                            "edition_defaults" => Ok(__FieldTag::__edition_defaults),
                            "features" => Ok(__FieldTag::__features),
                            "featureSupport" => Ok(__FieldTag::__feature_support),
                            "feature_support" => Ok(__FieldTag::__feature_support),
                            "uninterpretedOption" => Ok(__FieldTag::__uninterpreted_option),
                            "uninterpreted_option" => Ok(__FieldTag::__uninterpreted_option),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::FieldOptions;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct FieldOptions")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__ctype => {
                            if !fields.insert(__FieldTag::__ctype) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for ctype",
                                ));
                            }
                            result.ctype = map
                                .next_value::<std::option::Option<crate::field_options::CType>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__packed => {
                            if !fields.insert(__FieldTag::__packed) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for packed",
                                ));
                            }
                            result.packed = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__jstype => {
                            if !fields.insert(__FieldTag::__jstype) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for jstype",
                                ));
                            }
                            result.jstype = map
                                .next_value::<std::option::Option<crate::field_options::JSType>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__lazy => {
                            if !fields.insert(__FieldTag::__lazy) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for lazy",
                                ));
                            }
                            result.lazy = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__unverified_lazy => {
                            if !fields.insert(__FieldTag::__unverified_lazy) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for unverified_lazy",
                                ));
                            }
                            result.unverified_lazy = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__deprecated => {
                            if !fields.insert(__FieldTag::__deprecated) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for deprecated",
                                ));
                            }
                            result.deprecated = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__weak => {
                            if !fields.insert(__FieldTag::__weak) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for weak",
                                ));
                            }
                            result.weak = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__debug_redact => {
                            if !fields.insert(__FieldTag::__debug_redact) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for debug_redact",
                                ));
                            }
                            result.debug_redact = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__retention => {
                            if !fields.insert(__FieldTag::__retention) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for retention",
                                ));
                            }
                            result.retention = map.next_value::<std::option::Option<crate::field_options::OptionRetention>>()?.unwrap_or_default();
                        }
                        __FieldTag::__targets => {
                            if !fields.insert(__FieldTag::__targets) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for targets",
                                ));
                            }
                            result.targets = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<crate::field_options::OptionTargetType>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__edition_defaults => {
                            if !fields.insert(__FieldTag::__edition_defaults) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for edition_defaults",
                                ));
                            }
                            result.edition_defaults = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<crate::field_options::EditionDefault>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__features => {
                            if !fields.insert(__FieldTag::__features) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for features",
                                ));
                            }
                            result.features =
                                map.next_value::<std::option::Option<crate::FeatureSet>>()?;
                        }
                        __FieldTag::__feature_support => {
                            if !fields.insert(__FieldTag::__feature_support) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for feature_support",
                                ));
                            }
                            result.feature_support = map.next_value::<std::option::Option<crate::field_options::FeatureSupport>>()?
                                ;
                        }
                        __FieldTag::__uninterpreted_option => {
                            if !fields.insert(__FieldTag::__uninterpreted_option) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for uninterpreted_option",
                                ));
                            }
                            result.uninterpreted_option = map.next_value::<std::option::Option<std::vec::Vec<crate::UninterpretedOption>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::field_options::EditionDefault {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __edition,
            __value,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for EditionDefault")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "edition" => Ok(__FieldTag::__edition),
                            "value" => Ok(__FieldTag::__value),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::field_options::EditionDefault;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct EditionDefault")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__edition => {
                            if !fields.insert(__FieldTag::__edition) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for edition",
                                ));
                            }
                            result.edition = map
                                .next_value::<std::option::Option<crate::Edition>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__value => {
                            if !fields.insert(__FieldTag::__value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for value",
                                ));
                            }
                            result.value = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::field_options::FeatureSupport {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __edition_introduced,
            __edition_deprecated,
            __deprecation_warning,
            __edition_removed,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for FeatureSupport")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "editionIntroduced" => Ok(__FieldTag::__edition_introduced),
                            "edition_introduced" => Ok(__FieldTag::__edition_introduced),
                            "editionDeprecated" => Ok(__FieldTag::__edition_deprecated),
                            "edition_deprecated" => Ok(__FieldTag::__edition_deprecated),
                            "deprecationWarning" => Ok(__FieldTag::__deprecation_warning),
                            "deprecation_warning" => Ok(__FieldTag::__deprecation_warning),
                            "editionRemoved" => Ok(__FieldTag::__edition_removed),
                            "edition_removed" => Ok(__FieldTag::__edition_removed),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::field_options::FeatureSupport;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct FeatureSupport")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__edition_introduced => {
                            if !fields.insert(__FieldTag::__edition_introduced) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for edition_introduced",
                                ));
                            }
                            result.edition_introduced = map
                                .next_value::<std::option::Option<crate::Edition>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__edition_deprecated => {
                            if !fields.insert(__FieldTag::__edition_deprecated) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for edition_deprecated",
                                ));
                            }
                            result.edition_deprecated = map
                                .next_value::<std::option::Option<crate::Edition>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__deprecation_warning => {
                            if !fields.insert(__FieldTag::__deprecation_warning) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for deprecation_warning",
                                ));
                            }
                            result.deprecation_warning = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__edition_removed => {
                            if !fields.insert(__FieldTag::__edition_removed) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for edition_removed",
                                ));
                            }
                            result.edition_removed = map
                                .next_value::<std::option::Option<crate::Edition>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::OneofOptions {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __features,
            __uninterpreted_option,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for OneofOptions")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "features" => Ok(__FieldTag::__features),
                            "uninterpretedOption" => Ok(__FieldTag::__uninterpreted_option),
                            "uninterpreted_option" => Ok(__FieldTag::__uninterpreted_option),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::OneofOptions;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct OneofOptions")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__features => {
                            if !fields.insert(__FieldTag::__features) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for features",
                                ));
                            }
                            result.features =
                                map.next_value::<std::option::Option<crate::FeatureSet>>()?;
                        }
                        __FieldTag::__uninterpreted_option => {
                            if !fields.insert(__FieldTag::__uninterpreted_option) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for uninterpreted_option",
                                ));
                            }
                            result.uninterpreted_option = map.next_value::<std::option::Option<std::vec::Vec<crate::UninterpretedOption>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::EnumOptions {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __allow_alias,
            __deprecated,
            __deprecated_legacy_json_field_conflicts,
            __features,
            __uninterpreted_option,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for EnumOptions")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "allowAlias" => Ok(__FieldTag::__allow_alias),
                            "allow_alias" => Ok(__FieldTag::__allow_alias),
                            "deprecated" => Ok(__FieldTag::__deprecated),
                            "deprecatedLegacyJsonFieldConflicts" => {
                                Ok(__FieldTag::__deprecated_legacy_json_field_conflicts)
                            }
                            "deprecated_legacy_json_field_conflicts" => {
                                Ok(__FieldTag::__deprecated_legacy_json_field_conflicts)
                            }
                            "features" => Ok(__FieldTag::__features),
                            "uninterpretedOption" => Ok(__FieldTag::__uninterpreted_option),
                            "uninterpreted_option" => Ok(__FieldTag::__uninterpreted_option),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::EnumOptions;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct EnumOptions")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__allow_alias => {
                            if !fields.insert(__FieldTag::__allow_alias) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for allow_alias",
                                ));
                            }
                            result.allow_alias = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__deprecated => {
                            if !fields.insert(__FieldTag::__deprecated) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for deprecated",
                                ));
                            }
                            result.deprecated = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__deprecated_legacy_json_field_conflicts => {
                            if !fields.insert(__FieldTag::__deprecated_legacy_json_field_conflicts)
                            {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for deprecated_legacy_json_field_conflicts",
                                ));
                            }
                            result.deprecated_legacy_json_field_conflicts = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__features => {
                            if !fields.insert(__FieldTag::__features) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for features",
                                ));
                            }
                            result.features =
                                map.next_value::<std::option::Option<crate::FeatureSet>>()?;
                        }
                        __FieldTag::__uninterpreted_option => {
                            if !fields.insert(__FieldTag::__uninterpreted_option) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for uninterpreted_option",
                                ));
                            }
                            result.uninterpreted_option = map.next_value::<std::option::Option<std::vec::Vec<crate::UninterpretedOption>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::EnumValueOptions {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __deprecated,
            __features,
            __debug_redact,
            __feature_support,
            __uninterpreted_option,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for EnumValueOptions")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "deprecated" => Ok(__FieldTag::__deprecated),
                            "features" => Ok(__FieldTag::__features),
                            "debugRedact" => Ok(__FieldTag::__debug_redact),
                            "debug_redact" => Ok(__FieldTag::__debug_redact),
                            "featureSupport" => Ok(__FieldTag::__feature_support),
                            "feature_support" => Ok(__FieldTag::__feature_support),
                            "uninterpretedOption" => Ok(__FieldTag::__uninterpreted_option),
                            "uninterpreted_option" => Ok(__FieldTag::__uninterpreted_option),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::EnumValueOptions;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct EnumValueOptions")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__deprecated => {
                            if !fields.insert(__FieldTag::__deprecated) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for deprecated",
                                ));
                            }
                            result.deprecated = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__features => {
                            if !fields.insert(__FieldTag::__features) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for features",
                                ));
                            }
                            result.features =
                                map.next_value::<std::option::Option<crate::FeatureSet>>()?;
                        }
                        __FieldTag::__debug_redact => {
                            if !fields.insert(__FieldTag::__debug_redact) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for debug_redact",
                                ));
                            }
                            result.debug_redact = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__feature_support => {
                            if !fields.insert(__FieldTag::__feature_support) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for feature_support",
                                ));
                            }
                            result.feature_support = map.next_value::<std::option::Option<crate::field_options::FeatureSupport>>()?
                                ;
                        }
                        __FieldTag::__uninterpreted_option => {
                            if !fields.insert(__FieldTag::__uninterpreted_option) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for uninterpreted_option",
                                ));
                            }
                            result.uninterpreted_option = map.next_value::<std::option::Option<std::vec::Vec<crate::UninterpretedOption>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::ServiceOptions {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __features,
            __deprecated,
            __uninterpreted_option,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for ServiceOptions")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "features" => Ok(__FieldTag::__features),
                            "deprecated" => Ok(__FieldTag::__deprecated),
                            "uninterpretedOption" => Ok(__FieldTag::__uninterpreted_option),
                            "uninterpreted_option" => Ok(__FieldTag::__uninterpreted_option),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::ServiceOptions;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct ServiceOptions")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__features => {
                            if !fields.insert(__FieldTag::__features) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for features",
                                ));
                            }
                            result.features =
                                map.next_value::<std::option::Option<crate::FeatureSet>>()?;
                        }
                        __FieldTag::__deprecated => {
                            if !fields.insert(__FieldTag::__deprecated) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for deprecated",
                                ));
                            }
                            result.deprecated = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__uninterpreted_option => {
                            if !fields.insert(__FieldTag::__uninterpreted_option) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for uninterpreted_option",
                                ));
                            }
                            result.uninterpreted_option = map.next_value::<std::option::Option<std::vec::Vec<crate::UninterpretedOption>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::MethodOptions {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __deprecated,
            __idempotency_level,
            __features,
            __uninterpreted_option,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for MethodOptions")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "deprecated" => Ok(__FieldTag::__deprecated),
                            "idempotencyLevel" => Ok(__FieldTag::__idempotency_level),
                            "idempotency_level" => Ok(__FieldTag::__idempotency_level),
                            "features" => Ok(__FieldTag::__features),
                            "uninterpretedOption" => Ok(__FieldTag::__uninterpreted_option),
                            "uninterpreted_option" => Ok(__FieldTag::__uninterpreted_option),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::MethodOptions;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct MethodOptions")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__deprecated => {
                            if !fields.insert(__FieldTag::__deprecated) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for deprecated",
                                ));
                            }
                            result.deprecated = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__idempotency_level => {
                            if !fields.insert(__FieldTag::__idempotency_level) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for idempotency_level",
                                ));
                            }
                            result.idempotency_level = map.next_value::<std::option::Option<crate::method_options::IdempotencyLevel>>()?.unwrap_or_default();
                        }
                        __FieldTag::__features => {
                            if !fields.insert(__FieldTag::__features) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for features",
                                ));
                            }
                            result.features =
                                map.next_value::<std::option::Option<crate::FeatureSet>>()?;
                        }
                        __FieldTag::__uninterpreted_option => {
                            if !fields.insert(__FieldTag::__uninterpreted_option) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for uninterpreted_option",
                                ));
                            }
                            result.uninterpreted_option = map.next_value::<std::option::Option<std::vec::Vec<crate::UninterpretedOption>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::UninterpretedOption {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __identifier_value,
            __positive_int_value,
            __negative_int_value,
            __double_value,
            __string_value,
            __aggregate_value,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for UninterpretedOption")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "identifierValue" => Ok(__FieldTag::__identifier_value),
                            "identifier_value" => Ok(__FieldTag::__identifier_value),
                            "positiveIntValue" => Ok(__FieldTag::__positive_int_value),
                            "positive_int_value" => Ok(__FieldTag::__positive_int_value),
                            "negativeIntValue" => Ok(__FieldTag::__negative_int_value),
                            "negative_int_value" => Ok(__FieldTag::__negative_int_value),
                            "doubleValue" => Ok(__FieldTag::__double_value),
                            "double_value" => Ok(__FieldTag::__double_value),
                            "stringValue" => Ok(__FieldTag::__string_value),
                            "string_value" => Ok(__FieldTag::__string_value),
                            "aggregateValue" => Ok(__FieldTag::__aggregate_value),
                            "aggregate_value" => Ok(__FieldTag::__aggregate_value),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::UninterpretedOption;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct UninterpretedOption")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<crate::uninterpreted_option::NamePart>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__identifier_value => {
                            if !fields.insert(__FieldTag::__identifier_value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for identifier_value",
                                ));
                            }
                            result.identifier_value = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__positive_int_value => {
                            if !fields.insert(__FieldTag::__positive_int_value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for positive_int_value",
                                ));
                            }
                            struct __With(std::option::Option<u64>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::U64> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.positive_int_value =
                                map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__negative_int_value => {
                            if !fields.insert(__FieldTag::__negative_int_value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for negative_int_value",
                                ));
                            }
                            struct __With(std::option::Option<i64>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I64> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.negative_int_value =
                                map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__double_value => {
                            if !fields.insert(__FieldTag::__double_value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for double_value",
                                ));
                            }
                            struct __With(std::option::Option<f64>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::F64> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.double_value = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__string_value => {
                            if !fields.insert(__FieldTag::__string_value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for string_value",
                                ));
                            }
                            struct __With(std::option::Option<::bytes::Bytes>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<serde_with::base64::Base64> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.string_value = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__aggregate_value => {
                            if !fields.insert(__FieldTag::__aggregate_value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for aggregate_value",
                                ));
                            }
                            result.aggregate_value = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::uninterpreted_option::NamePart {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name_part,
            __is_extension,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for NamePart")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "namePart" => Ok(__FieldTag::__name_part),
                            "name_part" => Ok(__FieldTag::__name_part),
                            "isExtension" => Ok(__FieldTag::__is_extension),
                            "is_extension" => Ok(__FieldTag::__is_extension),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::uninterpreted_option::NamePart;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct NamePart")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name_part => {
                            if !fields.insert(__FieldTag::__name_part) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name_part",
                                ));
                            }
                            result.name_part = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__is_extension => {
                            if !fields.insert(__FieldTag::__is_extension) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for is_extension",
                                ));
                            }
                            result.is_extension = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::FeatureSet {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __field_presence,
            __enum_type,
            __repeated_field_encoding,
            __utf8_validation,
            __message_encoding,
            __json_format,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for FeatureSet")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "fieldPresence" => Ok(__FieldTag::__field_presence),
                            "field_presence" => Ok(__FieldTag::__field_presence),
                            "enumType" => Ok(__FieldTag::__enum_type),
                            "enum_type" => Ok(__FieldTag::__enum_type),
                            "repeatedFieldEncoding" => Ok(__FieldTag::__repeated_field_encoding),
                            "repeated_field_encoding" => Ok(__FieldTag::__repeated_field_encoding),
                            "utf8Validation" => Ok(__FieldTag::__utf8_validation),
                            "utf8_validation" => Ok(__FieldTag::__utf8_validation),
                            "messageEncoding" => Ok(__FieldTag::__message_encoding),
                            "message_encoding" => Ok(__FieldTag::__message_encoding),
                            "jsonFormat" => Ok(__FieldTag::__json_format),
                            "json_format" => Ok(__FieldTag::__json_format),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::FeatureSet;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct FeatureSet")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__field_presence => {
                            if !fields.insert(__FieldTag::__field_presence) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for field_presence",
                                ));
                            }
                            result.field_presence = map.next_value::<std::option::Option<crate::feature_set::FieldPresence>>()?.unwrap_or_default();
                        }
                        __FieldTag::__enum_type => {
                            if !fields.insert(__FieldTag::__enum_type) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for enum_type",
                                ));
                            }
                            result.enum_type = map
                                .next_value::<std::option::Option<crate::feature_set::EnumType>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__repeated_field_encoding => {
                            if !fields.insert(__FieldTag::__repeated_field_encoding) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for repeated_field_encoding",
                                ));
                            }
                            result.repeated_field_encoding = map.next_value::<std::option::Option<crate::feature_set::RepeatedFieldEncoding>>()?.unwrap_or_default();
                        }
                        __FieldTag::__utf8_validation => {
                            if !fields.insert(__FieldTag::__utf8_validation) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for utf8_validation",
                                ));
                            }
                            result.utf8_validation = map.next_value::<std::option::Option<crate::feature_set::Utf8Validation>>()?.unwrap_or_default();
                        }
                        __FieldTag::__message_encoding => {
                            if !fields.insert(__FieldTag::__message_encoding) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for message_encoding",
                                ));
                            }
                            result.message_encoding = map.next_value::<std::option::Option<crate::feature_set::MessageEncoding>>()?.unwrap_or_default();
                        }
                        __FieldTag::__json_format => {
                            if !fields.insert(__FieldTag::__json_format) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for json_format",
                                ));
                            }
                            result.json_format = map
                                .next_value::<std::option::Option<crate::feature_set::JsonFormat>>(
                                )?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::FeatureSetDefaults {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __defaults,
            __minimum_edition,
            __maximum_edition,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for FeatureSetDefaults")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "defaults" => Ok(__FieldTag::__defaults),
                            "minimumEdition" => Ok(__FieldTag::__minimum_edition),
                            "minimum_edition" => Ok(__FieldTag::__minimum_edition),
                            "maximumEdition" => Ok(__FieldTag::__maximum_edition),
                            "maximum_edition" => Ok(__FieldTag::__maximum_edition),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::FeatureSetDefaults;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct FeatureSetDefaults")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__defaults => {
                            if !fields.insert(__FieldTag::__defaults) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for defaults",
                                ));
                            }
                            result.defaults = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<
                                        crate::feature_set_defaults::FeatureSetEditionDefault,
                                    >,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__minimum_edition => {
                            if !fields.insert(__FieldTag::__minimum_edition) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for minimum_edition",
                                ));
                            }
                            result.minimum_edition = map
                                .next_value::<std::option::Option<crate::Edition>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__maximum_edition => {
                            if !fields.insert(__FieldTag::__maximum_edition) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for maximum_edition",
                                ));
                            }
                            result.maximum_edition = map
                                .next_value::<std::option::Option<crate::Edition>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::feature_set_defaults::FeatureSetEditionDefault {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __edition,
            __overridable_features,
            __fixed_features,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for FeatureSetEditionDefault")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "edition" => Ok(__FieldTag::__edition),
                            "overridableFeatures" => Ok(__FieldTag::__overridable_features),
                            "overridable_features" => Ok(__FieldTag::__overridable_features),
                            "fixedFeatures" => Ok(__FieldTag::__fixed_features),
                            "fixed_features" => Ok(__FieldTag::__fixed_features),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::feature_set_defaults::FeatureSetEditionDefault;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct FeatureSetEditionDefault")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__edition => {
                            if !fields.insert(__FieldTag::__edition) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for edition",
                                ));
                            }
                            result.edition = map
                                .next_value::<std::option::Option<crate::Edition>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__overridable_features => {
                            if !fields.insert(__FieldTag::__overridable_features) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for overridable_features",
                                ));
                            }
                            result.overridable_features =
                                map.next_value::<std::option::Option<crate::FeatureSet>>()?;
                        }
                        __FieldTag::__fixed_features => {
                            if !fields.insert(__FieldTag::__fixed_features) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for fixed_features",
                                ));
                            }
                            result.fixed_features =
                                map.next_value::<std::option::Option<crate::FeatureSet>>()?;
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::SourceCodeInfo {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __location,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for SourceCodeInfo")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "location" => Ok(__FieldTag::__location),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::SourceCodeInfo;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct SourceCodeInfo")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__location => {
                            if !fields.insert(__FieldTag::__location) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for location",
                                ));
                            }
                            result.location = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<crate::source_code_info::Location>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::source_code_info::Location {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __path,
            __span,
            __leading_comments,
            __trailing_comments,
            __leading_detached_comments,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Location")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "path" => Ok(__FieldTag::__path),
                            "span" => Ok(__FieldTag::__span),
                            "leadingComments" => Ok(__FieldTag::__leading_comments),
                            "leading_comments" => Ok(__FieldTag::__leading_comments),
                            "trailingComments" => Ok(__FieldTag::__trailing_comments),
                            "trailing_comments" => Ok(__FieldTag::__trailing_comments),
                            "leadingDetachedComments" => {
                                Ok(__FieldTag::__leading_detached_comments)
                            }
                            "leading_detached_comments" => {
                                Ok(__FieldTag::__leading_detached_comments)
                            }
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::source_code_info::Location;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Location")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__path => {
                            if !fields.insert(__FieldTag::__path) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for path",
                                ));
                            }
                            struct __With(std::option::Option<std::vec::Vec<i32>>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::<
                                        std::option::Option<std::vec::Vec<wkt::internal::I32>>,
                                    >::deserialize(deserializer)
                                    .map(__With)
                                }
                            }
                            result.path = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__span => {
                            if !fields.insert(__FieldTag::__span) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for span",
                                ));
                            }
                            struct __With(std::option::Option<std::vec::Vec<i32>>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::<
                                        std::option::Option<std::vec::Vec<wkt::internal::I32>>,
                                    >::deserialize(deserializer)
                                    .map(__With)
                                }
                            }
                            result.span = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__leading_comments => {
                            if !fields.insert(__FieldTag::__leading_comments) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for leading_comments",
                                ));
                            }
                            result.leading_comments = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__trailing_comments => {
                            if !fields.insert(__FieldTag::__trailing_comments) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for trailing_comments",
                                ));
                            }
                            result.trailing_comments = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__leading_detached_comments => {
                            if !fields.insert(__FieldTag::__leading_detached_comments) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for leading_detached_comments",
                                ));
                            }
                            result.leading_detached_comments = map.next_value::<std::option::Option<std::vec::Vec<std::string::String>>>()?.unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::GeneratedCodeInfo {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __annotation,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for GeneratedCodeInfo")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "annotation" => Ok(__FieldTag::__annotation),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::GeneratedCodeInfo;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct GeneratedCodeInfo")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__annotation => {
                            if !fields.insert(__FieldTag::__annotation) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for annotation",
                                ));
                            }
                            result.annotation = map
                                .next_value::<std::option::Option<
                                    std::vec::Vec<crate::generated_code_info::Annotation>,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::generated_code_info::Annotation {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __path,
            __source_file,
            __begin,
            __end,
            __semantic,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Annotation")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "path" => Ok(__FieldTag::__path),
                            "sourceFile" => Ok(__FieldTag::__source_file),
                            "source_file" => Ok(__FieldTag::__source_file),
                            "begin" => Ok(__FieldTag::__begin),
                            "end" => Ok(__FieldTag::__end),
                            "semantic" => Ok(__FieldTag::__semantic),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::generated_code_info::Annotation;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Annotation")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__path => {
                            if !fields.insert(__FieldTag::__path) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for path",
                                ));
                            }
                            struct __With(std::option::Option<std::vec::Vec<i32>>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::<
                                        std::option::Option<std::vec::Vec<wkt::internal::I32>>,
                                    >::deserialize(deserializer)
                                    .map(__With)
                                }
                            }
                            result.path = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__source_file => {
                            if !fields.insert(__FieldTag::__source_file) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for source_file",
                                ));
                            }
                            result.source_file = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__begin => {
                            if !fields.insert(__FieldTag::__begin) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for begin",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.begin = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__end => {
                            if !fields.insert(__FieldTag::__end) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for end",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.end = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__semantic => {
                            if !fields.insert(__FieldTag::__semantic) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for semantic",
                                ));
                            }
                            result.semantic = map
                                .next_value::<std::option::Option<
                                    crate::generated_code_info::annotation::Semantic,
                                >>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::SourceContext {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __file_name,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for SourceContext")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "fileName" => Ok(__FieldTag::__file_name),
                            "file_name" => Ok(__FieldTag::__file_name),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::SourceContext;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct SourceContext")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__file_name => {
                            if !fields.insert(__FieldTag::__file_name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for file_name",
                                ));
                            }
                            result.file_name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::Type {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __fields,
            __oneofs,
            __options,
            __source_context,
            __syntax,
            __edition,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Type")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "fields" => Ok(__FieldTag::__fields),
                            "oneofs" => Ok(__FieldTag::__oneofs),
                            "options" => Ok(__FieldTag::__options),
                            "sourceContext" => Ok(__FieldTag::__source_context),
                            "source_context" => Ok(__FieldTag::__source_context),
                            "syntax" => Ok(__FieldTag::__syntax),
                            "edition" => Ok(__FieldTag::__edition),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::Type;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Type")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__fields => {
                            if !fields.insert(__FieldTag::__fields) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for fields",
                                ));
                            }
                            result.fields = map
                                .next_value::<std::option::Option<std::vec::Vec<crate::Field>>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__oneofs => {
                            if !fields.insert(__FieldTag::__oneofs) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for oneofs",
                                ));
                            }
                            result.oneofs = map.next_value::<std::option::Option<std::vec::Vec<std::string::String>>>()?.unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options = map
                                .next_value::<std::option::Option<std::vec::Vec<crate::Option>>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__source_context => {
                            if !fields.insert(__FieldTag::__source_context) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for source_context",
                                ));
                            }
                            result.source_context =
                                map.next_value::<std::option::Option<crate::SourceContext>>()?;
                        }
                        __FieldTag::__syntax => {
                            if !fields.insert(__FieldTag::__syntax) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for syntax",
                                ));
                            }
                            result.syntax = map
                                .next_value::<std::option::Option<crate::Syntax>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__edition => {
                            if !fields.insert(__FieldTag::__edition) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for edition",
                                ));
                            }
                            result.edition = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::Field {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __kind,
            __cardinality,
            __number,
            __name,
            __type_url,
            __oneof_index,
            __packed,
            __options,
            __json_name,
            __default_value,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Field")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "kind" => Ok(__FieldTag::__kind),
                            "cardinality" => Ok(__FieldTag::__cardinality),
                            "number" => Ok(__FieldTag::__number),
                            "name" => Ok(__FieldTag::__name),
                            "typeUrl" => Ok(__FieldTag::__type_url),
                            "type_url" => Ok(__FieldTag::__type_url),
                            "oneofIndex" => Ok(__FieldTag::__oneof_index),
                            "oneof_index" => Ok(__FieldTag::__oneof_index),
                            "packed" => Ok(__FieldTag::__packed),
                            "options" => Ok(__FieldTag::__options),
                            "jsonName" => Ok(__FieldTag::__json_name),
                            "json_name" => Ok(__FieldTag::__json_name),
                            "defaultValue" => Ok(__FieldTag::__default_value),
                            "default_value" => Ok(__FieldTag::__default_value),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::Field;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Field")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__kind => {
                            if !fields.insert(__FieldTag::__kind) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for kind",
                                ));
                            }
                            result.kind = map
                                .next_value::<std::option::Option<crate::field::Kind>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__cardinality => {
                            if !fields.insert(__FieldTag::__cardinality) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for cardinality",
                                ));
                            }
                            result.cardinality = map
                                .next_value::<std::option::Option<crate::field::Cardinality>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__number => {
                            if !fields.insert(__FieldTag::__number) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for number",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.number = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__type_url => {
                            if !fields.insert(__FieldTag::__type_url) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for type_url",
                                ));
                            }
                            result.type_url = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__oneof_index => {
                            if !fields.insert(__FieldTag::__oneof_index) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for oneof_index",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.oneof_index = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__packed => {
                            if !fields.insert(__FieldTag::__packed) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for packed",
                                ));
                            }
                            result.packed = map
                                .next_value::<std::option::Option<bool>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options = map
                                .next_value::<std::option::Option<std::vec::Vec<crate::Option>>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__json_name => {
                            if !fields.insert(__FieldTag::__json_name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for json_name",
                                ));
                            }
                            result.json_name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__default_value => {
                            if !fields.insert(__FieldTag::__default_value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for default_value",
                                ));
                            }
                            result.default_value = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::Enum {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __enumvalue,
            __options,
            __source_context,
            __syntax,
            __edition,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Enum")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "enumvalue" => Ok(__FieldTag::__enumvalue),
                            "options" => Ok(__FieldTag::__options),
                            "sourceContext" => Ok(__FieldTag::__source_context),
                            "source_context" => Ok(__FieldTag::__source_context),
                            "syntax" => Ok(__FieldTag::__syntax),
                            "edition" => Ok(__FieldTag::__edition),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::Enum;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Enum")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__enumvalue => {
                            if !fields.insert(__FieldTag::__enumvalue) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for enumvalue",
                                ));
                            }
                            result.enumvalue = map
                                .next_value::<std::option::Option<std::vec::Vec<crate::EnumValue>>>(
                                )?
                                .unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options = map
                                .next_value::<std::option::Option<std::vec::Vec<crate::Option>>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__source_context => {
                            if !fields.insert(__FieldTag::__source_context) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for source_context",
                                ));
                            }
                            result.source_context =
                                map.next_value::<std::option::Option<crate::SourceContext>>()?;
                        }
                        __FieldTag::__syntax => {
                            if !fields.insert(__FieldTag::__syntax) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for syntax",
                                ));
                            }
                            result.syntax = map
                                .next_value::<std::option::Option<crate::Syntax>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__edition => {
                            if !fields.insert(__FieldTag::__edition) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for edition",
                                ));
                            }
                            result.edition = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::EnumValue {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __number,
            __options,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for EnumValue")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "number" => Ok(__FieldTag::__number),
                            "options" => Ok(__FieldTag::__options),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::EnumValue;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct EnumValue")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__number => {
                            if !fields.insert(__FieldTag::__number) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for number",
                                ));
                            }
                            struct __With(std::option::Option<i32>);
                            impl<'de> serde::de::Deserialize<'de> for __With {
                                fn deserialize<D>(
                                    deserializer: D,
                                ) -> std::result::Result<Self, D::Error>
                                where
                                    D: serde::de::Deserializer<'de>,
                                {
                                    serde_with::As::< std::option::Option<wkt::internal::I32> >::deserialize(deserializer).map(__With)
                                }
                            }
                            result.number = map.next_value::<__With>()?.0.unwrap_or_default();
                        }
                        __FieldTag::__options => {
                            if !fields.insert(__FieldTag::__options) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for options",
                                ));
                            }
                            result.options = map
                                .next_value::<std::option::Option<std::vec::Vec<crate::Option>>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}

#[doc(hidden)]
impl<'de> serde::de::Deserialize<'de> for super::Option {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        #[allow(non_camel_case_types)]
        #[doc(hidden)]
        #[derive(PartialEq, Eq, Hash)]
        enum __FieldTag {
            __name,
            __value,
            Unknown(std::string::String),
        }
        impl<'de> serde::de::Deserialize<'de> for __FieldTag {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct Visitor;
                impl<'de> serde::de::Visitor<'de> for Visitor {
                    type Value = __FieldTag;
                    fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                        formatter.write_str("a field name for Option")
                    }
                    fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
                    where
                        E: serde::de::Error,
                    {
                        use std::result::Result::Ok;
                        use std::string::ToString;
                        match value {
                            "name" => Ok(__FieldTag::__name),
                            "value" => Ok(__FieldTag::__value),
                            _ => Ok(__FieldTag::Unknown(value.to_string())),
                        }
                    }
                }
                deserializer.deserialize_identifier(Visitor)
            }
        }
        struct Visitor;
        impl<'de> serde::de::Visitor<'de> for Visitor {
            type Value = super::Option;
            fn expecting(&self, formatter: &mut std::fmt::Formatter) -> std::fmt::Result {
                formatter.write_str("struct Option")
            }
            fn visit_map<A>(self, mut map: A) -> std::result::Result<Self::Value, A::Error>
            where
                A: serde::de::MapAccess<'de>,
            {
                #[allow(unused_imports)]
                use serde::de::Error;
                use std::option::Option::Some;
                let mut fields = std::collections::HashSet::new();
                let mut result = Self::Value::new();
                while let Some(tag) = map.next_key::<__FieldTag>()? {
                    #[allow(clippy::match_single_binding)]
                    match tag {
                        __FieldTag::__name => {
                            if !fields.insert(__FieldTag::__name) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for name",
                                ));
                            }
                            result.name = map
                                .next_value::<std::option::Option<std::string::String>>()?
                                .unwrap_or_default();
                        }
                        __FieldTag::__value => {
                            if !fields.insert(__FieldTag::__value) {
                                return std::result::Result::Err(A::Error::duplicate_field(
                                    "multiple values for value",
                                ));
                            }
                            result.value = map.next_value::<std::option::Option<crate::Any>>()?;
                        }
                        __FieldTag::Unknown(key) => {
                            let value = map.next_value::<serde_json::Value>()?;
                            result._unknown_fields.insert(key, value);
                        }
                    }
                }
                std::result::Result::Ok(result)
            }
        }
        deserializer.deserialize_any(Visitor)
    }
}
