// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -triple=x86_64 -std=c99 -Wno-dangling -emit-llvm -o - %s | FileCheck %s --check-prefix=CHECK
// RUN: %clang_cc1 -triple=x86_64 -std=c11 -Wno-dangling -emit-llvm -o - %s | FileCheck %s --check-prefix=CHECK
// RUN: %clang_cc1 -triple=x86_64 -std=c11 -O2 -disable-llvm-passes -Wno-dangling -emit-llvm -o - %s | FileCheck %s --check-prefix=C11-O2

// Ensure that codegen for temporary lifetimes makes sense.

struct X { int a[5]; };
struct X f(void);

// CHECK-LABEL: define dso_local i32 @func_return(
// CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[P:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_X:%.*]], align 4
// CHECK-NEXT:    call void @f(ptr dead_on_unwind writable sret([[STRUCT_X]]) align 4 [[REF_TMP]])
// CHECK-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [5 x i32], ptr [[A]], i64 0, i64 0
// CHECK-NEXT:    store ptr [[ARRAYDECAY]], ptr [[P]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[P]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK-NEXT:    ret i32 [[TMP1]]
//
// C11-O2-LABEL: define dso_local i32 @func_return(
// C11-O2-SAME: ) #[[ATTR0:[0-9]+]] {
// C11-O2-NEXT:  [[ENTRY:.*:]]
// C11-O2-NEXT:    [[P:%.*]] = alloca ptr, align 8
// C11-O2-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_X:%.*]], align 4
// C11-O2-NEXT:    call void @llvm.lifetime.start.p0(i64 8, ptr [[P]]) #[[ATTR5:[0-9]+]]
// C11-O2-NEXT:    call void @llvm.lifetime.start.p0(i64 20, ptr [[REF_TMP]]) #[[ATTR5]]
// C11-O2-NEXT:    call void @f(ptr dead_on_unwind writable sret([[STRUCT_X]]) align 4 [[REF_TMP]])
// C11-O2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[REF_TMP]], i32 0, i32 0
// C11-O2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [5 x i32], ptr [[A]], i64 0, i64 0
// C11-O2-NEXT:    call void @llvm.lifetime.end.p0(i64 20, ptr [[REF_TMP]]) #[[ATTR5]]
// C11-O2-NEXT:    store ptr [[ARRAYDECAY]], ptr [[P]], align 8, !tbaa [[TBAA2:![0-9]+]]
// C11-O2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[P]], align 8, !tbaa [[TBAA2]]
// C11-O2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4, !tbaa [[TBAA7:![0-9]+]]
// C11-O2-NEXT:    call void @llvm.lifetime.end.p0(i64 8, ptr [[P]]) #[[ATTR5]]
// C11-O2-NEXT:    ret i32 [[TMP1]]
//
int func_return(void) {
  int *p = f().a;
  return *p;
}

// CHECK-LABEL: define dso_local i32 @ternary(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_X:%.*]], align 4
// CHECK-NEXT:    [[Q:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTCOMPOUNDLITERAL:%.*]] = alloca [[STRUCT_X]], align 4
// CHECK-NEXT:    br i1 true, label %[[COND_TRUE:.*]], label %[[COND_FALSE:.*]]
// CHECK:       [[COND_TRUE]]:
// CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[REF_TMP]], i8 0, i64 20, i1 false)
// CHECK-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK-NEXT:    br label %[[COND_END:.*]]
// CHECK:       [[COND_FALSE]]:
// CHECK-NEXT:    call void @f(ptr dead_on_unwind writable sret([[STRUCT_X]]) align 4 [[REF_TMP]])
// CHECK-NEXT:    br label %[[COND_END]]
// CHECK:       [[COND_END]]:
// CHECK-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [5 x i32], ptr [[A1]], i64 0, i64 0
// CHECK-NEXT:    store ptr [[ARRAYDECAY]], ptr @p, align 8
// CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[DOTCOMPOUNDLITERAL]], i8 0, i64 20, i1 false)
// CHECK-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[DOTCOMPOUNDLITERAL]], i32 0, i32 0
// CHECK-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[DOTCOMPOUNDLITERAL]], i32 0, i32 0
// CHECK-NEXT:    [[ARRAYDECAY4:%.*]] = getelementptr inbounds [5 x i32], ptr [[A3]], i64 0, i64 0
// CHECK-NEXT:    store ptr [[ARRAYDECAY4]], ptr [[Q]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr @p, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[Q]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[TMP3]]
// CHECK-NEXT:    ret i32 [[ADD]]
//
// C11-O2-LABEL: define dso_local i32 @ternary(
// C11-O2-SAME: ) #[[ATTR0]] {
// C11-O2-NEXT:  [[ENTRY:.*:]]
// C11-O2-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_X:%.*]], align 4
// C11-O2-NEXT:    [[Q:%.*]] = alloca ptr, align 8
// C11-O2-NEXT:    [[DOTCOMPOUNDLITERAL:%.*]] = alloca [[STRUCT_X]], align 4
// C11-O2-NEXT:    call void @llvm.lifetime.start.p0(i64 20, ptr [[REF_TMP]]) #[[ATTR5]]
// C11-O2-NEXT:    br i1 true, label %[[COND_TRUE:.*]], label %[[COND_FALSE:.*]]
// C11-O2:       [[COND_TRUE]]:
// C11-O2-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[REF_TMP]], i8 0, i64 20, i1 false)
// C11-O2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[REF_TMP]], i32 0, i32 0
// C11-O2-NEXT:    br label %[[COND_END:.*]]
// C11-O2:       [[COND_FALSE]]:
// C11-O2-NEXT:    call void @f(ptr dead_on_unwind writable sret([[STRUCT_X]]) align 4 [[REF_TMP]])
// C11-O2-NEXT:    br label %[[COND_END]]
// C11-O2:       [[COND_END]]:
// C11-O2-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[REF_TMP]], i32 0, i32 0
// C11-O2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [5 x i32], ptr [[A1]], i64 0, i64 0
// C11-O2-NEXT:    store ptr [[ARRAYDECAY]], ptr @p, align 8, !tbaa [[TBAA2]]
// C11-O2-NEXT:    call void @llvm.lifetime.end.p0(i64 20, ptr [[REF_TMP]]) #[[ATTR5]]
// C11-O2-NEXT:    call void @llvm.lifetime.start.p0(i64 8, ptr [[Q]]) #[[ATTR5]]
// C11-O2-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[DOTCOMPOUNDLITERAL]], i8 0, i64 20, i1 false)
// C11-O2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[DOTCOMPOUNDLITERAL]], i32 0, i32 0
// C11-O2-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[DOTCOMPOUNDLITERAL]], i32 0, i32 0
// C11-O2-NEXT:    [[ARRAYDECAY4:%.*]] = getelementptr inbounds [5 x i32], ptr [[A3]], i64 0, i64 0
// C11-O2-NEXT:    store ptr [[ARRAYDECAY4]], ptr [[Q]], align 8, !tbaa [[TBAA2]]
// C11-O2-NEXT:    [[TMP0:%.*]] = load ptr, ptr @p, align 8, !tbaa [[TBAA2]]
// C11-O2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4, !tbaa [[TBAA7]]
// C11-O2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[Q]], align 8, !tbaa [[TBAA2]]
// C11-O2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4, !tbaa [[TBAA7]]
// C11-O2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[TMP3]]
// C11-O2-NEXT:    call void @llvm.lifetime.end.p0(i64 8, ptr [[Q]]) #[[ATTR5]]
// C11-O2-NEXT:    ret i32 [[ADD]]
//
int ternary(void) {
  extern int *p;
  p = (1 ? (struct X){ 0 } : f()).a;
  int *q = 1 ? (struct X){ 0 }.a : f().a;

  return *p + *q;
}

// CHECK-LABEL: define dso_local i32 @comma(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[X:%.*]] = alloca [[STRUCT_X:%.*]], align 4
// CHECK-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_X]], align 4
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[REF_TMP]], ptr align 4 [[X]], i64 20, i1 false)
// CHECK-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [5 x i32], ptr [[A]], i64 0, i64 0
// CHECK-NEXT:    store ptr [[ARRAYDECAY]], ptr @p, align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr @p, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK-NEXT:    ret i32 [[TMP1]]
//
// C11-O2-LABEL: define dso_local i32 @comma(
// C11-O2-SAME: ) #[[ATTR0]] {
// C11-O2-NEXT:  [[ENTRY:.*:]]
// C11-O2-NEXT:    [[X:%.*]] = alloca [[STRUCT_X:%.*]], align 4
// C11-O2-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_X]], align 4
// C11-O2-NEXT:    call void @llvm.lifetime.start.p0(i64 20, ptr [[X]]) #[[ATTR5]]
// C11-O2-NEXT:    call void @llvm.lifetime.start.p0(i64 20, ptr [[REF_TMP]]) #[[ATTR5]]
// C11-O2-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[REF_TMP]], ptr align 4 [[X]], i64 20, i1 false), !tbaa.struct [[TBAA_STRUCT9:![0-9]+]]
// C11-O2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[REF_TMP]], i32 0, i32 0
// C11-O2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [5 x i32], ptr [[A]], i64 0, i64 0
// C11-O2-NEXT:    store ptr [[ARRAYDECAY]], ptr @p, align 8, !tbaa [[TBAA2]]
// C11-O2-NEXT:    call void @llvm.lifetime.end.p0(i64 20, ptr [[REF_TMP]]) #[[ATTR5]]
// C11-O2-NEXT:    [[TMP0:%.*]] = load ptr, ptr @p, align 8, !tbaa [[TBAA2]]
// C11-O2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4, !tbaa [[TBAA7]]
// C11-O2-NEXT:    call void @llvm.lifetime.end.p0(i64 20, ptr [[X]]) #[[ATTR5]]
// C11-O2-NEXT:    ret i32 [[TMP1]]
//
int comma(void) {
  struct X x;
  extern int *p;
  p = ((void)0, x).a;
  return *p;
}

// CHECK-LABEL: define dso_local i32 @cast(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[X:%.*]] = alloca [[STRUCT_X:%.*]], align 4
// CHECK-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_X]], align 4
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[REF_TMP]], ptr align 4 [[X]], i64 20, i1 false)
// CHECK-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [5 x i32], ptr [[A]], i64 0, i64 0
// CHECK-NEXT:    store ptr [[ARRAYDECAY]], ptr @p, align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr @p, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK-NEXT:    ret i32 [[TMP1]]
//
// C11-O2-LABEL: define dso_local i32 @cast(
// C11-O2-SAME: ) #[[ATTR0]] {
// C11-O2-NEXT:  [[ENTRY:.*:]]
// C11-O2-NEXT:    [[X:%.*]] = alloca [[STRUCT_X:%.*]], align 4
// C11-O2-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_X]], align 4
// C11-O2-NEXT:    call void @llvm.lifetime.start.p0(i64 20, ptr [[X]]) #[[ATTR5]]
// C11-O2-NEXT:    call void @llvm.lifetime.start.p0(i64 20, ptr [[REF_TMP]]) #[[ATTR5]]
// C11-O2-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[REF_TMP]], ptr align 4 [[X]], i64 20, i1 false), !tbaa.struct [[TBAA_STRUCT9]]
// C11-O2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[REF_TMP]], i32 0, i32 0
// C11-O2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [5 x i32], ptr [[A]], i64 0, i64 0
// C11-O2-NEXT:    store ptr [[ARRAYDECAY]], ptr @p, align 8, !tbaa [[TBAA2]]
// C11-O2-NEXT:    call void @llvm.lifetime.end.p0(i64 20, ptr [[REF_TMP]]) #[[ATTR5]]
// C11-O2-NEXT:    [[TMP0:%.*]] = load ptr, ptr @p, align 8, !tbaa [[TBAA2]]
// C11-O2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4, !tbaa [[TBAA7]]
// C11-O2-NEXT:    call void @llvm.lifetime.end.p0(i64 20, ptr [[X]]) #[[ATTR5]]
// C11-O2-NEXT:    ret i32 [[TMP1]]
//
int cast(void) {
  struct X x;
  extern int *p;
  p = ((struct X)x).a;
  return *p;
}

// CHECK-LABEL: define dso_local i32 @assign(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[X:%.*]] = alloca [[STRUCT_X:%.*]], align 4
// CHECK-NEXT:    [[S:%.*]] = alloca [[STRUCT_X]], align 4
// CHECK-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_X]], align 4
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[X]], ptr align 4 [[S]], i64 20, i1 false)
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[REF_TMP]], ptr align 4 [[X]], i64 20, i1 false)
// CHECK-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [5 x i32], ptr [[A]], i64 0, i64 0
// CHECK-NEXT:    store ptr [[ARRAYDECAY]], ptr @p, align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr @p, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK-NEXT:    ret i32 [[TMP1]]
//
// C11-O2-LABEL: define dso_local i32 @assign(
// C11-O2-SAME: ) #[[ATTR0]] {
// C11-O2-NEXT:  [[ENTRY:.*:]]
// C11-O2-NEXT:    [[X:%.*]] = alloca [[STRUCT_X:%.*]], align 4
// C11-O2-NEXT:    [[S:%.*]] = alloca [[STRUCT_X]], align 4
// C11-O2-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_X]], align 4
// C11-O2-NEXT:    call void @llvm.lifetime.start.p0(i64 20, ptr [[X]]) #[[ATTR5]]
// C11-O2-NEXT:    call void @llvm.lifetime.start.p0(i64 20, ptr [[S]]) #[[ATTR5]]
// C11-O2-NEXT:    call void @llvm.lifetime.start.p0(i64 20, ptr [[REF_TMP]]) #[[ATTR5]]
// C11-O2-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[X]], ptr align 4 [[S]], i64 20, i1 false), !tbaa.struct [[TBAA_STRUCT9]]
// C11-O2-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[REF_TMP]], ptr align 4 [[X]], i64 20, i1 false), !tbaa.struct [[TBAA_STRUCT9]]
// C11-O2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_X]], ptr [[REF_TMP]], i32 0, i32 0
// C11-O2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [5 x i32], ptr [[A]], i64 0, i64 0
// C11-O2-NEXT:    store ptr [[ARRAYDECAY]], ptr @p, align 8, !tbaa [[TBAA2]]
// C11-O2-NEXT:    call void @llvm.lifetime.end.p0(i64 20, ptr [[REF_TMP]]) #[[ATTR5]]
// C11-O2-NEXT:    [[TMP0:%.*]] = load ptr, ptr @p, align 8, !tbaa [[TBAA2]]
// C11-O2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4, !tbaa [[TBAA7]]
// C11-O2-NEXT:    call void @llvm.lifetime.end.p0(i64 20, ptr [[S]]) #[[ATTR5]]
// C11-O2-NEXT:    call void @llvm.lifetime.end.p0(i64 20, ptr [[X]]) #[[ATTR5]]
// C11-O2-NEXT:    ret i32 [[TMP1]]
//
int assign(void) {
  struct X x, s;
  extern int *p;
  p = (x = s).a;
  return *p;
}
//.
// C11-O2: [[TBAA2]] = !{[[META3:![0-9]+]], [[META3]], i64 0}
// C11-O2: [[META3]] = !{!"p1 int", [[META4:![0-9]+]], i64 0}
// C11-O2: [[META4]] = !{!"any pointer", [[META5:![0-9]+]], i64 0}
// C11-O2: [[META5]] = !{!"omnipotent char", [[META6:![0-9]+]], i64 0}
// C11-O2: [[META6]] = !{!"Simple C/C++ TBAA"}
// C11-O2: [[TBAA7]] = !{[[META8:![0-9]+]], [[META8]], i64 0}
// C11-O2: [[META8]] = !{!"int", [[META5]], i64 0}
// C11-O2: [[TBAA_STRUCT9]] = !{i64 0, i64 20, [[META10:![0-9]+]]}
// C11-O2: [[META10]] = !{[[META5]], [[META5]], i64 0}
//.
