/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManager;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.utils.ArrayUtils;

public class DesktopDataSourceRegistry<T extends DataSourceDescriptor>
extends DataSourceRegistry<T> {
    private static final Log log = Log.getLog(DesktopDataSourceRegistry.class);

    public DesktopDataSourceRegistry(DBPProject project) {
        super(project);
    }

    public DesktopDataSourceRegistry(@NotNull DBPProject project, DataSourceConfigurationManager configurationManager, @NotNull DBPPreferenceStore preferenceStore) {
        super(project, configurationManager, preferenceStore);
    }

    /*
     * WARNING - void declaration
     */
    protected void updateProjectNature() {
        DBPProject dBPProject;
        if (this.isMultiUser() || !((dBPProject = this.getProject()) instanceof RCPProject)) {
            return;
        }
        RCPProject rCPProject = (RCPProject)dBPProject;
        try {
            IProjectDescription description;
            void rcpProject;
            IProject eclipseProject = rcpProject.getEclipseProject();
            if (eclipseProject != null && (description = eclipseProject.getDescription()) != null) {
                Object[] natureIds = description.getNatureIds();
                if (this.getDataSourceCount() > 0 && !ArrayUtils.contains((Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature")) {
                    description.setNatureIds((String[])ArrayUtils.add(String.class, (Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature"));
                    try {
                        eclipseProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        log.debug((Object)"Can't set project nature", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }
}

