/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.style.UseWhenStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DateTimeValue;

public class UseWhenFilter
extends ProxyReceiver {
    private StartTagBuffer startTag;
    private int useWhenCode;
    private int xslUseWhenCode;
    private int defaultNamespaceCode;
    private int depthOfHole = 0;
    private boolean emptyStylesheetElement = false;
    private Stack defaultNamespaceStack = new Stack();
    private DateTimeValue currentDateTime = DateTimeValue.getCurrentDateTime(null);

    public UseWhenFilter(StartTagBuffer startTag) {
        this.startTag = startTag;
    }

    public void open() throws XPathException {
        this.useWhenCode = this.getNamePool().allocate("", "", "use-when") & 0xFFFFF;
        this.xslUseWhenCode = this.getNamePool().allocate("xsl", "http://www.w3.org/1999/XSL/Transform", "use-when");
        this.defaultNamespaceCode = this.getNamePool().allocate("", "", "xpath-default-namespace");
        this.nextReceiver.open();
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.defaultNamespaceStack.push(this.startTag.getAttribute(this.defaultNamespaceCode));
        if (this.emptyStylesheetElement) {
            ++this.depthOfHole;
            return;
        }
        if (this.depthOfHole == 0) {
            block9: {
                short uriCode = this.getNamePool().getURICode(nameCode);
                String useWhen = uriCode == 2 ? this.startTag.getAttribute(this.useWhenCode) : this.startTag.getAttribute(this.xslUseWhenCode);
                if (useWhen != null) {
                    try {
                        boolean b = this.evaluateUseWhen(useWhen, this.getDocumentLocator().getLineNumber(locationId));
                        if (b) break block9;
                        int fp = nameCode & 0xFFFFF;
                        if (fp == 199 || fp == 202) {
                            this.emptyStylesheetElement = true;
                            break block9;
                        }
                        this.depthOfHole = 1;
                        return;
                    }
                    catch (XPathException e) {
                        XPathException err = new XPathException("Error in use-when expression. " + e.getMessage());
                        ExpressionLocation loc = new ExpressionLocation();
                        loc.setSystemId(this.getDocumentLocator().getSystemId(locationId));
                        loc.setLineNumber(this.getDocumentLocator().getLineNumber(locationId));
                        err.setLocator(loc);
                        err.setErrorCodeQName(e.getErrorCodeQName());
                        try {
                            this.getPipelineConfiguration().getErrorListener().fatalError(err);
                        }
                        catch (TransformerException tex) {
                            throw XPathException.makeXPathException(tex);
                        }
                        err.setHasBeenReported(true);
                        throw err;
                    }
                }
            }
            this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        } else {
            ++this.depthOfHole;
        }
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.namespace(namespaceCode, properties);
        }
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
        }
    }

    public void startContent() throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.startContent();
        }
    }

    public void endElement() throws XPathException {
        this.defaultNamespaceStack.pop();
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            this.nextReceiver.endElement();
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) {
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
    }

    public boolean evaluateUseWhen(String expression, int locationId) throws XPathException {
        UseWhenStaticContext staticContext = new UseWhenStaticContext(this.getConfiguration(), this.startTag);
        staticContext.setBaseURI(this.getDocumentLocator().getSystemId(locationId));
        staticContext.setDefaultElementNamespace("");
        for (int i = this.defaultNamespaceStack.size() - 1; i >= 0; --i) {
            String uri = (String)this.defaultNamespaceStack.get(i);
            if (uri == null) continue;
            staticContext.setDefaultElementNamespace(uri);
            break;
        }
        Expression expr = ExpressionTool.make(expression, staticContext, staticContext, 0, 0, this.getDocumentLocator().getLineNumber(locationId), false);
        expr.setContainer(staticContext);
        ItemType contextItemType = Type.ITEM_TYPE;
        ExpressionVisitor visitor = ExpressionVisitor.make(staticContext, staticContext.getExecutable());
        expr = visitor.typeCheck(expr, contextItemType);
        SlotManager stackFrameMap = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
        Controller controller = new Controller(this.getConfiguration());
        controller.setURIResolver(new URIPreventer());
        controller.setCurrentDateTime(this.currentDateTime);
        XPathContextMajor dynamicContext = controller.newXPathContext();
        dynamicContext = dynamicContext.newCleanContext();
        dynamicContext.openStackFrame(stackFrameMap);
        return expr.effectiveBooleanValue(dynamicContext);
    }

    private static class URIPreventer
    implements URIResolver {
        private URIPreventer() {
        }

        public Source resolve(String href, String base) throws TransformerException {
            throw new TransformerException("No external documents are available within an [xsl]use-when expression");
        }
    }
}

