/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.StringTokenizer;
import net.sf.saxon.event.RuleBasedStripper;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.StripSpaceRules;
import net.sf.saxon.trans.XPathException;

public class XSLPreserveSpace
extends StyleElement {
    private String elements;

    public boolean isDeclaration() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("elements")) {
                this.elements = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (this.elements == null) {
            this.reportAbsence("elements");
            this.elements = "*";
        }
    }

    public void validate(Declaration decl) throws XPathException {
        this.checkEmpty();
        this.checkTopLevel(null);
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        RuleBasedStripper.StripRuleTarget preserve = this.getFingerprint() == 190 ? RuleBasedStripper.PRESERVE : RuleBasedStripper.STRIP;
        StripSpaceRules stripperRules = this.getPrincipalStylesheetModule().getStripperRules();
        StringTokenizer st = new StringTokenizer(this.elements, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            String localName;
            String uri;
            String prefix;
            NodeTest nt;
            String s = st.nextToken();
            if (s.equals("*")) {
                nt = NodeKindTest.ELEMENT;
                stripperRules.addRule(nt, preserve, decl.getModule(), decl.getSourceElement().getLineNumber());
                continue;
            }
            if (s.endsWith(":*")) {
                if (s.length() == 2) {
                    this.compileError("No prefix before ':*'");
                }
                prefix = s.substring(0, s.length() - 2);
                String uri2 = this.getURIForPrefix(prefix, false);
                nt = new NamespaceTest(this.getNamePool(), 1, uri2);
                stripperRules.addRule(nt, preserve, decl.getModule(), decl.getSourceElement().getLineNumber());
                continue;
            }
            if (s.startsWith("*:")) {
                if (s.length() == 2) {
                    this.compileError("No local name after '*:'");
                }
                String localname = s.substring(2);
                nt = new LocalNameTest(this.getNamePool(), 1, localname);
                stripperRules.addRule(nt, preserve, decl.getModule(), decl.getSourceElement().getLineNumber());
                continue;
            }
            try {
                String[] parts = this.getConfiguration().getNameChecker().getQNameParts(s);
                prefix = parts[0];
                if (parts[0].equals("")) {
                    uri = this.getDefaultXPathNamespace();
                } else {
                    uri = this.getURIForPrefix(prefix, false);
                    if (uri == null) {
                        this.undeclaredNamespaceError(prefix, "XTSE0280");
                        return null;
                    }
                }
                localName = parts[1];
            }
            catch (QNameException err) {
                this.compileError("Element name " + s + " is not a valid QName", "XTSE0280");
                return null;
            }
            NamePool target = this.getNamePool();
            int nameCode = target.allocate("", uri, localName);
            nt = new NameTest(1, nameCode, this.getNamePool());
            stripperRules.addRule(nt, preserve, decl.getModule(), decl.getSourceElement().getLineNumber());
        }
        return null;
    }
}

