// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package verifiedpermissions

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchIsAuthorized = "BatchIsAuthorized"

// BatchIsAuthorizedRequest generates a "aws/request.Request" representing the
// client's request for the BatchIsAuthorized operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchIsAuthorized for more information on using the BatchIsAuthorized
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchIsAuthorizedRequest method.
//	req, resp := client.BatchIsAuthorizedRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/BatchIsAuthorized
func (c *VerifiedPermissions) BatchIsAuthorizedRequest(input *BatchIsAuthorizedInput) (req *request.Request, output *BatchIsAuthorizedOutput) {
	op := &request.Operation{
		Name:       opBatchIsAuthorized,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchIsAuthorizedInput{}
	}

	output = &BatchIsAuthorizedOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchIsAuthorized API operation for Amazon Verified Permissions.
//
// Makes a series of decisions about multiple authorization requests for one
// principal or resource. Each request contains the equivalent content of an
// IsAuthorized request: principal, action, resource, and context. Either the
// principal or the resource parameter must be identical across all requests.
// For example, Verified Permissions won't evaluate a pair of requests where
// bob views photo1 and alice views photo2. Authorization of bob to view photo1
// and photo2, or bob and alice to view photo1, are valid batches.
//
// The request is evaluated against all policies in the specified policy store
// that match the entities that you declare. The result of the decisions is
// a series of Allow or Deny responses, along with the IDs of the policies that
// produced each decision.
//
// The entities of a BatchIsAuthorized API request can contain up to 100 principals
// and up to 100 resources. The requests of a BatchIsAuthorized API request
// can contain up to 30 requests.
//
// The BatchIsAuthorized operation doesn't have its own IAM permission. To authorize
// this operation for Amazon Web Services principals, include the permission
// verifiedpermissions:IsAuthorized in their IAM policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation BatchIsAuthorized for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/BatchIsAuthorized
func (c *VerifiedPermissions) BatchIsAuthorized(input *BatchIsAuthorizedInput) (*BatchIsAuthorizedOutput, error) {
	req, out := c.BatchIsAuthorizedRequest(input)
	return out, req.Send()
}

// BatchIsAuthorizedWithContext is the same as BatchIsAuthorized with the addition of
// the ability to pass a context and additional request options.
//
// See BatchIsAuthorized for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) BatchIsAuthorizedWithContext(ctx aws.Context, input *BatchIsAuthorizedInput, opts ...request.Option) (*BatchIsAuthorizedOutput, error) {
	req, out := c.BatchIsAuthorizedRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchIsAuthorizedWithToken = "BatchIsAuthorizedWithToken"

// BatchIsAuthorizedWithTokenRequest generates a "aws/request.Request" representing the
// client's request for the BatchIsAuthorizedWithToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchIsAuthorizedWithToken for more information on using the BatchIsAuthorizedWithToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchIsAuthorizedWithTokenRequest method.
//	req, resp := client.BatchIsAuthorizedWithTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/BatchIsAuthorizedWithToken
func (c *VerifiedPermissions) BatchIsAuthorizedWithTokenRequest(input *BatchIsAuthorizedWithTokenInput) (req *request.Request, output *BatchIsAuthorizedWithTokenOutput) {
	op := &request.Operation{
		Name:       opBatchIsAuthorizedWithToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchIsAuthorizedWithTokenInput{}
	}

	output = &BatchIsAuthorizedWithTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchIsAuthorizedWithToken API operation for Amazon Verified Permissions.
//
// Makes a series of decisions about multiple authorization requests for one
// token. The principal in this request comes from an external identity source
// in the form of an identity or access token, formatted as a JSON web token
// (JWT) (https://wikipedia.org/wiki/JSON_Web_Token). The information in the
// parameters can also define additional context that Verified Permissions can
// include in the evaluations.
//
// The request is evaluated against all policies in the specified policy store
// that match the entities that you provide in the entities declaration and
// in the token. The result of the decisions is a series of Allow or Deny responses,
// along with the IDs of the policies that produced each decision.
//
// The entities of a BatchIsAuthorizedWithToken API request can contain up to
// 100 resources and up to 99 user groups. The requests of a BatchIsAuthorizedWithToken
// API request can contain up to 30 requests.
//
// The BatchIsAuthorizedWithToken operation doesn't have its own IAM permission.
// To authorize this operation for Amazon Web Services principals, include the
// permission verifiedpermissions:IsAuthorizedWithToken in their IAM policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation BatchIsAuthorizedWithToken for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/BatchIsAuthorizedWithToken
func (c *VerifiedPermissions) BatchIsAuthorizedWithToken(input *BatchIsAuthorizedWithTokenInput) (*BatchIsAuthorizedWithTokenOutput, error) {
	req, out := c.BatchIsAuthorizedWithTokenRequest(input)
	return out, req.Send()
}

// BatchIsAuthorizedWithTokenWithContext is the same as BatchIsAuthorizedWithToken with the addition of
// the ability to pass a context and additional request options.
//
// See BatchIsAuthorizedWithToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) BatchIsAuthorizedWithTokenWithContext(ctx aws.Context, input *BatchIsAuthorizedWithTokenInput, opts ...request.Option) (*BatchIsAuthorizedWithTokenOutput, error) {
	req, out := c.BatchIsAuthorizedWithTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIdentitySource = "CreateIdentitySource"

// CreateIdentitySourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateIdentitySource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIdentitySource for more information on using the CreateIdentitySource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIdentitySourceRequest method.
//	req, resp := client.CreateIdentitySourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/CreateIdentitySource
func (c *VerifiedPermissions) CreateIdentitySourceRequest(input *CreateIdentitySourceInput) (req *request.Request, output *CreateIdentitySourceOutput) {
	op := &request.Operation{
		Name:       opCreateIdentitySource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIdentitySourceInput{}
	}

	output = &CreateIdentitySourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIdentitySource API operation for Amazon Verified Permissions.
//
// Adds an identity source to a policy store–an Amazon Cognito user pool or
// OpenID Connect (OIDC) identity provider (IdP).
//
// After you create an identity source, you can use the identities provided
// by the IdP as proxies for the principal in authorization queries that use
// the IsAuthorizedWithToken (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html)
// or BatchIsAuthorizedWithToken (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorizedWithToken.html)
// API operations. These identities take the form of tokens that contain claims
// about the user, such as IDs, attributes and group memberships. Identity sources
// provide identity (ID) tokens and access tokens. Verified Permissions derives
// information about your user and session from token claims. Access tokens
// provide action context to your policies, and ID tokens provide principal
// Attributes.
//
// Tokens from an identity source user continue to be usable until they expire.
// Token revocation and resource deletion have no effect on the validity of
// a token in your policy store
//
// To reference a user from this identity source in your Cedar policies, refer
// to the following syntax examples.
//
//   - Amazon Cognito user pool: Namespace::[Entity type]::[User pool ID]|[user
//     principal attribute], for example MyCorp::User::us-east-1_EXAMPLE|a1b2c3d4-5678-90ab-cdef-EXAMPLE11111.
//
//   - OpenID Connect (OIDC) provider: Namespace::[Entity type]::[principalIdClaim]|[user
//     principal attribute], for example MyCorp::User::MyOIDCProvider|a1b2c3d4-5678-90ab-cdef-EXAMPLE22222.
//
// Verified Permissions is eventually consistent (https://wikipedia.org/wiki/Eventual_consistency)
// . It can take a few seconds for a new or changed element to propagate through
// the service and be visible in the results of other Verified Permissions operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation CreateIdentitySource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - ServiceQuotaExceededException
//     The request failed because it would cause a service quota to be exceeded.
//
//   - ConflictException
//     The request failed because another request to modify a resource occurred
//     at the same.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/CreateIdentitySource
func (c *VerifiedPermissions) CreateIdentitySource(input *CreateIdentitySourceInput) (*CreateIdentitySourceOutput, error) {
	req, out := c.CreateIdentitySourceRequest(input)
	return out, req.Send()
}

// CreateIdentitySourceWithContext is the same as CreateIdentitySource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIdentitySource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) CreateIdentitySourceWithContext(ctx aws.Context, input *CreateIdentitySourceInput, opts ...request.Option) (*CreateIdentitySourceOutput, error) {
	req, out := c.CreateIdentitySourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePolicy = "CreatePolicy"

// CreatePolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePolicy for more information on using the CreatePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePolicyRequest method.
//	req, resp := client.CreatePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/CreatePolicy
func (c *VerifiedPermissions) CreatePolicyRequest(input *CreatePolicyInput) (req *request.Request, output *CreatePolicyOutput) {
	op := &request.Operation{
		Name:       opCreatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePolicyInput{}
	}

	output = &CreatePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicy API operation for Amazon Verified Permissions.
//
// Creates a Cedar policy and saves it in the specified policy store. You can
// create either a static policy or a policy linked to a policy template.
//
//   - To create a static policy, provide the Cedar policy text in the StaticPolicy
//     section of the PolicyDefinition.
//
//   - To create a policy that is dynamically linked to a policy template,
//     specify the policy template ID and the principal and resource to associate
//     with this policy in the templateLinked section of the PolicyDefinition.
//     If the policy template is ever updated, any policies linked to the policy
//     template automatically use the updated template.
//
// Creating a policy causes it to be validated against the schema in the policy
// store. If the policy doesn't pass validation, the operation fails and the
// policy isn't stored.
//
// Verified Permissions is eventually consistent (https://wikipedia.org/wiki/Eventual_consistency)
// . It can take a few seconds for a new or changed element to propagate through
// the service and be visible in the results of other Verified Permissions operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation CreatePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - ServiceQuotaExceededException
//     The request failed because it would cause a service quota to be exceeded.
//
//   - ConflictException
//     The request failed because another request to modify a resource occurred
//     at the same.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/CreatePolicy
func (c *VerifiedPermissions) CreatePolicy(input *CreatePolicyInput) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	return out, req.Send()
}

// CreatePolicyWithContext is the same as CreatePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) CreatePolicyWithContext(ctx aws.Context, input *CreatePolicyInput, opts ...request.Option) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePolicyStore = "CreatePolicyStore"

// CreatePolicyStoreRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicyStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePolicyStore for more information on using the CreatePolicyStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePolicyStoreRequest method.
//	req, resp := client.CreatePolicyStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/CreatePolicyStore
func (c *VerifiedPermissions) CreatePolicyStoreRequest(input *CreatePolicyStoreInput) (req *request.Request, output *CreatePolicyStoreOutput) {
	op := &request.Operation{
		Name:       opCreatePolicyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePolicyStoreInput{}
	}

	output = &CreatePolicyStoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicyStore API operation for Amazon Verified Permissions.
//
// Creates a policy store. A policy store is a container for policy resources.
//
// Although Cedar supports multiple namespaces (https://docs.cedarpolicy.com/schema/schema.html#namespace),
// Verified Permissions currently supports only one namespace per policy store.
//
// Verified Permissions is eventually consistent (https://wikipedia.org/wiki/Eventual_consistency)
// . It can take a few seconds for a new or changed element to propagate through
// the service and be visible in the results of other Verified Permissions operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation CreatePolicyStore for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - ServiceQuotaExceededException
//     The request failed because it would cause a service quota to be exceeded.
//
//   - ConflictException
//     The request failed because another request to modify a resource occurred
//     at the same.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/CreatePolicyStore
func (c *VerifiedPermissions) CreatePolicyStore(input *CreatePolicyStoreInput) (*CreatePolicyStoreOutput, error) {
	req, out := c.CreatePolicyStoreRequest(input)
	return out, req.Send()
}

// CreatePolicyStoreWithContext is the same as CreatePolicyStore with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePolicyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) CreatePolicyStoreWithContext(ctx aws.Context, input *CreatePolicyStoreInput, opts ...request.Option) (*CreatePolicyStoreOutput, error) {
	req, out := c.CreatePolicyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePolicyTemplate = "CreatePolicyTemplate"

// CreatePolicyTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicyTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePolicyTemplate for more information on using the CreatePolicyTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePolicyTemplateRequest method.
//	req, resp := client.CreatePolicyTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/CreatePolicyTemplate
func (c *VerifiedPermissions) CreatePolicyTemplateRequest(input *CreatePolicyTemplateInput) (req *request.Request, output *CreatePolicyTemplateOutput) {
	op := &request.Operation{
		Name:       opCreatePolicyTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePolicyTemplateInput{}
	}

	output = &CreatePolicyTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicyTemplate API operation for Amazon Verified Permissions.
//
// Creates a policy template. A template can use placeholders for the principal
// and resource. A template must be instantiated into a policy by associating
// it with specific principals and resources to use for the placeholders. That
// instantiated policy can then be considered in authorization decisions. The
// instantiated policy works identically to any other policy, except that it
// is dynamically linked to the template. If the template changes, then any
// policies that are linked to that template are immediately updated as well.
//
// Verified Permissions is eventually consistent (https://wikipedia.org/wiki/Eventual_consistency)
// . It can take a few seconds for a new or changed element to propagate through
// the service and be visible in the results of other Verified Permissions operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation CreatePolicyTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - ServiceQuotaExceededException
//     The request failed because it would cause a service quota to be exceeded.
//
//   - ConflictException
//     The request failed because another request to modify a resource occurred
//     at the same.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/CreatePolicyTemplate
func (c *VerifiedPermissions) CreatePolicyTemplate(input *CreatePolicyTemplateInput) (*CreatePolicyTemplateOutput, error) {
	req, out := c.CreatePolicyTemplateRequest(input)
	return out, req.Send()
}

// CreatePolicyTemplateWithContext is the same as CreatePolicyTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePolicyTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) CreatePolicyTemplateWithContext(ctx aws.Context, input *CreatePolicyTemplateInput, opts ...request.Option) (*CreatePolicyTemplateOutput, error) {
	req, out := c.CreatePolicyTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdentitySource = "DeleteIdentitySource"

// DeleteIdentitySourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdentitySource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdentitySource for more information on using the DeleteIdentitySource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIdentitySourceRequest method.
//	req, resp := client.DeleteIdentitySourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/DeleteIdentitySource
func (c *VerifiedPermissions) DeleteIdentitySourceRequest(input *DeleteIdentitySourceInput) (req *request.Request, output *DeleteIdentitySourceOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentitySource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentitySourceInput{}
	}

	output = &DeleteIdentitySourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIdentitySource API operation for Amazon Verified Permissions.
//
// Deletes an identity source that references an identity provider (IdP) such
// as Amazon Cognito. After you delete the identity source, you can no longer
// use tokens for identities from that identity source to represent principals
// in authorization queries made using IsAuthorizedWithToken (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html).
// operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation DeleteIdentitySource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - ConflictException
//     The request failed because another request to modify a resource occurred
//     at the same.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/DeleteIdentitySource
func (c *VerifiedPermissions) DeleteIdentitySource(input *DeleteIdentitySourceInput) (*DeleteIdentitySourceOutput, error) {
	req, out := c.DeleteIdentitySourceRequest(input)
	return out, req.Send()
}

// DeleteIdentitySourceWithContext is the same as DeleteIdentitySource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdentitySource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) DeleteIdentitySourceWithContext(ctx aws.Context, input *DeleteIdentitySourceInput, opts ...request.Option) (*DeleteIdentitySourceOutput, error) {
	req, out := c.DeleteIdentitySourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicy for more information on using the DeletePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePolicyRequest method.
//	req, resp := client.DeletePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/DeletePolicy
func (c *VerifiedPermissions) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	output = &DeletePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicy API operation for Amazon Verified Permissions.
//
// Deletes the specified policy from the policy store.
//
// This operation is idempotent; if you specify a policy that doesn't exist,
// the request response returns a successful HTTP 200 status code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation DeletePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - ConflictException
//     The request failed because another request to modify a resource occurred
//     at the same.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/DeletePolicy
func (c *VerifiedPermissions) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	return out, req.Send()
}

// DeletePolicyWithContext is the same as DeletePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) DeletePolicyWithContext(ctx aws.Context, input *DeletePolicyInput, opts ...request.Option) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicyStore = "DeletePolicyStore"

// DeletePolicyStoreRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicyStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicyStore for more information on using the DeletePolicyStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePolicyStoreRequest method.
//	req, resp := client.DeletePolicyStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/DeletePolicyStore
func (c *VerifiedPermissions) DeletePolicyStoreRequest(input *DeletePolicyStoreInput) (req *request.Request, output *DeletePolicyStoreOutput) {
	op := &request.Operation{
		Name:       opDeletePolicyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyStoreInput{}
	}

	output = &DeletePolicyStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicyStore API operation for Amazon Verified Permissions.
//
// Deletes the specified policy store.
//
// This operation is idempotent. If you specify a policy store that does not
// exist, the request response will still return a successful HTTP 200 status
// code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation DeletePolicyStore for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/DeletePolicyStore
func (c *VerifiedPermissions) DeletePolicyStore(input *DeletePolicyStoreInput) (*DeletePolicyStoreOutput, error) {
	req, out := c.DeletePolicyStoreRequest(input)
	return out, req.Send()
}

// DeletePolicyStoreWithContext is the same as DeletePolicyStore with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) DeletePolicyStoreWithContext(ctx aws.Context, input *DeletePolicyStoreInput, opts ...request.Option) (*DeletePolicyStoreOutput, error) {
	req, out := c.DeletePolicyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicyTemplate = "DeletePolicyTemplate"

// DeletePolicyTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicyTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicyTemplate for more information on using the DeletePolicyTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePolicyTemplateRequest method.
//	req, resp := client.DeletePolicyTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/DeletePolicyTemplate
func (c *VerifiedPermissions) DeletePolicyTemplateRequest(input *DeletePolicyTemplateInput) (req *request.Request, output *DeletePolicyTemplateOutput) {
	op := &request.Operation{
		Name:       opDeletePolicyTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyTemplateInput{}
	}

	output = &DeletePolicyTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicyTemplate API operation for Amazon Verified Permissions.
//
// Deletes the specified policy template from the policy store.
//
// This operation also deletes any policies that were created from the specified
// policy template. Those policies are immediately removed from all future API
// responses, and are asynchronously deleted from the policy store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation DeletePolicyTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - ConflictException
//     The request failed because another request to modify a resource occurred
//     at the same.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/DeletePolicyTemplate
func (c *VerifiedPermissions) DeletePolicyTemplate(input *DeletePolicyTemplateInput) (*DeletePolicyTemplateOutput, error) {
	req, out := c.DeletePolicyTemplateRequest(input)
	return out, req.Send()
}

// DeletePolicyTemplateWithContext is the same as DeletePolicyTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicyTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) DeletePolicyTemplateWithContext(ctx aws.Context, input *DeletePolicyTemplateInput, opts ...request.Option) (*DeletePolicyTemplateOutput, error) {
	req, out := c.DeletePolicyTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentitySource = "GetIdentitySource"

// GetIdentitySourceRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentitySource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdentitySource for more information on using the GetIdentitySource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdentitySourceRequest method.
//	req, resp := client.GetIdentitySourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/GetIdentitySource
func (c *VerifiedPermissions) GetIdentitySourceRequest(input *GetIdentitySourceInput) (req *request.Request, output *GetIdentitySourceOutput) {
	op := &request.Operation{
		Name:       opGetIdentitySource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentitySourceInput{}
	}

	output = &GetIdentitySourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentitySource API operation for Amazon Verified Permissions.
//
// Retrieves the details about the specified identity source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation GetIdentitySource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/GetIdentitySource
func (c *VerifiedPermissions) GetIdentitySource(input *GetIdentitySourceInput) (*GetIdentitySourceOutput, error) {
	req, out := c.GetIdentitySourceRequest(input)
	return out, req.Send()
}

// GetIdentitySourceWithContext is the same as GetIdentitySource with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentitySource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) GetIdentitySourceWithContext(ctx aws.Context, input *GetIdentitySourceInput, opts ...request.Option) (*GetIdentitySourceOutput, error) {
	req, out := c.GetIdentitySourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicy for more information on using the GetPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPolicyRequest method.
//	req, resp := client.GetPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/GetPolicy
func (c *VerifiedPermissions) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicy API operation for Amazon Verified Permissions.
//
// Retrieves information about the specified policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation GetPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/GetPolicy
func (c *VerifiedPermissions) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	return out, req.Send()
}

// GetPolicyWithContext is the same as GetPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) GetPolicyWithContext(ctx aws.Context, input *GetPolicyInput, opts ...request.Option) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicyStore = "GetPolicyStore"

// GetPolicyStoreRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicyStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicyStore for more information on using the GetPolicyStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPolicyStoreRequest method.
//	req, resp := client.GetPolicyStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/GetPolicyStore
func (c *VerifiedPermissions) GetPolicyStoreRequest(input *GetPolicyStoreInput) (req *request.Request, output *GetPolicyStoreOutput) {
	op := &request.Operation{
		Name:       opGetPolicyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyStoreInput{}
	}

	output = &GetPolicyStoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicyStore API operation for Amazon Verified Permissions.
//
// Retrieves details about a policy store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation GetPolicyStore for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/GetPolicyStore
func (c *VerifiedPermissions) GetPolicyStore(input *GetPolicyStoreInput) (*GetPolicyStoreOutput, error) {
	req, out := c.GetPolicyStoreRequest(input)
	return out, req.Send()
}

// GetPolicyStoreWithContext is the same as GetPolicyStore with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) GetPolicyStoreWithContext(ctx aws.Context, input *GetPolicyStoreInput, opts ...request.Option) (*GetPolicyStoreOutput, error) {
	req, out := c.GetPolicyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicyTemplate = "GetPolicyTemplate"

// GetPolicyTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicyTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicyTemplate for more information on using the GetPolicyTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPolicyTemplateRequest method.
//	req, resp := client.GetPolicyTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/GetPolicyTemplate
func (c *VerifiedPermissions) GetPolicyTemplateRequest(input *GetPolicyTemplateInput) (req *request.Request, output *GetPolicyTemplateOutput) {
	op := &request.Operation{
		Name:       opGetPolicyTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyTemplateInput{}
	}

	output = &GetPolicyTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicyTemplate API operation for Amazon Verified Permissions.
//
// Retrieve the details for the specified policy template in the specified policy
// store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation GetPolicyTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/GetPolicyTemplate
func (c *VerifiedPermissions) GetPolicyTemplate(input *GetPolicyTemplateInput) (*GetPolicyTemplateOutput, error) {
	req, out := c.GetPolicyTemplateRequest(input)
	return out, req.Send()
}

// GetPolicyTemplateWithContext is the same as GetPolicyTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicyTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) GetPolicyTemplateWithContext(ctx aws.Context, input *GetPolicyTemplateInput, opts ...request.Option) (*GetPolicyTemplateOutput, error) {
	req, out := c.GetPolicyTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSchema = "GetSchema"

// GetSchemaRequest generates a "aws/request.Request" representing the
// client's request for the GetSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSchema for more information on using the GetSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSchemaRequest method.
//	req, resp := client.GetSchemaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/GetSchema
func (c *VerifiedPermissions) GetSchemaRequest(input *GetSchemaInput) (req *request.Request, output *GetSchemaOutput) {
	op := &request.Operation{
		Name:       opGetSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSchemaInput{}
	}

	output = &GetSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSchema API operation for Amazon Verified Permissions.
//
// Retrieve the details for the specified schema in the specified policy store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation GetSchema for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/GetSchema
func (c *VerifiedPermissions) GetSchema(input *GetSchemaInput) (*GetSchemaOutput, error) {
	req, out := c.GetSchemaRequest(input)
	return out, req.Send()
}

// GetSchemaWithContext is the same as GetSchema with the addition of
// the ability to pass a context and additional request options.
//
// See GetSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) GetSchemaWithContext(ctx aws.Context, input *GetSchemaInput, opts ...request.Option) (*GetSchemaOutput, error) {
	req, out := c.GetSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIsAuthorized = "IsAuthorized"

// IsAuthorizedRequest generates a "aws/request.Request" representing the
// client's request for the IsAuthorized operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IsAuthorized for more information on using the IsAuthorized
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the IsAuthorizedRequest method.
//	req, resp := client.IsAuthorizedRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/IsAuthorized
func (c *VerifiedPermissions) IsAuthorizedRequest(input *IsAuthorizedInput) (req *request.Request, output *IsAuthorizedOutput) {
	op := &request.Operation{
		Name:       opIsAuthorized,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IsAuthorizedInput{}
	}

	output = &IsAuthorizedOutput{}
	req = c.newRequest(op, input, output)
	return
}

// IsAuthorized API operation for Amazon Verified Permissions.
//
// Makes an authorization decision about a service request described in the
// parameters. The information in the parameters can also define additional
// context that Verified Permissions can include in the evaluation. The request
// is evaluated against all matching policies in the specified policy store.
// The result of the decision is either Allow or Deny, along with a list of
// the policies that resulted in the decision.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation IsAuthorized for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/IsAuthorized
func (c *VerifiedPermissions) IsAuthorized(input *IsAuthorizedInput) (*IsAuthorizedOutput, error) {
	req, out := c.IsAuthorizedRequest(input)
	return out, req.Send()
}

// IsAuthorizedWithContext is the same as IsAuthorized with the addition of
// the ability to pass a context and additional request options.
//
// See IsAuthorized for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) IsAuthorizedWithContext(ctx aws.Context, input *IsAuthorizedInput, opts ...request.Option) (*IsAuthorizedOutput, error) {
	req, out := c.IsAuthorizedRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIsAuthorizedWithToken = "IsAuthorizedWithToken"

// IsAuthorizedWithTokenRequest generates a "aws/request.Request" representing the
// client's request for the IsAuthorizedWithToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IsAuthorizedWithToken for more information on using the IsAuthorizedWithToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the IsAuthorizedWithTokenRequest method.
//	req, resp := client.IsAuthorizedWithTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/IsAuthorizedWithToken
func (c *VerifiedPermissions) IsAuthorizedWithTokenRequest(input *IsAuthorizedWithTokenInput) (req *request.Request, output *IsAuthorizedWithTokenOutput) {
	op := &request.Operation{
		Name:       opIsAuthorizedWithToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IsAuthorizedWithTokenInput{}
	}

	output = &IsAuthorizedWithTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// IsAuthorizedWithToken API operation for Amazon Verified Permissions.
//
// Makes an authorization decision about a service request described in the
// parameters. The principal in this request comes from an external identity
// source in the form of an identity token formatted as a JSON web token (JWT)
// (https://wikipedia.org/wiki/JSON_Web_Token). The information in the parameters
// can also define additional context that Verified Permissions can include
// in the evaluation. The request is evaluated against all matching policies
// in the specified policy store. The result of the decision is either Allow
// or Deny, along with a list of the policies that resulted in the decision.
//
// At this time, Verified Permissions accepts tokens from only Amazon Cognito.
//
// Verified Permissions validates each token that is specified in a request
// by checking its expiration date and its signature.
//
// Tokens from an identity source user continue to be usable until they expire.
// Token revocation and resource deletion have no effect on the validity of
// a token in your policy store
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation IsAuthorizedWithToken for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/IsAuthorizedWithToken
func (c *VerifiedPermissions) IsAuthorizedWithToken(input *IsAuthorizedWithTokenInput) (*IsAuthorizedWithTokenOutput, error) {
	req, out := c.IsAuthorizedWithTokenRequest(input)
	return out, req.Send()
}

// IsAuthorizedWithTokenWithContext is the same as IsAuthorizedWithToken with the addition of
// the ability to pass a context and additional request options.
//
// See IsAuthorizedWithToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) IsAuthorizedWithTokenWithContext(ctx aws.Context, input *IsAuthorizedWithTokenInput, opts ...request.Option) (*IsAuthorizedWithTokenOutput, error) {
	req, out := c.IsAuthorizedWithTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIdentitySources = "ListIdentitySources"

// ListIdentitySourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentitySources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentitySources for more information on using the ListIdentitySources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdentitySourcesRequest method.
//	req, resp := client.ListIdentitySourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/ListIdentitySources
func (c *VerifiedPermissions) ListIdentitySourcesRequest(input *ListIdentitySourcesInput) (req *request.Request, output *ListIdentitySourcesOutput) {
	op := &request.Operation{
		Name:       opListIdentitySources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdentitySourcesInput{}
	}

	output = &ListIdentitySourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentitySources API operation for Amazon Verified Permissions.
//
// Returns a paginated list of all of the identity sources defined in the specified
// policy store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation ListIdentitySources for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/ListIdentitySources
func (c *VerifiedPermissions) ListIdentitySources(input *ListIdentitySourcesInput) (*ListIdentitySourcesOutput, error) {
	req, out := c.ListIdentitySourcesRequest(input)
	return out, req.Send()
}

// ListIdentitySourcesWithContext is the same as ListIdentitySources with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentitySources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) ListIdentitySourcesWithContext(ctx aws.Context, input *ListIdentitySourcesInput, opts ...request.Option) (*ListIdentitySourcesOutput, error) {
	req, out := c.ListIdentitySourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdentitySourcesPages iterates over the pages of a ListIdentitySources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdentitySources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIdentitySources operation.
//	pageNum := 0
//	err := client.ListIdentitySourcesPages(params,
//	    func(page *verifiedpermissions.ListIdentitySourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VerifiedPermissions) ListIdentitySourcesPages(input *ListIdentitySourcesInput, fn func(*ListIdentitySourcesOutput, bool) bool) error {
	return c.ListIdentitySourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdentitySourcesPagesWithContext same as ListIdentitySourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) ListIdentitySourcesPagesWithContext(ctx aws.Context, input *ListIdentitySourcesInput, fn func(*ListIdentitySourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdentitySourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdentitySourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIdentitySourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPolicies = "ListPolicies"

// ListPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicies for more information on using the ListPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPoliciesRequest method.
//	req, resp := client.ListPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/ListPolicies
func (c *VerifiedPermissions) ListPoliciesRequest(input *ListPoliciesInput) (req *request.Request, output *ListPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPoliciesInput{}
	}

	output = &ListPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicies API operation for Amazon Verified Permissions.
//
// Returns a paginated list of all policies stored in the specified policy store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation ListPolicies for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/ListPolicies
func (c *VerifiedPermissions) ListPolicies(input *ListPoliciesInput) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	return out, req.Send()
}

// ListPoliciesWithContext is the same as ListPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) ListPoliciesWithContext(ctx aws.Context, input *ListPoliciesInput, opts ...request.Option) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPoliciesPages iterates over the pages of a ListPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPolicies operation.
//	pageNum := 0
//	err := client.ListPoliciesPages(params,
//	    func(page *verifiedpermissions.ListPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VerifiedPermissions) ListPoliciesPages(input *ListPoliciesInput, fn func(*ListPoliciesOutput, bool) bool) error {
	return c.ListPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPoliciesPagesWithContext same as ListPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) ListPoliciesPagesWithContext(ctx aws.Context, input *ListPoliciesInput, fn func(*ListPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPolicyStores = "ListPolicyStores"

// ListPolicyStoresRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicyStores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicyStores for more information on using the ListPolicyStores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPolicyStoresRequest method.
//	req, resp := client.ListPolicyStoresRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/ListPolicyStores
func (c *VerifiedPermissions) ListPolicyStoresRequest(input *ListPolicyStoresInput) (req *request.Request, output *ListPolicyStoresOutput) {
	op := &request.Operation{
		Name:       opListPolicyStores,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPolicyStoresInput{}
	}

	output = &ListPolicyStoresOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicyStores API operation for Amazon Verified Permissions.
//
// Returns a paginated list of all policy stores in the calling Amazon Web Services
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation ListPolicyStores for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/ListPolicyStores
func (c *VerifiedPermissions) ListPolicyStores(input *ListPolicyStoresInput) (*ListPolicyStoresOutput, error) {
	req, out := c.ListPolicyStoresRequest(input)
	return out, req.Send()
}

// ListPolicyStoresWithContext is the same as ListPolicyStores with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicyStores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) ListPolicyStoresWithContext(ctx aws.Context, input *ListPolicyStoresInput, opts ...request.Option) (*ListPolicyStoresOutput, error) {
	req, out := c.ListPolicyStoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPolicyStoresPages iterates over the pages of a ListPolicyStores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPolicyStores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPolicyStores operation.
//	pageNum := 0
//	err := client.ListPolicyStoresPages(params,
//	    func(page *verifiedpermissions.ListPolicyStoresOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VerifiedPermissions) ListPolicyStoresPages(input *ListPolicyStoresInput, fn func(*ListPolicyStoresOutput, bool) bool) error {
	return c.ListPolicyStoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPolicyStoresPagesWithContext same as ListPolicyStoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) ListPolicyStoresPagesWithContext(ctx aws.Context, input *ListPolicyStoresInput, fn func(*ListPolicyStoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPolicyStoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPolicyStoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPolicyStoresOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPolicyTemplates = "ListPolicyTemplates"

// ListPolicyTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicyTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicyTemplates for more information on using the ListPolicyTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPolicyTemplatesRequest method.
//	req, resp := client.ListPolicyTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/ListPolicyTemplates
func (c *VerifiedPermissions) ListPolicyTemplatesRequest(input *ListPolicyTemplatesInput) (req *request.Request, output *ListPolicyTemplatesOutput) {
	op := &request.Operation{
		Name:       opListPolicyTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPolicyTemplatesInput{}
	}

	output = &ListPolicyTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicyTemplates API operation for Amazon Verified Permissions.
//
// Returns a paginated list of all policy templates in the specified policy
// store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation ListPolicyTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/ListPolicyTemplates
func (c *VerifiedPermissions) ListPolicyTemplates(input *ListPolicyTemplatesInput) (*ListPolicyTemplatesOutput, error) {
	req, out := c.ListPolicyTemplatesRequest(input)
	return out, req.Send()
}

// ListPolicyTemplatesWithContext is the same as ListPolicyTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicyTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) ListPolicyTemplatesWithContext(ctx aws.Context, input *ListPolicyTemplatesInput, opts ...request.Option) (*ListPolicyTemplatesOutput, error) {
	req, out := c.ListPolicyTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPolicyTemplatesPages iterates over the pages of a ListPolicyTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPolicyTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPolicyTemplates operation.
//	pageNum := 0
//	err := client.ListPolicyTemplatesPages(params,
//	    func(page *verifiedpermissions.ListPolicyTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VerifiedPermissions) ListPolicyTemplatesPages(input *ListPolicyTemplatesInput, fn func(*ListPolicyTemplatesOutput, bool) bool) error {
	return c.ListPolicyTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPolicyTemplatesPagesWithContext same as ListPolicyTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) ListPolicyTemplatesPagesWithContext(ctx aws.Context, input *ListPolicyTemplatesInput, fn func(*ListPolicyTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPolicyTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPolicyTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPolicyTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutSchema = "PutSchema"

// PutSchemaRequest generates a "aws/request.Request" representing the
// client's request for the PutSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSchema for more information on using the PutSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutSchemaRequest method.
//	req, resp := client.PutSchemaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/PutSchema
func (c *VerifiedPermissions) PutSchemaRequest(input *PutSchemaInput) (req *request.Request, output *PutSchemaOutput) {
	op := &request.Operation{
		Name:       opPutSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutSchemaInput{}
	}

	output = &PutSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSchema API operation for Amazon Verified Permissions.
//
// Creates or updates the policy schema in the specified policy store. The schema
// is used to validate any Cedar policies and policy templates submitted to
// the policy store. Any changes to the schema validate only policies and templates
// submitted after the schema change. Existing policies and templates are not
// re-evaluated against the changed schema. If you later update a policy, then
// it is evaluated against the new schema at that time.
//
// Verified Permissions is eventually consistent (https://wikipedia.org/wiki/Eventual_consistency)
// . It can take a few seconds for a new or changed element to propagate through
// the service and be visible in the results of other Verified Permissions operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation PutSchema for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - ServiceQuotaExceededException
//     The request failed because it would cause a service quota to be exceeded.
//
//   - ConflictException
//     The request failed because another request to modify a resource occurred
//     at the same.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/PutSchema
func (c *VerifiedPermissions) PutSchema(input *PutSchemaInput) (*PutSchemaOutput, error) {
	req, out := c.PutSchemaRequest(input)
	return out, req.Send()
}

// PutSchemaWithContext is the same as PutSchema with the addition of
// the ability to pass a context and additional request options.
//
// See PutSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) PutSchemaWithContext(ctx aws.Context, input *PutSchemaInput, opts ...request.Option) (*PutSchemaOutput, error) {
	req, out := c.PutSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIdentitySource = "UpdateIdentitySource"

// UpdateIdentitySourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIdentitySource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIdentitySource for more information on using the UpdateIdentitySource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIdentitySourceRequest method.
//	req, resp := client.UpdateIdentitySourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/UpdateIdentitySource
func (c *VerifiedPermissions) UpdateIdentitySourceRequest(input *UpdateIdentitySourceInput) (req *request.Request, output *UpdateIdentitySourceOutput) {
	op := &request.Operation{
		Name:       opUpdateIdentitySource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateIdentitySourceInput{}
	}

	output = &UpdateIdentitySourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIdentitySource API operation for Amazon Verified Permissions.
//
// Updates the specified identity source to use a new identity provider (IdP),
// or to change the mapping of identities from the IdP to a different principal
// entity type.
//
// Verified Permissions is eventually consistent (https://wikipedia.org/wiki/Eventual_consistency)
// . It can take a few seconds for a new or changed element to propagate through
// the service and be visible in the results of other Verified Permissions operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation UpdateIdentitySource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - ConflictException
//     The request failed because another request to modify a resource occurred
//     at the same.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/UpdateIdentitySource
func (c *VerifiedPermissions) UpdateIdentitySource(input *UpdateIdentitySourceInput) (*UpdateIdentitySourceOutput, error) {
	req, out := c.UpdateIdentitySourceRequest(input)
	return out, req.Send()
}

// UpdateIdentitySourceWithContext is the same as UpdateIdentitySource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIdentitySource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) UpdateIdentitySourceWithContext(ctx aws.Context, input *UpdateIdentitySourceInput, opts ...request.Option) (*UpdateIdentitySourceOutput, error) {
	req, out := c.UpdateIdentitySourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePolicy = "UpdatePolicy"

// UpdatePolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePolicy for more information on using the UpdatePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePolicyRequest method.
//	req, resp := client.UpdatePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/UpdatePolicy
func (c *VerifiedPermissions) UpdatePolicyRequest(input *UpdatePolicyInput) (req *request.Request, output *UpdatePolicyOutput) {
	op := &request.Operation{
		Name:       opUpdatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePolicyInput{}
	}

	output = &UpdatePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePolicy API operation for Amazon Verified Permissions.
//
// Modifies a Cedar static policy in the specified policy store. You can change
// only certain elements of the UpdatePolicyDefinition (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyInput.html#amazonverifiedpermissions-UpdatePolicy-request-UpdatePolicyDefinition)
// parameter. You can directly update only static policies. To change a template-linked
// policy, you must update the template instead, using UpdatePolicyTemplate
// (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html).
//
//   - If policy validation is enabled in the policy store, then updating a
//     static policy causes Verified Permissions to validate the policy against
//     the schema in the policy store. If the updated static policy doesn't pass
//     validation, the operation fails and the update isn't stored.
//
//   - When you edit a static policy, you can change only certain elements
//     of a static policy: The action referenced by the policy. A condition clause,
//     such as when and unless. You can't change these elements of a static policy:
//     Changing a policy from a static policy to a template-linked policy. Changing
//     the effect of a static policy from permit or forbid. The principal referenced
//     by a static policy. The resource referenced by a static policy.
//
//   - To update a template-linked policy, you must update the template instead.
//
// Verified Permissions is eventually consistent (https://wikipedia.org/wiki/Eventual_consistency)
// . It can take a few seconds for a new or changed element to propagate through
// the service and be visible in the results of other Verified Permissions operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation UpdatePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - ServiceQuotaExceededException
//     The request failed because it would cause a service quota to be exceeded.
//
//   - ConflictException
//     The request failed because another request to modify a resource occurred
//     at the same.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/UpdatePolicy
func (c *VerifiedPermissions) UpdatePolicy(input *UpdatePolicyInput) (*UpdatePolicyOutput, error) {
	req, out := c.UpdatePolicyRequest(input)
	return out, req.Send()
}

// UpdatePolicyWithContext is the same as UpdatePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) UpdatePolicyWithContext(ctx aws.Context, input *UpdatePolicyInput, opts ...request.Option) (*UpdatePolicyOutput, error) {
	req, out := c.UpdatePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePolicyStore = "UpdatePolicyStore"

// UpdatePolicyStoreRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePolicyStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePolicyStore for more information on using the UpdatePolicyStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePolicyStoreRequest method.
//	req, resp := client.UpdatePolicyStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/UpdatePolicyStore
func (c *VerifiedPermissions) UpdatePolicyStoreRequest(input *UpdatePolicyStoreInput) (req *request.Request, output *UpdatePolicyStoreOutput) {
	op := &request.Operation{
		Name:       opUpdatePolicyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePolicyStoreInput{}
	}

	output = &UpdatePolicyStoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePolicyStore API operation for Amazon Verified Permissions.
//
// Modifies the validation setting for a policy store.
//
// Verified Permissions is eventually consistent (https://wikipedia.org/wiki/Eventual_consistency)
// . It can take a few seconds for a new or changed element to propagate through
// the service and be visible in the results of other Verified Permissions operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation UpdatePolicyStore for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - ConflictException
//     The request failed because another request to modify a resource occurred
//     at the same.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/UpdatePolicyStore
func (c *VerifiedPermissions) UpdatePolicyStore(input *UpdatePolicyStoreInput) (*UpdatePolicyStoreOutput, error) {
	req, out := c.UpdatePolicyStoreRequest(input)
	return out, req.Send()
}

// UpdatePolicyStoreWithContext is the same as UpdatePolicyStore with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePolicyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) UpdatePolicyStoreWithContext(ctx aws.Context, input *UpdatePolicyStoreInput, opts ...request.Option) (*UpdatePolicyStoreOutput, error) {
	req, out := c.UpdatePolicyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePolicyTemplate = "UpdatePolicyTemplate"

// UpdatePolicyTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePolicyTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePolicyTemplate for more information on using the UpdatePolicyTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePolicyTemplateRequest method.
//	req, resp := client.UpdatePolicyTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/UpdatePolicyTemplate
func (c *VerifiedPermissions) UpdatePolicyTemplateRequest(input *UpdatePolicyTemplateInput) (req *request.Request, output *UpdatePolicyTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdatePolicyTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePolicyTemplateInput{}
	}

	output = &UpdatePolicyTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePolicyTemplate API operation for Amazon Verified Permissions.
//
// Updates the specified policy template. You can update only the description
// and the some elements of the policyBody (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html#amazonverifiedpermissions-UpdatePolicyTemplate-request-policyBody).
//
// Changes you make to the policy template content are immediately (within the
// constraints of eventual consistency) reflected in authorization decisions
// that involve all template-linked policies instantiated from this template.
//
// Verified Permissions is eventually consistent (https://wikipedia.org/wiki/Eventual_consistency)
// . It can take a few seconds for a new or changed element to propagate through
// the service and be visible in the results of other Verified Permissions operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Verified Permissions's
// API operation UpdatePolicyTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed because one or more input parameters don't satisfy their
//     constraint requirements. The output is provided as a list of fields and a
//     reason for each field that isn't valid.
//
//     The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
//
//   - ConflictException
//     The request failed because another request to modify a resource occurred
//     at the same.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request failed because it references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request failed because it exceeded a throttling quota.
//
//   - InternalServerException
//     The request failed because of an internal error. Try your request again later
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/UpdatePolicyTemplate
func (c *VerifiedPermissions) UpdatePolicyTemplate(input *UpdatePolicyTemplateInput) (*UpdatePolicyTemplateOutput, error) {
	req, out := c.UpdatePolicyTemplateRequest(input)
	return out, req.Send()
}

// UpdatePolicyTemplateWithContext is the same as UpdatePolicyTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePolicyTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VerifiedPermissions) UpdatePolicyTemplateWithContext(ctx aws.Context, input *UpdatePolicyTemplateInput, opts ...request.Option) (*UpdatePolicyTemplateOutput, error) {
	req, out := c.UpdatePolicyTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about an action for a request for which an authorization
// decision is made.
//
// This data type is used as a request parameter to the IsAuthorized (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html),
// BatchIsAuthorized (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html),
// and IsAuthorizedWithToken (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html)
// operations.
//
// Example: { "actionId": "<action name>", "actionType": "Action" }
type ActionIdentifier struct {
	_ struct{} `type:"structure"`

	// The ID of an action.
	//
	// ActionId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActionIdentifier's
	// String and GoString methods.
	//
	// ActionId is a required field
	ActionId *string `locationName:"actionId" min:"1" type:"string" required:"true" sensitive:"true"`

	// The type of an action.
	//
	// ActionType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActionIdentifier's
	// String and GoString methods.
	//
	// ActionType is a required field
	ActionType *string `locationName:"actionType" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionIdentifier"}
	if s.ActionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionId"))
	}
	if s.ActionId != nil && len(*s.ActionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionId", 1))
	}
	if s.ActionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionType"))
	}
	if s.ActionType != nil && len(*s.ActionType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionId sets the ActionId field's value.
func (s *ActionIdentifier) SetActionId(v string) *ActionIdentifier {
	s.ActionId = &v
	return s
}

// SetActionType sets the ActionType field's value.
func (s *ActionIdentifier) SetActionType(v string) *ActionIdentifier {
	s.ActionType = &v
	return s
}

// The value of an attribute.
//
// Contains information about the runtime context for a request for which an
// authorization decision is made.
//
// This data type is used as a member of the ContextDefinition (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ContextDefinition.html)
// structure which is uses as a request parameter for the IsAuthorized (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html),
// BatchIsAuthorized (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html),
// and IsAuthorizedWithToken (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html)
// operations.
type AttributeValue struct {
	_ struct{} `type:"structure"`

	// An attribute value of Boolean (https://docs.cedarpolicy.com/policies/syntax-datatypes.html#boolean)
	// type.
	//
	// Example: {"boolean": true}
	//
	// Boolean is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AttributeValue's
	// String and GoString methods.
	Boolean *bool `locationName:"boolean" type:"boolean" sensitive:"true"`

	// An attribute value of type EntityIdentifier (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html).
	//
	// Example: "entityIdentifier": { "entityId": "<id>", "entityType": "<entity
	// type>"}
	EntityIdentifier *EntityIdentifier `locationName:"entityIdentifier" type:"structure"`

	// An attribute value of Long (https://docs.cedarpolicy.com/policies/syntax-datatypes.html#long)
	// type.
	//
	// Example: {"long": 0}
	//
	// Long is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AttributeValue's
	// String and GoString methods.
	Long *int64 `locationName:"long" type:"long" sensitive:"true"`

	// An attribute value of Record (https://docs.cedarpolicy.com/policies/syntax-datatypes.html#record)
	// type.
	//
	// Example: {"record": { "keyName": {} } }
	Record map[string]*AttributeValue `locationName:"record" type:"map"`

	// An attribute value of Set (https://docs.cedarpolicy.com/policies/syntax-datatypes.html#set)
	// type.
	//
	// Example: {"set": [ {} ] }
	Set []*AttributeValue `locationName:"set" type:"list"`

	// An attribute value of String (https://docs.cedarpolicy.com/policies/syntax-datatypes.html#string)
	// type.
	//
	// Example: {"string": "abc"}
	//
	// String_ is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AttributeValue's
	// String and GoString methods.
	String_ *string `locationName:"string" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeValue"}
	if s.EntityIdentifier != nil {
		if err := s.EntityIdentifier.Validate(); err != nil {
			invalidParams.AddNested("EntityIdentifier", err.(request.ErrInvalidParams))
		}
	}
	if s.Record != nil {
		for i, v := range s.Record {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Record", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Set != nil {
		for i, v := range s.Set {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Set", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBoolean sets the Boolean field's value.
func (s *AttributeValue) SetBoolean(v bool) *AttributeValue {
	s.Boolean = &v
	return s
}

// SetEntityIdentifier sets the EntityIdentifier field's value.
func (s *AttributeValue) SetEntityIdentifier(v *EntityIdentifier) *AttributeValue {
	s.EntityIdentifier = v
	return s
}

// SetLong sets the Long field's value.
func (s *AttributeValue) SetLong(v int64) *AttributeValue {
	s.Long = &v
	return s
}

// SetRecord sets the Record field's value.
func (s *AttributeValue) SetRecord(v map[string]*AttributeValue) *AttributeValue {
	s.Record = v
	return s
}

// SetSet sets the Set field's value.
func (s *AttributeValue) SetSet(v []*AttributeValue) *AttributeValue {
	s.Set = v
	return s
}

// SetString_ sets the String_ field's value.
func (s *AttributeValue) SetString_(v string) *AttributeValue {
	s.String_ = &v
	return s
}

type BatchIsAuthorizedInput struct {
	_ struct{} `type:"structure"`

	// Specifies the list of resources and principals and their associated attributes
	// that Verified Permissions can examine when evaluating the policies.
	//
	// You can include only principal and resource entities in this parameter; you
	// can't include actions. You must specify actions in the schema.
	Entities *EntitiesDefinition `locationName:"entities" type:"structure"`

	// Specifies the ID of the policy store. Policies in this policy store will
	// be used to make the authorization decisions for the input.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// An array of up to 30 requests that you want Verified Permissions to evaluate.
	//
	// Requests is a required field
	Requests []*BatchIsAuthorizedInputItem `locationName:"requests" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchIsAuthorizedInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchIsAuthorizedInput"}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.Requests == nil {
		invalidParams.Add(request.NewErrParamRequired("Requests"))
	}
	if s.Requests != nil && len(s.Requests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Requests", 1))
	}
	if s.Entities != nil {
		if err := s.Entities.Validate(); err != nil {
			invalidParams.AddNested("Entities", err.(request.ErrInvalidParams))
		}
	}
	if s.Requests != nil {
		for i, v := range s.Requests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Requests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntities sets the Entities field's value.
func (s *BatchIsAuthorizedInput) SetEntities(v *EntitiesDefinition) *BatchIsAuthorizedInput {
	s.Entities = v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *BatchIsAuthorizedInput) SetPolicyStoreId(v string) *BatchIsAuthorizedInput {
	s.PolicyStoreId = &v
	return s
}

// SetRequests sets the Requests field's value.
func (s *BatchIsAuthorizedInput) SetRequests(v []*BatchIsAuthorizedInputItem) *BatchIsAuthorizedInput {
	s.Requests = v
	return s
}

// An authorization request that you include in a BatchIsAuthorized API request.
type BatchIsAuthorizedInputItem struct {
	_ struct{} `type:"structure"`

	// Specifies the requested action to be authorized. For example, PhotoFlash::ReadPhoto.
	Action *ActionIdentifier `locationName:"action" type:"structure"`

	// Specifies additional context that can be used to make more granular authorization
	// decisions.
	Context *ContextDefinition `locationName:"context" type:"structure"`

	// Specifies the principal for which the authorization decision is to be made.
	Principal *EntityIdentifier `locationName:"principal" type:"structure"`

	// Specifies the resource that you want an authorization decision for. For example,
	// PhotoFlash::Photo.
	Resource *EntityIdentifier `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedInputItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedInputItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchIsAuthorizedInputItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchIsAuthorizedInputItem"}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Context != nil {
		if err := s.Context.Validate(); err != nil {
			invalidParams.AddNested("Context", err.(request.ErrInvalidParams))
		}
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *BatchIsAuthorizedInputItem) SetAction(v *ActionIdentifier) *BatchIsAuthorizedInputItem {
	s.Action = v
	return s
}

// SetContext sets the Context field's value.
func (s *BatchIsAuthorizedInputItem) SetContext(v *ContextDefinition) *BatchIsAuthorizedInputItem {
	s.Context = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *BatchIsAuthorizedInputItem) SetPrincipal(v *EntityIdentifier) *BatchIsAuthorizedInputItem {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *BatchIsAuthorizedInputItem) SetResource(v *EntityIdentifier) *BatchIsAuthorizedInputItem {
	s.Resource = v
	return s
}

type BatchIsAuthorizedOutput struct {
	_ struct{} `type:"structure"`

	// A series of Allow or Deny decisions for each request, and the policies that
	// produced them.
	//
	// Results is a required field
	Results []*BatchIsAuthorizedOutputItem `locationName:"results" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedOutput) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *BatchIsAuthorizedOutput) SetResults(v []*BatchIsAuthorizedOutputItem) *BatchIsAuthorizedOutput {
	s.Results = v
	return s
}

// The decision, based on policy evaluation, from an individual authorization
// request in a BatchIsAuthorized API request.
type BatchIsAuthorizedOutputItem struct {
	_ struct{} `type:"structure"`

	// An authorization decision that indicates if the authorization request should
	// be allowed or denied.
	//
	// Decision is a required field
	Decision *string `locationName:"decision" type:"string" required:"true" enum:"Decision"`

	// The list of determining policies used to make the authorization decision.
	// For example, if there are two matching policies, where one is a forbid and
	// the other is a permit, then the forbid policy will be the determining policy.
	// In the case of multiple matching permit policies then there would be multiple
	// determining policies. In the case that no policies match, and hence the response
	// is DENY, there would be no determining policies.
	//
	// DeterminingPolicies is a required field
	DeterminingPolicies []*DeterminingPolicyItem `locationName:"determiningPolicies" type:"list" required:"true"`

	// Errors that occurred while making an authorization decision. For example,
	// a policy might reference an entity or attribute that doesn't exist in the
	// request.
	//
	// Errors is a required field
	Errors []*EvaluationErrorItem `locationName:"errors" type:"list" required:"true"`

	// The authorization request that initiated the decision.
	//
	// Request is a required field
	Request *BatchIsAuthorizedInputItem `locationName:"request" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedOutputItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedOutputItem) GoString() string {
	return s.String()
}

// SetDecision sets the Decision field's value.
func (s *BatchIsAuthorizedOutputItem) SetDecision(v string) *BatchIsAuthorizedOutputItem {
	s.Decision = &v
	return s
}

// SetDeterminingPolicies sets the DeterminingPolicies field's value.
func (s *BatchIsAuthorizedOutputItem) SetDeterminingPolicies(v []*DeterminingPolicyItem) *BatchIsAuthorizedOutputItem {
	s.DeterminingPolicies = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchIsAuthorizedOutputItem) SetErrors(v []*EvaluationErrorItem) *BatchIsAuthorizedOutputItem {
	s.Errors = v
	return s
}

// SetRequest sets the Request field's value.
func (s *BatchIsAuthorizedOutputItem) SetRequest(v *BatchIsAuthorizedInputItem) *BatchIsAuthorizedOutputItem {
	s.Request = v
	return s
}

type BatchIsAuthorizedWithTokenInput struct {
	_ struct{} `type:"structure"`

	// Specifies an access token for the principal that you want to authorize in
	// each request. This token is provided to you by the identity provider (IdP)
	// associated with the specified identity source. You must specify either an
	// accessToken, an identityToken, or both.
	//
	// Must be an access token. Verified Permissions returns an error if the token_use
	// claim in the submitted token isn't access.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BatchIsAuthorizedWithTokenInput's
	// String and GoString methods.
	AccessToken *string `locationName:"accessToken" min:"1" type:"string" sensitive:"true"`

	// Specifies the list of resources and their associated attributes that Verified
	// Permissions can examine when evaluating the policies.
	//
	// You can't include principals in this parameter, only resource and action
	// entities. This parameter can't include any entities of a type that matches
	// the user or group entity types that you defined in your identity source.
	//
	//    * The BatchIsAuthorizedWithToken operation takes principal attributes
	//    from only the identityToken or accessToken passed to the operation.
	//
	//    * For action entities, you can include only their Identifier and EntityType.
	Entities *EntitiesDefinition `locationName:"entities" type:"structure"`

	// Specifies an identity (ID) token for the principal that you want to authorize
	// in each request. This token is provided to you by the identity provider (IdP)
	// associated with the specified identity source. You must specify either an
	// accessToken, an identityToken, or both.
	//
	// Must be an ID token. Verified Permissions returns an error if the token_use
	// claim in the submitted token isn't id.
	//
	// IdentityToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BatchIsAuthorizedWithTokenInput's
	// String and GoString methods.
	IdentityToken *string `locationName:"identityToken" min:"1" type:"string" sensitive:"true"`

	// Specifies the ID of the policy store. Policies in this policy store will
	// be used to make an authorization decision for the input.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// An array of up to 30 requests that you want Verified Permissions to evaluate.
	//
	// Requests is a required field
	Requests []*BatchIsAuthorizedWithTokenInputItem `locationName:"requests" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedWithTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedWithTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchIsAuthorizedWithTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchIsAuthorizedWithTokenInput"}
	if s.AccessToken != nil && len(*s.AccessToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessToken", 1))
	}
	if s.IdentityToken != nil && len(*s.IdentityToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityToken", 1))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.Requests == nil {
		invalidParams.Add(request.NewErrParamRequired("Requests"))
	}
	if s.Requests != nil && len(s.Requests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Requests", 1))
	}
	if s.Entities != nil {
		if err := s.Entities.Validate(); err != nil {
			invalidParams.AddNested("Entities", err.(request.ErrInvalidParams))
		}
	}
	if s.Requests != nil {
		for i, v := range s.Requests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Requests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *BatchIsAuthorizedWithTokenInput) SetAccessToken(v string) *BatchIsAuthorizedWithTokenInput {
	s.AccessToken = &v
	return s
}

// SetEntities sets the Entities field's value.
func (s *BatchIsAuthorizedWithTokenInput) SetEntities(v *EntitiesDefinition) *BatchIsAuthorizedWithTokenInput {
	s.Entities = v
	return s
}

// SetIdentityToken sets the IdentityToken field's value.
func (s *BatchIsAuthorizedWithTokenInput) SetIdentityToken(v string) *BatchIsAuthorizedWithTokenInput {
	s.IdentityToken = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *BatchIsAuthorizedWithTokenInput) SetPolicyStoreId(v string) *BatchIsAuthorizedWithTokenInput {
	s.PolicyStoreId = &v
	return s
}

// SetRequests sets the Requests field's value.
func (s *BatchIsAuthorizedWithTokenInput) SetRequests(v []*BatchIsAuthorizedWithTokenInputItem) *BatchIsAuthorizedWithTokenInput {
	s.Requests = v
	return s
}

// An authorization request that you include in a BatchIsAuthorizedWithToken
// API request.
type BatchIsAuthorizedWithTokenInputItem struct {
	_ struct{} `type:"structure"`

	// Specifies the requested action to be authorized. For example, PhotoFlash::ReadPhoto.
	Action *ActionIdentifier `locationName:"action" type:"structure"`

	// Specifies additional context that can be used to make more granular authorization
	// decisions.
	Context *ContextDefinition `locationName:"context" type:"structure"`

	// Specifies the resource that you want an authorization decision for. For example,
	// PhotoFlash::Photo.
	Resource *EntityIdentifier `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedWithTokenInputItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedWithTokenInputItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchIsAuthorizedWithTokenInputItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchIsAuthorizedWithTokenInputItem"}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Context != nil {
		if err := s.Context.Validate(); err != nil {
			invalidParams.AddNested("Context", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *BatchIsAuthorizedWithTokenInputItem) SetAction(v *ActionIdentifier) *BatchIsAuthorizedWithTokenInputItem {
	s.Action = v
	return s
}

// SetContext sets the Context field's value.
func (s *BatchIsAuthorizedWithTokenInputItem) SetContext(v *ContextDefinition) *BatchIsAuthorizedWithTokenInputItem {
	s.Context = v
	return s
}

// SetResource sets the Resource field's value.
func (s *BatchIsAuthorizedWithTokenInputItem) SetResource(v *EntityIdentifier) *BatchIsAuthorizedWithTokenInputItem {
	s.Resource = v
	return s
}

type BatchIsAuthorizedWithTokenOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the principal in the ID or access token.
	Principal *EntityIdentifier `locationName:"principal" type:"structure"`

	// A series of Allow or Deny decisions for each request, and the policies that
	// produced them.
	//
	// Results is a required field
	Results []*BatchIsAuthorizedWithTokenOutputItem `locationName:"results" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedWithTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedWithTokenOutput) GoString() string {
	return s.String()
}

// SetPrincipal sets the Principal field's value.
func (s *BatchIsAuthorizedWithTokenOutput) SetPrincipal(v *EntityIdentifier) *BatchIsAuthorizedWithTokenOutput {
	s.Principal = v
	return s
}

// SetResults sets the Results field's value.
func (s *BatchIsAuthorizedWithTokenOutput) SetResults(v []*BatchIsAuthorizedWithTokenOutputItem) *BatchIsAuthorizedWithTokenOutput {
	s.Results = v
	return s
}

// The decision, based on policy evaluation, from an individual authorization
// request in a BatchIsAuthorizedWithToken API request.
type BatchIsAuthorizedWithTokenOutputItem struct {
	_ struct{} `type:"structure"`

	// An authorization decision that indicates if the authorization request should
	// be allowed or denied.
	//
	// Decision is a required field
	Decision *string `locationName:"decision" type:"string" required:"true" enum:"Decision"`

	// The list of determining policies used to make the authorization decision.
	// For example, if there are two matching policies, where one is a forbid and
	// the other is a permit, then the forbid policy will be the determining policy.
	// In the case of multiple matching permit policies then there would be multiple
	// determining policies. In the case that no policies match, and hence the response
	// is DENY, there would be no determining policies.
	//
	// DeterminingPolicies is a required field
	DeterminingPolicies []*DeterminingPolicyItem `locationName:"determiningPolicies" type:"list" required:"true"`

	// Errors that occurred while making an authorization decision. For example,
	// a policy might reference an entity or attribute that doesn't exist in the
	// request.
	//
	// Errors is a required field
	Errors []*EvaluationErrorItem `locationName:"errors" type:"list" required:"true"`

	// The authorization request that initiated the decision.
	//
	// Request is a required field
	Request *BatchIsAuthorizedWithTokenInputItem `locationName:"request" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedWithTokenOutputItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchIsAuthorizedWithTokenOutputItem) GoString() string {
	return s.String()
}

// SetDecision sets the Decision field's value.
func (s *BatchIsAuthorizedWithTokenOutputItem) SetDecision(v string) *BatchIsAuthorizedWithTokenOutputItem {
	s.Decision = &v
	return s
}

// SetDeterminingPolicies sets the DeterminingPolicies field's value.
func (s *BatchIsAuthorizedWithTokenOutputItem) SetDeterminingPolicies(v []*DeterminingPolicyItem) *BatchIsAuthorizedWithTokenOutputItem {
	s.DeterminingPolicies = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchIsAuthorizedWithTokenOutputItem) SetErrors(v []*EvaluationErrorItem) *BatchIsAuthorizedWithTokenOutputItem {
	s.Errors = v
	return s
}

// SetRequest sets the Request field's value.
func (s *BatchIsAuthorizedWithTokenOutputItem) SetRequest(v *BatchIsAuthorizedWithTokenInputItem) *BatchIsAuthorizedWithTokenOutputItem {
	s.Request = v
	return s
}

// The type of entity that a policy store maps to groups from an Amazon Cognito
// user pool identity source.
//
// This data type is part of a CognitoUserPoolConfiguration (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CognitoUserPoolConfiguration.html)
// structure and is a request parameter in CreateIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html).
type CognitoGroupConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the schema entity type that's mapped to the user pool group.
	// Defaults to AWS::CognitoGroup.
	//
	// GroupEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CognitoGroupConfiguration's
	// String and GoString methods.
	//
	// GroupEntityType is a required field
	GroupEntityType *string `locationName:"groupEntityType" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoGroupConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoGroupConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoGroupConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CognitoGroupConfiguration"}
	if s.GroupEntityType == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupEntityType"))
	}
	if s.GroupEntityType != nil && len(*s.GroupEntityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupEntityType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupEntityType sets the GroupEntityType field's value.
func (s *CognitoGroupConfiguration) SetGroupEntityType(v string) *CognitoGroupConfiguration {
	s.GroupEntityType = &v
	return s
}

// The type of entity that a policy store maps to groups from an Amazon Cognito
// user pool identity source.
//
// This data type is part of an CognitoUserPoolConfigurationDetail (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CognitoUserPoolConfigurationItem.html)
// structure and is a response parameter to GetIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html).
type CognitoGroupConfigurationDetail struct {
	_ struct{} `type:"structure"`

	// The name of the schema entity type that's mapped to the user pool group.
	// Defaults to AWS::CognitoGroup.
	//
	// GroupEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CognitoGroupConfigurationDetail's
	// String and GoString methods.
	GroupEntityType *string `locationName:"groupEntityType" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoGroupConfigurationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoGroupConfigurationDetail) GoString() string {
	return s.String()
}

// SetGroupEntityType sets the GroupEntityType field's value.
func (s *CognitoGroupConfigurationDetail) SetGroupEntityType(v string) *CognitoGroupConfigurationDetail {
	s.GroupEntityType = &v
	return s
}

// The type of entity that a policy store maps to groups from an Amazon Cognito
// user pool identity source.
//
// This data type is part of an CognitoUserPoolConfigurationItem (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CognitoUserPoolConfigurationDetail.html)
// structure and is a response parameter to ListIdentitySources (http://forums.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html).
type CognitoGroupConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The name of the schema entity type that's mapped to the user pool group.
	// Defaults to AWS::CognitoGroup.
	//
	// GroupEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CognitoGroupConfigurationItem's
	// String and GoString methods.
	GroupEntityType *string `locationName:"groupEntityType" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoGroupConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoGroupConfigurationItem) GoString() string {
	return s.String()
}

// SetGroupEntityType sets the GroupEntityType field's value.
func (s *CognitoGroupConfigurationItem) SetGroupEntityType(v string) *CognitoGroupConfigurationItem {
	s.GroupEntityType = &v
	return s
}

// The configuration for an identity source that represents a connection to
// an Amazon Cognito user pool used as an identity provider for Verified Permissions.
//
// This data type part of a Configuration (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_Configuration.html)
// structure that is used as a parameter to CreateIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html).
//
// Example:"CognitoUserPoolConfiguration":{"UserPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","ClientIds":
// ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType":
// "MyCorp::Group"}}
type CognitoUserPoolConfiguration struct {
	_ struct{} `type:"structure"`

	// The unique application client IDs that are associated with the specified
	// Amazon Cognito user pool.
	//
	// Example: "ClientIds": ["&ExampleCogClientId;"]
	ClientIds []*string `locationName:"clientIds" type:"list"`

	// The type of entity that a policy store maps to groups from an Amazon Cognito
	// user pool identity source.
	GroupConfiguration *CognitoGroupConfiguration `locationName:"groupConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the Amazon Cognito user pool that contains the identities to be authorized.
	//
	// Example: "UserPoolArn": "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"
	//
	// UserPoolArn is a required field
	UserPoolArn *string `locationName:"userPoolArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoUserPoolConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoUserPoolConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoUserPoolConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CognitoUserPoolConfiguration"}
	if s.UserPoolArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolArn"))
	}
	if s.UserPoolArn != nil && len(*s.UserPoolArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolArn", 1))
	}
	if s.GroupConfiguration != nil {
		if err := s.GroupConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GroupConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientIds sets the ClientIds field's value.
func (s *CognitoUserPoolConfiguration) SetClientIds(v []*string) *CognitoUserPoolConfiguration {
	s.ClientIds = v
	return s
}

// SetGroupConfiguration sets the GroupConfiguration field's value.
func (s *CognitoUserPoolConfiguration) SetGroupConfiguration(v *CognitoGroupConfiguration) *CognitoUserPoolConfiguration {
	s.GroupConfiguration = v
	return s
}

// SetUserPoolArn sets the UserPoolArn field's value.
func (s *CognitoUserPoolConfiguration) SetUserPoolArn(v string) *CognitoUserPoolConfiguration {
	s.UserPoolArn = &v
	return s
}

// The configuration for an identity source that represents a connection to
// an Amazon Cognito user pool used as an identity provider for Verified Permissions.
//
// This data type is used as a field that is part of an ConfigurationDetail
// (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html)
// structure that is part of the response to GetIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html).
//
// Example:"CognitoUserPoolConfiguration":{"UserPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","ClientIds":
// ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType":
// "MyCorp::Group"}}
type CognitoUserPoolConfigurationDetail struct {
	_ struct{} `type:"structure"`

	// The unique application client IDs that are associated with the specified
	// Amazon Cognito user pool.
	//
	// Example: "clientIds": ["&ExampleCogClientId;"]
	//
	// ClientIds is a required field
	ClientIds []*string `locationName:"clientIds" type:"list" required:"true"`

	// The type of entity that a policy store maps to groups from an Amazon Cognito
	// user pool identity source.
	GroupConfiguration *CognitoGroupConfigurationDetail `locationName:"groupConfiguration" type:"structure"`

	// The OpenID Connect (OIDC) issuer ID of the Amazon Cognito user pool that
	// contains the identities to be authorized.
	//
	// Example: "issuer": "https://cognito-idp.us-east-1.amazonaws.com/us-east-1_1a2b3c4d5"
	//
	// Issuer is a required field
	Issuer *string `locationName:"issuer" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the Amazon Cognito user pool that contains the identities to be authorized.
	//
	// Example: "userPoolArn": "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"
	//
	// UserPoolArn is a required field
	UserPoolArn *string `locationName:"userPoolArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoUserPoolConfigurationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoUserPoolConfigurationDetail) GoString() string {
	return s.String()
}

// SetClientIds sets the ClientIds field's value.
func (s *CognitoUserPoolConfigurationDetail) SetClientIds(v []*string) *CognitoUserPoolConfigurationDetail {
	s.ClientIds = v
	return s
}

// SetGroupConfiguration sets the GroupConfiguration field's value.
func (s *CognitoUserPoolConfigurationDetail) SetGroupConfiguration(v *CognitoGroupConfigurationDetail) *CognitoUserPoolConfigurationDetail {
	s.GroupConfiguration = v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *CognitoUserPoolConfigurationDetail) SetIssuer(v string) *CognitoUserPoolConfigurationDetail {
	s.Issuer = &v
	return s
}

// SetUserPoolArn sets the UserPoolArn field's value.
func (s *CognitoUserPoolConfigurationDetail) SetUserPoolArn(v string) *CognitoUserPoolConfigurationDetail {
	s.UserPoolArn = &v
	return s
}

// The configuration for an identity source that represents a connection to
// an Amazon Cognito user pool used as an identity provider for Verified Permissions.
//
// This data type is used as a field that is part of the ConfigurationItem (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationItem.html)
// structure that is part of the response to ListIdentitySources (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html).
//
// Example:"CognitoUserPoolConfiguration":{"UserPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","ClientIds":
// ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType":
// "MyCorp::Group"}}
type CognitoUserPoolConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The unique application client IDs that are associated with the specified
	// Amazon Cognito user pool.
	//
	// Example: "clientIds": ["&ExampleCogClientId;"]
	//
	// ClientIds is a required field
	ClientIds []*string `locationName:"clientIds" type:"list" required:"true"`

	// The type of entity that a policy store maps to groups from an Amazon Cognito
	// user pool identity source.
	GroupConfiguration *CognitoGroupConfigurationItem `locationName:"groupConfiguration" type:"structure"`

	// The OpenID Connect (OIDC) issuer ID of the Amazon Cognito user pool that
	// contains the identities to be authorized.
	//
	// Example: "issuer": "https://cognito-idp.us-east-1.amazonaws.com/us-east-1_1a2b3c4d5"
	//
	// Issuer is a required field
	Issuer *string `locationName:"issuer" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the Amazon Cognito user pool that contains the identities to be authorized.
	//
	// Example: "userPoolArn": "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"
	//
	// UserPoolArn is a required field
	UserPoolArn *string `locationName:"userPoolArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoUserPoolConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoUserPoolConfigurationItem) GoString() string {
	return s.String()
}

// SetClientIds sets the ClientIds field's value.
func (s *CognitoUserPoolConfigurationItem) SetClientIds(v []*string) *CognitoUserPoolConfigurationItem {
	s.ClientIds = v
	return s
}

// SetGroupConfiguration sets the GroupConfiguration field's value.
func (s *CognitoUserPoolConfigurationItem) SetGroupConfiguration(v *CognitoGroupConfigurationItem) *CognitoUserPoolConfigurationItem {
	s.GroupConfiguration = v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *CognitoUserPoolConfigurationItem) SetIssuer(v string) *CognitoUserPoolConfigurationItem {
	s.Issuer = &v
	return s
}

// SetUserPoolArn sets the UserPoolArn field's value.
func (s *CognitoUserPoolConfigurationItem) SetUserPoolArn(v string) *CognitoUserPoolConfigurationItem {
	s.UserPoolArn = &v
	return s
}

// Contains configuration information used when creating a new identity source.
//
// This data type is used as a request parameter for the CreateIdentitySource
// (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html)
// operation.
type Configuration struct {
	_ struct{} `type:"structure"`

	// Contains configuration details of a Amazon Cognito user pool that Verified
	// Permissions can use as a source of authenticated identities as entities.
	// It specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of a Amazon Cognito user pool and one or more application client IDs.
	//
	// Example: "configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds":
	// ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType":
	// "MyCorp::Group"}}}
	CognitoUserPoolConfiguration *CognitoUserPoolConfiguration `locationName:"cognitoUserPoolConfiguration" type:"structure"`

	// Contains configuration details of an OpenID Connect (OIDC) identity provider,
	// or identity source, that Verified Permissions can use to generate entities
	// from authenticated identities. It specifies the issuer URL, token type that
	// you want to use, and policy store entity details.
	//
	// Example:"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}
	OpenIdConnectConfiguration *OpenIdConnectConfiguration `locationName:"openIdConnectConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Configuration"}
	if s.CognitoUserPoolConfiguration != nil {
		if err := s.CognitoUserPoolConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CognitoUserPoolConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OpenIdConnectConfiguration != nil {
		if err := s.OpenIdConnectConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OpenIdConnectConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCognitoUserPoolConfiguration sets the CognitoUserPoolConfiguration field's value.
func (s *Configuration) SetCognitoUserPoolConfiguration(v *CognitoUserPoolConfiguration) *Configuration {
	s.CognitoUserPoolConfiguration = v
	return s
}

// SetOpenIdConnectConfiguration sets the OpenIdConnectConfiguration field's value.
func (s *Configuration) SetOpenIdConnectConfiguration(v *OpenIdConnectConfiguration) *Configuration {
	s.OpenIdConnectConfiguration = v
	return s
}

// Contains configuration information about an identity source.
//
// This data type is a response parameter to the GetIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html)
// operation.
type ConfigurationDetail struct {
	_ struct{} `type:"structure"`

	// Contains configuration details of a Amazon Cognito user pool that Verified
	// Permissions can use as a source of authenticated identities as entities.
	// It specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of a Amazon Cognito user pool, the policy store entity that you want to assign
	// to user groups, and one or more application client IDs.
	//
	// Example: "configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds":
	// ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType":
	// "MyCorp::Group"}}}
	CognitoUserPoolConfiguration *CognitoUserPoolConfigurationDetail `locationName:"cognitoUserPoolConfiguration" type:"structure"`

	// Contains configuration details of an OpenID Connect (OIDC) identity provider,
	// or identity source, that Verified Permissions can use to generate entities
	// from authenticated identities. It specifies the issuer URL, token type that
	// you want to use, and policy store entity details.
	//
	// Example:"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}
	OpenIdConnectConfiguration *OpenIdConnectConfigurationDetail `locationName:"openIdConnectConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationDetail) GoString() string {
	return s.String()
}

// SetCognitoUserPoolConfiguration sets the CognitoUserPoolConfiguration field's value.
func (s *ConfigurationDetail) SetCognitoUserPoolConfiguration(v *CognitoUserPoolConfigurationDetail) *ConfigurationDetail {
	s.CognitoUserPoolConfiguration = v
	return s
}

// SetOpenIdConnectConfiguration sets the OpenIdConnectConfiguration field's value.
func (s *ConfigurationDetail) SetOpenIdConnectConfiguration(v *OpenIdConnectConfigurationDetail) *ConfigurationDetail {
	s.OpenIdConnectConfiguration = v
	return s
}

// Contains configuration information about an identity source.
//
// This data type is a response parameter to the ListIdentitySources (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html)
// operation.
type ConfigurationItem struct {
	_ struct{} `type:"structure"`

	// Contains configuration details of a Amazon Cognito user pool that Verified
	// Permissions can use as a source of authenticated identities as entities.
	// It specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of a Amazon Cognito user pool, the policy store entity that you want to assign
	// to user groups, and one or more application client IDs.
	//
	// Example: "configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds":
	// ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType":
	// "MyCorp::Group"}}}
	CognitoUserPoolConfiguration *CognitoUserPoolConfigurationItem `locationName:"cognitoUserPoolConfiguration" type:"structure"`

	// Contains configuration details of an OpenID Connect (OIDC) identity provider,
	// or identity source, that Verified Permissions can use to generate entities
	// from authenticated identities. It specifies the issuer URL, token type that
	// you want to use, and policy store entity details.
	//
	// Example:"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}
	OpenIdConnectConfiguration *OpenIdConnectConfigurationItem `locationName:"openIdConnectConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationItem) GoString() string {
	return s.String()
}

// SetCognitoUserPoolConfiguration sets the CognitoUserPoolConfiguration field's value.
func (s *ConfigurationItem) SetCognitoUserPoolConfiguration(v *CognitoUserPoolConfigurationItem) *ConfigurationItem {
	s.CognitoUserPoolConfiguration = v
	return s
}

// SetOpenIdConnectConfiguration sets the OpenIdConnectConfiguration field's value.
func (s *ConfigurationItem) SetOpenIdConnectConfiguration(v *OpenIdConnectConfigurationItem) *ConfigurationItem {
	s.OpenIdConnectConfiguration = v
	return s
}

// The request failed because another request to modify a resource occurred
// at the same.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The list of resources referenced with this failed request.
	//
	// Resources is a required field
	Resources []*ResourceConflict `locationName:"resources" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains additional details about the context of the request. Verified Permissions
// evaluates this information in an authorization request as part of the when
// and unless clauses in a policy.
//
// This data type is used as a request parameter for the IsAuthorized (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html),
// BatchIsAuthorized (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html),
// and IsAuthorizedWithToken (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html)
// operations.
//
// Example: "context":{"contextMap":{"<KeyName1>":{"boolean":true},"<KeyName2>":{"long":1234}}}
type ContextDefinition struct {
	_ struct{} `type:"structure"`

	// An list of attributes that are needed to successfully evaluate an authorization
	// request. Each attribute in this array must include a map of a data type and
	// its value.
	//
	// Example: "contextMap":{"<KeyName1>":{"boolean":true},"<KeyName2>":{"long":1234}}
	//
	// ContextMap is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ContextDefinition's
	// String and GoString methods.
	ContextMap map[string]*AttributeValue `locationName:"contextMap" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContextDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContextDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContextDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContextDefinition"}
	if s.ContextMap != nil {
		for i, v := range s.ContextMap {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContextMap", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContextMap sets the ContextMap field's value.
func (s *ContextDefinition) SetContextMap(v map[string]*AttributeValue) *ContextDefinition {
	s.ContextMap = v
	return s
}

type CreateIdentitySourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive ID that you provide to ensure the idempotency
	// of the request. This lets you safely retry the request without accidentally
	// performing the same operation a second time. Passing the same value to a
	// later call to an operation requires that you also pass the same value for
	// all other parameters. We recommend that you use a UUID type of value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an ConflictException error.
	//
	// Verified Permissions recognizes a ClientToken for eight hours. After eight
	// hours, the next request with the same parameters performs the operation again
	// regardless of the value of ClientToken.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Specifies the details required to communicate with the identity provider
	// (IdP) associated with this identity source.
	//
	// Configuration is a required field
	Configuration *Configuration `locationName:"configuration" type:"structure" required:"true"`

	// Specifies the ID of the policy store in which you want to store this identity
	// source. Only policies and requests made using this policy store can reference
	// identities from the identity provider configured in the new identity source.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// Specifies the namespace and data type of the principals generated for identities
	// authenticated by the new identity source.
	//
	// PrincipalEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateIdentitySourceInput's
	// String and GoString methods.
	PrincipalEntityType *string `locationName:"principalEntityType" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdentitySourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdentitySourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIdentitySourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIdentitySourceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.PrincipalEntityType != nil && len(*s.PrincipalEntityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalEntityType", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateIdentitySourceInput) SetClientToken(v string) *CreateIdentitySourceInput {
	s.ClientToken = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateIdentitySourceInput) SetConfiguration(v *Configuration) *CreateIdentitySourceInput {
	s.Configuration = v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *CreateIdentitySourceInput) SetPolicyStoreId(v string) *CreateIdentitySourceInput {
	s.PolicyStoreId = &v
	return s
}

// SetPrincipalEntityType sets the PrincipalEntityType field's value.
func (s *CreateIdentitySourceInput) SetPrincipalEntityType(v string) *CreateIdentitySourceInput {
	s.PrincipalEntityType = &v
	return s
}

type CreateIdentitySourceOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the identity source was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique ID of the new identity source.
	//
	// IdentitySourceId is a required field
	IdentitySourceId *string `locationName:"identitySourceId" min:"1" type:"string" required:"true"`

	// The date and time the identity source was most recently updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ID of the policy store that contains the identity source.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdentitySourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdentitySourceOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CreateIdentitySourceOutput) SetCreatedDate(v time.Time) *CreateIdentitySourceOutput {
	s.CreatedDate = &v
	return s
}

// SetIdentitySourceId sets the IdentitySourceId field's value.
func (s *CreateIdentitySourceOutput) SetIdentitySourceId(v string) *CreateIdentitySourceOutput {
	s.IdentitySourceId = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *CreateIdentitySourceOutput) SetLastUpdatedDate(v time.Time) *CreateIdentitySourceOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *CreateIdentitySourceOutput) SetPolicyStoreId(v string) *CreateIdentitySourceOutput {
	s.PolicyStoreId = &v
	return s
}

type CreatePolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive ID that you provide to ensure the idempotency
	// of the request. This lets you safely retry the request without accidentally
	// performing the same operation a second time. Passing the same value to a
	// later call to an operation requires that you also pass the same value for
	// all other parameters. We recommend that you use a UUID type of value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an ConflictException error.
	//
	// Verified Permissions recognizes a ClientToken for eight hours. After eight
	// hours, the next request with the same parameters performs the operation again
	// regardless of the value of ClientToken.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A structure that specifies the policy type and content to use for the new
	// policy. You must include either a static or a templateLinked element. The
	// policy content must be written in the Cedar policy language.
	//
	// Definition is a required field
	Definition *PolicyDefinition `locationName:"definition" type:"structure" required:"true"`

	// Specifies the PolicyStoreId of the policy store you want to store the policy
	// in.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePolicyInput) SetClientToken(v string) *CreatePolicyInput {
	s.ClientToken = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *CreatePolicyInput) SetDefinition(v *PolicyDefinition) *CreatePolicyInput {
	s.Definition = v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *CreatePolicyInput) SetPolicyStoreId(v string) *CreatePolicyInput {
	s.PolicyStoreId = &v
	return s
}

type CreatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The action that a policy permits or forbids. For example, {"actions": [{"actionId":
	// "ViewPhoto", "actionType": "PhotoFlash::Action"}, {"entityID": "SharePhoto",
	// "entityType": "PhotoFlash::Action"}]}.
	Actions []*ActionIdentifier `locationName:"actions" type:"list"`

	// The date and time the policy was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The effect of the decision that a policy returns to an authorization request.
	// For example, "effect": "Permit".
	Effect *string `locationName:"effect" type:"string" enum:"PolicyEffect"`

	// The date and time the policy was last updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique ID of the new policy.
	//
	// PolicyId is a required field
	PolicyId *string `locationName:"policyId" min:"1" type:"string" required:"true"`

	// The ID of the policy store that contains the new policy.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// The policy type of the new policy.
	//
	// PolicyType is a required field
	PolicyType *string `locationName:"policyType" type:"string" required:"true" enum:"PolicyType"`

	// The principal specified in the new policy's scope. This response element
	// isn't present when principal isn't specified in the policy content.
	Principal *EntityIdentifier `locationName:"principal" type:"structure"`

	// The resource specified in the new policy's scope. This response element isn't
	// present when the resource isn't specified in the policy content.
	Resource *EntityIdentifier `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePolicyOutput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *CreatePolicyOutput) SetActions(v []*ActionIdentifier) *CreatePolicyOutput {
	s.Actions = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CreatePolicyOutput) SetCreatedDate(v time.Time) *CreatePolicyOutput {
	s.CreatedDate = &v
	return s
}

// SetEffect sets the Effect field's value.
func (s *CreatePolicyOutput) SetEffect(v string) *CreatePolicyOutput {
	s.Effect = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *CreatePolicyOutput) SetLastUpdatedDate(v time.Time) *CreatePolicyOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *CreatePolicyOutput) SetPolicyId(v string) *CreatePolicyOutput {
	s.PolicyId = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *CreatePolicyOutput) SetPolicyStoreId(v string) *CreatePolicyOutput {
	s.PolicyStoreId = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *CreatePolicyOutput) SetPolicyType(v string) *CreatePolicyOutput {
	s.PolicyType = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *CreatePolicyOutput) SetPrincipal(v *EntityIdentifier) *CreatePolicyOutput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *CreatePolicyOutput) SetResource(v *EntityIdentifier) *CreatePolicyOutput {
	s.Resource = v
	return s
}

type CreatePolicyStoreInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive ID that you provide to ensure the idempotency
	// of the request. This lets you safely retry the request without accidentally
	// performing the same operation a second time. Passing the same value to a
	// later call to an operation requires that you also pass the same value for
	// all other parameters. We recommend that you use a UUID type of value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an ConflictException error.
	//
	// Verified Permissions recognizes a ClientToken for eight hours. After eight
	// hours, the next request with the same parameters performs the operation again
	// regardless of the value of ClientToken.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Descriptive text that you can provide to help with identification of the
	// current policy store.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePolicyStoreInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// Specifies the validation setting for this policy store.
	//
	// Currently, the only valid and required value is Mode.
	//
	// We recommend that you turn on STRICT mode only after you define a schema.
	// If a schema doesn't exist, then STRICT mode causes any policy to fail validation,
	// and Verified Permissions rejects the policy. You can turn off validation
	// by using the UpdatePolicyStore (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore).
	// Then, when you have a schema defined, use UpdatePolicyStore (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore)
	// again to turn validation back on.
	//
	// ValidationSettings is a required field
	ValidationSettings *ValidationSettings `locationName:"validationSettings" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePolicyStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePolicyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyStoreInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ValidationSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationSettings"))
	}
	if s.ValidationSettings != nil {
		if err := s.ValidationSettings.Validate(); err != nil {
			invalidParams.AddNested("ValidationSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePolicyStoreInput) SetClientToken(v string) *CreatePolicyStoreInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePolicyStoreInput) SetDescription(v string) *CreatePolicyStoreInput {
	s.Description = &v
	return s
}

// SetValidationSettings sets the ValidationSettings field's value.
func (s *CreatePolicyStoreInput) SetValidationSettings(v *ValidationSettings) *CreatePolicyStoreInput {
	s.ValidationSettings = v
	return s
}

type CreatePolicyStoreOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new policy store.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The date and time the policy store was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date and time the policy store was last updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique ID of the new policy store.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePolicyStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePolicyStoreOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreatePolicyStoreOutput) SetArn(v string) *CreatePolicyStoreOutput {
	s.Arn = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CreatePolicyStoreOutput) SetCreatedDate(v time.Time) *CreatePolicyStoreOutput {
	s.CreatedDate = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *CreatePolicyStoreOutput) SetLastUpdatedDate(v time.Time) *CreatePolicyStoreOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *CreatePolicyStoreOutput) SetPolicyStoreId(v string) *CreatePolicyStoreOutput {
	s.PolicyStoreId = &v
	return s
}

type CreatePolicyTemplateInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive ID that you provide to ensure the idempotency
	// of the request. This lets you safely retry the request without accidentally
	// performing the same operation a second time. Passing the same value to a
	// later call to an operation requires that you also pass the same value for
	// all other parameters. We recommend that you use a UUID type of value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an ConflictException error.
	//
	// Verified Permissions recognizes a ClientToken for eight hours. After eight
	// hours, the next request with the same parameters performs the operation again
	// regardless of the value of ClientToken.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Specifies a description for the policy template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePolicyTemplateInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the policy store in which to create the policy template.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// Specifies the content that you want to use for the new policy template, written
	// in the Cedar policy language.
	//
	// Statement is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePolicyTemplateInput's
	// String and GoString methods.
	//
	// Statement is a required field
	Statement *string `locationName:"statement" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePolicyTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePolicyTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyTemplateInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.Statement == nil {
		invalidParams.Add(request.NewErrParamRequired("Statement"))
	}
	if s.Statement != nil && len(*s.Statement) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statement", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePolicyTemplateInput) SetClientToken(v string) *CreatePolicyTemplateInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePolicyTemplateInput) SetDescription(v string) *CreatePolicyTemplateInput {
	s.Description = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *CreatePolicyTemplateInput) SetPolicyStoreId(v string) *CreatePolicyTemplateInput {
	s.PolicyStoreId = &v
	return s
}

// SetStatement sets the Statement field's value.
func (s *CreatePolicyTemplateInput) SetStatement(v string) *CreatePolicyTemplateInput {
	s.Statement = &v
	return s
}

type CreatePolicyTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the policy template was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date and time the policy template was most recently updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ID of the policy store that contains the policy template.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// The unique ID of the new policy template.
	//
	// PolicyTemplateId is a required field
	PolicyTemplateId *string `locationName:"policyTemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePolicyTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePolicyTemplateOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CreatePolicyTemplateOutput) SetCreatedDate(v time.Time) *CreatePolicyTemplateOutput {
	s.CreatedDate = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *CreatePolicyTemplateOutput) SetLastUpdatedDate(v time.Time) *CreatePolicyTemplateOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *CreatePolicyTemplateOutput) SetPolicyStoreId(v string) *CreatePolicyTemplateOutput {
	s.PolicyStoreId = &v
	return s
}

// SetPolicyTemplateId sets the PolicyTemplateId field's value.
func (s *CreatePolicyTemplateOutput) SetPolicyTemplateId(v string) *CreatePolicyTemplateOutput {
	s.PolicyTemplateId = &v
	return s
}

type DeleteIdentitySourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the identity source that you want to delete.
	//
	// IdentitySourceId is a required field
	IdentitySourceId *string `locationName:"identitySourceId" min:"1" type:"string" required:"true"`

	// Specifies the ID of the policy store that contains the identity source that
	// you want to delete.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentitySourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentitySourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdentitySourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdentitySourceInput"}
	if s.IdentitySourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentitySourceId"))
	}
	if s.IdentitySourceId != nil && len(*s.IdentitySourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentitySourceId", 1))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentitySourceId sets the IdentitySourceId field's value.
func (s *DeleteIdentitySourceInput) SetIdentitySourceId(v string) *DeleteIdentitySourceInput {
	s.IdentitySourceId = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *DeleteIdentitySourceInput) SetPolicyStoreId(v string) *DeleteIdentitySourceInput {
	s.PolicyStoreId = &v
	return s
}

type DeleteIdentitySourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentitySourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentitySourceOutput) GoString() string {
	return s.String()
}

type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the policy that you want to delete.
	//
	// PolicyId is a required field
	PolicyId *string `locationName:"policyId" min:"1" type:"string" required:"true"`

	// Specifies the ID of the policy store that contains the policy that you want
	// to delete.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 1))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *DeletePolicyInput) SetPolicyId(v string) *DeletePolicyInput {
	s.PolicyId = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *DeletePolicyInput) SetPolicyStoreId(v string) *DeletePolicyInput {
	s.PolicyStoreId = &v
	return s
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

type DeletePolicyStoreInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the policy store that you want to delete.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyStoreInput"}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *DeletePolicyStoreInput) SetPolicyStoreId(v string) *DeletePolicyStoreInput {
	s.PolicyStoreId = &v
	return s
}

type DeletePolicyStoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyStoreOutput) GoString() string {
	return s.String()
}

type DeletePolicyTemplateInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the policy store that contains the policy template that
	// you want to delete.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// Specifies the ID of the policy template that you want to delete.
	//
	// PolicyTemplateId is a required field
	PolicyTemplateId *string `locationName:"policyTemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyTemplateInput"}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.PolicyTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyTemplateId"))
	}
	if s.PolicyTemplateId != nil && len(*s.PolicyTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyTemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *DeletePolicyTemplateInput) SetPolicyStoreId(v string) *DeletePolicyTemplateInput {
	s.PolicyStoreId = &v
	return s
}

// SetPolicyTemplateId sets the PolicyTemplateId field's value.
func (s *DeletePolicyTemplateInput) SetPolicyTemplateId(v string) *DeletePolicyTemplateInput {
	s.PolicyTemplateId = &v
	return s
}

type DeletePolicyTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyTemplateOutput) GoString() string {
	return s.String()
}

// Contains information about one of the policies that determined an authorization
// decision.
//
// This data type is used as an element in a response parameter for the IsAuthorized
// (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html),
// BatchIsAuthorized (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html),
// and IsAuthorizedWithToken (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html)
// operations.
//
// Example: "determiningPolicies":[{"policyId":"SPEXAMPLEabcdefg111111"}]
type DeterminingPolicyItem struct {
	_ struct{} `type:"structure"`

	// The Id of a policy that determined to an authorization decision.
	//
	// Example: "policyId":"SPEXAMPLEabcdefg111111"
	//
	// PolicyId is a required field
	PolicyId *string `locationName:"policyId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeterminingPolicyItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeterminingPolicyItem) GoString() string {
	return s.String()
}

// SetPolicyId sets the PolicyId field's value.
func (s *DeterminingPolicyItem) SetPolicyId(v string) *DeterminingPolicyItem {
	s.PolicyId = &v
	return s
}

// Contains the list of entities to be considered during an authorization request.
// This includes all principals, resources, and actions required to successfully
// evaluate the request.
//
// This data type is used as a field in the response parameter for the IsAuthorized
// (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html)
// and IsAuthorizedWithToken (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html)
// operations.
type EntitiesDefinition struct {
	_ struct{} `type:"structure"`

	// An array of entities that are needed to successfully evaluate an authorization
	// request. Each entity in this array must include an identifier for the entity,
	// the attributes of the entity, and a list of any parent entities.
	EntityList []*EntityItem `locationName:"entityList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntitiesDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntitiesDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntitiesDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntitiesDefinition"}
	if s.EntityList != nil {
		for i, v := range s.EntityList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EntityList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityList sets the EntityList field's value.
func (s *EntitiesDefinition) SetEntityList(v []*EntityItem) *EntitiesDefinition {
	s.EntityList = v
	return s
}

// Contains the identifier of an entity, including its ID and type.
//
// This data type is used as a request parameter for IsAuthorized (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html)
// operation, and as a response parameter for the CreatePolicy (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html),
// GetPolicy (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetPolicy.html),
// and UpdatePolicy (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicy.html)
// operations.
//
// Example: {"entityId":"string","entityType":"string"}
type EntityIdentifier struct {
	_ struct{} `type:"structure"`

	// The identifier of an entity.
	//
	// "entityId":"identifier"
	//
	// EntityId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EntityIdentifier's
	// String and GoString methods.
	//
	// EntityId is a required field
	EntityId *string `locationName:"entityId" min:"1" type:"string" required:"true" sensitive:"true"`

	// The type of an entity.
	//
	// Example: "entityType":"typeName"
	//
	// EntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EntityIdentifier's
	// String and GoString methods.
	//
	// EntityType is a required field
	EntityType *string `locationName:"entityType" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityIdentifier"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}
	if s.EntityType == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityType"))
	}
	if s.EntityType != nil && len(*s.EntityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *EntityIdentifier) SetEntityId(v string) *EntityIdentifier {
	s.EntityId = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *EntityIdentifier) SetEntityType(v string) *EntityIdentifier {
	s.EntityType = &v
	return s
}

// Contains information about an entity that can be referenced in a Cedar policy.
//
// This data type is used as one of the fields in the EntitiesDefinition (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntitiesDefinition.html)
// structure.
//
// { "identifier": { "entityType": "Photo", "entityId": "VacationPhoto94.jpg"
// }, "attributes": {}, "parents": [ { "entityType": "Album", "entityId": "alice_folder"
// } ] }
type EntityItem struct {
	_ struct{} `type:"structure"`

	// A list of attributes for the entity.
	Attributes map[string]*AttributeValue `locationName:"attributes" type:"map"`

	// The identifier of the entity.
	//
	// Identifier is a required field
	Identifier *EntityIdentifier `locationName:"identifier" type:"structure" required:"true"`

	// The parent entities in the hierarchy that contains the entity. A principal
	// or resource entity can be defined with at most 99 transitive parents per
	// authorization request.
	//
	// A transitive parent is an entity in the hierarchy of entities including all
	// direct parents, and parents of parents. For example, a user can be a member
	// of 91 groups if one of those groups is a member of eight groups, for a total
	// of 100: one entity, 91 entity parents, and eight parents of parents.
	Parents []*EntityIdentifier `locationName:"parents" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityItem"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Identifier != nil {
		if err := s.Identifier.Validate(); err != nil {
			invalidParams.AddNested("Identifier", err.(request.ErrInvalidParams))
		}
	}
	if s.Parents != nil {
		for i, v := range s.Parents {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parents", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *EntityItem) SetAttributes(v map[string]*AttributeValue) *EntityItem {
	s.Attributes = v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *EntityItem) SetIdentifier(v *EntityIdentifier) *EntityItem {
	s.Identifier = v
	return s
}

// SetParents sets the Parents field's value.
func (s *EntityItem) SetParents(v []*EntityIdentifier) *EntityItem {
	s.Parents = v
	return s
}

// Contains information about a principal or resource that can be referenced
// in a Cedar policy.
//
// This data type is used as part of the PolicyFilter (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyFilter.html)
// structure that is used as a request parameter for the ListPolicies (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html)
// operation..
type EntityReference struct {
	_ struct{} `type:"structure"`

	// The identifier of the entity. It can consist of either an EntityType and
	// EntityId, a principal, or a resource.
	Identifier *EntityIdentifier `locationName:"identifier" type:"structure"`

	// Used to indicate that a principal or resource is not specified. This can
	// be used to search for policies that are not associated with a specific principal
	// or resource.
	Unspecified *bool `locationName:"unspecified" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityReference"}
	if s.Identifier != nil {
		if err := s.Identifier.Validate(); err != nil {
			invalidParams.AddNested("Identifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *EntityReference) SetIdentifier(v *EntityIdentifier) *EntityReference {
	s.Identifier = v
	return s
}

// SetUnspecified sets the Unspecified field's value.
func (s *EntityReference) SetUnspecified(v bool) *EntityReference {
	s.Unspecified = &v
	return s
}

// Contains a description of an evaluation error.
//
// This data type is a response parameter of the IsAuthorized (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html),
// BatchIsAuthorized (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html),
// and IsAuthorizedWithToken (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html)
// operations.
type EvaluationErrorItem struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The error description.
	//
	// ErrorDescription is a required field
	ErrorDescription *string `locationName:"errorDescription" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationErrorItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationErrorItem) GoString() string {
	return s.String()
}

// SetErrorDescription sets the ErrorDescription field's value.
func (s *EvaluationErrorItem) SetErrorDescription(v string) *EvaluationErrorItem {
	s.ErrorDescription = &v
	return s
}

type GetIdentitySourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the identity source you want information about.
	//
	// IdentitySourceId is a required field
	IdentitySourceId *string `locationName:"identitySourceId" min:"1" type:"string" required:"true"`

	// Specifies the ID of the policy store that contains the identity source you
	// want information about.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentitySourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentitySourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentitySourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentitySourceInput"}
	if s.IdentitySourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentitySourceId"))
	}
	if s.IdentitySourceId != nil && len(*s.IdentitySourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentitySourceId", 1))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentitySourceId sets the IdentitySourceId field's value.
func (s *GetIdentitySourceInput) SetIdentitySourceId(v string) *GetIdentitySourceInput {
	s.IdentitySourceId = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *GetIdentitySourceInput) SetPolicyStoreId(v string) *GetIdentitySourceInput {
	s.PolicyStoreId = &v
	return s
}

type GetIdentitySourceOutput struct {
	_ struct{} `type:"structure"`

	// Contains configuration information about an identity source.
	Configuration *ConfigurationDetail `locationName:"configuration" type:"structure"`

	// The date and time that the identity source was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A structure that describes the configuration of the identity source.
	//
	// Deprecated: This attribute has been replaced by configuration.cognitoUserPoolConfiguration
	Details *IdentitySourceDetails `locationName:"details" deprecated:"true" type:"structure"`

	// The ID of the identity source.
	//
	// IdentitySourceId is a required field
	IdentitySourceId *string `locationName:"identitySourceId" min:"1" type:"string" required:"true"`

	// The date and time that the identity source was most recently updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ID of the policy store that contains the identity source.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// The data type of principals generated for identities authenticated by this
	// identity source.
	//
	// PrincipalEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetIdentitySourceOutput's
	// String and GoString methods.
	//
	// PrincipalEntityType is a required field
	PrincipalEntityType *string `locationName:"principalEntityType" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentitySourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentitySourceOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *GetIdentitySourceOutput) SetConfiguration(v *ConfigurationDetail) *GetIdentitySourceOutput {
	s.Configuration = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetIdentitySourceOutput) SetCreatedDate(v time.Time) *GetIdentitySourceOutput {
	s.CreatedDate = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *GetIdentitySourceOutput) SetDetails(v *IdentitySourceDetails) *GetIdentitySourceOutput {
	s.Details = v
	return s
}

// SetIdentitySourceId sets the IdentitySourceId field's value.
func (s *GetIdentitySourceOutput) SetIdentitySourceId(v string) *GetIdentitySourceOutput {
	s.IdentitySourceId = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *GetIdentitySourceOutput) SetLastUpdatedDate(v time.Time) *GetIdentitySourceOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *GetIdentitySourceOutput) SetPolicyStoreId(v string) *GetIdentitySourceOutput {
	s.PolicyStoreId = &v
	return s
}

// SetPrincipalEntityType sets the PrincipalEntityType field's value.
func (s *GetIdentitySourceOutput) SetPrincipalEntityType(v string) *GetIdentitySourceOutput {
	s.PrincipalEntityType = &v
	return s
}

type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the policy you want information about.
	//
	// PolicyId is a required field
	PolicyId *string `locationName:"policyId" min:"1" type:"string" required:"true"`

	// Specifies the ID of the policy store that contains the policy that you want
	// information about.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 1))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *GetPolicyInput) SetPolicyId(v string) *GetPolicyInput {
	s.PolicyId = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *GetPolicyInput) SetPolicyStoreId(v string) *GetPolicyInput {
	s.PolicyStoreId = &v
	return s
}

type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The action that a policy permits or forbids. For example, {"actions": [{"actionId":
	// "ViewPhoto", "actionType": "PhotoFlash::Action"}, {"entityID": "SharePhoto",
	// "entityType": "PhotoFlash::Action"}]}.
	Actions []*ActionIdentifier `locationName:"actions" type:"list"`

	// The date and time that the policy was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The definition of the requested policy.
	//
	// Definition is a required field
	Definition *PolicyDefinitionDetail `locationName:"definition" type:"structure" required:"true"`

	// The effect of the decision that a policy returns to an authorization request.
	// For example, "effect": "Permit".
	Effect *string `locationName:"effect" type:"string" enum:"PolicyEffect"`

	// The date and time that the policy was last updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique ID of the policy that you want information about.
	//
	// PolicyId is a required field
	PolicyId *string `locationName:"policyId" min:"1" type:"string" required:"true"`

	// The ID of the policy store that contains the policy that you want information
	// about.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// The type of the policy.
	//
	// PolicyType is a required field
	PolicyType *string `locationName:"policyType" type:"string" required:"true" enum:"PolicyType"`

	// The principal specified in the policy's scope. This element isn't included
	// in the response when Principal isn't present in the policy content.
	Principal *EntityIdentifier `locationName:"principal" type:"structure"`

	// The resource specified in the policy's scope. This element isn't included
	// in the response when Resource isn't present in the policy content.
	Resource *EntityIdentifier `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *GetPolicyOutput) SetActions(v []*ActionIdentifier) *GetPolicyOutput {
	s.Actions = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetPolicyOutput) SetCreatedDate(v time.Time) *GetPolicyOutput {
	s.CreatedDate = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetPolicyOutput) SetDefinition(v *PolicyDefinitionDetail) *GetPolicyOutput {
	s.Definition = v
	return s
}

// SetEffect sets the Effect field's value.
func (s *GetPolicyOutput) SetEffect(v string) *GetPolicyOutput {
	s.Effect = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *GetPolicyOutput) SetLastUpdatedDate(v time.Time) *GetPolicyOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *GetPolicyOutput) SetPolicyId(v string) *GetPolicyOutput {
	s.PolicyId = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *GetPolicyOutput) SetPolicyStoreId(v string) *GetPolicyOutput {
	s.PolicyStoreId = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *GetPolicyOutput) SetPolicyType(v string) *GetPolicyOutput {
	s.PolicyType = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *GetPolicyOutput) SetPrincipal(v *EntityIdentifier) *GetPolicyOutput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *GetPolicyOutput) SetResource(v *EntityIdentifier) *GetPolicyOutput {
	s.Resource = v
	return s
}

type GetPolicyStoreInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the policy store that you want information about.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyStoreInput"}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *GetPolicyStoreInput) SetPolicyStoreId(v string) *GetPolicyStoreInput {
	s.PolicyStoreId = &v
	return s
}

type GetPolicyStoreOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the policy store.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The date and time that the policy store was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Descriptive text that you can provide to help with identification of the
	// current policy store.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetPolicyStoreOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The date and time that the policy store was last updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ID of the policy store;
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// The current validation settings for the policy store.
	//
	// ValidationSettings is a required field
	ValidationSettings *ValidationSettings `locationName:"validationSettings" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyStoreOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetPolicyStoreOutput) SetArn(v string) *GetPolicyStoreOutput {
	s.Arn = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetPolicyStoreOutput) SetCreatedDate(v time.Time) *GetPolicyStoreOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetPolicyStoreOutput) SetDescription(v string) *GetPolicyStoreOutput {
	s.Description = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *GetPolicyStoreOutput) SetLastUpdatedDate(v time.Time) *GetPolicyStoreOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *GetPolicyStoreOutput) SetPolicyStoreId(v string) *GetPolicyStoreOutput {
	s.PolicyStoreId = &v
	return s
}

// SetValidationSettings sets the ValidationSettings field's value.
func (s *GetPolicyStoreOutput) SetValidationSettings(v *ValidationSettings) *GetPolicyStoreOutput {
	s.ValidationSettings = v
	return s
}

type GetPolicyTemplateInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the policy store that contains the policy template that
	// you want information about.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// Specifies the ID of the policy template that you want information about.
	//
	// PolicyTemplateId is a required field
	PolicyTemplateId *string `locationName:"policyTemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyTemplateInput"}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.PolicyTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyTemplateId"))
	}
	if s.PolicyTemplateId != nil && len(*s.PolicyTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyTemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *GetPolicyTemplateInput) SetPolicyStoreId(v string) *GetPolicyTemplateInput {
	s.PolicyStoreId = &v
	return s
}

// SetPolicyTemplateId sets the PolicyTemplateId field's value.
func (s *GetPolicyTemplateInput) SetPolicyTemplateId(v string) *GetPolicyTemplateInput {
	s.PolicyTemplateId = &v
	return s
}

type GetPolicyTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the policy template was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the policy template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetPolicyTemplateOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The date and time that the policy template was most recently updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ID of the policy store that contains the policy template.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// The ID of the policy template.
	//
	// PolicyTemplateId is a required field
	PolicyTemplateId *string `locationName:"policyTemplateId" min:"1" type:"string" required:"true"`

	// The content of the body of the policy template written in the Cedar policy
	// language.
	//
	// Statement is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetPolicyTemplateOutput's
	// String and GoString methods.
	//
	// Statement is a required field
	Statement *string `locationName:"statement" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyTemplateOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetPolicyTemplateOutput) SetCreatedDate(v time.Time) *GetPolicyTemplateOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetPolicyTemplateOutput) SetDescription(v string) *GetPolicyTemplateOutput {
	s.Description = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *GetPolicyTemplateOutput) SetLastUpdatedDate(v time.Time) *GetPolicyTemplateOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *GetPolicyTemplateOutput) SetPolicyStoreId(v string) *GetPolicyTemplateOutput {
	s.PolicyStoreId = &v
	return s
}

// SetPolicyTemplateId sets the PolicyTemplateId field's value.
func (s *GetPolicyTemplateOutput) SetPolicyTemplateId(v string) *GetPolicyTemplateOutput {
	s.PolicyTemplateId = &v
	return s
}

// SetStatement sets the Statement field's value.
func (s *GetPolicyTemplateOutput) SetStatement(v string) *GetPolicyTemplateOutput {
	s.Statement = &v
	return s
}

type GetSchemaInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the policy store that contains the schema.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSchemaInput"}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *GetSchemaInput) SetPolicyStoreId(v string) *GetSchemaInput {
	s.PolicyStoreId = &v
	return s
}

type GetSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the schema was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date and time that the schema was most recently updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The namespaces of the entities referenced by this schema.
	Namespaces []*string `locationName:"namespaces" type:"list"`

	// The ID of the policy store that contains the schema.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// The body of the schema, written in Cedar schema JSON.
	//
	// Schema is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSchemaOutput's
	// String and GoString methods.
	//
	// Schema is a required field
	Schema *string `locationName:"schema" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetSchemaOutput) SetCreatedDate(v time.Time) *GetSchemaOutput {
	s.CreatedDate = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *GetSchemaOutput) SetLastUpdatedDate(v time.Time) *GetSchemaOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetNamespaces sets the Namespaces field's value.
func (s *GetSchemaOutput) SetNamespaces(v []*string) *GetSchemaOutput {
	s.Namespaces = v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *GetSchemaOutput) SetPolicyStoreId(v string) *GetSchemaOutput {
	s.PolicyStoreId = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *GetSchemaOutput) SetSchema(v string) *GetSchemaOutput {
	s.Schema = &v
	return s
}

// A structure that contains configuration of the identity source.
//
// This data type was a response parameter for the GetIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html)
// operation. Replaced by ConfigurationDetail (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html).
//
// Deprecated: This shape has been replaced by ConfigurationDetail
type IdentitySourceDetails struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The application client IDs associated with the specified Amazon Cognito user
	// pool that are enabled for this identity source.
	//
	// Deprecated: This attribute has been replaced by configuration.cognitoUserPoolConfiguration.clientIds
	ClientIds []*string `locationName:"clientIds" deprecated:"true" type:"list"`

	// The well-known URL that points to this user pool's OIDC discovery endpoint.
	// This is a URL string in the following format. This URL replaces the placeholders
	// for both the Amazon Web Services Region and the user pool identifier with
	// those appropriate for this user pool.
	//
	// https://cognito-idp.<region>.amazonaws.com/<user-pool-id>/.well-known/openid-configuration
	//
	// Deprecated: This attribute has been replaced by configuration.cognitoUserPoolConfiguration.issuer
	DiscoveryUrl *string `locationName:"discoveryUrl" min:"1" deprecated:"true" type:"string"`

	// A string that identifies the type of OIDC service represented by this identity
	// source.
	//
	// At this time, the only valid value is cognito.
	//
	// Deprecated: This attribute has been replaced by configuration
	OpenIdIssuer *string `locationName:"openIdIssuer" deprecated:"true" type:"string" enum:"OpenIdIssuer"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the Amazon Cognito user pool whose identities are accessible to this Verified
	// Permissions policy store.
	//
	// Deprecated: This attribute has been replaced by configuration.cognitoUserPoolConfiguration.userPoolArn
	UserPoolArn *string `locationName:"userPoolArn" min:"1" deprecated:"true" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentitySourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentitySourceDetails) GoString() string {
	return s.String()
}

// SetClientIds sets the ClientIds field's value.
func (s *IdentitySourceDetails) SetClientIds(v []*string) *IdentitySourceDetails {
	s.ClientIds = v
	return s
}

// SetDiscoveryUrl sets the DiscoveryUrl field's value.
func (s *IdentitySourceDetails) SetDiscoveryUrl(v string) *IdentitySourceDetails {
	s.DiscoveryUrl = &v
	return s
}

// SetOpenIdIssuer sets the OpenIdIssuer field's value.
func (s *IdentitySourceDetails) SetOpenIdIssuer(v string) *IdentitySourceDetails {
	s.OpenIdIssuer = &v
	return s
}

// SetUserPoolArn sets the UserPoolArn field's value.
func (s *IdentitySourceDetails) SetUserPoolArn(v string) *IdentitySourceDetails {
	s.UserPoolArn = &v
	return s
}

// A structure that defines characteristics of an identity source that you can
// use to filter.
//
// This data type is a request parameter for the ListIdentityStores (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentityStores.html)
// operation.
type IdentitySourceFilter struct {
	_ struct{} `type:"structure"`

	// The Cedar entity type of the principals returned by the identity provider
	// (IdP) associated with this identity source.
	//
	// PrincipalEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IdentitySourceFilter's
	// String and GoString methods.
	PrincipalEntityType *string `locationName:"principalEntityType" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentitySourceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentitySourceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdentitySourceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdentitySourceFilter"}
	if s.PrincipalEntityType != nil && len(*s.PrincipalEntityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalEntityType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipalEntityType sets the PrincipalEntityType field's value.
func (s *IdentitySourceFilter) SetPrincipalEntityType(v string) *IdentitySourceFilter {
	s.PrincipalEntityType = &v
	return s
}

// A structure that defines an identity source.
//
// This data type is a response parameter to the ListIdentitySources (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html)
// operation.
type IdentitySourceItem struct {
	_ struct{} `type:"structure"`

	// Contains configuration information about an identity source.
	Configuration *ConfigurationItem `locationName:"configuration" type:"structure"`

	// The date and time the identity source was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A structure that contains the details of the associated identity provider
	// (IdP).
	//
	// Deprecated: This attribute has been replaced by configuration.cognitoUserPoolConfiguration
	Details *IdentitySourceItemDetails `locationName:"details" deprecated:"true" type:"structure"`

	// The unique identifier of the identity source.
	//
	// IdentitySourceId is a required field
	IdentitySourceId *string `locationName:"identitySourceId" min:"1" type:"string" required:"true"`

	// The date and time the identity source was most recently updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The identifier of the policy store that contains the identity source.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// The Cedar entity type of the principals returned from the IdP associated
	// with this identity source.
	//
	// PrincipalEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IdentitySourceItem's
	// String and GoString methods.
	//
	// PrincipalEntityType is a required field
	PrincipalEntityType *string `locationName:"principalEntityType" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentitySourceItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentitySourceItem) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *IdentitySourceItem) SetConfiguration(v *ConfigurationItem) *IdentitySourceItem {
	s.Configuration = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *IdentitySourceItem) SetCreatedDate(v time.Time) *IdentitySourceItem {
	s.CreatedDate = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *IdentitySourceItem) SetDetails(v *IdentitySourceItemDetails) *IdentitySourceItem {
	s.Details = v
	return s
}

// SetIdentitySourceId sets the IdentitySourceId field's value.
func (s *IdentitySourceItem) SetIdentitySourceId(v string) *IdentitySourceItem {
	s.IdentitySourceId = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *IdentitySourceItem) SetLastUpdatedDate(v time.Time) *IdentitySourceItem {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *IdentitySourceItem) SetPolicyStoreId(v string) *IdentitySourceItem {
	s.PolicyStoreId = &v
	return s
}

// SetPrincipalEntityType sets the PrincipalEntityType field's value.
func (s *IdentitySourceItem) SetPrincipalEntityType(v string) *IdentitySourceItem {
	s.PrincipalEntityType = &v
	return s
}

// A structure that contains configuration of the identity source.
//
// This data type was a response parameter for the ListIdentitySources (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html)
// operation. Replaced by ConfigurationItem (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationItem.html).
//
// Deprecated: This shape has been replaced by ConfigurationItem
type IdentitySourceItemDetails struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The application client IDs associated with the specified Amazon Cognito user
	// pool that are enabled for this identity source.
	//
	// Deprecated: This attribute has been replaced by configuration.cognitoUserPoolConfiguration.clientIds
	ClientIds []*string `locationName:"clientIds" deprecated:"true" type:"list"`

	// The well-known URL that points to this user pool's OIDC discovery endpoint.
	// This is a URL string in the following format. This URL replaces the placeholders
	// for both the Amazon Web Services Region and the user pool identifier with
	// those appropriate for this user pool.
	//
	// https://cognito-idp.<region>.amazonaws.com/<user-pool-id>/.well-known/openid-configuration
	//
	// Deprecated: This attribute has been replaced by configuration.cognitoUserPoolConfiguration.issuer
	DiscoveryUrl *string `locationName:"discoveryUrl" min:"1" deprecated:"true" type:"string"`

	// A string that identifies the type of OIDC service represented by this identity
	// source.
	//
	// At this time, the only valid value is cognito.
	//
	// Deprecated: This attribute has been replaced by configuration
	OpenIdIssuer *string `locationName:"openIdIssuer" deprecated:"true" type:"string" enum:"OpenIdIssuer"`

	// The Amazon Cognito user pool whose identities are accessible to this Verified
	// Permissions policy store.
	//
	// Deprecated: This attribute has been replaced by configuration.cognitoUserPoolConfiguration.userPoolArn
	UserPoolArn *string `locationName:"userPoolArn" min:"1" deprecated:"true" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentitySourceItemDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentitySourceItemDetails) GoString() string {
	return s.String()
}

// SetClientIds sets the ClientIds field's value.
func (s *IdentitySourceItemDetails) SetClientIds(v []*string) *IdentitySourceItemDetails {
	s.ClientIds = v
	return s
}

// SetDiscoveryUrl sets the DiscoveryUrl field's value.
func (s *IdentitySourceItemDetails) SetDiscoveryUrl(v string) *IdentitySourceItemDetails {
	s.DiscoveryUrl = &v
	return s
}

// SetOpenIdIssuer sets the OpenIdIssuer field's value.
func (s *IdentitySourceItemDetails) SetOpenIdIssuer(v string) *IdentitySourceItemDetails {
	s.OpenIdIssuer = &v
	return s
}

// SetUserPoolArn sets the UserPoolArn field's value.
func (s *IdentitySourceItemDetails) SetUserPoolArn(v string) *IdentitySourceItemDetails {
	s.UserPoolArn = &v
	return s
}

// The request failed because of an internal error. Try your request again later
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type IsAuthorizedInput struct {
	_ struct{} `type:"structure"`

	// Specifies the requested action to be authorized. For example, is the principal
	// authorized to perform this action on the resource?
	Action *ActionIdentifier `locationName:"action" type:"structure"`

	// Specifies additional context that can be used to make more granular authorization
	// decisions.
	Context *ContextDefinition `locationName:"context" type:"structure"`

	// Specifies the list of resources and principals and their associated attributes
	// that Verified Permissions can examine when evaluating the policies.
	//
	// You can include only principal and resource entities in this parameter; you
	// can't include actions. You must specify actions in the schema.
	Entities *EntitiesDefinition `locationName:"entities" type:"structure"`

	// Specifies the ID of the policy store. Policies in this policy store will
	// be used to make an authorization decision for the input.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// Specifies the principal for which the authorization decision is to be made.
	Principal *EntityIdentifier `locationName:"principal" type:"structure"`

	// Specifies the resource for which the authorization decision is to be made.
	Resource *EntityIdentifier `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsAuthorizedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsAuthorizedInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IsAuthorizedInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IsAuthorizedInput"}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Context != nil {
		if err := s.Context.Validate(); err != nil {
			invalidParams.AddNested("Context", err.(request.ErrInvalidParams))
		}
	}
	if s.Entities != nil {
		if err := s.Entities.Validate(); err != nil {
			invalidParams.AddNested("Entities", err.(request.ErrInvalidParams))
		}
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *IsAuthorizedInput) SetAction(v *ActionIdentifier) *IsAuthorizedInput {
	s.Action = v
	return s
}

// SetContext sets the Context field's value.
func (s *IsAuthorizedInput) SetContext(v *ContextDefinition) *IsAuthorizedInput {
	s.Context = v
	return s
}

// SetEntities sets the Entities field's value.
func (s *IsAuthorizedInput) SetEntities(v *EntitiesDefinition) *IsAuthorizedInput {
	s.Entities = v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *IsAuthorizedInput) SetPolicyStoreId(v string) *IsAuthorizedInput {
	s.PolicyStoreId = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *IsAuthorizedInput) SetPrincipal(v *EntityIdentifier) *IsAuthorizedInput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *IsAuthorizedInput) SetResource(v *EntityIdentifier) *IsAuthorizedInput {
	s.Resource = v
	return s
}

type IsAuthorizedOutput struct {
	_ struct{} `type:"structure"`

	// An authorization decision that indicates if the authorization request should
	// be allowed or denied.
	//
	// Decision is a required field
	Decision *string `locationName:"decision" type:"string" required:"true" enum:"Decision"`

	// The list of determining policies used to make the authorization decision.
	// For example, if there are two matching policies, where one is a forbid and
	// the other is a permit, then the forbid policy will be the determining policy.
	// In the case of multiple matching permit policies then there would be multiple
	// determining policies. In the case that no policies match, and hence the response
	// is DENY, there would be no determining policies.
	//
	// DeterminingPolicies is a required field
	DeterminingPolicies []*DeterminingPolicyItem `locationName:"determiningPolicies" type:"list" required:"true"`

	// Errors that occurred while making an authorization decision, for example,
	// a policy references an Entity or entity Attribute that does not exist in
	// the slice.
	//
	// Errors is a required field
	Errors []*EvaluationErrorItem `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsAuthorizedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsAuthorizedOutput) GoString() string {
	return s.String()
}

// SetDecision sets the Decision field's value.
func (s *IsAuthorizedOutput) SetDecision(v string) *IsAuthorizedOutput {
	s.Decision = &v
	return s
}

// SetDeterminingPolicies sets the DeterminingPolicies field's value.
func (s *IsAuthorizedOutput) SetDeterminingPolicies(v []*DeterminingPolicyItem) *IsAuthorizedOutput {
	s.DeterminingPolicies = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *IsAuthorizedOutput) SetErrors(v []*EvaluationErrorItem) *IsAuthorizedOutput {
	s.Errors = v
	return s
}

type IsAuthorizedWithTokenInput struct {
	_ struct{} `type:"structure"`

	// Specifies an access token for the principal to be authorized. This token
	// is provided to you by the identity provider (IdP) associated with the specified
	// identity source. You must specify either an accessToken, an identityToken,
	// or both.
	//
	// Must be an access token. Verified Permissions returns an error if the token_use
	// claim in the submitted token isn't access.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IsAuthorizedWithTokenInput's
	// String and GoString methods.
	AccessToken *string `locationName:"accessToken" min:"1" type:"string" sensitive:"true"`

	// Specifies the requested action to be authorized. Is the specified principal
	// authorized to perform this action on the specified resource.
	Action *ActionIdentifier `locationName:"action" type:"structure"`

	// Specifies additional context that can be used to make more granular authorization
	// decisions.
	Context *ContextDefinition `locationName:"context" type:"structure"`

	// Specifies the list of resources and their associated attributes that Verified
	// Permissions can examine when evaluating the policies.
	//
	// You can't include principals in this parameter, only resource and action
	// entities. This parameter can't include any entities of a type that matches
	// the user or group entity types that you defined in your identity source.
	//
	//    * The IsAuthorizedWithToken operation takes principal attributes from
	//    only the identityToken or accessToken passed to the operation.
	//
	//    * For action entities, you can include only their Identifier and EntityType.
	Entities *EntitiesDefinition `locationName:"entities" type:"structure"`

	// Specifies an identity token for the principal to be authorized. This token
	// is provided to you by the identity provider (IdP) associated with the specified
	// identity source. You must specify either an accessToken, an identityToken,
	// or both.
	//
	// Must be an ID token. Verified Permissions returns an error if the token_use
	// claim in the submitted token isn't id.
	//
	// IdentityToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IsAuthorizedWithTokenInput's
	// String and GoString methods.
	IdentityToken *string `locationName:"identityToken" min:"1" type:"string" sensitive:"true"`

	// Specifies the ID of the policy store. Policies in this policy store will
	// be used to make an authorization decision for the input.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// Specifies the resource for which the authorization decision is made. For
	// example, is the principal allowed to perform the action on the resource?
	Resource *EntityIdentifier `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsAuthorizedWithTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsAuthorizedWithTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IsAuthorizedWithTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IsAuthorizedWithTokenInput"}
	if s.AccessToken != nil && len(*s.AccessToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessToken", 1))
	}
	if s.IdentityToken != nil && len(*s.IdentityToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityToken", 1))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Context != nil {
		if err := s.Context.Validate(); err != nil {
			invalidParams.AddNested("Context", err.(request.ErrInvalidParams))
		}
	}
	if s.Entities != nil {
		if err := s.Entities.Validate(); err != nil {
			invalidParams.AddNested("Entities", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *IsAuthorizedWithTokenInput) SetAccessToken(v string) *IsAuthorizedWithTokenInput {
	s.AccessToken = &v
	return s
}

// SetAction sets the Action field's value.
func (s *IsAuthorizedWithTokenInput) SetAction(v *ActionIdentifier) *IsAuthorizedWithTokenInput {
	s.Action = v
	return s
}

// SetContext sets the Context field's value.
func (s *IsAuthorizedWithTokenInput) SetContext(v *ContextDefinition) *IsAuthorizedWithTokenInput {
	s.Context = v
	return s
}

// SetEntities sets the Entities field's value.
func (s *IsAuthorizedWithTokenInput) SetEntities(v *EntitiesDefinition) *IsAuthorizedWithTokenInput {
	s.Entities = v
	return s
}

// SetIdentityToken sets the IdentityToken field's value.
func (s *IsAuthorizedWithTokenInput) SetIdentityToken(v string) *IsAuthorizedWithTokenInput {
	s.IdentityToken = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *IsAuthorizedWithTokenInput) SetPolicyStoreId(v string) *IsAuthorizedWithTokenInput {
	s.PolicyStoreId = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *IsAuthorizedWithTokenInput) SetResource(v *EntityIdentifier) *IsAuthorizedWithTokenInput {
	s.Resource = v
	return s
}

type IsAuthorizedWithTokenOutput struct {
	_ struct{} `type:"structure"`

	// An authorization decision that indicates if the authorization request should
	// be allowed or denied.
	//
	// Decision is a required field
	Decision *string `locationName:"decision" type:"string" required:"true" enum:"Decision"`

	// The list of determining policies used to make the authorization decision.
	// For example, if there are multiple matching policies, where at least one
	// is a forbid policy, then because forbid always overrides permit the forbid
	// policies are the determining policies. If all matching policies are permit
	// policies, then those policies are the determining policies. When no policies
	// match and the response is the default DENY, there are no determining policies.
	//
	// DeterminingPolicies is a required field
	DeterminingPolicies []*DeterminingPolicyItem `locationName:"determiningPolicies" type:"list" required:"true"`

	// Errors that occurred while making an authorization decision. For example,
	// a policy references an entity or entity attribute that does not exist in
	// the slice.
	//
	// Errors is a required field
	Errors []*EvaluationErrorItem `locationName:"errors" type:"list" required:"true"`

	// The identifier of the principal in the ID or access token.
	Principal *EntityIdentifier `locationName:"principal" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsAuthorizedWithTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsAuthorizedWithTokenOutput) GoString() string {
	return s.String()
}

// SetDecision sets the Decision field's value.
func (s *IsAuthorizedWithTokenOutput) SetDecision(v string) *IsAuthorizedWithTokenOutput {
	s.Decision = &v
	return s
}

// SetDeterminingPolicies sets the DeterminingPolicies field's value.
func (s *IsAuthorizedWithTokenOutput) SetDeterminingPolicies(v []*DeterminingPolicyItem) *IsAuthorizedWithTokenOutput {
	s.DeterminingPolicies = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *IsAuthorizedWithTokenOutput) SetErrors(v []*EvaluationErrorItem) *IsAuthorizedWithTokenOutput {
	s.Errors = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *IsAuthorizedWithTokenOutput) SetPrincipal(v *EntityIdentifier) *IsAuthorizedWithTokenOutput {
	s.Principal = v
	return s
}

type ListIdentitySourcesInput struct {
	_ struct{} `type:"structure"`

	// Specifies characteristics of an identity source that you can use to limit
	// the output to matching identity sources.
	Filters []*IdentitySourceFilter `locationName:"filters" type:"list"`

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value
	// as the NextToken request parameter in the next call to the operation to get
	// the next set of results. Note that the service might return fewer results
	// than the maximum even when there are more results available. You should check
	// NextToken after every operation to ensure that you receive all of the results.
	//
	// If you do not specify this parameter, the operation defaults to 10 identity
	// sources per response. You can specify a maximum of 50 identity sources per
	// response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Specifies the ID of the policy store that contains the identity sources that
	// you want to list.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentitySourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentitySourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentitySourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdentitySourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListIdentitySourcesInput) SetFilters(v []*IdentitySourceFilter) *ListIdentitySourcesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdentitySourcesInput) SetMaxResults(v int64) *ListIdentitySourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentitySourcesInput) SetNextToken(v string) *ListIdentitySourcesInput {
	s.NextToken = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *ListIdentitySourcesInput) SetPolicyStoreId(v string) *ListIdentitySourcesInput {
	s.PolicyStoreId = &v
	return s
}

type ListIdentitySourcesOutput struct {
	_ struct{} `type:"structure"`

	// The list of identity sources stored in the specified policy store.
	//
	// IdentitySources is a required field
	IdentitySources []*IdentitySourceItem `locationName:"identitySources" type:"list" required:"true"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentitySourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentitySourcesOutput) GoString() string {
	return s.String()
}

// SetIdentitySources sets the IdentitySources field's value.
func (s *ListIdentitySourcesOutput) SetIdentitySources(v []*IdentitySourceItem) *ListIdentitySourcesOutput {
	s.IdentitySources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentitySourcesOutput) SetNextToken(v string) *ListIdentitySourcesOutput {
	s.NextToken = &v
	return s
}

type ListPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies a filter that limits the response to only policies that match the
	// specified criteria. For example, you list only the policies that reference
	// a specified principal.
	Filter *PolicyFilter `locationName:"filter" type:"structure"`

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value
	// as the NextToken request parameter in the next call to the operation to get
	// the next set of results. Note that the service might return fewer results
	// than the maximum even when there are more results available. You should check
	// NextToken after every operation to ensure that you receive all of the results.
	//
	// If you do not specify this parameter, the operation defaults to 10 policies
	// per response. You can specify a maximum of 50 policies per response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Specifies the ID of the policy store you want to list policies from.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPoliciesInput) SetFilter(v *PolicyFilter) *ListPoliciesInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPoliciesInput) SetMaxResults(v int64) *ListPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesInput) SetNextToken(v string) *ListPoliciesInput {
	s.NextToken = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *ListPoliciesInput) SetPolicyStoreId(v string) *ListPoliciesInput {
	s.PolicyStoreId = &v
	return s
}

type ListPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Lists all policies that are available in the specified policy store.
	//
	// Policies is a required field
	Policies []*PolicyItem `locationName:"policies" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesOutput) SetNextToken(v string) *ListPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *ListPoliciesOutput) SetPolicies(v []*PolicyItem) *ListPoliciesOutput {
	s.Policies = v
	return s
}

type ListPolicyStoresInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value
	// as the NextToken request parameter in the next call to the operation to get
	// the next set of results. Note that the service might return fewer results
	// than the maximum even when there are more results available. You should check
	// NextToken after every operation to ensure that you receive all of the results.
	//
	// If you do not specify this parameter, the operation defaults to 10 policy
	// stores per response. You can specify a maximum of 50 policy stores per response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPolicyStoresInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPolicyStoresInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPolicyStoresInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPolicyStoresInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPolicyStoresInput) SetMaxResults(v int64) *ListPolicyStoresInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPolicyStoresInput) SetNextToken(v string) *ListPolicyStoresInput {
	s.NextToken = &v
	return s
}

type ListPolicyStoresOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The list of policy stores in the account.
	//
	// PolicyStores is a required field
	PolicyStores []*PolicyStoreItem `locationName:"policyStores" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPolicyStoresOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPolicyStoresOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPolicyStoresOutput) SetNextToken(v string) *ListPolicyStoresOutput {
	s.NextToken = &v
	return s
}

// SetPolicyStores sets the PolicyStores field's value.
func (s *ListPolicyStoresOutput) SetPolicyStores(v []*PolicyStoreItem) *ListPolicyStoresOutput {
	s.PolicyStores = v
	return s
}

type ListPolicyTemplatesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value
	// as the NextToken request parameter in the next call to the operation to get
	// the next set of results. Note that the service might return fewer results
	// than the maximum even when there are more results available. You should check
	// NextToken after every operation to ensure that you receive all of the results.
	//
	// If you do not specify this parameter, the operation defaults to 10 policy
	// templates per response. You can specify a maximum of 50 policy templates
	// per response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Specifies the ID of the policy store that contains the policy templates you
	// want to list.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPolicyTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPolicyTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPolicyTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPolicyTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPolicyTemplatesInput) SetMaxResults(v int64) *ListPolicyTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPolicyTemplatesInput) SetNextToken(v string) *ListPolicyTemplatesInput {
	s.NextToken = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *ListPolicyTemplatesInput) SetPolicyStoreId(v string) *ListPolicyTemplatesInput {
	s.PolicyStoreId = &v
	return s
}

type ListPolicyTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The list of the policy templates in the specified policy store.
	//
	// PolicyTemplates is a required field
	PolicyTemplates []*PolicyTemplateItem `locationName:"policyTemplates" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPolicyTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPolicyTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPolicyTemplatesOutput) SetNextToken(v string) *ListPolicyTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetPolicyTemplates sets the PolicyTemplates field's value.
func (s *ListPolicyTemplatesOutput) SetPolicyTemplates(v []*PolicyTemplateItem) *ListPolicyTemplatesOutput {
	s.PolicyTemplates = v
	return s
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// access token claims. Contains the claim that you want to identify as the
// principal in an authorization request, and the values of the aud claim, or
// audiences, that you want to accept.
//
// This data type is part of a OpenIdConnectTokenSelection (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelection.html)
// structure, which is a parameter of CreateIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html).
type OpenIdConnectAccessTokenConfiguration struct {
	_ struct{} `type:"structure"`

	// The access token aud claim values that you want to accept in your policy
	// store. For example, https://myapp.example.com, https://myapp2.example.com.
	Audiences []*string `locationName:"audiences" min:"1" type:"list"`

	// The claim that determines the principal in OIDC access tokens. For example,
	// sub.
	//
	// PrincipalIdClaim is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectAccessTokenConfiguration's
	// String and GoString methods.
	PrincipalIdClaim *string `locationName:"principalIdClaim" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectAccessTokenConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectAccessTokenConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenIdConnectAccessTokenConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenIdConnectAccessTokenConfiguration"}
	if s.Audiences != nil && len(s.Audiences) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Audiences", 1))
	}
	if s.PrincipalIdClaim != nil && len(*s.PrincipalIdClaim) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalIdClaim", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudiences sets the Audiences field's value.
func (s *OpenIdConnectAccessTokenConfiguration) SetAudiences(v []*string) *OpenIdConnectAccessTokenConfiguration {
	s.Audiences = v
	return s
}

// SetPrincipalIdClaim sets the PrincipalIdClaim field's value.
func (s *OpenIdConnectAccessTokenConfiguration) SetPrincipalIdClaim(v string) *OpenIdConnectAccessTokenConfiguration {
	s.PrincipalIdClaim = &v
	return s
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// access token claims. Contains the claim that you want to identify as the
// principal in an authorization request, and the values of the aud claim, or
// audiences, that you want to accept.
//
// This data type is part of a OpenIdConnectTokenSelectionDetail (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionDetail.html)
// structure, which is a parameter of GetIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html).
type OpenIdConnectAccessTokenConfigurationDetail struct {
	_ struct{} `type:"structure"`

	// The access token aud claim values that you want to accept in your policy
	// store. For example, https://myapp.example.com, https://myapp2.example.com.
	Audiences []*string `locationName:"audiences" min:"1" type:"list"`

	// The claim that determines the principal in OIDC access tokens. For example,
	// sub.
	//
	// PrincipalIdClaim is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectAccessTokenConfigurationDetail's
	// String and GoString methods.
	PrincipalIdClaim *string `locationName:"principalIdClaim" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectAccessTokenConfigurationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectAccessTokenConfigurationDetail) GoString() string {
	return s.String()
}

// SetAudiences sets the Audiences field's value.
func (s *OpenIdConnectAccessTokenConfigurationDetail) SetAudiences(v []*string) *OpenIdConnectAccessTokenConfigurationDetail {
	s.Audiences = v
	return s
}

// SetPrincipalIdClaim sets the PrincipalIdClaim field's value.
func (s *OpenIdConnectAccessTokenConfigurationDetail) SetPrincipalIdClaim(v string) *OpenIdConnectAccessTokenConfigurationDetail {
	s.PrincipalIdClaim = &v
	return s
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// access token claims. Contains the claim that you want to identify as the
// principal in an authorization request, and the values of the aud claim, or
// audiences, that you want to accept.
//
// This data type is part of a OpenIdConnectTokenSelectionItem (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionItem.html)
// structure, which is a parameter of ListIdentitySources (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html).
type OpenIdConnectAccessTokenConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The access token aud claim values that you want to accept in your policy
	// store. For example, https://myapp.example.com, https://myapp2.example.com.
	Audiences []*string `locationName:"audiences" min:"1" type:"list"`

	// The claim that determines the principal in OIDC access tokens. For example,
	// sub.
	//
	// PrincipalIdClaim is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectAccessTokenConfigurationItem's
	// String and GoString methods.
	PrincipalIdClaim *string `locationName:"principalIdClaim" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectAccessTokenConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectAccessTokenConfigurationItem) GoString() string {
	return s.String()
}

// SetAudiences sets the Audiences field's value.
func (s *OpenIdConnectAccessTokenConfigurationItem) SetAudiences(v []*string) *OpenIdConnectAccessTokenConfigurationItem {
	s.Audiences = v
	return s
}

// SetPrincipalIdClaim sets the PrincipalIdClaim field's value.
func (s *OpenIdConnectAccessTokenConfigurationItem) SetPrincipalIdClaim(v string) *OpenIdConnectAccessTokenConfigurationItem {
	s.PrincipalIdClaim = &v
	return s
}

// Contains configuration details of an OpenID Connect (OIDC) identity provider,
// or identity source, that Verified Permissions can use to generate entities
// from authenticated identities. It specifies the issuer URL, token type that
// you want to use, and policy store entity details.
//
// This data type is part of a Configuration (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_Configuration.html)
// structure, which is a parameter to CreateIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html).
type OpenIdConnectConfiguration struct {
	_ struct{} `type:"structure"`

	// A descriptive string that you want to prefix to user entities from your OIDC
	// identity provider. For example, if you set an entityIdPrefix of MyOIDCProvider,
	// you can reference principals in your policies in the format MyCorp::User::MyOIDCProvider|Carlos.
	//
	// EntityIdPrefix is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectConfiguration's
	// String and GoString methods.
	EntityIdPrefix *string `locationName:"entityIdPrefix" min:"1" type:"string" sensitive:"true"`

	// The claim in OIDC identity provider tokens that indicates a user's group
	// membership, and the entity type that you want to map it to. For example,
	// this object can map the contents of a groups claim to MyCorp::UserGroup.
	GroupConfiguration *OpenIdConnectGroupConfiguration `locationName:"groupConfiguration" type:"structure"`

	// The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery
	// endpoint at the path .well-known/openid-configuration.
	//
	// Issuer is a required field
	Issuer *string `locationName:"issuer" min:"1" type:"string" required:"true"`

	// The token type that you want to process from your OIDC identity provider.
	// Your policy store can process either identity (ID) or access tokens from
	// a given OIDC identity source.
	//
	// TokenSelection is a required field
	TokenSelection *OpenIdConnectTokenSelection `locationName:"tokenSelection" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenIdConnectConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenIdConnectConfiguration"}
	if s.EntityIdPrefix != nil && len(*s.EntityIdPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityIdPrefix", 1))
	}
	if s.Issuer == nil {
		invalidParams.Add(request.NewErrParamRequired("Issuer"))
	}
	if s.Issuer != nil && len(*s.Issuer) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Issuer", 1))
	}
	if s.TokenSelection == nil {
		invalidParams.Add(request.NewErrParamRequired("TokenSelection"))
	}
	if s.GroupConfiguration != nil {
		if err := s.GroupConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GroupConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.TokenSelection != nil {
		if err := s.TokenSelection.Validate(); err != nil {
			invalidParams.AddNested("TokenSelection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityIdPrefix sets the EntityIdPrefix field's value.
func (s *OpenIdConnectConfiguration) SetEntityIdPrefix(v string) *OpenIdConnectConfiguration {
	s.EntityIdPrefix = &v
	return s
}

// SetGroupConfiguration sets the GroupConfiguration field's value.
func (s *OpenIdConnectConfiguration) SetGroupConfiguration(v *OpenIdConnectGroupConfiguration) *OpenIdConnectConfiguration {
	s.GroupConfiguration = v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *OpenIdConnectConfiguration) SetIssuer(v string) *OpenIdConnectConfiguration {
	s.Issuer = &v
	return s
}

// SetTokenSelection sets the TokenSelection field's value.
func (s *OpenIdConnectConfiguration) SetTokenSelection(v *OpenIdConnectTokenSelection) *OpenIdConnectConfiguration {
	s.TokenSelection = v
	return s
}

// Contains configuration details of an OpenID Connect (OIDC) identity provider,
// or identity source, that Verified Permissions can use to generate entities
// from authenticated identities. It specifies the issuer URL, token type that
// you want to use, and policy store entity details.
//
// This data type is part of a ConfigurationDetail (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html)
// structure, which is a parameter to GetIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html).
type OpenIdConnectConfigurationDetail struct {
	_ struct{} `type:"structure"`

	// A descriptive string that you want to prefix to user entities from your OIDC
	// identity provider. For example, if you set an entityIdPrefix of MyOIDCProvider,
	// you can reference principals in your policies in the format MyCorp::User::MyOIDCProvider|Carlos.
	//
	// EntityIdPrefix is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectConfigurationDetail's
	// String and GoString methods.
	EntityIdPrefix *string `locationName:"entityIdPrefix" min:"1" type:"string" sensitive:"true"`

	// The claim in OIDC identity provider tokens that indicates a user's group
	// membership, and the entity type that you want to map it to. For example,
	// this object can map the contents of a groups claim to MyCorp::UserGroup.
	GroupConfiguration *OpenIdConnectGroupConfigurationDetail `locationName:"groupConfiguration" type:"structure"`

	// The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery
	// endpoint at the path .well-known/openid-configuration.
	//
	// Issuer is a required field
	Issuer *string `locationName:"issuer" min:"1" type:"string" required:"true"`

	// The token type that you want to process from your OIDC identity provider.
	// Your policy store can process either identity (ID) or access tokens from
	// a given OIDC identity source.
	//
	// TokenSelection is a required field
	TokenSelection *OpenIdConnectTokenSelectionDetail `locationName:"tokenSelection" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectConfigurationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectConfigurationDetail) GoString() string {
	return s.String()
}

// SetEntityIdPrefix sets the EntityIdPrefix field's value.
func (s *OpenIdConnectConfigurationDetail) SetEntityIdPrefix(v string) *OpenIdConnectConfigurationDetail {
	s.EntityIdPrefix = &v
	return s
}

// SetGroupConfiguration sets the GroupConfiguration field's value.
func (s *OpenIdConnectConfigurationDetail) SetGroupConfiguration(v *OpenIdConnectGroupConfigurationDetail) *OpenIdConnectConfigurationDetail {
	s.GroupConfiguration = v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *OpenIdConnectConfigurationDetail) SetIssuer(v string) *OpenIdConnectConfigurationDetail {
	s.Issuer = &v
	return s
}

// SetTokenSelection sets the TokenSelection field's value.
func (s *OpenIdConnectConfigurationDetail) SetTokenSelection(v *OpenIdConnectTokenSelectionDetail) *OpenIdConnectConfigurationDetail {
	s.TokenSelection = v
	return s
}

// Contains configuration details of an OpenID Connect (OIDC) identity provider,
// or identity source, that Verified Permissions can use to generate entities
// from authenticated identities. It specifies the issuer URL, token type that
// you want to use, and policy store entity details.
//
// This data type is part of a ConfigurationItem (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html)
// structure, which is a parameter to ListIdentitySources (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html).
type OpenIdConnectConfigurationItem struct {
	_ struct{} `type:"structure"`

	// A descriptive string that you want to prefix to user entities from your OIDC
	// identity provider. For example, if you set an entityIdPrefix of MyOIDCProvider,
	// you can reference principals in your policies in the format MyCorp::User::MyOIDCProvider|Carlos.
	//
	// EntityIdPrefix is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectConfigurationItem's
	// String and GoString methods.
	EntityIdPrefix *string `locationName:"entityIdPrefix" min:"1" type:"string" sensitive:"true"`

	// The claim in OIDC identity provider tokens that indicates a user's group
	// membership, and the entity type that you want to map it to. For example,
	// this object can map the contents of a groups claim to MyCorp::UserGroup.
	GroupConfiguration *OpenIdConnectGroupConfigurationItem `locationName:"groupConfiguration" type:"structure"`

	// The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery
	// endpoint at the path .well-known/openid-configuration.
	//
	// Issuer is a required field
	Issuer *string `locationName:"issuer" min:"1" type:"string" required:"true"`

	// The token type that you want to process from your OIDC identity provider.
	// Your policy store can process either identity (ID) or access tokens from
	// a given OIDC identity source.
	//
	// TokenSelection is a required field
	TokenSelection *OpenIdConnectTokenSelectionItem `locationName:"tokenSelection" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectConfigurationItem) GoString() string {
	return s.String()
}

// SetEntityIdPrefix sets the EntityIdPrefix field's value.
func (s *OpenIdConnectConfigurationItem) SetEntityIdPrefix(v string) *OpenIdConnectConfigurationItem {
	s.EntityIdPrefix = &v
	return s
}

// SetGroupConfiguration sets the GroupConfiguration field's value.
func (s *OpenIdConnectConfigurationItem) SetGroupConfiguration(v *OpenIdConnectGroupConfigurationItem) *OpenIdConnectConfigurationItem {
	s.GroupConfiguration = v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *OpenIdConnectConfigurationItem) SetIssuer(v string) *OpenIdConnectConfigurationItem {
	s.Issuer = &v
	return s
}

// SetTokenSelection sets the TokenSelection field's value.
func (s *OpenIdConnectConfigurationItem) SetTokenSelection(v *OpenIdConnectTokenSelectionItem) *OpenIdConnectConfigurationItem {
	s.TokenSelection = v
	return s
}

// The claim in OIDC identity provider tokens that indicates a user's group
// membership, and the entity type that you want to map it to. For example,
// this object can map the contents of a groups claim to MyCorp::UserGroup.
//
// This data type is part of a OpenIdConnectConfiguration (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfiguration.html)
// structure, which is a parameter of CreateIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html).
type OpenIdConnectGroupConfiguration struct {
	_ struct{} `type:"structure"`

	// The token claim that you want Verified Permissions to interpret as group
	// membership. For example, groups.
	//
	// GroupClaim is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectGroupConfiguration's
	// String and GoString methods.
	//
	// GroupClaim is a required field
	GroupClaim *string `locationName:"groupClaim" min:"1" type:"string" required:"true" sensitive:"true"`

	// The policy store entity type that you want to map your users' group claim
	// to. For example, MyCorp::UserGroup. A group entity type is an entity that
	// can have a user entity type as a member.
	//
	// GroupEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectGroupConfiguration's
	// String and GoString methods.
	//
	// GroupEntityType is a required field
	GroupEntityType *string `locationName:"groupEntityType" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectGroupConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectGroupConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenIdConnectGroupConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenIdConnectGroupConfiguration"}
	if s.GroupClaim == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupClaim"))
	}
	if s.GroupClaim != nil && len(*s.GroupClaim) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupClaim", 1))
	}
	if s.GroupEntityType == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupEntityType"))
	}
	if s.GroupEntityType != nil && len(*s.GroupEntityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupEntityType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupClaim sets the GroupClaim field's value.
func (s *OpenIdConnectGroupConfiguration) SetGroupClaim(v string) *OpenIdConnectGroupConfiguration {
	s.GroupClaim = &v
	return s
}

// SetGroupEntityType sets the GroupEntityType field's value.
func (s *OpenIdConnectGroupConfiguration) SetGroupEntityType(v string) *OpenIdConnectGroupConfiguration {
	s.GroupEntityType = &v
	return s
}

// The claim in OIDC identity provider tokens that indicates a user's group
// membership, and the entity type that you want to map it to. For example,
// this object can map the contents of a groups claim to MyCorp::UserGroup.
//
// This data type is part of a OpenIdConnectConfigurationDetail (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfigurationDetail.html)
// structure, which is a parameter of GetIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html).
type OpenIdConnectGroupConfigurationDetail struct {
	_ struct{} `type:"structure"`

	// The token claim that you want Verified Permissions to interpret as group
	// membership. For example, groups.
	//
	// GroupClaim is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectGroupConfigurationDetail's
	// String and GoString methods.
	//
	// GroupClaim is a required field
	GroupClaim *string `locationName:"groupClaim" min:"1" type:"string" required:"true" sensitive:"true"`

	// The policy store entity type that you want to map your users' group claim
	// to. For example, MyCorp::UserGroup. A group entity type is an entity that
	// can have a user entity type as a member.
	//
	// GroupEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectGroupConfigurationDetail's
	// String and GoString methods.
	//
	// GroupEntityType is a required field
	GroupEntityType *string `locationName:"groupEntityType" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectGroupConfigurationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectGroupConfigurationDetail) GoString() string {
	return s.String()
}

// SetGroupClaim sets the GroupClaim field's value.
func (s *OpenIdConnectGroupConfigurationDetail) SetGroupClaim(v string) *OpenIdConnectGroupConfigurationDetail {
	s.GroupClaim = &v
	return s
}

// SetGroupEntityType sets the GroupEntityType field's value.
func (s *OpenIdConnectGroupConfigurationDetail) SetGroupEntityType(v string) *OpenIdConnectGroupConfigurationDetail {
	s.GroupEntityType = &v
	return s
}

// The claim in OIDC identity provider tokens that indicates a user's group
// membership, and the entity type that you want to map it to. For example,
// this object can map the contents of a groups claim to MyCorp::UserGroup.
//
// This data type is part of a OpenIdConnectConfigurationItem (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfigurationItem.html)
// structure, which is a parameter of ListIdentitySourcea (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html).
type OpenIdConnectGroupConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The token claim that you want Verified Permissions to interpret as group
	// membership. For example, groups.
	//
	// GroupClaim is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectGroupConfigurationItem's
	// String and GoString methods.
	//
	// GroupClaim is a required field
	GroupClaim *string `locationName:"groupClaim" min:"1" type:"string" required:"true" sensitive:"true"`

	// The policy store entity type that you want to map your users' group claim
	// to. For example, MyCorp::UserGroup. A group entity type is an entity that
	// can have a user entity type as a member.
	//
	// GroupEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectGroupConfigurationItem's
	// String and GoString methods.
	//
	// GroupEntityType is a required field
	GroupEntityType *string `locationName:"groupEntityType" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectGroupConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectGroupConfigurationItem) GoString() string {
	return s.String()
}

// SetGroupClaim sets the GroupClaim field's value.
func (s *OpenIdConnectGroupConfigurationItem) SetGroupClaim(v string) *OpenIdConnectGroupConfigurationItem {
	s.GroupClaim = &v
	return s
}

// SetGroupEntityType sets the GroupEntityType field's value.
func (s *OpenIdConnectGroupConfigurationItem) SetGroupEntityType(v string) *OpenIdConnectGroupConfigurationItem {
	s.GroupEntityType = &v
	return s
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// identity (ID) token claims. Contains the claim that you want to identify
// as the principal in an authorization request, and the values of the aud claim,
// or audiences, that you want to accept.
//
// This data type is part of a OpenIdConnectTokenSelection (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelection.html)
// structure, which is a parameter of CreateIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html).
type OpenIdConnectIdentityTokenConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID token audience, or client ID, claim values that you want to accept
	// in your policy store from an OIDC identity provider. For example, 1example23456789,
	// 2example10111213.
	ClientIds []*string `locationName:"clientIds" type:"list"`

	// The claim that determines the principal in OIDC access tokens. For example,
	// sub.
	//
	// PrincipalIdClaim is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectIdentityTokenConfiguration's
	// String and GoString methods.
	PrincipalIdClaim *string `locationName:"principalIdClaim" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectIdentityTokenConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectIdentityTokenConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenIdConnectIdentityTokenConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenIdConnectIdentityTokenConfiguration"}
	if s.PrincipalIdClaim != nil && len(*s.PrincipalIdClaim) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalIdClaim", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientIds sets the ClientIds field's value.
func (s *OpenIdConnectIdentityTokenConfiguration) SetClientIds(v []*string) *OpenIdConnectIdentityTokenConfiguration {
	s.ClientIds = v
	return s
}

// SetPrincipalIdClaim sets the PrincipalIdClaim field's value.
func (s *OpenIdConnectIdentityTokenConfiguration) SetPrincipalIdClaim(v string) *OpenIdConnectIdentityTokenConfiguration {
	s.PrincipalIdClaim = &v
	return s
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// identity (ID) token claims. Contains the claim that you want to identify
// as the principal in an authorization request, and the values of the aud claim,
// or audiences, that you want to accept.
//
// This data type is part of a OpenIdConnectTokenSelectionDetail (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionDetail.html)
// structure, which is a parameter of GetIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html).
type OpenIdConnectIdentityTokenConfigurationDetail struct {
	_ struct{} `type:"structure"`

	// The ID token audience, or client ID, claim values that you want to accept
	// in your policy store from an OIDC identity provider. For example, 1example23456789,
	// 2example10111213.
	ClientIds []*string `locationName:"clientIds" type:"list"`

	// The claim that determines the principal in OIDC access tokens. For example,
	// sub.
	//
	// PrincipalIdClaim is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectIdentityTokenConfigurationDetail's
	// String and GoString methods.
	PrincipalIdClaim *string `locationName:"principalIdClaim" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectIdentityTokenConfigurationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectIdentityTokenConfigurationDetail) GoString() string {
	return s.String()
}

// SetClientIds sets the ClientIds field's value.
func (s *OpenIdConnectIdentityTokenConfigurationDetail) SetClientIds(v []*string) *OpenIdConnectIdentityTokenConfigurationDetail {
	s.ClientIds = v
	return s
}

// SetPrincipalIdClaim sets the PrincipalIdClaim field's value.
func (s *OpenIdConnectIdentityTokenConfigurationDetail) SetPrincipalIdClaim(v string) *OpenIdConnectIdentityTokenConfigurationDetail {
	s.PrincipalIdClaim = &v
	return s
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// identity (ID) token claims. Contains the claim that you want to identify
// as the principal in an authorization request, and the values of the aud claim,
// or audiences, that you want to accept.
//
// This data type is part of a OpenIdConnectTokenSelectionItem (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionItem.html)
// structure, which is a parameter of ListIdentitySources (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html).
type OpenIdConnectIdentityTokenConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The ID token audience, or client ID, claim values that you want to accept
	// in your policy store from an OIDC identity provider. For example, 1example23456789,
	// 2example10111213.
	ClientIds []*string `locationName:"clientIds" type:"list"`

	// The claim that determines the principal in OIDC access tokens. For example,
	// sub.
	//
	// PrincipalIdClaim is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OpenIdConnectIdentityTokenConfigurationItem's
	// String and GoString methods.
	PrincipalIdClaim *string `locationName:"principalIdClaim" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectIdentityTokenConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectIdentityTokenConfigurationItem) GoString() string {
	return s.String()
}

// SetClientIds sets the ClientIds field's value.
func (s *OpenIdConnectIdentityTokenConfigurationItem) SetClientIds(v []*string) *OpenIdConnectIdentityTokenConfigurationItem {
	s.ClientIds = v
	return s
}

// SetPrincipalIdClaim sets the PrincipalIdClaim field's value.
func (s *OpenIdConnectIdentityTokenConfigurationItem) SetPrincipalIdClaim(v string) *OpenIdConnectIdentityTokenConfigurationItem {
	s.PrincipalIdClaim = &v
	return s
}

// The token type that you want to process from your OIDC identity provider.
// Your policy store can process either identity (ID) or access tokens from
// a given OIDC identity source.
//
// This data type is part of a OpenIdConnectConfiguration (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfiguration.html)
// structure, which is a parameter of CreateIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html).
type OpenIdConnectTokenSelection struct {
	_ struct{} `type:"structure"`

	// The OIDC configuration for processing access tokens. Contains allowed audience
	// claims, for example https://auth.example.com, and the claim that you want
	// to map to the principal, for example sub.
	AccessTokenOnly *OpenIdConnectAccessTokenConfiguration `locationName:"accessTokenOnly" type:"structure"`

	// The OIDC configuration for processing identity (ID) tokens. Contains allowed
	// client ID claims, for example 1example23456789, and the claim that you want
	// to map to the principal, for example sub.
	IdentityTokenOnly *OpenIdConnectIdentityTokenConfiguration `locationName:"identityTokenOnly" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectTokenSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectTokenSelection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenIdConnectTokenSelection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenIdConnectTokenSelection"}
	if s.AccessTokenOnly != nil {
		if err := s.AccessTokenOnly.Validate(); err != nil {
			invalidParams.AddNested("AccessTokenOnly", err.(request.ErrInvalidParams))
		}
	}
	if s.IdentityTokenOnly != nil {
		if err := s.IdentityTokenOnly.Validate(); err != nil {
			invalidParams.AddNested("IdentityTokenOnly", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessTokenOnly sets the AccessTokenOnly field's value.
func (s *OpenIdConnectTokenSelection) SetAccessTokenOnly(v *OpenIdConnectAccessTokenConfiguration) *OpenIdConnectTokenSelection {
	s.AccessTokenOnly = v
	return s
}

// SetIdentityTokenOnly sets the IdentityTokenOnly field's value.
func (s *OpenIdConnectTokenSelection) SetIdentityTokenOnly(v *OpenIdConnectIdentityTokenConfiguration) *OpenIdConnectTokenSelection {
	s.IdentityTokenOnly = v
	return s
}

// The token type that you want to process from your OIDC identity provider.
// Your policy store can process either identity (ID) or access tokens from
// a given OIDC identity source.
//
// This data type is part of a OpenIdConnectConfigurationDetail (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfigurationDetail.html)
// structure, which is a parameter of GetIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html).
type OpenIdConnectTokenSelectionDetail struct {
	_ struct{} `type:"structure"`

	// The OIDC configuration for processing access tokens. Contains allowed audience
	// claims, for example https://auth.example.com, and the claim that you want
	// to map to the principal, for example sub.
	AccessTokenOnly *OpenIdConnectAccessTokenConfigurationDetail `locationName:"accessTokenOnly" type:"structure"`

	// The OIDC configuration for processing identity (ID) tokens. Contains allowed
	// client ID claims, for example 1example23456789, and the claim that you want
	// to map to the principal, for example sub.
	IdentityTokenOnly *OpenIdConnectIdentityTokenConfigurationDetail `locationName:"identityTokenOnly" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectTokenSelectionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectTokenSelectionDetail) GoString() string {
	return s.String()
}

// SetAccessTokenOnly sets the AccessTokenOnly field's value.
func (s *OpenIdConnectTokenSelectionDetail) SetAccessTokenOnly(v *OpenIdConnectAccessTokenConfigurationDetail) *OpenIdConnectTokenSelectionDetail {
	s.AccessTokenOnly = v
	return s
}

// SetIdentityTokenOnly sets the IdentityTokenOnly field's value.
func (s *OpenIdConnectTokenSelectionDetail) SetIdentityTokenOnly(v *OpenIdConnectIdentityTokenConfigurationDetail) *OpenIdConnectTokenSelectionDetail {
	s.IdentityTokenOnly = v
	return s
}

// The token type that you want to process from your OIDC identity provider.
// Your policy store can process either identity (ID) or access tokens from
// a given OIDC identity source.
//
// This data type is part of a OpenIdConnectConfigurationItem (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfigurationItem.html)
// structure, which is a parameter of ListIdentitySources (http://amazonaws.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html).
type OpenIdConnectTokenSelectionItem struct {
	_ struct{} `type:"structure"`

	// The OIDC configuration for processing access tokens. Contains allowed audience
	// claims, for example https://auth.example.com, and the claim that you want
	// to map to the principal, for example sub.
	AccessTokenOnly *OpenIdConnectAccessTokenConfigurationItem `locationName:"accessTokenOnly" type:"structure"`

	// The OIDC configuration for processing identity (ID) tokens. Contains allowed
	// client ID claims, for example 1example23456789, and the claim that you want
	// to map to the principal, for example sub.
	IdentityTokenOnly *OpenIdConnectIdentityTokenConfigurationItem `locationName:"identityTokenOnly" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectTokenSelectionItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConnectTokenSelectionItem) GoString() string {
	return s.String()
}

// SetAccessTokenOnly sets the AccessTokenOnly field's value.
func (s *OpenIdConnectTokenSelectionItem) SetAccessTokenOnly(v *OpenIdConnectAccessTokenConfigurationItem) *OpenIdConnectTokenSelectionItem {
	s.AccessTokenOnly = v
	return s
}

// SetIdentityTokenOnly sets the IdentityTokenOnly field's value.
func (s *OpenIdConnectTokenSelectionItem) SetIdentityTokenOnly(v *OpenIdConnectIdentityTokenConfigurationItem) *OpenIdConnectTokenSelectionItem {
	s.IdentityTokenOnly = v
	return s
}

// A structure that contains the details for a Cedar policy definition. It includes
// the policy type, a description, and a policy body. This is a top level data
// type used to create a policy.
//
// This data type is used as a request parameter for the CreatePolicy (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html)
// operation. This structure must always have either an static or a templateLinked
// element.
type PolicyDefinition struct {
	_ struct{} `type:"structure"`

	// A structure that describes a static policy. An static policy doesn't use
	// a template or allow placeholders for entities.
	Static *StaticPolicyDefinition `locationName:"static" type:"structure"`

	// A structure that describes a policy that was instantiated from a template.
	// The template can specify placeholders for principal and resource. When you
	// use CreatePolicy (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html)
	// to create a policy from a template, you specify the exact principal and resource
	// to use for the instantiated policy.
	TemplateLinked *TemplateLinkedPolicyDefinition `locationName:"templateLinked" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PolicyDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PolicyDefinition"}
	if s.Static != nil {
		if err := s.Static.Validate(); err != nil {
			invalidParams.AddNested("Static", err.(request.ErrInvalidParams))
		}
	}
	if s.TemplateLinked != nil {
		if err := s.TemplateLinked.Validate(); err != nil {
			invalidParams.AddNested("TemplateLinked", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatic sets the Static field's value.
func (s *PolicyDefinition) SetStatic(v *StaticPolicyDefinition) *PolicyDefinition {
	s.Static = v
	return s
}

// SetTemplateLinked sets the TemplateLinked field's value.
func (s *PolicyDefinition) SetTemplateLinked(v *TemplateLinkedPolicyDefinition) *PolicyDefinition {
	s.TemplateLinked = v
	return s
}

// A structure that describes a policy definition. It must always have either
// an static or a templateLinked element.
//
// This data type is used as a response parameter for the GetPolicy (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetPolicy.html)
// operation.
type PolicyDefinitionDetail struct {
	_ struct{} `type:"structure"`

	// Information about a static policy that wasn't created with a policy template.
	Static *StaticPolicyDefinitionDetail `locationName:"static" type:"structure"`

	// Information about a template-linked policy that was created by instantiating
	// a policy template.
	TemplateLinked *TemplateLinkedPolicyDefinitionDetail `locationName:"templateLinked" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyDefinitionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyDefinitionDetail) GoString() string {
	return s.String()
}

// SetStatic sets the Static field's value.
func (s *PolicyDefinitionDetail) SetStatic(v *StaticPolicyDefinitionDetail) *PolicyDefinitionDetail {
	s.Static = v
	return s
}

// SetTemplateLinked sets the TemplateLinked field's value.
func (s *PolicyDefinitionDetail) SetTemplateLinked(v *TemplateLinkedPolicyDefinitionDetail) *PolicyDefinitionDetail {
	s.TemplateLinked = v
	return s
}

// A structure that describes a PolicyDefinintion (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinintion.html).
// It will always have either an StaticPolicy or a TemplateLinkedPolicy element.
//
// This data type is used as a response parameter for the CreatePolicy (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html)
// and ListPolicies (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html)
// operations.
type PolicyDefinitionItem struct {
	_ struct{} `type:"structure"`

	// Information about a static policy that wasn't created with a policy template.
	Static *StaticPolicyDefinitionItem `locationName:"static" type:"structure"`

	// Information about a template-linked policy that was created by instantiating
	// a policy template.
	TemplateLinked *TemplateLinkedPolicyDefinitionItem `locationName:"templateLinked" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyDefinitionItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyDefinitionItem) GoString() string {
	return s.String()
}

// SetStatic sets the Static field's value.
func (s *PolicyDefinitionItem) SetStatic(v *StaticPolicyDefinitionItem) *PolicyDefinitionItem {
	s.Static = v
	return s
}

// SetTemplateLinked sets the TemplateLinked field's value.
func (s *PolicyDefinitionItem) SetTemplateLinked(v *TemplateLinkedPolicyDefinitionItem) *PolicyDefinitionItem {
	s.TemplateLinked = v
	return s
}

// Contains information about a filter to refine policies returned in a query.
//
// This data type is used as a response parameter for the ListPolicies (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html)
// operation.
type PolicyFilter struct {
	_ struct{} `type:"structure"`

	// Filters the output to only template-linked policies that were instantiated
	// from the specified policy template.
	PolicyTemplateId *string `locationName:"policyTemplateId" min:"1" type:"string"`

	// Filters the output to only policies of the specified type.
	PolicyType *string `locationName:"policyType" type:"string" enum:"PolicyType"`

	// Filters the output to only policies that reference the specified principal.
	Principal *EntityReference `locationName:"principal" type:"structure"`

	// Filters the output to only policies that reference the specified resource.
	Resource *EntityReference `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PolicyFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PolicyFilter"}
	if s.PolicyTemplateId != nil && len(*s.PolicyTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyTemplateId", 1))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyTemplateId sets the PolicyTemplateId field's value.
func (s *PolicyFilter) SetPolicyTemplateId(v string) *PolicyFilter {
	s.PolicyTemplateId = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *PolicyFilter) SetPolicyType(v string) *PolicyFilter {
	s.PolicyType = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *PolicyFilter) SetPrincipal(v *EntityReference) *PolicyFilter {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *PolicyFilter) SetResource(v *EntityReference) *PolicyFilter {
	s.Resource = v
	return s
}

// Contains information about a policy.
//
// This data type is used as a response parameter for the ListPolicies (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html)
// operation.
type PolicyItem struct {
	_ struct{} `type:"structure"`

	// The action that a policy permits or forbids. For example, {"actions": [{"actionId":
	// "ViewPhoto", "actionType": "PhotoFlash::Action"}, {"entityID": "SharePhoto",
	// "entityType": "PhotoFlash::Action"}]}.
	Actions []*ActionIdentifier `locationName:"actions" type:"list"`

	// The date and time the policy was created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The policy definition of an item in the list of policies returned.
	//
	// Definition is a required field
	Definition *PolicyDefinitionItem `locationName:"definition" type:"structure" required:"true"`

	// The effect of the decision that a policy returns to an authorization request.
	// For example, "effect": "Permit".
	Effect *string `locationName:"effect" type:"string" enum:"PolicyEffect"`

	// The date and time the policy was most recently updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The identifier of the policy you want information about.
	//
	// PolicyId is a required field
	PolicyId *string `locationName:"policyId" min:"1" type:"string" required:"true"`

	// The identifier of the PolicyStore where the policy you want information about
	// is stored.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// The type of the policy. This is one of the following values:
	//
	//    * static
	//
	//    * templateLinked
	//
	// PolicyType is a required field
	PolicyType *string `locationName:"policyType" type:"string" required:"true" enum:"PolicyType"`

	// The principal associated with the policy.
	Principal *EntityIdentifier `locationName:"principal" type:"structure"`

	// The resource associated with the policy.
	Resource *EntityIdentifier `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyItem) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *PolicyItem) SetActions(v []*ActionIdentifier) *PolicyItem {
	s.Actions = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PolicyItem) SetCreatedDate(v time.Time) *PolicyItem {
	s.CreatedDate = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *PolicyItem) SetDefinition(v *PolicyDefinitionItem) *PolicyItem {
	s.Definition = v
	return s
}

// SetEffect sets the Effect field's value.
func (s *PolicyItem) SetEffect(v string) *PolicyItem {
	s.Effect = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *PolicyItem) SetLastUpdatedDate(v time.Time) *PolicyItem {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *PolicyItem) SetPolicyId(v string) *PolicyItem {
	s.PolicyId = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *PolicyItem) SetPolicyStoreId(v string) *PolicyItem {
	s.PolicyStoreId = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *PolicyItem) SetPolicyType(v string) *PolicyItem {
	s.PolicyType = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *PolicyItem) SetPrincipal(v *EntityIdentifier) *PolicyItem {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *PolicyItem) SetResource(v *EntityIdentifier) *PolicyItem {
	s.Resource = v
	return s
}

// Contains information about a policy store.
//
// This data type is used as a response parameter for the ListPolicyStores (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicyStores.html)
// operation.
type PolicyStoreItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the policy store.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The date and time the policy was created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Descriptive text that you can provide to help with identification of the
	// current policy store.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PolicyStoreItem's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The date and time the policy store was most recently updated.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601"`

	// The unique identifier of the policy store.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyStoreItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyStoreItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PolicyStoreItem) SetArn(v string) *PolicyStoreItem {
	s.Arn = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PolicyStoreItem) SetCreatedDate(v time.Time) *PolicyStoreItem {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PolicyStoreItem) SetDescription(v string) *PolicyStoreItem {
	s.Description = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *PolicyStoreItem) SetLastUpdatedDate(v time.Time) *PolicyStoreItem {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *PolicyStoreItem) SetPolicyStoreId(v string) *PolicyStoreItem {
	s.PolicyStoreId = &v
	return s
}

// Contains details about a policy template
//
// This data type is used as a response parameter for the ListPolicyTemplates
// (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicyTemplates.html)
// operation.
type PolicyTemplateItem struct {
	_ struct{} `type:"structure"`

	// The date and time that the policy template was created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description attached to the policy template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PolicyTemplateItem's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The date and time that the policy template was most recently updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique identifier of the policy store that contains the template.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// The unique identifier of the policy template.
	//
	// PolicyTemplateId is a required field
	PolicyTemplateId *string `locationName:"policyTemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyTemplateItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyTemplateItem) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PolicyTemplateItem) SetCreatedDate(v time.Time) *PolicyTemplateItem {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PolicyTemplateItem) SetDescription(v string) *PolicyTemplateItem {
	s.Description = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *PolicyTemplateItem) SetLastUpdatedDate(v time.Time) *PolicyTemplateItem {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *PolicyTemplateItem) SetPolicyStoreId(v string) *PolicyTemplateItem {
	s.PolicyStoreId = &v
	return s
}

// SetPolicyTemplateId sets the PolicyTemplateId field's value.
func (s *PolicyTemplateItem) SetPolicyTemplateId(v string) *PolicyTemplateItem {
	s.PolicyTemplateId = &v
	return s
}

type PutSchemaInput struct {
	_ struct{} `type:"structure"`

	// Specifies the definition of the schema to be stored. The schema definition
	// must be written in Cedar schema JSON.
	//
	// Definition is a required field
	Definition *SchemaDefinition `locationName:"definition" type:"structure" required:"true"`

	// Specifies the ID of the policy store in which to place the schema.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSchemaInput"}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefinition sets the Definition field's value.
func (s *PutSchemaInput) SetDefinition(v *SchemaDefinition) *PutSchemaInput {
	s.Definition = v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *PutSchemaInput) SetPolicyStoreId(v string) *PutSchemaInput {
	s.PolicyStoreId = &v
	return s
}

type PutSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the schema was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date and time that the schema was last updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Identifies the namespaces of the entities referenced by this schema.
	//
	// Namespaces is a required field
	Namespaces []*string `locationName:"namespaces" type:"list" required:"true"`

	// The unique ID of the policy store that contains the schema.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSchemaOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PutSchemaOutput) SetCreatedDate(v time.Time) *PutSchemaOutput {
	s.CreatedDate = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *PutSchemaOutput) SetLastUpdatedDate(v time.Time) *PutSchemaOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetNamespaces sets the Namespaces field's value.
func (s *PutSchemaOutput) SetNamespaces(v []*string) *PutSchemaOutput {
	s.Namespaces = v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *PutSchemaOutput) SetPolicyStoreId(v string) *PutSchemaOutput {
	s.PolicyStoreId = &v
	return s
}

// Contains information about a resource conflict.
type ResourceConflict struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the resource involved in a conflict.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource involved in a conflict.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceConflict) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceConflict) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceConflict) SetResourceId(v string) *ResourceConflict {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceConflict) SetResourceType(v string) *ResourceConflict {
	s.ResourceType = &v
	return s
}

// The request failed because it references a resource that doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The unique ID of the resource referenced in the failed request.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resource type of the resource referenced in the failed request.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains a list of principal types, resource types, and actions that can
// be specified in policies stored in the same policy store. If the validation
// mode for the policy store is set to STRICT, then policies that can't be validated
// by this schema are rejected by Verified Permissions and can't be stored in
// the policy store.
type SchemaDefinition struct {
	_ struct{} `type:"structure"`

	// A JSON string representation of the schema supported by applications that
	// use this policy store. For more information, see Policy store schema (https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/schema.html)
	// in the Amazon Verified Permissions User Guide.
	//
	// CedarJson is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SchemaDefinition's
	// String and GoString methods.
	CedarJson *string `locationName:"cedarJson" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SchemaDefinition"}
	if s.CedarJson != nil && len(*s.CedarJson) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CedarJson", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCedarJson sets the CedarJson field's value.
func (s *SchemaDefinition) SetCedarJson(v string) *SchemaDefinition {
	s.CedarJson = &v
	return s
}

// The request failed because it would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The quota code recognized by the Amazon Web Services Service Quotas service.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The unique ID of the resource referenced in the failed request.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The resource type of the resource referenced in the failed request.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// The code for the Amazon Web Service that owns the quota.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about a static policy.
//
// This data type is used as a field that is part of the PolicyDefinitionDetail
// (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinitionDetail.html)
// type.
type StaticPolicyDefinition struct {
	_ struct{} `type:"structure"`

	// The description of the static policy.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StaticPolicyDefinition's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The policy content of the static policy, written in the Cedar policy language.
	//
	// Statement is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StaticPolicyDefinition's
	// String and GoString methods.
	//
	// Statement is a required field
	Statement *string `locationName:"statement" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StaticPolicyDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StaticPolicyDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StaticPolicyDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StaticPolicyDefinition"}
	if s.Statement == nil {
		invalidParams.Add(request.NewErrParamRequired("Statement"))
	}
	if s.Statement != nil && len(*s.Statement) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statement", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *StaticPolicyDefinition) SetDescription(v string) *StaticPolicyDefinition {
	s.Description = &v
	return s
}

// SetStatement sets the Statement field's value.
func (s *StaticPolicyDefinition) SetStatement(v string) *StaticPolicyDefinition {
	s.Statement = &v
	return s
}

// A structure that contains details about a static policy. It includes the
// description and policy body.
//
// This data type is used within a PolicyDefinition (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinition.html)
// structure as part of a request parameter for the CreatePolicy (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html)
// operation.
type StaticPolicyDefinitionDetail struct {
	_ struct{} `type:"structure"`

	// A description of the static policy.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StaticPolicyDefinitionDetail's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The content of the static policy written in the Cedar policy language.
	//
	// Statement is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StaticPolicyDefinitionDetail's
	// String and GoString methods.
	//
	// Statement is a required field
	Statement *string `locationName:"statement" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StaticPolicyDefinitionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StaticPolicyDefinitionDetail) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *StaticPolicyDefinitionDetail) SetDescription(v string) *StaticPolicyDefinitionDetail {
	s.Description = &v
	return s
}

// SetStatement sets the Statement field's value.
func (s *StaticPolicyDefinitionDetail) SetStatement(v string) *StaticPolicyDefinitionDetail {
	s.Statement = &v
	return s
}

// A structure that contains details about a static policy. It includes the
// description and policy statement.
//
// This data type is used within a PolicyDefinition (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinition.html)
// structure as part of a request parameter for the CreatePolicy (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html)
// operation.
type StaticPolicyDefinitionItem struct {
	_ struct{} `type:"structure"`

	// A description of the static policy.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StaticPolicyDefinitionItem's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StaticPolicyDefinitionItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StaticPolicyDefinitionItem) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *StaticPolicyDefinitionItem) SetDescription(v string) *StaticPolicyDefinitionItem {
	s.Description = &v
	return s
}

// Contains information about a policy created by instantiating a policy template.
type TemplateLinkedPolicyDefinition struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the policy template used to create this policy.
	//
	// PolicyTemplateId is a required field
	PolicyTemplateId *string `locationName:"policyTemplateId" min:"1" type:"string" required:"true"`

	// The principal associated with this template-linked policy. Verified Permissions
	// substitutes this principal for the ?principal placeholder in the policy template
	// when it evaluates an authorization request.
	Principal *EntityIdentifier `locationName:"principal" type:"structure"`

	// The resource associated with this template-linked policy. Verified Permissions
	// substitutes this resource for the ?resource placeholder in the policy template
	// when it evaluates an authorization request.
	Resource *EntityIdentifier `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateLinkedPolicyDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateLinkedPolicyDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateLinkedPolicyDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemplateLinkedPolicyDefinition"}
	if s.PolicyTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyTemplateId"))
	}
	if s.PolicyTemplateId != nil && len(*s.PolicyTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyTemplateId", 1))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyTemplateId sets the PolicyTemplateId field's value.
func (s *TemplateLinkedPolicyDefinition) SetPolicyTemplateId(v string) *TemplateLinkedPolicyDefinition {
	s.PolicyTemplateId = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *TemplateLinkedPolicyDefinition) SetPrincipal(v *EntityIdentifier) *TemplateLinkedPolicyDefinition {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *TemplateLinkedPolicyDefinition) SetResource(v *EntityIdentifier) *TemplateLinkedPolicyDefinition {
	s.Resource = v
	return s
}

// Contains information about a policy that was created by instantiating a policy
// template.
type TemplateLinkedPolicyDefinitionDetail struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the policy template used to create this policy.
	//
	// PolicyTemplateId is a required field
	PolicyTemplateId *string `locationName:"policyTemplateId" min:"1" type:"string" required:"true"`

	// The principal associated with this template-linked policy. Verified Permissions
	// substitutes this principal for the ?principal placeholder in the policy template
	// when it evaluates an authorization request.
	Principal *EntityIdentifier `locationName:"principal" type:"structure"`

	// The resource associated with this template-linked policy. Verified Permissions
	// substitutes this resource for the ?resource placeholder in the policy template
	// when it evaluates an authorization request.
	Resource *EntityIdentifier `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateLinkedPolicyDefinitionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateLinkedPolicyDefinitionDetail) GoString() string {
	return s.String()
}

// SetPolicyTemplateId sets the PolicyTemplateId field's value.
func (s *TemplateLinkedPolicyDefinitionDetail) SetPolicyTemplateId(v string) *TemplateLinkedPolicyDefinitionDetail {
	s.PolicyTemplateId = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *TemplateLinkedPolicyDefinitionDetail) SetPrincipal(v *EntityIdentifier) *TemplateLinkedPolicyDefinitionDetail {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *TemplateLinkedPolicyDefinitionDetail) SetResource(v *EntityIdentifier) *TemplateLinkedPolicyDefinitionDetail {
	s.Resource = v
	return s
}

// Contains information about a policy created by instantiating a policy template.
//
// This
type TemplateLinkedPolicyDefinitionItem struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the policy template used to create this policy.
	//
	// PolicyTemplateId is a required field
	PolicyTemplateId *string `locationName:"policyTemplateId" min:"1" type:"string" required:"true"`

	// The principal associated with this template-linked policy. Verified Permissions
	// substitutes this principal for the ?principal placeholder in the policy template
	// when it evaluates an authorization request.
	Principal *EntityIdentifier `locationName:"principal" type:"structure"`

	// The resource associated with this template-linked policy. Verified Permissions
	// substitutes this resource for the ?resource placeholder in the policy template
	// when it evaluates an authorization request.
	Resource *EntityIdentifier `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateLinkedPolicyDefinitionItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateLinkedPolicyDefinitionItem) GoString() string {
	return s.String()
}

// SetPolicyTemplateId sets the PolicyTemplateId field's value.
func (s *TemplateLinkedPolicyDefinitionItem) SetPolicyTemplateId(v string) *TemplateLinkedPolicyDefinitionItem {
	s.PolicyTemplateId = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *TemplateLinkedPolicyDefinitionItem) SetPrincipal(v *EntityIdentifier) *TemplateLinkedPolicyDefinitionItem {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *TemplateLinkedPolicyDefinitionItem) SetResource(v *EntityIdentifier) *TemplateLinkedPolicyDefinitionItem {
	s.Resource = v
	return s
}

// The request failed because it exceeded a throttling quota.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The quota code recognized by the Amazon Web Services Service Quotas service.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The code for the Amazon Web Service that owns the quota.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The user group entities from an Amazon Cognito user pool identity source.
type UpdateCognitoGroupConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the schema entity type that's mapped to the user pool group.
	// Defaults to AWS::CognitoGroup.
	//
	// GroupEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateCognitoGroupConfiguration's
	// String and GoString methods.
	//
	// GroupEntityType is a required field
	GroupEntityType *string `locationName:"groupEntityType" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCognitoGroupConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCognitoGroupConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCognitoGroupConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCognitoGroupConfiguration"}
	if s.GroupEntityType == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupEntityType"))
	}
	if s.GroupEntityType != nil && len(*s.GroupEntityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupEntityType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupEntityType sets the GroupEntityType field's value.
func (s *UpdateCognitoGroupConfiguration) SetGroupEntityType(v string) *UpdateCognitoGroupConfiguration {
	s.GroupEntityType = &v
	return s
}

// Contains configuration details of a Amazon Cognito user pool for use with
// an identity source.
type UpdateCognitoUserPoolConfiguration struct {
	_ struct{} `type:"structure"`

	// The client ID of an app client that is configured for the specified Amazon
	// Cognito user pool.
	ClientIds []*string `locationName:"clientIds" type:"list"`

	// The configuration of the user groups from an Amazon Cognito user pool identity
	// source.
	GroupConfiguration *UpdateCognitoGroupConfiguration `locationName:"groupConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the Amazon Cognito user pool associated with this identity source.
	//
	// UserPoolArn is a required field
	UserPoolArn *string `locationName:"userPoolArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCognitoUserPoolConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCognitoUserPoolConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCognitoUserPoolConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCognitoUserPoolConfiguration"}
	if s.UserPoolArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolArn"))
	}
	if s.UserPoolArn != nil && len(*s.UserPoolArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolArn", 1))
	}
	if s.GroupConfiguration != nil {
		if err := s.GroupConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GroupConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientIds sets the ClientIds field's value.
func (s *UpdateCognitoUserPoolConfiguration) SetClientIds(v []*string) *UpdateCognitoUserPoolConfiguration {
	s.ClientIds = v
	return s
}

// SetGroupConfiguration sets the GroupConfiguration field's value.
func (s *UpdateCognitoUserPoolConfiguration) SetGroupConfiguration(v *UpdateCognitoGroupConfiguration) *UpdateCognitoUserPoolConfiguration {
	s.GroupConfiguration = v
	return s
}

// SetUserPoolArn sets the UserPoolArn field's value.
func (s *UpdateCognitoUserPoolConfiguration) SetUserPoolArn(v string) *UpdateCognitoUserPoolConfiguration {
	s.UserPoolArn = &v
	return s
}

// Contains an update to replace the configuration in an existing identity source.
type UpdateConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains configuration details of a Amazon Cognito user pool.
	CognitoUserPoolConfiguration *UpdateCognitoUserPoolConfiguration `locationName:"cognitoUserPoolConfiguration" type:"structure"`

	// Contains configuration details of an OpenID Connect (OIDC) identity provider,
	// or identity source, that Verified Permissions can use to generate entities
	// from authenticated identities. It specifies the issuer URL, token type that
	// you want to use, and policy store entity details.
	OpenIdConnectConfiguration *UpdateOpenIdConnectConfiguration `locationName:"openIdConnectConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfiguration"}
	if s.CognitoUserPoolConfiguration != nil {
		if err := s.CognitoUserPoolConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CognitoUserPoolConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OpenIdConnectConfiguration != nil {
		if err := s.OpenIdConnectConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OpenIdConnectConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCognitoUserPoolConfiguration sets the CognitoUserPoolConfiguration field's value.
func (s *UpdateConfiguration) SetCognitoUserPoolConfiguration(v *UpdateCognitoUserPoolConfiguration) *UpdateConfiguration {
	s.CognitoUserPoolConfiguration = v
	return s
}

// SetOpenIdConnectConfiguration sets the OpenIdConnectConfiguration field's value.
func (s *UpdateConfiguration) SetOpenIdConnectConfiguration(v *UpdateOpenIdConnectConfiguration) *UpdateConfiguration {
	s.OpenIdConnectConfiguration = v
	return s
}

type UpdateIdentitySourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the identity source that you want to update.
	//
	// IdentitySourceId is a required field
	IdentitySourceId *string `locationName:"identitySourceId" min:"1" type:"string" required:"true"`

	// Specifies the ID of the policy store that contains the identity source that
	// you want to update.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// Specifies the data type of principals generated for identities authenticated
	// by the identity source.
	//
	// PrincipalEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateIdentitySourceInput's
	// String and GoString methods.
	PrincipalEntityType *string `locationName:"principalEntityType" min:"1" type:"string" sensitive:"true"`

	// Specifies the details required to communicate with the identity provider
	// (IdP) associated with this identity source.
	//
	// At this time, the only valid member of this structure is a Amazon Cognito
	// user pool configuration.
	//
	// You must specify a userPoolArn, and optionally, a ClientId.
	//
	// UpdateConfiguration is a required field
	UpdateConfiguration *UpdateConfiguration `locationName:"updateConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdentitySourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdentitySourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIdentitySourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIdentitySourceInput"}
	if s.IdentitySourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentitySourceId"))
	}
	if s.IdentitySourceId != nil && len(*s.IdentitySourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentitySourceId", 1))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.PrincipalEntityType != nil && len(*s.PrincipalEntityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalEntityType", 1))
	}
	if s.UpdateConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateConfiguration"))
	}
	if s.UpdateConfiguration != nil {
		if err := s.UpdateConfiguration.Validate(); err != nil {
			invalidParams.AddNested("UpdateConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentitySourceId sets the IdentitySourceId field's value.
func (s *UpdateIdentitySourceInput) SetIdentitySourceId(v string) *UpdateIdentitySourceInput {
	s.IdentitySourceId = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *UpdateIdentitySourceInput) SetPolicyStoreId(v string) *UpdateIdentitySourceInput {
	s.PolicyStoreId = &v
	return s
}

// SetPrincipalEntityType sets the PrincipalEntityType field's value.
func (s *UpdateIdentitySourceInput) SetPrincipalEntityType(v string) *UpdateIdentitySourceInput {
	s.PrincipalEntityType = &v
	return s
}

// SetUpdateConfiguration sets the UpdateConfiguration field's value.
func (s *UpdateIdentitySourceInput) SetUpdateConfiguration(v *UpdateConfiguration) *UpdateIdentitySourceInput {
	s.UpdateConfiguration = v
	return s
}

type UpdateIdentitySourceOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the updated identity source was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ID of the updated identity source.
	//
	// IdentitySourceId is a required field
	IdentitySourceId *string `locationName:"identitySourceId" min:"1" type:"string" required:"true"`

	// The date and time that the identity source was most recently updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ID of the policy store that contains the updated identity source.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdentitySourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdentitySourceOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *UpdateIdentitySourceOutput) SetCreatedDate(v time.Time) *UpdateIdentitySourceOutput {
	s.CreatedDate = &v
	return s
}

// SetIdentitySourceId sets the IdentitySourceId field's value.
func (s *UpdateIdentitySourceOutput) SetIdentitySourceId(v string) *UpdateIdentitySourceOutput {
	s.IdentitySourceId = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *UpdateIdentitySourceOutput) SetLastUpdatedDate(v time.Time) *UpdateIdentitySourceOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *UpdateIdentitySourceOutput) SetPolicyStoreId(v string) *UpdateIdentitySourceOutput {
	s.PolicyStoreId = &v
	return s
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// access token claims. Contains the claim that you want to identify as the
// principal in an authorization request, and the values of the aud claim, or
// audiences, that you want to accept.
//
// This data type is part of a UpdateOpenIdConnectTokenSelection (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectTokenSelection.html)
// structure, which is a parameter to UpdateIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html).
type UpdateOpenIdConnectAccessTokenConfiguration struct {
	_ struct{} `type:"structure"`

	// The access token aud claim values that you want to accept in your policy
	// store. For example, https://myapp.example.com, https://myapp2.example.com.
	Audiences []*string `locationName:"audiences" min:"1" type:"list"`

	// The claim that determines the principal in OIDC access tokens. For example,
	// sub.
	//
	// PrincipalIdClaim is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateOpenIdConnectAccessTokenConfiguration's
	// String and GoString methods.
	PrincipalIdClaim *string `locationName:"principalIdClaim" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOpenIdConnectAccessTokenConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOpenIdConnectAccessTokenConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOpenIdConnectAccessTokenConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOpenIdConnectAccessTokenConfiguration"}
	if s.Audiences != nil && len(s.Audiences) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Audiences", 1))
	}
	if s.PrincipalIdClaim != nil && len(*s.PrincipalIdClaim) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalIdClaim", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudiences sets the Audiences field's value.
func (s *UpdateOpenIdConnectAccessTokenConfiguration) SetAudiences(v []*string) *UpdateOpenIdConnectAccessTokenConfiguration {
	s.Audiences = v
	return s
}

// SetPrincipalIdClaim sets the PrincipalIdClaim field's value.
func (s *UpdateOpenIdConnectAccessTokenConfiguration) SetPrincipalIdClaim(v string) *UpdateOpenIdConnectAccessTokenConfiguration {
	s.PrincipalIdClaim = &v
	return s
}

// Contains configuration details of an OpenID Connect (OIDC) identity provider,
// or identity source, that Verified Permissions can use to generate entities
// from authenticated identities. It specifies the issuer URL, token type that
// you want to use, and policy store entity details.
//
// This data type is part of a UpdateConfiguration (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateConfiguration.html)
// structure, which is a parameter to UpdateIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html).
type UpdateOpenIdConnectConfiguration struct {
	_ struct{} `type:"structure"`

	// A descriptive string that you want to prefix to user entities from your OIDC
	// identity provider. For example, if you set an entityIdPrefix of MyOIDCProvider,
	// you can reference principals in your policies in the format MyCorp::User::MyOIDCProvider|Carlos.
	//
	// EntityIdPrefix is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateOpenIdConnectConfiguration's
	// String and GoString methods.
	EntityIdPrefix *string `locationName:"entityIdPrefix" min:"1" type:"string" sensitive:"true"`

	// The claim in OIDC identity provider tokens that indicates a user's group
	// membership, and the entity type that you want to map it to. For example,
	// this object can map the contents of a groups claim to MyCorp::UserGroup.
	GroupConfiguration *UpdateOpenIdConnectGroupConfiguration `locationName:"groupConfiguration" type:"structure"`

	// The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery
	// endpoint at the path .well-known/openid-configuration.
	//
	// Issuer is a required field
	Issuer *string `locationName:"issuer" min:"1" type:"string" required:"true"`

	// The token type that you want to process from your OIDC identity provider.
	// Your policy store can process either identity (ID) or access tokens from
	// a given OIDC identity source.
	//
	// TokenSelection is a required field
	TokenSelection *UpdateOpenIdConnectTokenSelection `locationName:"tokenSelection" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOpenIdConnectConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOpenIdConnectConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOpenIdConnectConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOpenIdConnectConfiguration"}
	if s.EntityIdPrefix != nil && len(*s.EntityIdPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityIdPrefix", 1))
	}
	if s.Issuer == nil {
		invalidParams.Add(request.NewErrParamRequired("Issuer"))
	}
	if s.Issuer != nil && len(*s.Issuer) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Issuer", 1))
	}
	if s.TokenSelection == nil {
		invalidParams.Add(request.NewErrParamRequired("TokenSelection"))
	}
	if s.GroupConfiguration != nil {
		if err := s.GroupConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GroupConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.TokenSelection != nil {
		if err := s.TokenSelection.Validate(); err != nil {
			invalidParams.AddNested("TokenSelection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityIdPrefix sets the EntityIdPrefix field's value.
func (s *UpdateOpenIdConnectConfiguration) SetEntityIdPrefix(v string) *UpdateOpenIdConnectConfiguration {
	s.EntityIdPrefix = &v
	return s
}

// SetGroupConfiguration sets the GroupConfiguration field's value.
func (s *UpdateOpenIdConnectConfiguration) SetGroupConfiguration(v *UpdateOpenIdConnectGroupConfiguration) *UpdateOpenIdConnectConfiguration {
	s.GroupConfiguration = v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *UpdateOpenIdConnectConfiguration) SetIssuer(v string) *UpdateOpenIdConnectConfiguration {
	s.Issuer = &v
	return s
}

// SetTokenSelection sets the TokenSelection field's value.
func (s *UpdateOpenIdConnectConfiguration) SetTokenSelection(v *UpdateOpenIdConnectTokenSelection) *UpdateOpenIdConnectConfiguration {
	s.TokenSelection = v
	return s
}

// The claim in OIDC identity provider tokens that indicates a user's group
// membership, and the entity type that you want to map it to. For example,
// this object can map the contents of a groups claim to MyCorp::UserGroup.
//
// This data type is part of a UpdateOpenIdConnectConfiguration (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectConfiguration.html)
// structure, which is a parameter to UpdateIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html).
type UpdateOpenIdConnectGroupConfiguration struct {
	_ struct{} `type:"structure"`

	// The token claim that you want Verified Permissions to interpret as group
	// membership. For example, groups.
	//
	// GroupClaim is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateOpenIdConnectGroupConfiguration's
	// String and GoString methods.
	//
	// GroupClaim is a required field
	GroupClaim *string `locationName:"groupClaim" min:"1" type:"string" required:"true" sensitive:"true"`

	// The policy store entity type that you want to map your users' group claim
	// to. For example, MyCorp::UserGroup. A group entity type is an entity that
	// can have a user entity type as a member.
	//
	// GroupEntityType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateOpenIdConnectGroupConfiguration's
	// String and GoString methods.
	//
	// GroupEntityType is a required field
	GroupEntityType *string `locationName:"groupEntityType" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOpenIdConnectGroupConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOpenIdConnectGroupConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOpenIdConnectGroupConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOpenIdConnectGroupConfiguration"}
	if s.GroupClaim == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupClaim"))
	}
	if s.GroupClaim != nil && len(*s.GroupClaim) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupClaim", 1))
	}
	if s.GroupEntityType == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupEntityType"))
	}
	if s.GroupEntityType != nil && len(*s.GroupEntityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupEntityType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupClaim sets the GroupClaim field's value.
func (s *UpdateOpenIdConnectGroupConfiguration) SetGroupClaim(v string) *UpdateOpenIdConnectGroupConfiguration {
	s.GroupClaim = &v
	return s
}

// SetGroupEntityType sets the GroupEntityType field's value.
func (s *UpdateOpenIdConnectGroupConfiguration) SetGroupEntityType(v string) *UpdateOpenIdConnectGroupConfiguration {
	s.GroupEntityType = &v
	return s
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// identity (ID) token claims. Contains the claim that you want to identify
// as the principal in an authorization request, and the values of the aud claim,
// or audiences, that you want to accept.
//
// This data type is part of a UpdateOpenIdConnectTokenSelection (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectTokenSelection.html)
// structure, which is a parameter to UpdateIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html).
type UpdateOpenIdConnectIdentityTokenConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID token audience, or client ID, claim values that you want to accept
	// in your policy store from an OIDC identity provider. For example, 1example23456789,
	// 2example10111213.
	ClientIds []*string `locationName:"clientIds" type:"list"`

	// The claim that determines the principal in OIDC access tokens. For example,
	// sub.
	//
	// PrincipalIdClaim is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateOpenIdConnectIdentityTokenConfiguration's
	// String and GoString methods.
	PrincipalIdClaim *string `locationName:"principalIdClaim" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOpenIdConnectIdentityTokenConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOpenIdConnectIdentityTokenConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOpenIdConnectIdentityTokenConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOpenIdConnectIdentityTokenConfiguration"}
	if s.PrincipalIdClaim != nil && len(*s.PrincipalIdClaim) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalIdClaim", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientIds sets the ClientIds field's value.
func (s *UpdateOpenIdConnectIdentityTokenConfiguration) SetClientIds(v []*string) *UpdateOpenIdConnectIdentityTokenConfiguration {
	s.ClientIds = v
	return s
}

// SetPrincipalIdClaim sets the PrincipalIdClaim field's value.
func (s *UpdateOpenIdConnectIdentityTokenConfiguration) SetPrincipalIdClaim(v string) *UpdateOpenIdConnectIdentityTokenConfiguration {
	s.PrincipalIdClaim = &v
	return s
}

// The token type that you want to process from your OIDC identity provider.
// Your policy store can process either identity (ID) or access tokens from
// a given OIDC identity source.
//
// This data type is part of a UpdateOpenIdConnectConfiguration (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectConfiguration.html)
// structure, which is a parameter to UpdateIdentitySource (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html).
type UpdateOpenIdConnectTokenSelection struct {
	_ struct{} `type:"structure"`

	// The OIDC configuration for processing access tokens. Contains allowed audience
	// claims, for example https://auth.example.com, and the claim that you want
	// to map to the principal, for example sub.
	AccessTokenOnly *UpdateOpenIdConnectAccessTokenConfiguration `locationName:"accessTokenOnly" type:"structure"`

	// The OIDC configuration for processing identity (ID) tokens. Contains allowed
	// client ID claims, for example 1example23456789, and the claim that you want
	// to map to the principal, for example sub.
	IdentityTokenOnly *UpdateOpenIdConnectIdentityTokenConfiguration `locationName:"identityTokenOnly" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOpenIdConnectTokenSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOpenIdConnectTokenSelection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOpenIdConnectTokenSelection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOpenIdConnectTokenSelection"}
	if s.AccessTokenOnly != nil {
		if err := s.AccessTokenOnly.Validate(); err != nil {
			invalidParams.AddNested("AccessTokenOnly", err.(request.ErrInvalidParams))
		}
	}
	if s.IdentityTokenOnly != nil {
		if err := s.IdentityTokenOnly.Validate(); err != nil {
			invalidParams.AddNested("IdentityTokenOnly", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessTokenOnly sets the AccessTokenOnly field's value.
func (s *UpdateOpenIdConnectTokenSelection) SetAccessTokenOnly(v *UpdateOpenIdConnectAccessTokenConfiguration) *UpdateOpenIdConnectTokenSelection {
	s.AccessTokenOnly = v
	return s
}

// SetIdentityTokenOnly sets the IdentityTokenOnly field's value.
func (s *UpdateOpenIdConnectTokenSelection) SetIdentityTokenOnly(v *UpdateOpenIdConnectIdentityTokenConfiguration) *UpdateOpenIdConnectTokenSelection {
	s.IdentityTokenOnly = v
	return s
}

// Contains information about updates to be applied to a policy.
//
// This data type is used as a request parameter in the UpdatePolicy (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicy.html)
// operation.
type UpdatePolicyDefinition struct {
	_ struct{} `type:"structure"`

	// Contains details about the updates to be applied to a static policy.
	Static *UpdateStaticPolicyDefinition `locationName:"static" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePolicyDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePolicyDefinition"}
	if s.Static != nil {
		if err := s.Static.Validate(); err != nil {
			invalidParams.AddNested("Static", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatic sets the Static field's value.
func (s *UpdatePolicyDefinition) SetStatic(v *UpdateStaticPolicyDefinition) *UpdatePolicyDefinition {
	s.Static = v
	return s
}

type UpdatePolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the updated policy content that you want to replace on the specified
	// policy. The content must be valid Cedar policy language text.
	//
	// You can change only the following elements from the policy definition:
	//
	//    * The action referenced by the policy.
	//
	//    * Any conditional clauses, such as when or unless clauses.
	//
	// You can't change the following elements:
	//
	//    * Changing from static to templateLinked.
	//
	//    * Changing the effect of the policy from permit or forbid.
	//
	//    * The principal referenced by the policy.
	//
	//    * The resource referenced by the policy.
	//
	// Definition is a required field
	Definition *UpdatePolicyDefinition `locationName:"definition" type:"structure" required:"true"`

	// Specifies the ID of the policy that you want to update. To find this value,
	// you can use ListPolicies (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html).
	//
	// PolicyId is a required field
	PolicyId *string `locationName:"policyId" min:"1" type:"string" required:"true"`

	// Specifies the ID of the policy store that contains the policy that you want
	// to update.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePolicyInput"}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 1))
	}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefinition sets the Definition field's value.
func (s *UpdatePolicyInput) SetDefinition(v *UpdatePolicyDefinition) *UpdatePolicyInput {
	s.Definition = v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *UpdatePolicyInput) SetPolicyId(v string) *UpdatePolicyInput {
	s.PolicyId = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *UpdatePolicyInput) SetPolicyStoreId(v string) *UpdatePolicyInput {
	s.PolicyStoreId = &v
	return s
}

type UpdatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The action that a policy permits or forbids. For example, {"actions": [{"actionId":
	// "ViewPhoto", "actionType": "PhotoFlash::Action"}, {"entityID": "SharePhoto",
	// "entityType": "PhotoFlash::Action"}]}.
	Actions []*ActionIdentifier `locationName:"actions" type:"list"`

	// The date and time that the policy was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The effect of the decision that a policy returns to an authorization request.
	// For example, "effect": "Permit".
	Effect *string `locationName:"effect" type:"string" enum:"PolicyEffect"`

	// The date and time that the policy was most recently updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ID of the policy that was updated.
	//
	// PolicyId is a required field
	PolicyId *string `locationName:"policyId" min:"1" type:"string" required:"true"`

	// The ID of the policy store that contains the policy that was updated.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// The type of the policy that was updated.
	//
	// PolicyType is a required field
	PolicyType *string `locationName:"policyType" type:"string" required:"true" enum:"PolicyType"`

	// The principal specified in the policy's scope. This element isn't included
	// in the response when Principal isn't present in the policy content.
	Principal *EntityIdentifier `locationName:"principal" type:"structure"`

	// The resource specified in the policy's scope. This element isn't included
	// in the response when Resource isn't present in the policy content.
	Resource *EntityIdentifier `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyOutput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *UpdatePolicyOutput) SetActions(v []*ActionIdentifier) *UpdatePolicyOutput {
	s.Actions = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *UpdatePolicyOutput) SetCreatedDate(v time.Time) *UpdatePolicyOutput {
	s.CreatedDate = &v
	return s
}

// SetEffect sets the Effect field's value.
func (s *UpdatePolicyOutput) SetEffect(v string) *UpdatePolicyOutput {
	s.Effect = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *UpdatePolicyOutput) SetLastUpdatedDate(v time.Time) *UpdatePolicyOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *UpdatePolicyOutput) SetPolicyId(v string) *UpdatePolicyOutput {
	s.PolicyId = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *UpdatePolicyOutput) SetPolicyStoreId(v string) *UpdatePolicyOutput {
	s.PolicyStoreId = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *UpdatePolicyOutput) SetPolicyType(v string) *UpdatePolicyOutput {
	s.PolicyType = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *UpdatePolicyOutput) SetPrincipal(v *EntityIdentifier) *UpdatePolicyOutput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *UpdatePolicyOutput) SetResource(v *EntityIdentifier) *UpdatePolicyOutput {
	s.Resource = v
	return s
}

type UpdatePolicyStoreInput struct {
	_ struct{} `type:"structure"`

	// Descriptive text that you can provide to help with identification of the
	// current policy store.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePolicyStoreInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// Specifies the ID of the policy store that you want to update
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// A structure that defines the validation settings that want to enable for
	// the policy store.
	//
	// ValidationSettings is a required field
	ValidationSettings *ValidationSettings `locationName:"validationSettings" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePolicyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePolicyStoreInput"}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.ValidationSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationSettings"))
	}
	if s.ValidationSettings != nil {
		if err := s.ValidationSettings.Validate(); err != nil {
			invalidParams.AddNested("ValidationSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdatePolicyStoreInput) SetDescription(v string) *UpdatePolicyStoreInput {
	s.Description = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *UpdatePolicyStoreInput) SetPolicyStoreId(v string) *UpdatePolicyStoreInput {
	s.PolicyStoreId = &v
	return s
}

// SetValidationSettings sets the ValidationSettings field's value.
func (s *UpdatePolicyStoreInput) SetValidationSettings(v *ValidationSettings) *UpdatePolicyStoreInput {
	s.ValidationSettings = v
	return s
}

type UpdatePolicyStoreOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the updated policy store.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The date and time that the policy store was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date and time that the policy store was most recently updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ID of the updated policy store.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyStoreOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdatePolicyStoreOutput) SetArn(v string) *UpdatePolicyStoreOutput {
	s.Arn = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *UpdatePolicyStoreOutput) SetCreatedDate(v time.Time) *UpdatePolicyStoreOutput {
	s.CreatedDate = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *UpdatePolicyStoreOutput) SetLastUpdatedDate(v time.Time) *UpdatePolicyStoreOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *UpdatePolicyStoreOutput) SetPolicyStoreId(v string) *UpdatePolicyStoreOutput {
	s.PolicyStoreId = &v
	return s
}

type UpdatePolicyTemplateInput struct {
	_ struct{} `type:"structure"`

	// Specifies a new description to apply to the policy template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePolicyTemplateInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// Specifies the ID of the policy store that contains the policy template that
	// you want to update.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// Specifies the ID of the policy template that you want to update.
	//
	// PolicyTemplateId is a required field
	PolicyTemplateId *string `locationName:"policyTemplateId" min:"1" type:"string" required:"true"`

	// Specifies new statement content written in Cedar policy language to replace
	// the current body of the policy template.
	//
	// You can change only the following elements of the policy body:
	//
	//    * The action referenced by the policy template.
	//
	//    * Any conditional clauses, such as when or unless clauses.
	//
	// You can't change the following elements:
	//
	//    * The effect (permit or forbid) of the policy template.
	//
	//    * The principal referenced by the policy template.
	//
	//    * The resource referenced by the policy template.
	//
	// Statement is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePolicyTemplateInput's
	// String and GoString methods.
	//
	// Statement is a required field
	Statement *string `locationName:"statement" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePolicyTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePolicyTemplateInput"}
	if s.PolicyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStoreId"))
	}
	if s.PolicyStoreId != nil && len(*s.PolicyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyStoreId", 1))
	}
	if s.PolicyTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyTemplateId"))
	}
	if s.PolicyTemplateId != nil && len(*s.PolicyTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyTemplateId", 1))
	}
	if s.Statement == nil {
		invalidParams.Add(request.NewErrParamRequired("Statement"))
	}
	if s.Statement != nil && len(*s.Statement) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statement", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdatePolicyTemplateInput) SetDescription(v string) *UpdatePolicyTemplateInput {
	s.Description = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *UpdatePolicyTemplateInput) SetPolicyStoreId(v string) *UpdatePolicyTemplateInput {
	s.PolicyStoreId = &v
	return s
}

// SetPolicyTemplateId sets the PolicyTemplateId field's value.
func (s *UpdatePolicyTemplateInput) SetPolicyTemplateId(v string) *UpdatePolicyTemplateInput {
	s.PolicyTemplateId = &v
	return s
}

// SetStatement sets the Statement field's value.
func (s *UpdatePolicyTemplateInput) SetStatement(v string) *UpdatePolicyTemplateInput {
	s.Statement = &v
	return s
}

type UpdatePolicyTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the policy template was originally created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date and time that the policy template was most recently updated.
	//
	// LastUpdatedDate is a required field
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ID of the policy store that contains the updated policy template.
	//
	// PolicyStoreId is a required field
	PolicyStoreId *string `locationName:"policyStoreId" min:"1" type:"string" required:"true"`

	// The ID of the updated policy template.
	//
	// PolicyTemplateId is a required field
	PolicyTemplateId *string `locationName:"policyTemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicyTemplateOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *UpdatePolicyTemplateOutput) SetCreatedDate(v time.Time) *UpdatePolicyTemplateOutput {
	s.CreatedDate = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *UpdatePolicyTemplateOutput) SetLastUpdatedDate(v time.Time) *UpdatePolicyTemplateOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetPolicyStoreId sets the PolicyStoreId field's value.
func (s *UpdatePolicyTemplateOutput) SetPolicyStoreId(v string) *UpdatePolicyTemplateOutput {
	s.PolicyStoreId = &v
	return s
}

// SetPolicyTemplateId sets the PolicyTemplateId field's value.
func (s *UpdatePolicyTemplateOutput) SetPolicyTemplateId(v string) *UpdatePolicyTemplateOutput {
	s.PolicyTemplateId = &v
	return s
}

// Contains information about an update to a static policy.
type UpdateStaticPolicyDefinition struct {
	_ struct{} `type:"structure"`

	// Specifies the description to be added to or replaced on the static policy.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateStaticPolicyDefinition's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// Specifies the Cedar policy language text to be added to or replaced on the
	// static policy.
	//
	// You can change only the following elements from the original content:
	//
	//    * The action referenced by the policy.
	//
	//    * Any conditional clauses, such as when or unless clauses.
	//
	// You can't change the following elements:
	//
	//    * Changing from StaticPolicy to TemplateLinkedPolicy.
	//
	//    * The effect (permit or forbid) of the policy.
	//
	//    * The principal referenced by the policy.
	//
	//    * The resource referenced by the policy.
	//
	// Statement is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateStaticPolicyDefinition's
	// String and GoString methods.
	//
	// Statement is a required field
	Statement *string `locationName:"statement" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStaticPolicyDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStaticPolicyDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStaticPolicyDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStaticPolicyDefinition"}
	if s.Statement == nil {
		invalidParams.Add(request.NewErrParamRequired("Statement"))
	}
	if s.Statement != nil && len(*s.Statement) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statement", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateStaticPolicyDefinition) SetDescription(v string) *UpdateStaticPolicyDefinition {
	s.Description = &v
	return s
}

// SetStatement sets the Statement field's value.
func (s *UpdateStaticPolicyDefinition) SetStatement(v string) *UpdateStaticPolicyDefinition {
	s.Statement = &v
	return s
}

// The request failed because one or more input parameters don't satisfy their
// constraint requirements. The output is provided as a list of fields and a
// reason for each field that isn't valid.
//
// The possible reasons include the following:
//
//   - UnrecognizedEntityType The policy includes an entity type that isn't
//     found in the schema.
//
//   - UnrecognizedActionId The policy includes an action id that isn't found
//     in the schema.
//
//   - InvalidActionApplication The policy includes an action that, according
//     to the schema, doesn't support the specified principal and resource.
//
//   - UnexpectedType The policy included an operand that isn't a valid type
//     for the specified operation.
//
//   - IncompatibleTypes The types of elements included in a set, or the types
//     of expressions used in an if...then...else clause aren't compatible in
//     this context.
//
//   - MissingAttribute The policy attempts to access a record or entity attribute
//     that isn't specified in the schema. Test for the existence of the attribute
//     first before attempting to access its value. For more information, see
//     the has (presence of attribute test) operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - UnsafeOptionalAttributeAccess The policy attempts to access a record
//     or entity attribute that is optional and isn't guaranteed to be present.
//     Test for the existence of the attribute first before attempting to access
//     its value. For more information, see the has (presence of attribute test)
//     operator (https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test)
//     in the Cedar Policy Language Guide.
//
//   - ImpossiblePolicy Cedar has determined that a policy condition always
//     evaluates to false. If the policy is always false, it can never apply
//     to any query, and so it can never affect an authorization decision.
//
//   - WrongNumberArguments The policy references an extension type with the
//     wrong number of arguments.
//
//   - FunctionArgumentValidationError Cedar couldn't parse the argument passed
//     to an extension type. For example, a string that is to be parsed as an
//     IPv4 address can contain only digits and the period character.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The list of fields that aren't valid.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about a field that failed policy validation.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Describes the policy validation error.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The path to the specific element that Verified Permissions found to be not
	// valid.
	//
	// Path is a required field
	Path *string `locationName:"path" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetPath sets the Path field's value.
func (s *ValidationExceptionField) SetPath(v string) *ValidationExceptionField {
	s.Path = &v
	return s
}

// A structure that contains Cedar policy validation settings for the policy
// store. The validation mode determines which validation failures that Cedar
// considers serious enough to block acceptance of a new or edited static policy
// or policy template.
//
// This data type is used as a request parameter in the CreatePolicyStore (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicyStore.html)
// and UpdatePolicyStore (https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore.html)
// operations.
type ValidationSettings struct {
	_ struct{} `type:"structure"`

	// The validation mode currently configured for this policy store. The valid
	// values are:
	//
	//    * OFF – Neither Verified Permissions nor Cedar perform any validation
	//    on policies. No validation errors are reported by either service.
	//
	//    * STRICT – Requires a schema to be present in the policy store. Cedar
	//    performs validation on all submitted new or updated static policies and
	//    policy templates. Any that fail validation are rejected and Cedar doesn't
	//    store them in the policy store.
	//
	// If Mode=STRICT and the policy store doesn't contain a schema, Verified Permissions
	// rejects all static policies and policy templates because there is no schema
	// to validate against.
	//
	// To submit a static policy or policy template without a schema, you must turn
	// off validation.
	//
	// Mode is a required field
	Mode *string `locationName:"mode" type:"string" required:"true" enum:"ValidationMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidationSettings"}
	if s.Mode == nil {
		invalidParams.Add(request.NewErrParamRequired("Mode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMode sets the Mode field's value.
func (s *ValidationSettings) SetMode(v string) *ValidationSettings {
	s.Mode = &v
	return s
}

const (
	// DecisionAllow is a Decision enum value
	DecisionAllow = "ALLOW"

	// DecisionDeny is a Decision enum value
	DecisionDeny = "DENY"
)

// Decision_Values returns all elements of the Decision enum
func Decision_Values() []string {
	return []string{
		DecisionAllow,
		DecisionDeny,
	}
}

const (
	// OpenIdIssuerCognito is a OpenIdIssuer enum value
	OpenIdIssuerCognito = "COGNITO"
)

// OpenIdIssuer_Values returns all elements of the OpenIdIssuer enum
func OpenIdIssuer_Values() []string {
	return []string{
		OpenIdIssuerCognito,
	}
}

const (
	// PolicyEffectPermit is a PolicyEffect enum value
	PolicyEffectPermit = "Permit"

	// PolicyEffectForbid is a PolicyEffect enum value
	PolicyEffectForbid = "Forbid"
)

// PolicyEffect_Values returns all elements of the PolicyEffect enum
func PolicyEffect_Values() []string {
	return []string{
		PolicyEffectPermit,
		PolicyEffectForbid,
	}
}

const (
	// PolicyTypeStatic is a PolicyType enum value
	PolicyTypeStatic = "STATIC"

	// PolicyTypeTemplateLinked is a PolicyType enum value
	PolicyTypeTemplateLinked = "TEMPLATE_LINKED"
)

// PolicyType_Values returns all elements of the PolicyType enum
func PolicyType_Values() []string {
	return []string{
		PolicyTypeStatic,
		PolicyTypeTemplateLinked,
	}
}

const (
	// ResourceTypeIdentitySource is a ResourceType enum value
	ResourceTypeIdentitySource = "IDENTITY_SOURCE"

	// ResourceTypePolicyStore is a ResourceType enum value
	ResourceTypePolicyStore = "POLICY_STORE"

	// ResourceTypePolicy is a ResourceType enum value
	ResourceTypePolicy = "POLICY"

	// ResourceTypePolicyTemplate is a ResourceType enum value
	ResourceTypePolicyTemplate = "POLICY_TEMPLATE"

	// ResourceTypeSchema is a ResourceType enum value
	ResourceTypeSchema = "SCHEMA"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeIdentitySource,
		ResourceTypePolicyStore,
		ResourceTypePolicy,
		ResourceTypePolicyTemplate,
		ResourceTypeSchema,
	}
}

const (
	// ValidationModeOff is a ValidationMode enum value
	ValidationModeOff = "OFF"

	// ValidationModeStrict is a ValidationMode enum value
	ValidationModeStrict = "STRICT"
)

// ValidationMode_Values returns all elements of the ValidationMode enum
func ValidationMode_Values() []string {
	return []string{
		ValidationModeOff,
		ValidationModeStrict,
	}
}
