/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.ManagedRuleProvider;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.internal.provider.AbstractResourceBundleProvider;
import org.openhab.core.automation.internal.provider.Vendor;
import org.openhab.core.automation.parser.Parser;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class RuleResourceBundleImporter
extends AbstractResourceBundleProvider<Rule> {
    protected @Nullable ManagedRuleProvider mProvider;

    public RuleResourceBundleImporter() {
        super("OH-INF/automation/rules/");
    }

    protected void setManagedRuleProvider(ManagedRuleProvider mProvider) {
        this.mProvider = mProvider;
    }

    @Override
    public void deactivate() {
        this.mProvider = null;
        super.deactivate();
    }

    @Override
    protected void processAutomationProvider(Bundle bundle) {
        String bsn = bundle.getSymbolicName();
        if (bsn == null) {
            bsn = String.format("@bundleId@0x%x", bundle.getBundleId());
        }
        Vendor vendor = new Vendor(bsn, bundle.getVersion().toString());
        this.logger.debug("Parse rules from bundle '{}' ", (Object)bsn);
        Enumeration urlEnum = null;
        try {
            if (bundle.getState() != 1) {
                urlEnum = bundle.findEntries(this.path, null, true);
            }
        }
        catch (IllegalStateException e) {
            this.logger.debug("Can't read from resource of bundle with ID {}. The bundle is uninstalled.", (Object)bundle.getBundleId(), (Object)e);
            this.processAutomationProviderUninstalled(bundle);
        }
        if (urlEnum != null) {
            while (urlEnum.hasMoreElements()) {
                Set<Rule> parsedObjects;
                URL url = (URL)urlEnum.nextElement();
                if (!(this.getPreviousPortfolio(vendor).isEmpty() || this.waitingProviders.get(bundle) != null && ((List)this.waitingProviders.get(bundle)).contains(url))) {
                    return;
                }
                if (url.getPath().endsWith(File.separator)) continue;
                String parserType = this.getParserType(url);
                Parser parser = (Parser)this.parsers.get(parserType);
                this.updateWaitingProviders(parser, bundle, url);
                if (parser == null || (parsedObjects = this.parseData(parser, url, bundle)).isEmpty()) continue;
                this.addNewProvidedObjects(List.of(), List.of(), parsedObjects);
            }
            this.putNewPortfolio(vendor, List.of());
        }
    }

    @Override
    protected void addNewProvidedObjects(List<String> newPortfolio, List<String> previousPortfolio, Set<Rule> parsedObjects) {
        if (parsedObjects != null && !parsedObjects.isEmpty()) {
            for (Rule rule : parsedObjects) {
                if (rule == null) continue;
                try {
                    this.mProvider.add(rule);
                }
                catch (IllegalArgumentException e) {
                    this.logger.debug("Not importing rule '{}' because: {}", new Object[]{rule.getUID(), e.getMessage(), e});
                }
                catch (IllegalStateException e) {
                    this.logger.debug("Not importing rule '{}' since the rule registry is in an invalid state: {}", (Object)rule.getUID(), (Object)e.getMessage());
                }
            }
        }
    }

    @Override
    protected List<String> getPreviousPortfolio(Vendor vendor) {
        List portfolio = (List)this.providerPortfolio.get(vendor);
        if (portfolio == null) {
            for (Map.Entry entry : this.providerPortfolio.entrySet()) {
                if (!((Vendor)entry.getKey()).getVendorSymbolicName().equals(vendor.getVendorSymbolicName())) continue;
                return (List)entry.getValue();
            }
        }
        return portfolio == null ? List.of() : portfolio;
    }

    @Override
    protected void processAutomationProviderUninstalled(Bundle bundle) {
        String bsn = bundle.getSymbolicName();
        if (bsn == null) {
            bsn = String.format("@bundleId@0x%x", bundle.getBundleId());
        }
        Vendor vendor = new Vendor(bsn, bundle.getVersion().toString());
        this.waitingProviders.remove(bundle);
        this.providerPortfolio.remove(vendor);
    }

    @Override
    protected String getUID(Rule parsedObject) {
        return parsedObject.getUID();
    }
}

