﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codeconnections/model/UpdateHostRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CodeConnections::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateHostRequest::SerializePayload() const {
  JsonValue payload;

  if (m_hostArnHasBeenSet) {
    payload.WithString("HostArn", m_hostArn);
  }

  if (m_providerEndpointHasBeenSet) {
    payload.WithString("ProviderEndpoint", m_providerEndpoint);
  }

  if (m_vpcConfigurationHasBeenSet) {
    payload.WithObject("VpcConfiguration", m_vpcConfiguration.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdateHostRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "com.amazonaws.codeconnections.CodeConnections_20231201.UpdateHost"));
  return headers;
}
