//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file DetectorConstruction.hh
/// \brief Definition of the DetectorConstruction class

#ifndef DetectorConstruction_h
#define DetectorConstruction_h 1

#include "G4VUserDetectorConstruction.hh"
#include "globals.hh"

class G4LogicalVolume;
class G4Material;
class DetectorMessenger;

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

class DetectorConstruction : public G4VUserDetectorConstruction
{
  public:
    DetectorConstruction();
    ~DetectorConstruction();

  public:
    G4VPhysicalVolume* Construct() override;
    void ConstructSDandField() override;

    void SetSizeXY(G4double);
    void SetSizeZ(G4double);
    void SetTargetMaterial(G4String);
    void SetWorldMaterial(G4String);

    void UpdateGeometry();

  public:
    const G4VPhysicalVolume* GetWorld() { return fWorld; };
    const G4VPhysicalVolume* GetBox() { return fBox; };

    G4double GetWorldSize() { return fWorldSize; };
    G4double GetBoxSizeXY() { return fBoxSizeXY; };
    G4double GetBoxSizeZ() { return fBoxSizeZ; };
    G4Material* GetMaterial() { return fTargetMaterial; };

  private:
    void ConstructMaterials();

    void PrintParameters();

  private:
    G4VPhysicalVolume* fWorld;
    G4VPhysicalVolume* fBox;

    G4double fBoxSizeXY;
    G4double fBoxSizeZ;
    G4double fWorldSize;
    G4Material* fTargetMaterial;
    G4Material* fWorldMaterial;

    DetectorMessenger* fMessenger;
};

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#endif
