\page README_extended Extended Examples

The set of "extended" examples is covering various 
use-cases and may require some additional libraries besides of Geant4. 

## Extended level examples:

- [analysis](\ref Examples_analysis)
   - Histogramming through the Geant4 analysis and external tools
- [biasing](\ref Examples_biasing)
   - Examples of event biasing, scoring and reverse-MC- 
- [common](\ref Examples_common)
   - A set of common classes which can be reused in other examples demonstrating just a particular feature
- [electromagnetic](\ref Examples_electromagnetic)
   - Specific EM physics simulation with histogramming
- [errorpropagation](\ref Examples_errorpropagation)
   - Use of the error propagation utility (Geant4e)
- [eventgenerator](\ref Examples_eventgenerator)
   - Applications demonstrating various ways of primary event generation:
     using Geant4 particle gun, Geant4 general particle source,
     using interface to HepMC, Pythia
- [exoticphysics](\ref Examples_exoticphysics)
   - Exotic simulation applications (classical magnetic monopole, etc...)
- [field](\ref Examples_field)
   - Specific simulation setups in magnetic field
- [g3tog3](\ref Examples_g3tog4)
   - Examples of usage of the g3tog4 converter tool
- [geometry](\ref Examples_geometry)
   - Specific geometry examples
- [hadronic](\ref Examples_hadronic)
   - Specific hadronic physics simulation with histogramming
- [medical](\ref Examples_medical)
   - Specific examples for medical physics applications
- [optical](\ref Examples_optical)
   - Examples of generic optical processes simulation setups
- [parallel](\ref Examples_parallel)
   - Examples of event-level parallelism in Geant4 using the
     MPI technique and underlying types of atomics
- [parameterisations](\ref Examples_parameterisations)
   - Examples for fast shower parameterisations according to specific models 
     (gflash) and an example to demonstrates how to use the Machine Learning (ML) inference
- [persistency](\ref Examples_persistency)
   - Persistency of geometry (GDML or ASCII) and simulation output
- [physicslists](\ref Examples_physicslists)
   - Examples to demonstrate usage of Geant4 reference physics lists and physics builders
- [polarisation](\ref Examples_polarisation)
   - Use of physics processes including polarization
- [radioactivedecay](\ref Examples_radioactivedecay)
   - Examples to simulate the decays of radioactive isotopes and
     induced radioactivity resulted from nuclear interactions
- [runAndEvent](\ref Examples_runAndEvent)
   - Examples to demonstrate how to connect the information between
     primary particles and hits and utilize user-information classes
- [visualization](\ref Examples_visualization)
   - Specific visualization features and graphical customisations

