/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.internal.p2.ui.model.RollbackProfileElement;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class ProfileSnapshots
extends ProvElement
implements IDeferredWorkbenchAdapter {
    String profileId;
    ProvisioningSession session;

    public ProfileSnapshots(String profileId, ProvisioningSession session) {
        super(null);
        this.profileId = profileId;
        this.session = session;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public Object[] getChildren(Object o) {
        IProfileRegistry registry = ProvUI.getProfileRegistry(this.session);
        long[] timestamps = registry.listProfileTimestamps(this.profileId);
        Map hidden = registry.getProfileStateProperties(this.profileId, "org.eclipse.equinox.p2.state.hidden");
        Map tag = registry.getProfileStateProperties(this.profileId, "org.eclipse.equinox.p2.state.tag");
        ArrayList<RollbackProfileElement> elements = new ArrayList<RollbackProfileElement>();
        int i = 0;
        while (i < timestamps.length) {
            if (!hidden.containsKey(String.valueOf(timestamps[i]))) {
                RollbackProfileElement element = null;
                String timestamp = String.valueOf(timestamps[i]);
                element = !tag.containsKey(timestamp) ? new RollbackProfileElement(this, this.profileId, timestamps[i]) : new RollbackProfileElement(this, this.profileId, timestamps[i], (String)tag.get(timestamp));
                elements.add(element);
                if (i == 0 && element.getChildren(element).length == 0) {
                    elements.clear();
                }
            }
            ++i;
        }
        if (elements.size() > 0) {
            ((RollbackProfileElement)elements.get(elements.size() - 1)).setIsCurrentProfile(true);
        }
        return elements.toArray(new RollbackProfileElement[elements.size()]);
    }

    public String getLabel(Object o) {
        return ProvUIMessages.ProfileSnapshots_Label;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        Object[] children = this.getChildren(object);
        collector.add(children, monitor);
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return false;
    }
}

