# -*- coding: utf-8 -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.

from gallery_dl.extractor import danbooru


__tests__ = (
{
    "#url"     : "https://danbooru.donmai.us/posts?tags=bonocho",
    "#category": ("Danbooru", "danbooru", "tag"),
    "#class"   : danbooru.DanbooruTagExtractor,
    "#sha1_content": "b196fb9f1668109d7774a0a82efea3ffdda07746",
},

{
    "#url"     : "https://danbooru.donmai.us/posts?tags=mushishi",
    "#comment" : "test page transitions",
    "#category": ("Danbooru", "danbooru", "tag"),
    "#class"   : danbooru.DanbooruTagExtractor,
    "#count"   : ">= 300",
},

{
    "#url"     : "https://danbooru.donmai.us/posts?tags=pixiv_id%3A1476533",
    "#comment" : "'external' option (#1747)",
    "#category": ("Danbooru", "danbooru", "tag"),
    "#class"   : danbooru.DanbooruTagExtractor,
    "#options" : {"external": True},
    "#pattern" : r"https://i\.pximg\.net/img-original/img/2008/08/28/02/35/48/1476533_p0\.jpg",
},

{
    "#url"     : "https://hijiribe.donmai.us/posts?tags=bonocho",
    "#category": ("Danbooru", "danbooru", "tag"),
    "#class"   : danbooru.DanbooruTagExtractor,
},

{
    "#url"     : "https://sonohara.donmai.us/posts?tags=bonocho",
    "#category": ("Danbooru", "danbooru", "tag"),
    "#class"   : danbooru.DanbooruTagExtractor,
},

{
    "#url"     : "https://safebooru.donmai.us/posts?tags=bonocho",
    "#category": ("Danbooru", "danbooru", "tag"),
    "#class"   : danbooru.DanbooruTagExtractor,
},

{
    "#url"     : "https://donmai.moe/posts?tags=bonocho",
    "#category": ("Danbooru", "danbooru", "tag"),
    "#class"   : danbooru.DanbooruTagExtractor,
},

{
    "#url"     : "https://danbooru.donmai.us/pools/7659",
    "#category": ("Danbooru", "danbooru", "pool"),
    "#class"   : danbooru.DanbooruPoolExtractor,
    "#auth"    : False,
    "#sha1_content": "15226ba183579bc2cdd67260445b5c97959a3e82",
    "#results"     : (
        "https://cdn.donmai.us/original/d8/3d/d83df4af8c0fa6d6069f8d3cf0b7dd56.jpg",
        "https://cdn.donmai.us/original/70/82/7082572fa74650f3c1f39152550cd724.jpg",
        "https://cdn.donmai.us/original/7a/b5/7ab551d011b89155a743d81308de653a.jpg",
        "https://cdn.donmai.us/original/fd/d3/fdd31d7feb62e2a90de950765aa556b9.jpg",
        "https://cdn.donmai.us/original/e7/11/e71119c20e1f7f7be829c168786ba807.jpg",
        "https://cdn.donmai.us/original/65/ae/65ae1865ebfe490a00039832cd0ce16a.jpg",
        "https://cdn.donmai.us/original/c3/e8/c3e82e213e6fa83fbe9c00659114c2d6.jpg",
        "https://cdn.donmai.us/original/58/64/586438b110b88aef5f2bf14c19e7102d.jpg",
    ),

    "num" : range(1, 8),
    "pool": {
        "category"   : "series",
        "created_at" : "2013-11-08T21:44:54.588-05:00",
        "description": "A comic by [[ken (koala)]] about a girl. Seems to be somewhat melancholy.\r\n\r\n(Also, this will probably be renamed if it gets translated, since the title doesn't make much sense as-is)",
        "id"         : 7659,
        "is_active"  : False,
        "is_deleted" : False,
        "name"       : "Original - ある○人の島 (Ken (Koala))",
        "post_count" : 8,
        "updated_at" : "2017-08-10T20:16:04.564-04:00",
    },
},

{
    "#url"     : "https://danbooru.donmai.us/pools/24413",
    "#category": ("Danbooru", "danbooru", "pool"),
    "#class"   : danbooru.DanbooruPoolExtractor,
    "#options" : {"order-posts": "asc"},
    "#results" : (
        "https://cdn.donmai.us/original/c5/7b/c57b045fee282199277d0f94e298b9dc.jpg",
        "https://cdn.donmai.us/original/44/6d/446d8b5db9b78694936408049745ee42.jpg",
        "https://cdn.donmai.us/original/34/0c/340c721ceb7fce6892a234adf0bea811.jpg",
        "https://cdn.donmai.us/original/47/c2/47c2c1ba1f7b83e0a487dbc7e722059f.jpg",
        "https://cdn.donmai.us/original/30/3b/303bdefb719b54253aa7731cf11ef91f.jpg",
    ),
},
{
    "#url"     : "https://danbooru.donmai.us/pools/24413",
    "#category": ("Danbooru", "danbooru", "pool"),
    "#class"   : danbooru.DanbooruPoolExtractor,
    "#options" : {"order-posts": "pool_desc"},
    "#results" : (
        "https://cdn.donmai.us/original/30/3b/303bdefb719b54253aa7731cf11ef91f.jpg",
        "https://cdn.donmai.us/original/47/c2/47c2c1ba1f7b83e0a487dbc7e722059f.jpg",
        "https://cdn.donmai.us/original/34/0c/340c721ceb7fce6892a234adf0bea811.jpg",
        "https://cdn.donmai.us/original/44/6d/446d8b5db9b78694936408049745ee42.jpg",
        "https://cdn.donmai.us/original/c5/7b/c57b045fee282199277d0f94e298b9dc.jpg",
    ),
},
{
    "#url"     : "https://danbooru.donmai.us/pools/24413",
    "#category": ("Danbooru", "danbooru", "pool"),
    "#class"   : danbooru.DanbooruPoolExtractor,
    "#options" : {"order-posts": "id"},
    "#results" : (
        "https://cdn.donmai.us/original/30/3b/303bdefb719b54253aa7731cf11ef91f.jpg",
        "https://cdn.donmai.us/original/44/6d/446d8b5db9b78694936408049745ee42.jpg",
        "https://cdn.donmai.us/original/34/0c/340c721ceb7fce6892a234adf0bea811.jpg",
        "https://cdn.donmai.us/original/47/c2/47c2c1ba1f7b83e0a487dbc7e722059f.jpg",
        "https://cdn.donmai.us/original/c5/7b/c57b045fee282199277d0f94e298b9dc.jpg",
    ),
},
{
    "#url"     : "https://danbooru.donmai.us/pools/24413",
    "#category": ("Danbooru", "danbooru", "pool"),
    "#class"   : danbooru.DanbooruPoolExtractor,
    "#options" : {"order-posts": "asc_id"},
    "#results" : (
        "https://cdn.donmai.us/original/c5/7b/c57b045fee282199277d0f94e298b9dc.jpg",
        "https://cdn.donmai.us/original/47/c2/47c2c1ba1f7b83e0a487dbc7e722059f.jpg",
        "https://cdn.donmai.us/original/34/0c/340c721ceb7fce6892a234adf0bea811.jpg",
        "https://cdn.donmai.us/original/44/6d/446d8b5db9b78694936408049745ee42.jpg",
        "https://cdn.donmai.us/original/30/3b/303bdefb719b54253aa7731cf11ef91f.jpg",
    ),
},

{
    "#url"     : "https://danbooru.donmai.us/pool/show/7659",
    "#category": ("Danbooru", "danbooru", "pool"),
    "#class"   : danbooru.DanbooruPoolExtractor,
},

{
    "#url"     : "https://danbooru.donmai.us/favorite_groups/14",
    "#category": ("Danbooru", "danbooru", "favgroup"),
    "#class"   : danbooru.DanbooruFavgroupExtractor,
    "#auth"    : False,
    "#count"   : 24,

    "favgroup": {
        "created_at": "2015-06-29T13:59:10.808-04:00",
        "creator_id": 65304,
        "id"        : 14,
        "is_public" : True,
        "name"      : "Mecha",
        "updated_at": "2019-07-07T07:21:50.677-04:00",
    },
},

{
    "#url"     : "https://danbooru.donmai.us/posts/294929",
    "#category": ("Danbooru", "danbooru", "post"),
    "#class"   : danbooru.DanbooruPostExtractor,
    "#sha1_content": "5e255713cbf0a8e0801dc423563c34d896bb9229",

    "approver_id": None,
    "bit_flags": 0,
    "created_at": "2008-08-12T00:46:05.385-04:00",
    "date": "dt:2008-08-12 04:46:05",
    "down_score": 0,
    "extension": "jpg",
    "fav_count": range(9, 15),
    "file_ext": "jpg",
    "file_size": 358232,
    "file_url": "https://cdn.donmai.us/original/ac/8e/ac8e3b92ea328ce9cf7211e69c905bf9.jpg",
    "filename": "ac8e3b92ea328ce9cf7211e69c905bf9",
    "has_active_children": False,
    "has_children": False,
    "has_large": True,
    "has_visible_children": False,
    "id": 294929,
    "image_height": 687,
    "image_width": 895,
    "is_banned": False,
    "is_deleted": False,
    "is_flagged": False,
    "is_pending": False,
    "large_file_url": "https://cdn.donmai.us/sample/ac/8e/sample-ac8e3b92ea328ce9cf7211e69c905bf9.jpg",
    "last_comment_bumped_at": None,
    "last_commented_at": None,
    "last_noted_at": None,
    "md5": "ac8e3b92ea328ce9cf7211e69c905bf9",
    "media_asset": dict,
    "parent_id": None,
    "pixiv_id": 1129835,
    "preview_file_url": "https://cdn.donmai.us/180x180/ac/8e/ac8e3b92ea328ce9cf7211e69c905bf9.jpg",
    "rating": "s",
    "score": range(1, 5),
    "source": "https://i.pximg.net/img-original/img/2008/07/09/16/10/23/1129835_p0.jpg",
    "subcategory": "post",
    "tag_count": range(32, 40),
    "tag_count_artist": 1,
    "tag_count_character": 3,
    "tag_count_copyright": 3,
    "tag_count_general": range(23, 30),
    "tag_count_meta": 2,
    "tag_string": "2boys bat_(animal) batman batman_(series) black_bodysuit bodysuit bonocho brown_eyes card closed_mouth collared_shirt commentary_request copyright_name dc_comics expressionless facepaint glasgow_smile heath_ledger joker_(dc) male_focus multiple_boys outline outstretched_arm parted_lips photoshop_(medium) pink_shirt playing_card shirt sketch smile the_dark_knight upper_body white_outline wing_collar",
    "tag_string_artist": "bonocho",
    "tag_string_character": "batman heath_ledger joker_(dc)",
    "tag_string_copyright": "batman_(series) dc_comics the_dark_knight",
    "tag_string_general": "2boys bat_(animal) black_bodysuit bodysuit brown_eyes card closed_mouth collared_shirt copyright_name expressionless facepaint glasgow_smile male_focus multiple_boys outline outstretched_arm parted_lips pink_shirt playing_card shirt sketch smile upper_body white_outline wing_collar",
    "tag_string_meta": "commentary_request photoshop_(medium)",
    "tags": [
        "2boys",
        "bat_(animal)",
        "batman",
        "batman_(series)",
        "black_bodysuit",
        "bodysuit",
        "bonocho",
        "brown_eyes",
        "card",
        "closed_mouth",
        "collared_shirt",
        "commentary_request",
        "copyright_name",
        "dc_comics",
        "expressionless",
        "facepaint",
        "glasgow_smile",
        "heath_ledger",
        "joker_(dc)",
        "male_focus",
        "multiple_boys",
        "outline",
        "outstretched_arm",
        "parted_lips",
        "photoshop_(medium)",
        "pink_shirt",
        "playing_card",
        "shirt",
        "sketch",
        "smile",
        "the_dark_knight",
        "upper_body",
        "white_outline",
        "wing_collar",
    ],
    "tags_artist": [
        "bonocho",
    ],
    "tags_character": [
        "batman",
        "heath_ledger",
        "joker_(dc)",
    ],
    "tags_copyright": [
        "batman_(series)",
        "dc_comics",
        "the_dark_knight",
    ],
    "tags_general": [
        "2boys",
        "bat_(animal)",
        "black_bodysuit",
        "bodysuit",
        "brown_eyes",
        "card",
        "closed_mouth",
        "collared_shirt",
        "copyright_name",
        "expressionless",
        "facepaint",
        "glasgow_smile",
        "male_focus",
        "multiple_boys",
        "outline",
        "outstretched_arm",
        "parted_lips",
        "pink_shirt",
        "playing_card",
        "shirt",
        "sketch",
        "smile",
        "upper_body",
        "white_outline",
        "wing_collar",
    ],
    "tags_meta": [
        "commentary_request",
        "photoshop_(medium)",
    ],
    "up_score": range(1, 5),
    "updated_at": "2024-03-24T13:25:30.456-04:00",
    "uploader_id": 67005,
},

{
    "#url"     : "https://danbooru.donmai.us/posts/3613024",
    "#category": ("Danbooru", "danbooru", "post"),
    "#class"   : danbooru.DanbooruPostExtractor,
    "#options" : {"ugoira": False},
    "#results" : "https://cdn.donmai.us/sample/5e/e5/sample-5ee54a2d95ed36376ec1d8f6ddbdece9.webm",

    "!_ugoira_original"  : ...,
    "!_ugoira_frame_data": ...,
},

{
    "#url"     : "https://danbooru.donmai.us/posts/3613024",
    "#category": ("Danbooru", "danbooru", "post"),
    "#class"   : danbooru.DanbooruPostExtractor,
    "#options" : {"ugoira": True},
    "#results" : "https://cdn.donmai.us/original/5e/e5/5ee54a2d95ed36376ec1d8f6ddbdece9.zip",

    "_ugoira_original"     : False,
    "_ugoira_frame_data[*]": {
        "file" : r"re:^0000\d\d\.jpg$",
        "delay": int,
    },
},

{
    "#url"     : "https://danbooru.donmai.us/post/show/294929",
    "#category": ("Danbooru", "danbooru", "post"),
    "#class"   : danbooru.DanbooruPostExtractor,
},

{
    "#url"     : "https://danbooru.donmai.us/explore/posts/popular",
    "#category": ("Danbooru", "danbooru", "popular"),
    "#class"   : danbooru.DanbooruPopularExtractor,
},

{
    "#url"     : "https://danbooru.donmai.us/explore/posts/popular?date=2013-06-06&scale=week",
    "#category": ("Danbooru", "danbooru", "popular"),
    "#class"   : danbooru.DanbooruPopularExtractor,
    "#range"   : "1-120",
    "#count"   : 120,
},

{
    "#url"     : "https://danbooru.donmai.us/artists/288683",
    "#category": ("Danbooru", "danbooru", "artist"),
    "#class"   : danbooru.DanbooruArtistExtractor,
    "#results" : "https://danbooru.donmai.us/posts?tags=kaori_%28vuoian_appxv%29",

    "created_at" : "2022-05-12T16:00:40.852-04:00",
    "updated_at" : "2022-05-12T22:10:51.917-04:00",
    "group_name" : "",
    "id"         : 288683,
    "is_banned"  : False,
    "is_deleted" : False,
    "name"       : "kaori_(vuoian_appxv)",
    "other_names": [
        "香",
        "vuoian_appxv",
    ],
},

{
    "#url"     : "https://danbooru.donmai.us/artists?commit=Search&search%5Bany_name_matches%5D=yu&search%5Border%5D=created_at",
    "#category": ("Danbooru", "danbooru", "artist-search"),
    "#class"   : danbooru.DanbooruArtistSearchExtractor,
    "#pattern" : danbooru.DanbooruTagExtractor.pattern,
    "#count"   : "> 50",

    "created_at" : str,
    "updated_at" : str,
    "group_name" : str,
    "id"         : int,
    "is_banned"  : bool,
    "is_deleted" : bool,
    "name"       : str,
    "other_names": list,
},

{
    "#url"     : "https://danbooru.donmai.us/posts/random?tags=bonocho",
    "#category": ("Danbooru", "danbooru", "random"),
    "#class"   : danbooru.DanbooruRandomExtractor,
    "#pattern" : "https://cdn.donmai.us/original/.+",
    "#count"   : 1,

    "search_tags": "bonocho",
},

{
    "#url"     : "https://danbooru.donmai.us/posts/random",
    "#category": ("Danbooru", "danbooru", "random"),
    "#class"   : danbooru.DanbooruRandomExtractor,
    "#pattern" : "https://cdn.donmai.us/original/.+",
    "#count"   : 1,

    "search_tags": "",
},

{
    "#url"     : "https://danbooru.donmai.us/media_assets/35394309",
    "#category": ("Danbooru", "danbooru", "media-asset"),
    "#class"   : danbooru.DanbooruMediaassetExtractor,
    "#results" : "https://cdn.donmai.us/original/4a/ae/4aae24ce57d92c1167910ab068c7514b.jpg",

    "created_at"     : "2025-11-06T06:42:00.070-05:00",
    "date"           : "dt:2025-11-06 11:42:00",
    "duration"       : None,
    "extension"      : "jpg",
    "file_ext"       : "jpg",
    "file_key"       : "PyWKmcv0U",
    "file_size"      : 416727,
    "file_url"       : "https://cdn.donmai.us/original/4a/ae/4aae24ce57d92c1167910ab068c7514b.jpg",
    "filename"       : "4aae24ce57d92c1167910ab068c7514b",
    "id"             : 35394309,
    "image_height"   : 2132,
    "image_width"    : 1867,
    "is_public"      : True,
    "md5"            : "4aae24ce57d92c1167910ab068c7514b",
    "pixel_hash"     : "ecfbad5b0bf98b1e8faeef908aba8613",
    "status"         : "active",
    "tag_string"     : "",
    "tag_string_artist": "",
    "tag_string_character": "",
    "tag_string_copyright": "",
    "tag_string_general": "",
    "tag_string_meta": "",
    "tags"           : (),
    "tags_artist"    : (),
    "tags_character" : (),
    "tags_copyright" : (),
    "tags_general"   : (),
    "tags_meta"      : (),
    "updated_at"     : "2025-11-06T06:42:01.465-05:00",
    "variants"       : [
        {
            "file_ext": "jpg",
            "height"  : 180,
            "type"    : "180x180",
            "url"     : "https://cdn.donmai.us/180x180/4a/ae/4aae24ce57d92c1167910ab068c7514b.jpg",
            "width"   : 158,
        },
        {
            "file_ext": "jpg",
            "height"  : 360,
            "type"    : "360x360",
            "url"     : "https://cdn.donmai.us/360x360/4a/ae/4aae24ce57d92c1167910ab068c7514b.jpg",
            "width"   : 315,
        },
        {
            "file_ext": "webp",
            "height"  : 720,
            "type"    : "720x720",
            "url"     : "https://cdn.donmai.us/720x720/4a/ae/4aae24ce57d92c1167910ab068c7514b.webp",
            "width"   : 631,
        },
        {
            "file_ext": "jpg",
            "height"  : 971,
            "type"    : "sample",
            "url"     : "https://cdn.donmai.us/sample/4a/ae/sample-4aae24ce57d92c1167910ab068c7514b.jpg",
            "width"   : 850,
        },
        {
            "file_ext": "jpg",
            "height"  : 2132,
            "type"    : "original",
            "url"     : "https://cdn.donmai.us/original/4a/ae/4aae24ce57d92c1167910ab068c7514b.jpg",
            "width"   : 1867,
        },
    ],
},

)
