package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListChildrenStacks invokes the edas.ListChildrenStacks API synchronously
func (client *Client) ListChildrenStacks(request *ListChildrenStacksRequest) (response *ListChildrenStacksResponse, err error) {
	response = CreateListChildrenStacksResponse()
	err = client.DoAction(request, response)
	return
}

// ListChildrenStacksWithChan invokes the edas.ListChildrenStacks API asynchronously
func (client *Client) ListChildrenStacksWithChan(request *ListChildrenStacksRequest) (<-chan *ListChildrenStacksResponse, <-chan error) {
	responseChan := make(chan *ListChildrenStacksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListChildrenStacks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListChildrenStacksWithCallback invokes the edas.ListChildrenStacks API asynchronously
func (client *Client) ListChildrenStacksWithCallback(request *ListChildrenStacksRequest, callback func(response *ListChildrenStacksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListChildrenStacksResponse
		var err error
		defer close(result)
		response, err = client.ListChildrenStacks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListChildrenStacksRequest is the request struct for api ListChildrenStacks
type ListChildrenStacksRequest struct {
	*requests.RoaRequest
	StackId     requests.Integer `position:"Query" name:"StackId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
}

// ListChildrenStacksResponse is the response struct for api ListChildrenStacks
type ListChildrenStacksResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Code      int                      `json:"Code" xml:"Code"`
	Message   string                   `json:"Message" xml:"Message"`
	Data      DataInListChildrenStacks `json:"Data" xml:"Data"`
}

// CreateListChildrenStacksRequest creates a request to invoke ListChildrenStacks API
func CreateListChildrenStacksRequest() (request *ListChildrenStacksRequest) {
	request = &ListChildrenStacksRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListChildrenStacks", "/pop/v5/s2i/list_children_stack", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListChildrenStacksResponse creates a response to parse from ListChildrenStacks response
func CreateListChildrenStacksResponse() (response *ListChildrenStacksResponse) {
	response = &ListChildrenStacksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
