package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNumbersOfSystemBlacklist invokes the cloudcallcenter.ListNumbersOfSystemBlacklist API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listnumbersofsystemblacklist.html
func (client *Client) ListNumbersOfSystemBlacklist(request *ListNumbersOfSystemBlacklistRequest) (response *ListNumbersOfSystemBlacklistResponse, err error) {
	response = CreateListNumbersOfSystemBlacklistResponse()
	err = client.DoAction(request, response)
	return
}

// ListNumbersOfSystemBlacklistWithChan invokes the cloudcallcenter.ListNumbersOfSystemBlacklist API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listnumbersofsystemblacklist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListNumbersOfSystemBlacklistWithChan(request *ListNumbersOfSystemBlacklistRequest) (<-chan *ListNumbersOfSystemBlacklistResponse, <-chan error) {
	responseChan := make(chan *ListNumbersOfSystemBlacklistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNumbersOfSystemBlacklist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNumbersOfSystemBlacklistWithCallback invokes the cloudcallcenter.ListNumbersOfSystemBlacklist API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listnumbersofsystemblacklist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListNumbersOfSystemBlacklistWithCallback(request *ListNumbersOfSystemBlacklistRequest, callback func(response *ListNumbersOfSystemBlacklistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNumbersOfSystemBlacklistResponse
		var err error
		defer close(result)
		response, err = client.ListNumbersOfSystemBlacklist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNumbersOfSystemBlacklistRequest is the request struct for api ListNumbersOfSystemBlacklist
type ListNumbersOfSystemBlacklistRequest struct {
	*requests.RpcRequest
	Filter     string           `position:"Query" name:"Filter"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListNumbersOfSystemBlacklistResponse is the response struct for api ListNumbersOfSystemBlacklist
type ListNumbersOfSystemBlacklistResponse struct {
	*responses.BaseResponse
	RequestId      string                             `json:"RequestId" xml:"RequestId"`
	Success        bool                               `json:"Success" xml:"Success"`
	Code           string                             `json:"Code" xml:"Code"`
	Message        string                             `json:"Message" xml:"Message"`
	HttpStatusCode int                                `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           DataInListNumbersOfSystemBlacklist `json:"Data" xml:"Data"`
}

// CreateListNumbersOfSystemBlacklistRequest creates a request to invoke ListNumbersOfSystemBlacklist API
func CreateListNumbersOfSystemBlacklistRequest() (request *ListNumbersOfSystemBlacklistRequest) {
	request = &ListNumbersOfSystemBlacklistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListNumbersOfSystemBlacklist", "", "")
	request.Method = requests.POST
	return
}

// CreateListNumbersOfSystemBlacklistResponse creates a response to parse from ListNumbersOfSystemBlacklist response
func CreateListNumbersOfSystemBlacklistResponse() (response *ListNumbersOfSystemBlacklistResponse) {
	response = &ListNumbersOfSystemBlacklistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
