package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RollbackGtmRecoveryPlan invokes the alidns.RollbackGtmRecoveryPlan API synchronously
func (client *Client) RollbackGtmRecoveryPlan(request *RollbackGtmRecoveryPlanRequest) (response *RollbackGtmRecoveryPlanResponse, err error) {
	response = CreateRollbackGtmRecoveryPlanResponse()
	err = client.DoAction(request, response)
	return
}

// RollbackGtmRecoveryPlanWithChan invokes the alidns.RollbackGtmRecoveryPlan API asynchronously
func (client *Client) RollbackGtmRecoveryPlanWithChan(request *RollbackGtmRecoveryPlanRequest) (<-chan *RollbackGtmRecoveryPlanResponse, <-chan error) {
	responseChan := make(chan *RollbackGtmRecoveryPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RollbackGtmRecoveryPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RollbackGtmRecoveryPlanWithCallback invokes the alidns.RollbackGtmRecoveryPlan API asynchronously
func (client *Client) RollbackGtmRecoveryPlanWithCallback(request *RollbackGtmRecoveryPlanRequest, callback func(response *RollbackGtmRecoveryPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RollbackGtmRecoveryPlanResponse
		var err error
		defer close(result)
		response, err = client.RollbackGtmRecoveryPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RollbackGtmRecoveryPlanRequest is the request struct for api RollbackGtmRecoveryPlan
type RollbackGtmRecoveryPlanRequest struct {
	*requests.RpcRequest
	UserClientIp   string           `position:"Query" name:"UserClientIp"`
	RecoveryPlanId requests.Integer `position:"Query" name:"RecoveryPlanId"`
	Lang           string           `position:"Query" name:"Lang"`
}

// RollbackGtmRecoveryPlanResponse is the response struct for api RollbackGtmRecoveryPlan
type RollbackGtmRecoveryPlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRollbackGtmRecoveryPlanRequest creates a request to invoke RollbackGtmRecoveryPlan API
func CreateRollbackGtmRecoveryPlanRequest() (request *RollbackGtmRecoveryPlanRequest) {
	request = &RollbackGtmRecoveryPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "RollbackGtmRecoveryPlan", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRollbackGtmRecoveryPlanResponse creates a response to parse from RollbackGtmRecoveryPlan response
func CreateRollbackGtmRecoveryPlanResponse() (response *RollbackGtmRecoveryPlanResponse) {
	response = &RollbackGtmRecoveryPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
