/*
	file automatically generated by make_test_files.pl
	Tue May 16 16:46:35 2023
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for TDR
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );



/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */
double pdf( double x, const UNUR_DISTR *distr );

double pdf_bimodal( double x, const UNUR_DISTR *distr );
double dpdf_bimodal( double x, const UNUR_DISTR *distr );

double pdf_negative( double x, const UNUR_DISTR *distr );
double dpdf_negative( double x, const UNUR_DISTR *distr );

double pdf_partnegative( double x, const UNUR_DISTR *distr );
double dpdf_partnegative( double x, const UNUR_DISTR *distr );

#define COMPARE_SAMPLE_SIZE   (10000)
#define VIOLATE_SAMPLE_SIZE   (20)




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



/* pdf of bimodal density */
double pdf_bimodal( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
	return ( exp(-(x-1.)*(x-1.)) + exp(-(x+1.)*(x+1.)) );
}
double dpdf_bimodal( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
	return ( -2. * (x-1.) * exp(-(x-1.)*(x-1.)) -2. * (x+1.) * exp(-(x+1.)*(x+1.)) );
}

/* pdf with negative value */
double pdf_negative( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
	return (-x*x);
}
double dpdf_negative( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{
	return (-2.*x);
}

/* pdf with partial negative value */
double pdf_partnegative( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)  
{ 
	return ((x>-0.89 && x<0.89) ? -1.: exp(-x*x)); 
}
double dpdf_partnegative( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED) 
{
	return ((x>-0.89 && x<0.89) ?0.: -2.*x*exp(-x*x));
}

/* pdf of normal density */
double pdf( double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
	return exp(-x*x/2.);
} /* end of pdf */

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,35,(unur_tdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,35,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,41,(unur_tdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,41,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* data missing in distribution object */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
/* pdf, dpdf */
n_tests_failed += (check_expected_NULL(TESTLOG,48,(unur_tdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,48,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* dpdf */
unur_distr_cont_set_pdf(distr,pdf);
n_tests_failed += (check_expected_NULL(TESTLOG,53,(unur_tdr_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,53,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,63,(unur_tdr_set_cpoints( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,63,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,66,(unur_tdr_set_reinit_percentiles( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,66,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,69,(unur_tdr_set_guidefactor( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,69,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,72,(unur_tdr_set_max_sqhratio( par, 0.95 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,72,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,75,(unur_tdr_set_max_intervals( par, 100 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,75,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,78,(unur_tdr_set_usecenter( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,78,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,81,(unur_tdr_set_usemode( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,81,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,84,(unur_tdr_set_variant_gw( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,84,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,87,(unur_tdr_set_variant_ps( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,87,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,90,(unur_tdr_set_variant_ia( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,90,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,93,(unur_tdr_set_usedars( par, TRUE )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,93,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,96,(unur_tdr_set_darsfactor( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,96,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,99,(unur_tdr_set_c( par, -0.5 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,99,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,102,(unur_tdr_set_verify( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,102,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,105,(unur_tdr_set_pedantic( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,105,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid parameter object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_arou_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,114,(unur_tdr_set_cpoints( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,114,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,117,(unur_tdr_set_reinit_percentiles( par, 0, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,117,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,120,(unur_tdr_set_guidefactor( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,120,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,123,(unur_tdr_set_max_sqhratio( par, 0.95 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,123,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,126,(unur_tdr_set_max_intervals( par, 100 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,126,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,129,(unur_tdr_set_usecenter( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,129,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,132,(unur_tdr_set_usemode( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,132,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,135,(unur_tdr_set_variant_gw( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,135,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,138,(unur_tdr_set_variant_ps( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,138,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,141,(unur_tdr_set_variant_ia( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,141,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,144,(unur_tdr_set_usedars( par, TRUE )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,144,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,147,(unur_tdr_set_darsfactor( par, 1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,147,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,150,(unur_tdr_set_c( par, -0.5 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,150,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,153,(unur_tdr_set_verify( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,153,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,156,(unur_tdr_set_pedantic( par, 1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,156,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double perc[] = {0.1,0.4,0.2};
   double stp[] = {1.,0.,1.};
   int n_stp = 3;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_tdr_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,169,(unur_tdr_set_cpoints( par, -1, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,169,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,172,(unur_tdr_set_cpoints( par, n_stp, stp )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,172,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_tdr_set_reinit_percentiles( par, -1, NULL );
n_tests_failed += (check_errorcode(TESTLOG,175,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,178,(unur_tdr_set_reinit_percentiles( par, n_stp, stp )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,178,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,181,(unur_tdr_set_reinit_percentiles( par, n_stp, perc )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,181,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,184,(unur_tdr_set_guidefactor( par, -1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,184,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,187,(unur_tdr_set_max_sqhratio( par, -1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,187,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,190,(unur_tdr_set_max_sqhratio( par, 2. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,190,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,193,(unur_tdr_set_max_intervals( par, 0 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,193,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,196,(unur_tdr_set_usedars( par, -1 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,196,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,199,(unur_tdr_set_darsfactor( par, -1. )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,199,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,202,(unur_tdr_set_c( par, 0.5 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,202,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,205,(unur_tdr_set_c( par, -0.6 )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,205,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_tdr_set_c( par, -0.3 );
n_tests_failed += (check_errorcode(TESTLOG,208,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [get] */

void test_get (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[get "); fflush(stdout);
	fprintf(TESTLOG,"\n[get]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_arou_new(distr);
   gen = unur_init(par); 
abort_if_NULL(TESTLOG, 218,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,222,(unur_tdr_get_sqhratio(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,222,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,225,(unur_tdr_get_hatarea(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,225,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,228,(unur_tdr_get_squeezearea(gen)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,228,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_get() */

/*---------------------------------------------------------------------------*/
/* [chg] */

void test_chg (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[chg "); fflush(stdout);
	fprintf(TESTLOG,"\n[chg]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_arou_new(distr);
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 239,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,243,(unur_tdr_chg_reinit_percentiles(gen, -1, NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,243,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,246,(unur_tdr_chg_verify(gen,1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,246,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double percmon[] = {0.1,0.4,0.2};
   double percdom[] = {0.1,0.4,2.};
   int n_perc = 3;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdr_new(distr); 
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 255,    gen );


unur_reset_errno();
unur_tdr_chg_reinit_percentiles( gen, -1, NULL );
n_tests_failed += (check_errorcode(TESTLOG,259,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,262,(unur_tdr_chg_reinit_percentiles( gen, n_perc, percmon )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,262,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,265,(unur_tdr_chg_reinit_percentiles( gen, n_perc, percdom )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,265,UNUR_ERR_PAR_SET)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_chg() */

/*---------------------------------------------------------------------------*/
/* [init] */

void test_init (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[init "); fflush(stdout);
	fprintf(TESTLOG,"\n[init]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,276,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,276,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* stp out of domain */
UNUR_GEN   *gen = NULL;
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double stp[] = {-2.5,-1.,0.,1.,2.5};
   int n_stp = 5;
   gen = NULL;
   distr = unur_distr_normal(NULL,0);
   unur_distr_cont_set_domain(distr,-2.,2.);
   par = unur_tdr_new(distr);
   unur_tdr_set_usedars(par,FALSE);
   unur_tdr_set_cpoints( par, n_stp, stp ); 


unur_reset_errno();
gen = unur_init( par );
n_tests_failed += (check_errorcode(TESTLOG,289,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;
unur_free(gen);
unur_distr_free(distr);
}

{ /* bimodal */
UNUR_GEN   *gen = NULL;
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   gen = NULL;
   distr = unur_distr_cont_new(); 
   unur_distr_cont_set_pdf(distr,pdf_bimodal);
   unur_distr_cont_set_dpdf(distr,dpdf_bimodal);
   par = unur_tdr_new(distr);
   unur_tdr_set_usedars(par,FALSE);
   unur_tdr_set_cpoints( par, 30, NULL ); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,301,(gen = unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,301,UNUR_ERR_GEN_CONDITION)==UNUR_SUCCESS)?0:1;
unur_free(gen);
unur_distr_free(distr);
}

{ /* wrong mode */
UNUR_GEN   *gen = NULL;
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = NULL; 


unur_reset_errno();
unur_distr_cont_set_mode(distr,-1.);
par = unur_tdr_new(distr);
unur_tdr_set_usedars(par,FALSE);
unur_tdr_set_cpoints( par, 30, NULL );
n_tests_failed += (check_expected_NULL(TESTLOG,313,(gen = unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,313,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_distr_cont_set_mode(distr,1.);
par = unur_tdr_new(distr);
unur_tdr_set_usedars(par,FALSE);
unur_tdr_set_cpoints( par, 30, NULL );
gen = unur_init( par );
n_tests_failed += (check_errorcode(TESTLOG,320,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;
unur_free(gen);
unur_distr_free(distr);
}

{ /* negative value of pdf */
UNUR_GEN   *gen = NULL;
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   gen = NULL;
   distr = unur_distr_cont_new(); 
   unur_distr_cont_set_pdf(distr,pdf_negative);
   unur_distr_cont_set_dpdf(distr,dpdf_negative);
   par = NULL; 


unur_reset_errno();
par = unur_tdr_new(distr);
unur_tdr_set_usedars(par,FALSE);
unur_tdr_set_cpoints( par, 30, NULL );
n_tests_failed += (check_expected_NULL(TESTLOG,333,(gen = unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,333,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_distr_cont_set_domain(distr,-2.,2.);
par = unur_tdr_new(distr);
unur_tdr_set_usedars(par,FALSE);
unur_tdr_set_cpoints( par, 30, NULL );
n_tests_failed += (check_expected_NULL(TESTLOG,340,(gen = unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,340,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;
unur_free(gen);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_init() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* exist */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdr_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 348,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_reinit(TESTLOG,352,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_GEN   *gen = NULL;
   gen = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,362,(unur_tdr_eval_invcdfhat(gen,0.5,NULL,NULL,NULL)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,362,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_free(gen);
}

{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_arou_new(distr);
   gen = unur_init(par); 
abort_if_NULL(TESTLOG, 368,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,372,(unur_tdr_eval_invcdfhat(gen,0.5,NULL,NULL,NULL)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,372,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* invalid domain */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_tdr_new(distr);
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 379,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_INFINITY(TESTLOG,383,(unur_tdr_eval_invcdfhat(gen,1.5,NULL,NULL,NULL)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,383,UNUR_ERR_DOMAIN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_negINFINITY(TESTLOG,386,(unur_tdr_eval_invcdfhat(gen,-0.5,NULL,NULL,NULL)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,386,UNUR_ERR_DOMAIN)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* partial negative value of pdf */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   int i;
   double x;
   double stp[] = {-0.9,0.9};
   int n_stp = 2;
   distr = unur_distr_cont_new();
   unur_distr_cont_set_pdf(distr,pdf_partnegative);
   unur_distr_cont_set_dpdf(distr,dpdf_partnegative);
   par = unur_tdr_new(distr);
   unur_tdr_set_usedars(par,FALSE);
   unur_tdr_set_usecenter(par,FALSE);
   unur_tdr_set_cpoints( par, n_stp, stp );
   unur_tdr_set_pedantic( par, 1 );
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 402,    gen );


unur_reset_errno();
for (i=0; i<100; i++) { x = unur_sample_cont(gen); }
n_tests_failed += (check_expected_INFINITY(TESTLOG,407,(x))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,407,UNUR_ERR_GEN_CONDITION)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = unur_distr_normal(NULL,0); 
   par = NULL; 


unur_reset_errno();
/* GW, c = -0.5 */
par = unur_tdr_new(distr);
unur_tdr_set_variant_gw(par);
unur_tdr_set_c(par,-0.5);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,422,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* GW, c = -0.5 - verifying mode */
par = unur_tdr_new(distr);
unur_tdr_set_variant_gw(par);
unur_tdr_set_c(par,-0.5);
unur_tdr_set_verify(par,1);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,430,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* PS, c = -0.5 */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ps(par);
unur_tdr_set_c(par,-0.5);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,437,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* PS, c = -0.5 - verifying mode */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ps(par);
unur_tdr_set_c(par,-0.5);
unur_tdr_set_verify(par,1);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,445,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* IA, c = -0.5 */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ia(par);
unur_tdr_set_c(par,-0.5);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,452,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* IA, c = -0.5 - verifying mode */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ia(par);
unur_tdr_set_c(par,-0.5);
unur_tdr_set_verify(par,1);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,460,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* GW, c = 0 */
par = unur_tdr_new(distr);
unur_tdr_set_variant_gw(par);
unur_tdr_set_c(par,0.);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,470,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* GW, c = 0, verifying mode */
par = unur_tdr_new(distr);
unur_tdr_set_variant_gw(par);
unur_tdr_set_c(par,0.);
unur_tdr_set_verify(par,1);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,478,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* PS, c = 0 */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ps(par);
unur_tdr_set_c(par,0.);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,485,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* PS, c = 0, verifying mode */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ps(par);
unur_tdr_set_c(par,0.);
unur_tdr_set_verify(par,1);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,493,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* IA, c = 0 */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ia(par);
unur_tdr_set_c(par,0.);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par_start(TESTLOG,500,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* IA, c = 0, verifying mode */
par = unur_tdr_new(distr);
unur_tdr_set_variant_ia(par);
unur_tdr_set_c(par,0.);
unur_tdr_set_verify(par,1);
unur_tdr_set_usedars(par,FALSE);
n_tests_failed += (compare_sequence_par(TESTLOG,508,par,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   distr = unur_distr_normal(NULL,0); 
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_tdr_new(distr);
unur_tabl_set_max_sqhratio(par,0.);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,522,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,528,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare stringparser */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {3.,3.};
   distr = NULL;
   par = NULL;
   gen = NULL; 


unur_reset_errno();
distr = unur_distr_gamma(fpar,2);
unur_distr_cont_set_center(distr,2.1);
par = unur_tdr_new(distr);
unur_tdr_set_cpoints(par,20,NULL);
unur_tdr_set_guidefactor(par,2.);
unur_tdr_set_max_intervals(par,32);
unur_tdr_set_max_sqhratio(par,0.9);
unur_tdr_set_usecenter(par,TRUE);
unur_tdr_set_verify(par,TRUE);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,548,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.); center = 2.1 & \
  method = tdr; usecenter; cpoints = 20; guidefactor = 2.; \
  max_intervals = 32; max_sqhratio = 0.9; verify" );
n_tests_failed += (compare_sequence_gen(TESTLOG,555,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdr_new(distr);
unur_tdr_set_cpoints(par,9,NULL);
unur_tdr_set_pedantic(par,TRUE);
unur_tdr_set_usemode(par,FALSE);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,565,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = tdr; cpoints = 9; pedantic; usemode = false" );
n_tests_failed += (compare_sequence_gen(TESTLOG,571,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdr_new(distr);
unur_tdr_set_c(par,0.);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,579,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = tdr; c = 0." );
n_tests_failed += (compare_sequence_gen(TESTLOG,585,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdr_new(distr);
unur_tdr_set_c(par,-0.5);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,593,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = tdr; c = -0.5" );
n_tests_failed += (compare_sequence_gen(TESTLOG,599,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdr_new(distr);
unur_tdr_set_variant_gw(par);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,607,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = tdr; variant_gw" );
n_tests_failed += (compare_sequence_gen(TESTLOG,613,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdr_new(distr);
unur_tdr_set_variant_ia(par);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,621,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = tdr; variant_ia" );
n_tests_failed += (compare_sequence_gen(TESTLOG,627,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
distr = unur_distr_gamma(fpar,2);
par = unur_tdr_new(distr);
unur_tdr_set_variant_ps(par);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,635,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,3.) & \
  method = tdr; variant_ps" );
n_tests_failed += (compare_sequence_gen(TESTLOG,641,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_tdr_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */


/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_tdr_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_tdr_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 110885;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 110885;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("tdr: ");

	/* run tests */
test_new();
test_set();
test_get();
test_chg();
test_init();
test_reinit();
test_sample();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

