/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnslabel;

import org.minidns.dnslabel.DnsLabel;
import org.minidns.dnslabel.LeadingOrTrailingHyphenLabel;
import org.minidns.dnslabel.NonReservedLdhLabel;
import org.minidns.dnslabel.ReservedLdhLabel;
import org.minidns.dnslabel.XnLabel;

public abstract class LdhLabel
extends DnsLabel {
    protected LdhLabel(String label) {
        super(label);
    }

    public static boolean isLdhLabel(String label) {
        if (label.isEmpty()) {
            return false;
        }
        if (LeadingOrTrailingHyphenLabel.isLeadingOrTrailingHypenLabelInternal(label)) {
            return false;
        }
        return LdhLabel.consistsOnlyOfLettersDigitsAndHypen(label);
    }

    protected static LdhLabel fromInternal(String label) {
        assert (LdhLabel.isLdhLabel(label));
        if (ReservedLdhLabel.isReservedLdhLabel(label)) {
            if (XnLabel.isXnLabelInternal(label)) {
                return XnLabel.fromInternal(label);
            }
            return new ReservedLdhLabel(label);
        }
        return new NonReservedLdhLabel(label);
    }
}

