// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/notification-how-to-filtering.html">Configuring event notifications using object key name filtering</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct NotificationConfigurationFilter {
    /// <p>A container for object key name prefix and suffix filtering rules.</p>
    pub key: ::std::option::Option<crate::types::S3KeyFilter>,
}
impl NotificationConfigurationFilter {
    /// <p>A container for object key name prefix and suffix filtering rules.</p>
    pub fn key(&self) -> ::std::option::Option<&crate::types::S3KeyFilter> {
        self.key.as_ref()
    }
}
impl NotificationConfigurationFilter {
    /// Creates a new builder-style object to manufacture [`NotificationConfigurationFilter`](crate::types::NotificationConfigurationFilter).
    pub fn builder() -> crate::types::builders::NotificationConfigurationFilterBuilder {
        crate::types::builders::NotificationConfigurationFilterBuilder::default()
    }
}

/// A builder for [`NotificationConfigurationFilter`](crate::types::NotificationConfigurationFilter).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct NotificationConfigurationFilterBuilder {
    pub(crate) key: ::std::option::Option<crate::types::S3KeyFilter>,
}
impl NotificationConfigurationFilterBuilder {
    /// <p>A container for object key name prefix and suffix filtering rules.</p>
    pub fn key(mut self, input: crate::types::S3KeyFilter) -> Self {
        self.key = ::std::option::Option::Some(input);
        self
    }
    /// <p>A container for object key name prefix and suffix filtering rules.</p>
    pub fn set_key(mut self, input: ::std::option::Option<crate::types::S3KeyFilter>) -> Self {
        self.key = input;
        self
    }
    /// <p>A container for object key name prefix and suffix filtering rules.</p>
    pub fn get_key(&self) -> &::std::option::Option<crate::types::S3KeyFilter> {
        &self.key
    }
    /// Consumes the builder and constructs a [`NotificationConfigurationFilter`](crate::types::NotificationConfigurationFilter).
    pub fn build(self) -> crate::types::NotificationConfigurationFilter {
        crate::types::NotificationConfigurationFilter { key: self.key }
    }
}
