# Agent Settings

Learn about all the settings you can customize in Zed's Agent Panel.

## Model Settings {#model-settings}

### Default Model {#default-model}

If you're using [Zed's hosted LLM service](./subscription.md), it sets `claude-sonnet-4` as the default model for agentic work (agent panel, inline assistant) and `gpt-5-nano` as the default "fast" model (thread summarization, git commit messages). If you're not subscribed or want to change these defaults, you can manually edit the `default_model` object in your settings:

```json [settings]
{
  "agent": {
    "default_model": {
      "provider": "openai",
      "model": "gpt-4o"
    }
  }
}
```

### Feature-specific Models {#feature-specific-models}

You can assign distinct and specific models for the following AI-powered features:

- Thread summary model: Used for generating thread summaries
- Inline assistant model: Used for the inline assistant feature
- Commit message model: Used for generating Git commit messages

```json [settings]
{
  "agent": {
    "default_model": {
      "provider": "zed.dev",
      "model": "claude-sonnet-4"
    },
    "inline_assistant_model": {
      "provider": "anthropic",
      "model": "claude-3-5-sonnet"
    },
    "commit_message_model": {
      "provider": "openai",
      "model": "gpt-4o-mini"
    },
    "thread_summary_model": {
      "provider": "google",
      "model": "gemini-2.0-flash"
    }
  }
}
```

> If a custom model isn't set for one of these features, they automatically fall back to using the default model.

### Alternative Models for Inline Assists {#alternative-assists}

The Inline Assist feature in particular has the capacity to perform multiple generations in parallel using different models.
That is possible by assigning more than one model to it, taking the configuration shown above one step further.

When configured, the inline assist UI will surface controls to cycle between the outputs generated by each model.

The models you specify here are always used in _addition_ to your [default model](#default-model).

For example, the following configuration will generate two outputs for every assist.
One with Claude Sonnet 4 (the default model), and one with GPT-5-mini.

```json [settings]
{
  "agent": {
    "default_model": {
      "provider": "zed.dev",
      "model": "claude-sonnet-4"
    },
    "inline_alternatives": [
      {
        "provider": "zed.dev",
        "model": "gpt-4-mini"
      }
    ]
  }
}
```

### Model Temperature

Specify a custom temperature for a provider and/or model:

```json [settings]
"model_parameters": [
  // To set parameters for all requests to OpenAI models:
  {
    "provider": "openai",
    "temperature": 0.5
  },
  // To set parameters for all requests in general:
  {
    "temperature": 0
  },
  // To set parameters for a specific provider and model:
  {
    "provider": "zed.dev",
    "model": "claude-sonnet-4",
    "temperature": 1.0
  }
],
```

## Agent Panel Settings {#agent-panel-settings}

Note that some of these settings are also surfaced in the Agent Panel's settings UI, which you can access either via the `agent: open settings` action or by the dropdown menu on the top-right corner of the panel.

### Default View

Use the `default_view` setting to change the default view of the Agent Panel.
You can choose between `thread` (the default) and `text_thread`:

```json [settings]
{
  "agent": {
    "default_view": "text_thread"
  }
}
```

### Font Size

Use the `agent_font_size` setting to change the font size of rendered agent responses in the panel.

```json [settings]
{
  "agent": {
    "agent_font_size": 18
  }
}
```

> Editors in the Agent Panel—whether that is the main message textarea or previous messages—use monospace fonts and therefore, are controlled by the `buffer_font_size` setting, which is defined globally in your `settings.json`.

### Auto-run Commands

Control whether to allow the agent to run commands without asking you for permission.
The default value is `false`.

```json [settings]
{
  "agent": {
    "always_allow_tool_actions": true
  }
}
```

### Single-file Review

Control whether to display review actions (accept & reject) in single buffers after the agent is done performing edits.
The default value is `false`.

```json [settings]
{
  "agent": {
    "single_file_review": true
  }
}
```

When set to false, these controls are only available in the multibuffer review tab.

### Sound Notification

Control whether to hear a notification sound when the agent is done generating changes or needs your input.
The default value is `false`.

```json [settings]
{
  "agent": {
    "play_sound_when_agent_done": true
  }
}
```

### Message Editor Size

Use the `message_editor_min_lines` setting to control minimum number of lines of height the agent message editor should have.
It is set to `4` by default, and the max number of lines is always double of the minimum.

```json [settings]
{
  "agent": {
    "message_editor_min_lines": 4
  }
}
```

### Modifier to Send

Make a modifier (`cmd` on macOS, `ctrl` on Linux) required to send messages.
This is encouraged for more thoughtful prompt crafting.
The default value is `false`.

```json [settings]
{
  "agent": {
    "use_modifier_to_send": true
  }
}
```

### Edit Card

Use the `expand_edit_card` setting to control whether edit cards show the full diff in the Agent Panel.
It is set to `true` by default, but if set to false, the card's height is capped to a certain number of lines, requiring a click to be expanded.

```json [settings]
{
  "agent": {
    "expand_edit_card": false
  }
}
```

### Terminal Card

Use the `expand_terminal_card` setting to control whether terminal cards show the command output in the Agent Panel.
It is set to `true` by default, but if set to false, the card will be fully collapsed even while the command is running, requiring a click to be expanded.

```json [settings]
{
  "agent": {
    "expand_terminal_card": false
  }
}
```

### Feedback Controls

Control whether to display the thumbs up/down buttons at the bottom of each agent response, allowing to give Zed feedback about the agent's performance.
The default value is `true`.

```json [settings]
{
  "agent": {
    "enable_feedback": false
  }
}
```
