//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uikeyinput?language=objc)
    #[cfg(feature = "UITextInputTraits")]
    pub unsafe trait UIKeyInput: UITextInputTraits + MainThreadOnly {
        #[unsafe(method(hasText))]
        #[unsafe(method_family = none)]
        fn hasText(&self) -> bool;

        #[unsafe(method(insertText:))]
        #[unsafe(method_family = none)]
        fn insertText(&self, text: &NSString);

        #[unsafe(method(deleteBackward))]
        #[unsafe(method_family = none)]
        fn deleteBackward(&self);
    }
);

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextstoragedirection?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITextStorageDirection(pub NSInteger);
impl UITextStorageDirection {
    #[doc(alias = "UITextStorageDirectionForward")]
    pub const Forward: Self = Self(0);
    #[doc(alias = "UITextStorageDirectionBackward")]
    pub const Backward: Self = Self(1);
}

unsafe impl Encode for UITextStorageDirection {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITextStorageDirection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextlayoutdirection?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITextLayoutDirection(pub NSInteger);
impl UITextLayoutDirection {
    #[doc(alias = "UITextLayoutDirectionRight")]
    pub const Right: Self = Self(2);
    #[doc(alias = "UITextLayoutDirectionLeft")]
    pub const Left: Self = Self(3);
    #[doc(alias = "UITextLayoutDirectionUp")]
    pub const Up: Self = Self(4);
    #[doc(alias = "UITextLayoutDirectionDown")]
    pub const Down: Self = Self(5);
}

unsafe impl Encode for UITextLayoutDirection {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITextLayoutDirection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextdirection?language=objc)
// NS_TYPED_ENUM
pub type UITextDirection = NSInteger;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextgranularity?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITextGranularity(pub NSInteger);
impl UITextGranularity {
    #[doc(alias = "UITextGranularityCharacter")]
    pub const Character: Self = Self(0);
    #[doc(alias = "UITextGranularityWord")]
    pub const Word: Self = Self(1);
    #[doc(alias = "UITextGranularitySentence")]
    pub const Sentence: Self = Self(2);
    #[doc(alias = "UITextGranularityParagraph")]
    pub const Paragraph: Self = Self(3);
    #[doc(alias = "UITextGranularityLine")]
    pub const Line: Self = Self(4);
    #[doc(alias = "UITextGranularityDocument")]
    pub const Document: Self = Self(5);
}

unsafe impl Encode for UITextGranularity {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITextGranularity {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidictationphrase?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIDictationPhrase;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIDictationPhrase {}
);

impl UIDictationPhrase {
    extern_methods!(
        #[unsafe(method(text))]
        #[unsafe(method_family = none)]
        pub fn text(&self) -> Retained<NSString>;

        #[unsafe(method(alternativeInterpretations))]
        #[unsafe(method_family = none)]
        pub fn alternativeInterpretations(&self) -> Option<Retained<NSArray<NSString>>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UIDictationPhrase {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextinputassistantitem?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextInputAssistantItem;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextInputAssistantItem {}
);

impl UITextInputAssistantItem {
    extern_methods!(
        /// Default is YES, controls if the user is allowed to hide the shortcuts bar. Does not influence the built in auto-hiding logic.
        #[unsafe(method(allowsHidingShortcuts))]
        #[unsafe(method_family = none)]
        pub fn allowsHidingShortcuts(&self) -> bool;

        /// Setter for [`allowsHidingShortcuts`][Self::allowsHidingShortcuts].
        #[unsafe(method(setAllowsHidingShortcuts:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsHidingShortcuts(&self, allows_hiding_shortcuts: bool);

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Contains UIBarButtonItemGroups that should be displayed in the leading position on the keyboard's assistant bar.
        #[unsafe(method(leadingBarButtonGroups))]
        #[unsafe(method_family = none)]
        pub fn leadingBarButtonGroups(&self) -> Retained<NSArray<UIBarButtonItemGroup>>;

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Setter for [`leadingBarButtonGroups`][Self::leadingBarButtonGroups].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setLeadingBarButtonGroups:))]
        #[unsafe(method_family = none)]
        pub fn setLeadingBarButtonGroups(
            &self,
            leading_bar_button_groups: &NSArray<UIBarButtonItemGroup>,
        );

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Contains UIBarButtonItemGroups that should be displayed in the trailing position on the keyboard's assistant bar.
        #[unsafe(method(trailingBarButtonGroups))]
        #[unsafe(method_family = none)]
        pub fn trailingBarButtonGroups(&self) -> Retained<NSArray<UIBarButtonItemGroup>>;

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Setter for [`trailingBarButtonGroups`][Self::trailingBarButtonGroups].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTrailingBarButtonGroups:))]
        #[unsafe(method_family = none)]
        pub fn setTrailingBarButtonGroups(
            &self,
            trailing_bar_button_groups: &NSArray<UIBarButtonItemGroup>,
        );

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// A button that appears next to the text preview in the keyboard on visionOS.
        #[unsafe(method(keyboardActionButtonItem))]
        #[unsafe(method_family = none)]
        pub fn keyboardActionButtonItem(&self) -> Option<Retained<UIBarButtonItem>>;

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// Setter for [`keyboardActionButtonItem`][Self::keyboardActionButtonItem].
        #[unsafe(method(setKeyboardActionButtonItem:))]
        #[unsafe(method_family = none)]
        pub fn setKeyboardActionButtonItem(
            &self,
            keyboard_action_button_item: Option<&UIBarButtonItem>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl UITextInputAssistantItem {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextplaceholder?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextPlaceholder;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextPlaceholder {}
);

impl UITextPlaceholder {
    extern_methods!(
        #[unsafe(method(rects))]
        #[unsafe(method_family = none)]
        pub fn rects(&self) -> Retained<NSArray<UITextSelectionRect>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UITextPlaceholder {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextalternativestyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITextAlternativeStyle(pub NSInteger);
impl UITextAlternativeStyle {
    #[doc(alias = "UITextAlternativeStyleNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "UITextAlternativeStyleLowConfidence")]
    pub const LowConfidence: Self = Self(1);
}

unsafe impl Encode for UITextAlternativeStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITextAlternativeStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextinput?language=objc)
    #[cfg(feature = "UITextInputTraits")]
    pub unsafe trait UITextInput: UIKeyInput + MainThreadOnly {
        #[unsafe(method(textInRange:))]
        #[unsafe(method_family = none)]
        fn textInRange(&self, range: &UITextRange) -> Option<Retained<NSString>>;

        #[unsafe(method(replaceRange:withText:))]
        #[unsafe(method_family = none)]
        fn replaceRange_withText(&self, range: &UITextRange, text: &NSString);

        #[unsafe(method(selectedTextRange))]
        #[unsafe(method_family = none)]
        fn selectedTextRange(&self) -> Option<Retained<UITextRange>>;

        /// Setter for [`selectedTextRange`][Self::selectedTextRange].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSelectedTextRange:))]
        #[unsafe(method_family = none)]
        fn setSelectedTextRange(&self, selected_text_range: Option<&UITextRange>);

        #[unsafe(method(markedTextRange))]
        #[unsafe(method_family = none)]
        fn markedTextRange(&self) -> Option<Retained<UITextRange>>;

        #[unsafe(method(markedTextStyle))]
        #[unsafe(method_family = none)]
        fn markedTextStyle(
            &self,
        ) -> Option<Retained<NSDictionary<NSAttributedStringKey, AnyObject>>>;

        /// Setter for [`markedTextStyle`][Self::markedTextStyle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `marked_text_style` generic should be of the correct type.
        #[unsafe(method(setMarkedTextStyle:))]
        #[unsafe(method_family = none)]
        unsafe fn setMarkedTextStyle(
            &self,
            marked_text_style: Option<&NSDictionary<NSAttributedStringKey, AnyObject>>,
        );

        #[unsafe(method(setMarkedText:selectedRange:))]
        #[unsafe(method_family = none)]
        fn setMarkedText_selectedRange(
            &self,
            marked_text: Option<&NSString>,
            selected_range: NSRange,
        );

        #[unsafe(method(unmarkText))]
        #[unsafe(method_family = none)]
        fn unmarkText(&self);

        #[unsafe(method(beginningOfDocument))]
        #[unsafe(method_family = none)]
        fn beginningOfDocument(&self) -> Retained<UITextPosition>;

        #[unsafe(method(endOfDocument))]
        #[unsafe(method_family = none)]
        fn endOfDocument(&self) -> Retained<UITextPosition>;

        #[unsafe(method(textRangeFromPosition:toPosition:))]
        #[unsafe(method_family = none)]
        fn textRangeFromPosition_toPosition(
            &self,
            from_position: &UITextPosition,
            to_position: &UITextPosition,
        ) -> Option<Retained<UITextRange>>;

        #[unsafe(method(positionFromPosition:offset:))]
        #[unsafe(method_family = none)]
        fn positionFromPosition_offset(
            &self,
            position: &UITextPosition,
            offset: NSInteger,
        ) -> Option<Retained<UITextPosition>>;

        #[unsafe(method(positionFromPosition:inDirection:offset:))]
        #[unsafe(method_family = none)]
        fn positionFromPosition_inDirection_offset(
            &self,
            position: &UITextPosition,
            direction: UITextLayoutDirection,
            offset: NSInteger,
        ) -> Option<Retained<UITextPosition>>;

        #[unsafe(method(comparePosition:toPosition:))]
        #[unsafe(method_family = none)]
        fn comparePosition_toPosition(
            &self,
            position: &UITextPosition,
            other: &UITextPosition,
        ) -> NSComparisonResult;

        #[unsafe(method(offsetFromPosition:toPosition:))]
        #[unsafe(method_family = none)]
        fn offsetFromPosition_toPosition(
            &self,
            from: &UITextPosition,
            to_position: &UITextPosition,
        ) -> NSInteger;

        #[unsafe(method(inputDelegate))]
        #[unsafe(method_family = none)]
        fn inputDelegate(&self) -> Option<Retained<ProtocolObject<dyn UITextInputDelegate>>>;

        /// Setter for [`inputDelegate`][Self::inputDelegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setInputDelegate:))]
        #[unsafe(method_family = none)]
        fn setInputDelegate(
            &self,
            input_delegate: Option<&ProtocolObject<dyn UITextInputDelegate>>,
        );

        #[unsafe(method(tokenizer))]
        #[unsafe(method_family = none)]
        fn tokenizer(&self) -> Retained<ProtocolObject<dyn UITextInputTokenizer>>;

        #[unsafe(method(positionWithinRange:farthestInDirection:))]
        #[unsafe(method_family = none)]
        fn positionWithinRange_farthestInDirection(
            &self,
            range: &UITextRange,
            direction: UITextLayoutDirection,
        ) -> Option<Retained<UITextPosition>>;

        #[unsafe(method(characterRangeByExtendingPosition:inDirection:))]
        #[unsafe(method_family = none)]
        fn characterRangeByExtendingPosition_inDirection(
            &self,
            position: &UITextPosition,
            direction: UITextLayoutDirection,
        ) -> Option<Retained<UITextRange>>;

        #[cfg(feature = "NSText")]
        #[unsafe(method(baseWritingDirectionForPosition:inDirection:))]
        #[unsafe(method_family = none)]
        fn baseWritingDirectionForPosition_inDirection(
            &self,
            position: &UITextPosition,
            direction: UITextStorageDirection,
        ) -> NSWritingDirection;

        #[cfg(feature = "NSText")]
        #[unsafe(method(setBaseWritingDirection:forRange:))]
        #[unsafe(method_family = none)]
        fn setBaseWritingDirection_forRange(
            &self,
            writing_direction: NSWritingDirection,
            range: &UITextRange,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(firstRectForRange:))]
        #[unsafe(method_family = none)]
        fn firstRectForRange(&self, range: &UITextRange) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(caretRectForPosition:))]
        #[unsafe(method_family = none)]
        fn caretRectForPosition(&self, position: &UITextPosition) -> CGRect;

        #[unsafe(method(selectionRectsForRange:))]
        #[unsafe(method_family = none)]
        fn selectionRectsForRange(
            &self,
            range: &UITextRange,
        ) -> Retained<NSArray<UITextSelectionRect>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(closestPositionToPoint:))]
        #[unsafe(method_family = none)]
        fn closestPositionToPoint(&self, point: CGPoint) -> Option<Retained<UITextPosition>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(closestPositionToPoint:withinRange:))]
        #[unsafe(method_family = none)]
        fn closestPositionToPoint_withinRange(
            &self,
            point: CGPoint,
            range: &UITextRange,
        ) -> Option<Retained<UITextPosition>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(characterRangeAtPoint:))]
        #[unsafe(method_family = none)]
        fn characterRangeAtPoint(&self, point: CGPoint) -> Option<Retained<UITextRange>>;

        #[optional]
        #[unsafe(method(shouldChangeTextInRange:replacementText:))]
        #[unsafe(method_family = none)]
        fn shouldChangeTextInRange_replacementText(
            &self,
            range: &UITextRange,
            text: &NSString,
        ) -> bool;

        #[optional]
        #[unsafe(method(textStylingAtPosition:inDirection:))]
        #[unsafe(method_family = none)]
        fn textStylingAtPosition_inDirection(
            &self,
            position: &UITextPosition,
            direction: UITextStorageDirection,
        ) -> Option<Retained<NSDictionary<NSAttributedStringKey, AnyObject>>>;

        #[optional]
        #[unsafe(method(positionWithinRange:atCharacterOffset:))]
        #[unsafe(method_family = none)]
        fn positionWithinRange_atCharacterOffset(
            &self,
            range: &UITextRange,
            offset: NSInteger,
        ) -> Option<Retained<UITextPosition>>;

        #[optional]
        #[unsafe(method(characterOffsetOfPosition:withinRange:))]
        #[unsafe(method_family = none)]
        fn characterOffsetOfPosition_withinRange(
            &self,
            position: &UITextPosition,
            range: &UITextRange,
        ) -> NSInteger;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(textInputView))]
        #[unsafe(method_family = none)]
        fn textInputView(&self) -> Retained<UIView>;

        #[optional]
        #[unsafe(method(selectionAffinity))]
        #[unsafe(method_family = none)]
        fn selectionAffinity(&self) -> UITextStorageDirection;

        /// Setter for [`selectionAffinity`][Self::selectionAffinity].
        #[optional]
        #[unsafe(method(setSelectionAffinity:))]
        #[unsafe(method_family = none)]
        fn setSelectionAffinity(&self, selection_affinity: UITextStorageDirection);

        #[optional]
        #[unsafe(method(insertDictationResult:))]
        #[unsafe(method_family = none)]
        fn insertDictationResult(&self, dictation_result: &NSArray<UIDictationPhrase>);

        #[optional]
        #[unsafe(method(dictationRecordingDidEnd))]
        #[unsafe(method_family = none)]
        fn dictationRecordingDidEnd(&self);

        #[optional]
        #[unsafe(method(dictationRecognitionFailed))]
        #[unsafe(method_family = none)]
        fn dictationRecognitionFailed(&self);

        #[optional]
        #[unsafe(method(insertDictationResultPlaceholder))]
        #[unsafe(method_family = none)]
        fn insertDictationResultPlaceholder(&self) -> Retained<AnyObject>;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// `placeholder` should be of the correct type.
        #[optional]
        #[unsafe(method(frameForDictationResultPlaceholder:))]
        #[unsafe(method_family = none)]
        unsafe fn frameForDictationResultPlaceholder(&self, placeholder: &AnyObject) -> CGRect;

        /// # Safety
        ///
        /// `placeholder` should be of the correct type.
        #[optional]
        #[unsafe(method(removeDictationResultPlaceholder:willInsertResult:))]
        #[unsafe(method_family = none)]
        unsafe fn removeDictationResultPlaceholder_willInsertResult(
            &self,
            placeholder: &AnyObject,
            will_insert_result: bool,
        );

        #[optional]
        #[unsafe(method(insertText:alternatives:style:))]
        #[unsafe(method_family = none)]
        fn insertText_alternatives_style(
            &self,
            text: &NSString,
            alternatives: &NSArray<NSString>,
            style: UITextAlternativeStyle,
        );

        #[optional]
        #[unsafe(method(setAttributedMarkedText:selectedRange:))]
        #[unsafe(method_family = none)]
        fn setAttributedMarkedText_selectedRange(
            &self,
            marked_text: Option<&NSAttributedString>,
            selected_range: NSRange,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[optional]
        #[unsafe(method(insertTextPlaceholderWithSize:))]
        #[unsafe(method_family = none)]
        fn insertTextPlaceholderWithSize(&self, size: CGSize) -> Retained<UITextPlaceholder>;

        #[optional]
        #[unsafe(method(removeTextPlaceholder:))]
        #[unsafe(method_family = none)]
        fn removeTextPlaceholder(&self, text_placeholder: &UITextPlaceholder);

        #[cfg(feature = "objc2-core-foundation")]
        #[optional]
        #[unsafe(method(beginFloatingCursorAtPoint:))]
        #[unsafe(method_family = none)]
        fn beginFloatingCursorAtPoint(&self, point: CGPoint);

        #[cfg(feature = "objc2-core-foundation")]
        #[optional]
        #[unsafe(method(updateFloatingCursorAtPoint:))]
        #[unsafe(method_family = none)]
        fn updateFloatingCursorAtPoint(&self, point: CGPoint);

        #[optional]
        #[unsafe(method(endFloatingCursor))]
        #[unsafe(method_family = none)]
        fn endFloatingCursor(&self);

        #[cfg(feature = "objc2-core-foundation")]
        /// Similar to `-caretRectForPosition:`, optionally provide a transform for the caret at `position`. As with all geometry information in this protocol,
        /// transforms are assumed to be relative to the `textInputView` coordinate space. If unimplemented, the identity transform is assumed.
        #[optional]
        #[unsafe(method(caretTransformForPosition:))]
        #[unsafe(method_family = none)]
        fn caretTransformForPosition(&self, position: &UITextPosition) -> CGAffineTransform;

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Called when the text input is preparing an edit menu presentation for the specified text range.
        ///
        ///
        /// Parameter `textRange`: The text range for which the menu is presented for.
        ///
        /// Parameter `suggestedActions`: The actions and commands that the system suggests.
        ///
        ///
        /// Returns: Return a UIMenu describing the desired menu hierarchy. Return
        /// `nil`to present the default system menu.
        #[optional]
        #[unsafe(method(editMenuForTextRange:suggestedActions:))]
        #[unsafe(method_family = none)]
        fn editMenuForTextRange_suggestedActions(
            &self,
            text_range: &UITextRange,
            suggested_actions: &NSArray<UIMenuElement>,
        ) -> Option<Retained<UIMenu>>;

        #[cfg(feature = "UIEditMenuInteraction")]
        #[optional]
        #[unsafe(method(willPresentEditMenuWithAnimator:))]
        #[unsafe(method_family = none)]
        fn willPresentEditMenuWithAnimator(
            &self,
            animator: &ProtocolObject<dyn UIEditMenuInteractionAnimating>,
        );

        #[cfg(feature = "UIEditMenuInteraction")]
        #[optional]
        #[unsafe(method(willDismissEditMenuWithAnimator:))]
        #[unsafe(method_family = none)]
        fn willDismissEditMenuWithAnimator(
            &self,
            animator: &ProtocolObject<dyn UIEditMenuInteractionAnimating>,
        );

        #[optional]
        #[unsafe(method(supportsAdaptiveImageGlyph))]
        #[unsafe(method_family = none)]
        fn supportsAdaptiveImageGlyph(&self) -> bool;

        /// Setter for [`supportsAdaptiveImageGlyph`][Self::supportsAdaptiveImageGlyph].
        #[optional]
        #[unsafe(method(setSupportsAdaptiveImageGlyph:))]
        #[unsafe(method_family = none)]
        fn setSupportsAdaptiveImageGlyph(&self, supports_adaptive_image_glyph: bool);

        #[cfg(feature = "NSAdaptiveImageGlyph")]
        #[optional]
        #[unsafe(method(insertAdaptiveImageGlyph:replacementRange:))]
        #[unsafe(method_family = none)]
        fn insertAdaptiveImageGlyph_replacementRange(
            &self,
            adaptive_image_glyph: &NSAdaptiveImageGlyph,
            replacement_range: &UITextRange,
        );

        #[optional]
        #[unsafe(method(isEditable))]
        #[unsafe(method_family = none)]
        fn isEditable(&self) -> bool;

        #[optional]
        #[unsafe(method(insertAttributedText:))]
        #[unsafe(method_family = none)]
        fn insertAttributedText(&self, string: &NSAttributedString);

        #[optional]
        #[unsafe(method(attributedTextInRange:))]
        #[unsafe(method_family = none)]
        fn attributedTextInRange(&self, range: &UITextRange) -> Retained<NSAttributedString>;

        #[optional]
        #[unsafe(method(replaceRange:withAttributedText:))]
        #[unsafe(method_family = none)]
        fn replaceRange_withAttributedText(
            &self,
            range: &UITextRange,
            attributed_text: &NSAttributedString,
        );

        #[optional]
        #[unsafe(method(willPresentWritingTools))]
        #[unsafe(method_family = none)]
        fn willPresentWritingTools(&self);

        #[optional]
        #[unsafe(method(didDismissWritingTools))]
        #[unsafe(method_family = none)]
        fn didDismissWritingTools(&self);

        #[cfg(feature = "UIInputSuggestion")]
        /// Inserts the user or system’s input suggestion into the document.
        #[optional]
        #[unsafe(method(insertInputSuggestion:))]
        #[unsafe(method_family = none)]
        fn insertInputSuggestion(&self, input_suggestion: &UIInputSuggestion);
    }
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextinputtextbackgroundcolorkey?language=objc)
    #[deprecated]
    pub static UITextInputTextBackgroundColorKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextinputtextcolorkey?language=objc)
    #[deprecated]
    pub static UITextInputTextColorKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextinputtextfontkey?language=objc)
    #[deprecated]
    pub static UITextInputTextFontKey: &'static NSString;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextposition?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextPosition;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextPosition {}
);

impl UITextPosition {
    extern_methods!();
}

/// Methods declared on superclass `NSObject`.
impl UITextPosition {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextrange?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextRange;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextRange {}
);

impl UITextRange {
    extern_methods!(
        #[unsafe(method(isEmpty))]
        #[unsafe(method_family = none)]
        pub fn isEmpty(&self) -> bool;

        #[unsafe(method(start))]
        #[unsafe(method_family = none)]
        pub fn start(&self) -> Retained<UITextPosition>;

        #[unsafe(method(end))]
        #[unsafe(method_family = none)]
        pub fn end(&self) -> Retained<UITextPosition>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UITextRange {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextselectionrect?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextSelectionRect;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextSelectionRect {}
);

impl UITextSelectionRect {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(rect))]
        #[unsafe(method_family = none)]
        pub fn rect(&self) -> CGRect;

        #[cfg(feature = "NSText")]
        #[unsafe(method(writingDirection))]
        #[unsafe(method_family = none)]
        pub fn writingDirection(&self) -> NSWritingDirection;

        #[unsafe(method(containsStart))]
        #[unsafe(method_family = none)]
        pub fn containsStart(&self) -> bool;

        #[unsafe(method(containsEnd))]
        #[unsafe(method_family = none)]
        pub fn containsEnd(&self) -> bool;

        #[unsafe(method(isVertical))]
        #[unsafe(method_family = none)]
        pub fn isVertical(&self) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        /// Custom transform for highlight rects.
        /// This transform is assumed to be in the `textInputView` coordinate space.
        /// Default is CGAffineTransformIdentity (no transform applied).
        #[unsafe(method(transform))]
        #[unsafe(method_family = none)]
        pub fn transform(&self) -> CGAffineTransform;
    );
}

/// Methods declared on superclass `NSObject`.
impl UITextSelectionRect {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextinputdelegate?language=objc)
    pub unsafe trait UITextInputDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(feature = "UITextInputTraits")]
        #[unsafe(method(selectionWillChange:))]
        #[unsafe(method_family = none)]
        fn selectionWillChange(&self, text_input: Option<&ProtocolObject<dyn UITextInput>>);

        #[cfg(feature = "UITextInputTraits")]
        #[unsafe(method(selectionDidChange:))]
        #[unsafe(method_family = none)]
        fn selectionDidChange(&self, text_input: Option<&ProtocolObject<dyn UITextInput>>);

        #[cfg(feature = "UITextInputTraits")]
        #[unsafe(method(textWillChange:))]
        #[unsafe(method_family = none)]
        fn textWillChange(&self, text_input: Option<&ProtocolObject<dyn UITextInput>>);

        #[cfg(feature = "UITextInputTraits")]
        #[unsafe(method(textDidChange:))]
        #[unsafe(method_family = none)]
        fn textDidChange(&self, text_input: Option<&ProtocolObject<dyn UITextInput>>);

        #[cfg(all(feature = "UIConversationContext", feature = "UITextInputTraits"))]
        /// Tells the input delegate when text has changed in the input object for a conversation.
        #[unsafe(method(conversationContext:didChange:))]
        #[unsafe(method_family = none)]
        fn conversationContext_didChange(
            &self,
            context: Option<&UIConversationContext>,
            text_input: Option<&ProtocolObject<dyn UITextInput>>,
        );
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextinputtokenizer?language=objc)
    pub unsafe trait UITextInputTokenizer: NSObjectProtocol + MainThreadOnly {
        #[unsafe(method(rangeEnclosingPosition:withGranularity:inDirection:))]
        #[unsafe(method_family = none)]
        fn rangeEnclosingPosition_withGranularity_inDirection(
            &self,
            position: &UITextPosition,
            granularity: UITextGranularity,
            direction: UITextDirection,
        ) -> Option<Retained<UITextRange>>;

        #[unsafe(method(isPosition:atBoundary:inDirection:))]
        #[unsafe(method_family = none)]
        fn isPosition_atBoundary_inDirection(
            &self,
            position: &UITextPosition,
            granularity: UITextGranularity,
            direction: UITextDirection,
        ) -> bool;

        #[unsafe(method(positionFromPosition:toBoundary:inDirection:))]
        #[unsafe(method_family = none)]
        fn positionFromPosition_toBoundary_inDirection(
            &self,
            position: &UITextPosition,
            granularity: UITextGranularity,
            direction: UITextDirection,
        ) -> Option<Retained<UITextPosition>>;

        #[unsafe(method(isPosition:withinTextUnit:inDirection:))]
        #[unsafe(method_family = none)]
        fn isPosition_withinTextUnit_inDirection(
            &self,
            position: &UITextPosition,
            granularity: UITextGranularity,
            direction: UITextDirection,
        ) -> bool;
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextinputstringtokenizer?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextInputStringTokenizer;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextInputStringTokenizer {}
);

extern_conformance!(
    unsafe impl UITextInputTokenizer for UITextInputStringTokenizer {}
);

impl UITextInputStringTokenizer {
    extern_methods!(
        #[cfg(all(feature = "UIResponder", feature = "UITextInputTraits"))]
        /// # Safety
        ///
        /// `text_input` must implement UITextInput.
        #[unsafe(method(initWithTextInput:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithTextInput(
            this: Allocated<Self>,
            text_input: &UIResponder,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UITextInputStringTokenizer {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextinputmode?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextInputMode;
);

extern_conformance!(
    unsafe impl NSCoding for UITextInputMode {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextInputMode {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UITextInputMode {}
);

impl UITextInputMode {
    extern_methods!(
        #[unsafe(method(primaryLanguage))]
        #[unsafe(method_family = none)]
        pub fn primaryLanguage(&self) -> Option<Retained<NSString>>;

        #[deprecated]
        #[unsafe(method(currentInputMode))]
        #[unsafe(method_family = none)]
        pub fn currentInputMode(mtm: MainThreadMarker) -> Option<Retained<UITextInputMode>>;

        #[unsafe(method(activeInputModes))]
        #[unsafe(method_family = none)]
        pub fn activeInputModes(mtm: MainThreadMarker) -> Retained<NSArray<UITextInputMode>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UITextInputMode {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextinputcurrentinputmodedidchangenotification?language=objc)
    pub static UITextInputCurrentInputModeDidChangeNotification: &'static NSNotificationName;
}
