/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.auth.jaas.internal;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.openhab.core.auth.AuthenticationException;
import org.openhab.core.auth.Credentials;
import org.openhab.core.auth.UserRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedUserLoginModule
implements LoginModule {
    private final Logger logger = LoggerFactory.getLogger(ManagedUserLoginModule.class);
    private UserRegistry userRegistry;
    private Subject subject;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
    }

    @Override
    public boolean login() throws LoginException {
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(UserRegistry.class).getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(UserRegistry.class);
            this.userRegistry = (UserRegistry)bundleContext.getService(serviceReference);
        }
        catch (Exception e) {
            this.logger.error("Cannot initialize the ManagedLoginModule", (Throwable)e);
            throw new LoginException("Authorization failed");
        }
        try {
            Credentials credentials = (Credentials)this.subject.getPrivateCredentials().iterator().next();
            this.userRegistry.authenticate(credentials);
            return true;
        }
        catch (AuthenticationException e) {
            throw new LoginException(e.getMessage());
        }
    }

    @Override
    public boolean commit() throws LoginException {
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        return false;
    }
}

