/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { from, of } from 'rxjs';
import { map, switchMap } from 'rxjs/operators';
/**
 * Perform a side effect through a switchMap for every emission on the source Observable,
 * but return an Observable that is identical to the source. It's essentially the same as
 * the `tap` operator, but if the side effectful `next` function returns an ObservableInput,
 * it will wait before continuing with the original value.
 */
export function switchTap(next) {
    return switchMap(v => {
        const nextResult = next(v);
        if (nextResult) {
            return from(nextResult).pipe(map(() => v));
        }
        return of(v);
    });
}
//# sourceMappingURL=data:application/json;base64,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