/*
    SPDX-FileCopyrightText: 2011 Alex Richardson <alex.richardson@gmx.de>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#include "stringdata.hpp"

// lib
#include "stringdatainformation.hpp"

StringData::StringData(StringDataInformation* parent)
    : mParent(parent)
    , mMode(None)
    , mLittleEndian(true)
    , mEofReached(false)
{
}

StringData::~StringData() = default;

void StringData::setTerminationCodePoint(uint term)
{
    if (term > UNICODE_MAX) {
        mParent->logError() << "Attempting to set termination code point which is larger"
            " than 0x10ffff (max unicode):" << term;
        return;
    }
    mTerminationCodePoint = term;
    mMode |= Sequence;
}

void StringData::setEndianness(QSysInfo::Endian endianness)
{
    mLittleEndian = (endianness == QSysInfo::LittleEndian);
}
