/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleActionEvent;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEditableTextEvent;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableCellEvent;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueEvent;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkAttribute;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkEditableTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTableIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextRange;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextRectangle;
import org.eclipse.swt.internal.accessibility.gtk.AtkValueIface;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class AccessibleObject {
    long atkHandle;
    int index = -1;
    int id = -1;
    Accessible accessible;
    AccessibleObject parent;
    AccessibleObject[] children;
    boolean isLightweight = false;
    static long actionNamePtr = -1L;
    static long descriptionPtr = -1L;
    static long keybindingPtr = -1L;
    static long namePtr = -1L;
    static final Map<LONG, AccessibleObject> AccessibleObjects = new HashMap<LONG, AccessibleObject>(9);
    static final boolean DEBUG = Device.DEBUG;

    AccessibleObject(long type, long widget, Accessible accessible, boolean isLightweight) {
        if (type == OS.swt_fixed_get_type()) {
            this.atkHandle = widget != 0L && !isLightweight ? GTK.gtk_widget_get_accessible(widget) : OS.g_object_new(OS.swt_fixed_accessible_get_type(), 0L);
            OS.swt_fixed_accessible_register_accessible(this.atkHandle, false, widget);
        } else {
            this.atkHandle = GTK.gtk_widget_get_accessible(widget);
        }
        this.accessible = accessible;
        this.isLightweight = isLightweight;
        AccessibleObjects.put(new LONG(this.atkHandle), this);
    }

    static void print(String str) {
        System.out.println(str);
    }

    static int size(Collection<?> listeners) {
        return listeners == null ? 0 : listeners.size();
    }

    static AtkActionIface getParentActionIface(long atkObject) {
        long type = OS.swt_fixed_accessible_get_type();
        if (OS.g_type_is_a(OS.g_type_parent(type), ATK.ATK_TYPE_ACTION())) {
            AtkActionIface iface = new AtkActionIface();
            ATK.memmove(iface, OS.g_type_interface_peek_parent(ATK.ATK_ACTION_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkAction_do_action(long atkObject, long index) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleActionListener> listeners = accessible.accessibleActionListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                event.index = (int)index;
                for (int i = 0; i < length; ++i) {
                    AccessibleActionListener listener = listeners.get(i);
                    listener.doAction(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkActionIface iface = AccessibleObject.getParentActionIface(atkObject);
        if (iface != null && iface.do_action != 0L) {
            parentResult = ATK.call(iface.do_action, atkObject, index);
        }
        return parentResult;
    }

    static long atkAction_get_n_actions(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleActionListener> listeners = accessible.accessibleActionListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleActionListener listener = listeners.get(i);
                    listener.getActionCount(event);
                }
                return event.count;
            }
        }
        long parentResult = 0L;
        AtkActionIface iface = AccessibleObject.getParentActionIface(atkObject);
        if (iface != null && iface.get_n_actions != 0L) {
            parentResult = ATK.call(iface.get_n_actions, atkObject);
        }
        return parentResult;
    }

    static long atkAction_get_description(long atkObject, long index) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleActionListener> listeners = accessible.accessibleActionListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                event.index = (int)index;
                for (int i = 0; i < length; ++i) {
                    AccessibleActionListener listener = listeners.get(i);
                    listener.getDescription(event);
                }
                if (event.result == null) {
                    return 0L;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(event.result);
                return descriptionPtr;
            }
        }
        long parentResult = 0L;
        AtkActionIface iface = AccessibleObject.getParentActionIface(atkObject);
        if (iface != null && iface.get_description != 0L) {
            parentResult = ATK.call(iface.get_description, atkObject, index);
        }
        return parentResult;
    }

    static long atkAction_get_keybinding(long atkObject, long index) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkActionIface iface = AccessibleObject.getParentActionIface(atkObject);
        if (iface != null && iface.get_keybinding != 0L) {
            parentResult = ATK.call(iface.get_keybinding, atkObject, index);
        }
        if (object != null) {
            List<AccessibleListener> listeners2;
            Accessible accessible = object.accessible;
            List<AccessibleActionListener> listeners = accessible.accessibleActionListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                event.index = (int)index;
                for (int i = 0; i < length; ++i) {
                    AccessibleActionListener listener = listeners.get(i);
                    listener.getKeyBinding(event);
                }
                if (event.result != null) {
                    if (keybindingPtr != -1L) {
                        OS.g_free(keybindingPtr);
                    }
                    keybindingPtr = AccessibleObject.getStringPtr(event.result);
                    return keybindingPtr;
                }
            }
            if ((length = AccessibleObject.size(listeners2 = accessible.accessibleListeners)) > 0) {
                AccessibleEvent event = new AccessibleEvent(accessible);
                event.childID = object.id;
                if (parentResult != 0L) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                for (int i = 0; i < length; ++i) {
                    AccessibleListener listener = listeners2.get(i);
                    listener.getKeyboardShortcut(event);
                }
                if (event.result != null) {
                    if (keybindingPtr != -1L) {
                        OS.g_free(keybindingPtr);
                    }
                    keybindingPtr = AccessibleObject.getStringPtr(event.result);
                    return keybindingPtr;
                }
            }
        }
        return parentResult;
    }

    static long atkAction_get_name(long atkObject, long index) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkActionIface iface = AccessibleObject.getParentActionIface(atkObject);
        if (iface != null && iface.get_name != 0L) {
            parentResult = ATK.call(iface.get_name, atkObject, index);
        }
        if (object != null) {
            List<AccessibleControlListener> listeners2;
            Accessible accessible = object.accessible;
            List<AccessibleActionListener> listeners = accessible.accessibleActionListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleActionEvent event = new AccessibleActionEvent(accessible);
                event.index = (int)index;
                for (int i = 0; i < length; ++i) {
                    AccessibleActionListener listener = listeners.get(i);
                    listener.getName(event);
                }
                if (event.result != null) {
                    if (actionNamePtr != -1L) {
                        OS.g_free(actionNamePtr);
                    }
                    actionNamePtr = AccessibleObject.getStringPtr(event.result);
                    return actionNamePtr;
                }
            }
            if (index == 0L && (length = AccessibleObject.size(listeners2 = accessible.accessibleControlListeners)) > 0) {
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                if (parentResult != 0L) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                for (int i = 0; i < length; ++i) {
                    AccessibleControlListener listener = listeners2.get(i);
                    listener.getDefaultAction(event);
                }
                if (event.result != null) {
                    if (actionNamePtr != -1L) {
                        OS.g_free(actionNamePtr);
                    }
                    actionNamePtr = AccessibleObject.getStringPtr(event.result);
                    return actionNamePtr;
                }
            }
        }
        return parentResult;
    }

    static AtkComponentIface getParentComponentIface(long atkObject) {
        long type = OS.swt_fixed_accessible_get_type();
        if (OS.g_type_is_a(OS.g_type_parent(type), ATK.ATK_TYPE_COMPONENT())) {
            AtkComponentIface iface = new AtkComponentIface();
            ATK.memmove(iface, OS.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkComponent_get_extents(long atkObject, long x, long y, long width, long height, long coord_type) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        C.memmove(x, new int[]{0}, 4L);
        C.memmove(y, new int[]{0}, 4L);
        C.memmove(width, new int[]{0}, 4L);
        C.memmove(height, new int[]{0}, 4L);
        AtkComponentIface iface = AccessibleObject.getParentComponentIface(atkObject);
        if (iface != null && iface.get_extents != 0L) {
            OS.call(iface.get_extents, atkObject, x, y, width, height, coord_type);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                int[] parentX = new int[1];
                int[] parentY = new int[1];
                int[] parentWidth = new int[1];
                int[] parentHeight = new int[1];
                C.memmove(parentX, x, 4L);
                C.memmove(parentY, y, 4L);
                C.memmove(parentWidth, width, 4L);
                C.memmove(parentHeight, height, 4L);
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.x = parentX[0];
                event.y = parentY[0];
                event.width = parentWidth[0];
                event.height = parentHeight[0];
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coord_type == 1L) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x += topWindowX[0];
                    event.y += topWindowY[0];
                }
                for (int i = 0; i < length; ++i) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getLocation(event);
                }
                if (coord_type == 1L) {
                    event.x -= topWindowX[0];
                    event.y -= topWindowY[0];
                }
                C.memmove(x, new int[]{event.x}, 4L);
                C.memmove(y, new int[]{event.y}, 4L);
                C.memmove(width, new int[]{event.width}, 4L);
                C.memmove(height, new int[]{event.height}, 4L);
            }
        }
        return 0L;
    }

    static long atkComponent_get_position(long atkObject, long x, long y, long coord_type) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        C.memmove(x, new int[]{0}, 4L);
        C.memmove(y, new int[]{0}, 4L);
        AtkComponentIface iface = AccessibleObject.getParentComponentIface(atkObject);
        if (iface != null && iface.get_position != 0L) {
            OS.call(iface.get_position, atkObject, x, y, coord_type);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                int[] parentX = new int[1];
                int[] parentY = new int[1];
                C.memmove(parentX, x, 4L);
                C.memmove(parentY, y, 4L);
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.x = parentX[0];
                event.y = parentY[0];
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coord_type == 1L) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x += topWindowX[0];
                    event.y += topWindowY[0];
                }
                for (int i = 0; i < length; ++i) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getLocation(event);
                }
                if (coord_type == 1L) {
                    event.x -= topWindowX[0];
                    event.y -= topWindowY[0];
                }
                C.memmove(x, new int[]{event.x}, 4L);
                C.memmove(y, new int[]{event.y}, 4L);
            }
        }
        return 0L;
    }

    static long atkComponent_get_size(long atkObject, long width, long height, long coord_type) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        C.memmove(width, new int[]{0}, 4L);
        C.memmove(height, new int[]{0}, 4L);
        AtkComponentIface iface = AccessibleObject.getParentComponentIface(atkObject);
        if (iface != null && iface.get_size != 0L) {
            ATK.call(iface.get_size, atkObject, width, height);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                int[] parentWidth = new int[1];
                int[] parentHeight = new int[1];
                C.memmove(parentWidth, width, 4L);
                C.memmove(parentHeight, height, 4L);
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.width = parentWidth[0];
                event.height = parentHeight[0];
                for (int i = 0; i < length; ++i) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getLocation(event);
                }
                C.memmove(width, new int[]{event.width}, 4L);
                C.memmove(height, new int[]{event.height}, 4L);
            }
        }
        return 0L;
    }

    static long atkComponent_ref_accessible_at_point(long atkObject, long x, long y, long coord_type) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                Accessible result;
                AccessibleObject accObj;
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.x = (int)x;
                event.y = (int)y;
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coord_type == 1L) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x += topWindowX[0];
                    event.y += topWindowY[0];
                }
                for (int i = 0; i < length; ++i) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getChildAtPoint(event);
                }
                if (event.childID == object.id) {
                    event.childID = -1;
                }
                AccessibleObject accessibleObject = accObj = (result = event.accessible) != null ? result.getAccessibleObject() : object.getChildByID(event.childID);
                if (accObj != null) {
                    return OS.g_object_ref(accObj.atkHandle);
                }
            }
        }
        long parentResult = 0L;
        AtkComponentIface iface = AccessibleObject.getParentComponentIface(atkObject);
        if (iface != null && iface.ref_accessible_at_point != 0L) {
            parentResult = OS.call(iface.ref_accessible_at_point, atkObject, x, y, coord_type);
        }
        return parentResult;
    }

    static AtkEditableTextIface getParentEditableTextIface(long atkObject) {
        long type = OS.swt_fixed_accessible_get_type();
        if (OS.g_type_is_a(OS.g_type_parent(type), ATK.ATK_TYPE_EDITABLE_TEXT())) {
            AtkEditableTextIface iface = new AtkEditableTextIface();
            ATK.memmove(iface, OS.g_type_interface_peek_parent(ATK.ATK_EDITABLE_TEXT_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkEditableText_set_run_attributes(long atkObject, long attrib_set, long start_offset, long end_offset) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                Display display = accessible.control.getDisplay();
                long fontDesc = OS.pango_font_description_new();
                boolean createFont = false;
                TextStyle style = new TextStyle();
                String[] attributes = new String[]{};
                long current = attrib_set;
                int listLength = OS.g_slist_length(attrib_set);
                for (int i = 0; i < listLength; ++i) {
                    long attrPtr = OS.g_slist_data(current);
                    if (attrPtr != 0L) {
                        AtkAttribute attr = new AtkAttribute();
                        ATK.memmove(attr, attrPtr, AtkAttribute.sizeof);
                        String name = AccessibleObject.getString(attr.name);
                        String value = AccessibleObject.getString(attr.value);
                        OS.g_free(attrPtr);
                        String[] newAttributes = new String[attributes.length + 2];
                        System.arraycopy(attributes, 0, newAttributes, 0, attributes.length);
                        newAttributes[attributes.length] = name;
                        newAttributes[attributes.length + 1] = value;
                        attributes = newAttributes;
                        try {
                            if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(10)))) {
                                style.rise = Integer.parseInt(value);
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(11)))) {
                                if (value.equals("single") || value.equals("low")) {
                                    style.underline = true;
                                    style.underlineStyle = 0;
                                } else if (value.equals("double")) {
                                    style.underline = true;
                                    style.underlineStyle = 1;
                                } else if (value.equals("error")) {
                                    style.underline = true;
                                    style.underlineStyle = 2;
                                } else if (value.equals("squiggle")) {
                                    style.underline = true;
                                    style.underlineStyle = 3;
                                }
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(12)))) {
                                if (value.equals("true") || value.equals("1") || value.equals("single")) {
                                    style.strikeout = true;
                                }
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(17)))) {
                                byte[] buffer = Converter.wcsToMbcs(value, true);
                                OS.pango_font_description_set_family(fontDesc, buffer);
                                createFont = true;
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(13)))) {
                                float size = Float.parseFloat(value);
                                OS.pango_font_description_set_size(fontDesc, (int)(size * 1024.0f));
                                createFont = true;
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(27)))) {
                                int fontStyle = -1;
                                if (value.equals("normal")) {
                                    fontStyle = 0;
                                } else if (value.equals("italic")) {
                                    fontStyle = 2;
                                } else if (value.equals("oblique")) {
                                    fontStyle = 1;
                                }
                                if (fontStyle != -1) {
                                    OS.pango_font_description_set_style(fontDesc, fontStyle);
                                    createFont = true;
                                }
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(26)))) {
                                int variant = -1;
                                if (value.equals("normal")) {
                                    variant = 0;
                                } else if (value.equals("small_caps")) {
                                    variant = 1;
                                }
                                if (variant != -1) {
                                    OS.pango_font_description_set_variant(fontDesc, variant);
                                    createFont = true;
                                }
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(25)))) {
                                int stretch = -1;
                                if (value.equals("ultra_condensed")) {
                                    stretch = 0;
                                } else if (value.equals("extra_condensed")) {
                                    stretch = 1;
                                } else if (value.equals("condensed")) {
                                    stretch = 2;
                                } else if (value.equals("semi_condensed")) {
                                    stretch = 3;
                                } else if (value.equals("normal")) {
                                    stretch = 4;
                                } else if (value.equals("semi_expanded")) {
                                    stretch = 5;
                                } else if (value.equals("expanded")) {
                                    stretch = 6;
                                } else if (value.equals("extra_expanded")) {
                                    stretch = 7;
                                } else if (value.equals("ultra_expanded")) {
                                    stretch = 8;
                                }
                                if (stretch != -1) {
                                    OS.pango_font_description_set_stretch(fontDesc, stretch);
                                    createFont = true;
                                }
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(15)))) {
                                int weight = Integer.parseInt(value);
                                OS.pango_font_description_set_weight(fontDesc, weight);
                                createFont = true;
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(19)))) {
                                style.foreground = AccessibleObject.colorFromString(display, value);
                            } else if (name.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(18)))) {
                                style.background = AccessibleObject.colorFromString(display, value);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    current = OS.g_slist_next(current);
                }
                if (createFont) {
                    style.font = Font.gtk_new(display, fontDesc);
                }
                AccessibleTextAttributeEvent event = new AccessibleTextAttributeEvent(accessible);
                event.start = (int)start_offset;
                event.end = (int)end_offset;
                event.textStyle = style;
                event.attributes = attributes;
                for (int i = 0; i < length; ++i) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.setTextAttributes(event);
                }
                if (style.font != null) {
                    style.font.dispose();
                }
                if (style.foreground != null) {
                    style.foreground.dispose();
                }
                if (style.background != null) {
                    style.background.dispose();
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getParentEditableTextIface(atkObject);
        if (iface != null && iface.set_run_attributes != 0L) {
            parentResult = OS.call(iface.set_run_attributes, atkObject, attrib_set, start_offset, end_offset);
        }
        return parentResult;
    }

    static Color colorFromString(Display display, String rgbString) {
        try {
            int comma1 = rgbString.indexOf(44);
            int comma2 = rgbString.indexOf(44, comma1 + 1);
            int r = Integer.parseInt(rgbString.substring(0, comma1));
            int g = Integer.parseInt(rgbString.substring(comma1 + 1, comma2));
            int b = Integer.parseInt(rgbString.substring(comma2 + 1, rgbString.length()));
            return new Color(display, r, g, b);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static long atkEditableText_set_text_contents(long atkObject, long string) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(accessible);
                event.start = 0;
                String text = object.getText();
                event.end = text == null ? 0 : text.length();
                event.string = AccessibleObject.getString(string);
                for (int i = 0; i < length; ++i) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.replaceText(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getParentEditableTextIface(atkObject);
        if (iface != null && iface.set_text_contents != 0L) {
            parentResult = ATK.call(iface.set_text_contents, atkObject, string);
        }
        return parentResult;
    }

    static long atkEditableText_insert_text(long atkObject, long string, long string_length, long position) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(accessible);
                int[] pos = new int[1];
                C.memmove(pos, position, (long)C.PTR_SIZEOF);
                event.start = event.end = pos[0];
                event.string = AccessibleObject.getString(string);
                for (int i = 0; i < length; ++i) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.replaceText(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getParentEditableTextIface(atkObject);
        if (iface != null && iface.insert_text != 0L) {
            parentResult = OS.call(iface.insert_text, atkObject, string, string_length, position);
        }
        return parentResult;
    }

    static long atkEditableText_copy_text(long atkObject, long start_pos, long end_pos) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(accessible);
                event.start = (int)start_pos;
                event.end = (int)end_pos;
                for (int i = 0; i < length; ++i) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.copyText(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getParentEditableTextIface(atkObject);
        if (iface != null && iface.copy_text != 0L) {
            parentResult = ATK.call(iface.copy_text, atkObject, start_pos, end_pos);
        }
        return parentResult;
    }

    static long atkEditableText_cut_text(long atkObject, long start_pos, long end_pos) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(accessible);
                event.start = (int)start_pos;
                event.end = (int)end_pos;
                for (int i = 0; i < length; ++i) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.cutText(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getParentEditableTextIface(atkObject);
        if (iface != null && iface.cut_text != 0L) {
            parentResult = ATK.call(iface.cut_text, atkObject, start_pos, end_pos);
        }
        return parentResult;
    }

    static long atkEditableText_delete_text(long atkObject, long start_pos, long end_pos) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(accessible);
                event.start = (int)start_pos;
                event.end = (int)end_pos;
                event.string = "";
                for (int i = 0; i < length; ++i) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.replaceText(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getParentEditableTextIface(atkObject);
        if (iface != null && iface.delete_text != 0L) {
            parentResult = ATK.call(iface.delete_text, atkObject, start_pos, end_pos);
        }
        return parentResult;
    }

    static long atkEditableText_paste_text(long atkObject, long position) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleEditableTextListener> listeners = accessible.accessibleEditableTextListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(accessible);
                event.start = (int)position;
                for (int i = 0; i < length; ++i) {
                    AccessibleEditableTextListener listener = listeners.get(i);
                    listener.pasteText(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkEditableTextIface iface = AccessibleObject.getParentEditableTextIface(atkObject);
        if (iface != null && iface.paste_text != 0L) {
            parentResult = ATK.call(iface.paste_text, atkObject, position);
        }
        return parentResult;
    }

    static AtkHypertextIface getParentHypertextIface(long atkObject) {
        long type = OS.swt_fixed_accessible_get_type();
        if (OS.g_type_is_a(OS.g_type_parent(type), ATK.ATK_TYPE_HYPERTEXT())) {
            AtkHypertextIface iface = new AtkHypertextIface();
            ATK.memmove(iface, OS.g_type_interface_peek_parent(ATK.ATK_HYPERTEXT_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkHypertext_get_link(long atkObject, long link_index) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.index = (int)link_index;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getHyperlink(event);
                }
                Accessible result = event.accessible;
                return result != null ? result.getAccessibleObject().atkHandle : 0L;
            }
        }
        long parentResult = 0L;
        AtkHypertextIface iface = AccessibleObject.getParentHypertextIface(atkObject);
        if (iface != null && iface.get_link != 0L) {
            parentResult = ATK.call(iface.get_link, atkObject, link_index);
        }
        return parentResult;
    }

    static long atkHypertext_get_n_links(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getHyperlinkCount(event);
                }
                return event.count;
            }
        }
        long parentResult = 0L;
        AtkHypertextIface iface = AccessibleObject.getParentHypertextIface(atkObject);
        if (iface != null && iface.get_n_links != 0L) {
            parentResult = ATK.call(iface.get_n_links, atkObject);
        }
        return parentResult;
    }

    static long atkHypertext_get_link_index(long atkObject, long char_index) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.offset = (int)char_index;
                event.index = -1;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getHyperlinkIndex(event);
                }
                return event.index;
            }
        }
        long parentResult = 0L;
        AtkHypertextIface iface = AccessibleObject.getParentHypertextIface(atkObject);
        if (iface != null && iface.get_link_index != 0L) {
            parentResult = ATK.call(iface.get_link_index, atkObject, char_index);
        }
        return parentResult;
    }

    static AtkObjectClass getParentAtkObjectClass() {
        long parentType;
        AtkObjectClass objectClass = new AtkObjectClass();
        long type = OS.swt_fixed_accessible_get_type();
        if (type != 0L && (parentType = OS.g_type_parent(type)) != 0L) {
            ATK.memmove(objectClass, OS.g_type_class_peek(parentType));
        }
        return objectClass;
    }

    static long atkObject_get_description(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkObjectClass objectClass = AccessibleObject.getParentAtkObjectClass();
        if (objectClass.get_description != 0L) {
            parentResult = ATK.call(objectClass.get_description, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleListener> listeners = accessible.accessibleListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEvent event = new AccessibleEvent(accessible);
                event.childID = object.id;
                if (parentResult != 0L) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                for (int i = 0; i < length; ++i) {
                    AccessibleListener listener = listeners.get(i);
                    listener.getDescription(event);
                }
                if (event.result == null) {
                    return parentResult;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(event.result);
                return descriptionPtr;
            }
        }
        return parentResult;
    }

    static long atkObject_get_attributes(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkObjectClass objectClass = AccessibleObject.getParentAtkObjectClass();
        if (objectClass.get_attributes != 0L) {
            parentResult = ATK.call(objectClass.get_attributes, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleAttributeListener> listeners = accessible.accessibleAttributeListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                Control control;
                int posinset;
                AccessibleAttributeEvent event = new AccessibleAttributeEvent(accessible);
                event.groupIndex = -1;
                event.groupCount = -1;
                event.groupLevel = -1;
                event.indent = -1;
                event.alignment = -1;
                event.rightMargin = -1;
                event.leftMargin = -1;
                event.bottomMargin = -1;
                event.topMargin = -1;
                for (int i = 0; i < length; ++i) {
                    AccessibleAttributeListener listener = listeners.get(i);
                    listener.getAttributes(event);
                }
                AtkAttribute attr = new AtkAttribute();
                if (event.leftMargin != -1) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(1));
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(event.leftMargin));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (event.rightMargin != -1) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(2));
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(event.rightMargin));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (event.topMargin != -1) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = AccessibleObject.getStringPtr("top-margin");
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(event.topMargin));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (event.bottomMargin != -1) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = AccessibleObject.getStringPtr("bottom-margin");
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(event.bottomMargin));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (event.indent != -1) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(3));
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(event.indent));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (event.justify) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(24));
                    attr.value = AccessibleObject.getStringPtr("fill");
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                } else if (event.alignment != -1) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(24));
                    String str = "left";
                    switch (event.alignment) {
                        case 16384: {
                            str = "left";
                            break;
                        }
                        case 131072: {
                            str = "right";
                            break;
                        }
                        case 0x1000000: {
                            str = "center";
                        }
                    }
                    attr.value = AccessibleObject.getStringPtr(str);
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                int level = event.groupLevel != -1 ? event.groupLevel : 0;
                int setsize = event.groupCount != -1 ? event.groupCount : 0;
                int n = posinset = event.groupIndex != -1 ? event.groupIndex : 0;
                if (setsize == 0 && posinset == 0 && (control = accessible.control) instanceof Button && (control.getStyle() & 0x10) != 0) {
                    Control[] children = control.getParent().getChildren();
                    posinset = 1;
                    setsize = 1;
                    for (int i = 0; i < children.length; ++i) {
                        Control child = children[i];
                        if (!(child instanceof Button) || (child.getStyle() & 0x10) == 0) continue;
                        if (child == control) {
                            posinset = setsize;
                            continue;
                        }
                        ++setsize;
                    }
                }
                if (level != 0) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = AccessibleObject.getStringPtr("level");
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(level));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (setsize != 0) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = AccessibleObject.getStringPtr("setsize");
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(setsize));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (posinset != 0) {
                    long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                    attr.name = AccessibleObject.getStringPtr("posinset");
                    attr.value = AccessibleObject.getStringPtr(String.valueOf(posinset));
                    ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                    parentResult = OS.g_slist_append(parentResult, attrPtr);
                }
                if (event.attributes != null) {
                    int end = event.attributes.length / 2 * 2;
                    for (int i = 0; i < end; i += 2) {
                        long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = AccessibleObject.getStringPtr(event.attributes[i]);
                        attr.value = AccessibleObject.getStringPtr(event.attributes[i + 1]);
                        ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                        parentResult = OS.g_slist_append(parentResult, attrPtr);
                    }
                }
            }
        }
        return parentResult;
    }

    static long atkObject_get_name(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkObjectClass objectClass = AccessibleObject.getParentAtkObjectClass();
        if (objectClass.get_name != 0L) {
            parentResult = ATK.call(objectClass.get_name, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleListener> listeners = accessible.accessibleListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleEvent event = new AccessibleEvent(accessible);
                event.childID = object.id;
                if (parentResult != 0L) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                for (int i = 0; i < length; ++i) {
                    AccessibleListener listener = listeners.get(i);
                    listener.getName(event);
                }
                if (event.result == null) {
                    return parentResult;
                }
                if (namePtr != -1L) {
                    OS.g_free(namePtr);
                }
                namePtr = AccessibleObject.getStringPtr(event.result);
                return namePtr;
            }
        }
        return parentResult;
    }

    static long atkObject_get_n_children(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkObjectClass objectClass = AccessibleObject.getParentAtkObjectClass();
        if (objectClass.get_n_children != 0L) {
            parentResult = ATK.call(objectClass.get_n_children, atkObject);
        }
        if (object != null && object.id == -1) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.detail = (int)parentResult;
                for (int i = 0; i < length; ++i) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getChildCount(event);
                }
                return event.detail;
            }
        }
        return parentResult;
    }

    static long atkObject_get_index_in_parent(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            AccessibleControlEvent event = new AccessibleControlEvent(accessible);
            event.childID = -5;
            event.detail = -1;
            for (int i = 0; i < AccessibleObject.size(listeners); ++i) {
                AccessibleControlListener listener = listeners.get(i);
                listener.getChild(event);
            }
            if (event.detail != -1) {
                return event.detail;
            }
            if (object.index != -1) {
                return object.index;
            }
        }
        AtkObjectClass objectClass = AccessibleObject.getParentAtkObjectClass();
        if (objectClass.get_index_in_parent == 0L) {
            return 0L;
        }
        long result = ATK.call(objectClass.get_index_in_parent, atkObject);
        return result;
    }

    static long atkObject_get_parent(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null && object.parent != null) {
            return object.parent.atkHandle;
        }
        AtkObjectClass objectClass = AccessibleObject.getParentAtkObjectClass();
        if (objectClass.get_parent == 0L) {
            return 0L;
        }
        long parentResult = ATK.call(objectClass.get_parent, atkObject);
        return parentResult;
    }

    static long atkObject_get_role(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.detail = -1;
                for (int i = 0; i < length; ++i) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getRole(event);
                }
                if (event.detail != -1) {
                    switch (event.detail) {
                        case 44: {
                            return 7L;
                        }
                        case 10: {
                            return 18L;
                        }
                        case 46: {
                            return 11L;
                        }
                        case 18: {
                            return 16L;
                        }
                        case 41: {
                            return 28L;
                        }
                        case 30: {
                            return 60L;
                        }
                        case 33: {
                            return 30L;
                        }
                        case 34: {
                            return 31L;
                        }
                        case 11: {
                            return 32L;
                        }
                        case 2: {
                            return 33L;
                        }
                        case 12: {
                            return 34L;
                        }
                        case 48: {
                            return 41L;
                        }
                        case 43: {
                            return 42L;
                        }
                        case 3: {
                            return 47L;
                        }
                        case 21: {
                            return 49L;
                        }
                        case 51: {
                            return 50L;
                        }
                        case 24: {
                            return 54L;
                        }
                        case 29: {
                            return 55L;
                        }
                        case 25: {
                            return 56L;
                        }
                        case 26: {
                            return 57L;
                        }
                        case 60: {
                            return 37L;
                        }
                        case 37: {
                            return 36L;
                        }
                        case 42: {
                            return 60L;
                        }
                        case 22: {
                            return 62L;
                        }
                        case 13: {
                            return 63L;
                        }
                        case 35: {
                            return 64L;
                        }
                        case 36: {
                            return 31L;
                        }
                        case 45: {
                            return 43L;
                        }
                        case 62: {
                            return 42L;
                        }
                        case 9: {
                            return 68L;
                        }
                        case 28: {
                            return 88L;
                        }
                        case 27: {
                            return 66L;
                        }
                        case 8: {
                            return 2L;
                        }
                        case 54: {
                            return 3L;
                        }
                        case 1025: {
                            return 6L;
                        }
                        case 20: {
                            return 38L;
                        }
                        case 52: {
                            return 52L;
                        }
                        case 23: {
                            return 53L;
                        }
                        case 1027: {
                            return 8L;
                        }
                        case 1073: {
                            return 44L;
                        }
                        case 61: {
                            return 66L;
                        }
                        case 47: {
                            return 4L;
                        }
                        case 1029: {
                            return 12L;
                        }
                        case 1038: {
                            return 70L;
                        }
                        case 1040: {
                            return 85L;
                        }
                        case 1043: {
                            return 69L;
                        }
                        case 1044: {
                            return 81L;
                        }
                        case 1053: {
                            return 82L;
                        }
                        case 1054: {
                            return 71L;
                        }
                        case 1060: {
                            return 83L;
                        }
                        case 15: {
                            return 80L;
                        }
                        case 40: {
                            return 26L;
                        }
                    }
                }
            }
        }
        AtkObjectClass objectClass = AccessibleObject.getParentAtkObjectClass();
        if (objectClass.get_role == 0L) {
            return 0L;
        }
        return ATK.call(objectClass.get_role, atkObject);
    }

    static long atkObject_ref_child(long atkObject, long index) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null && object.id == -1) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleObject accObject;
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = -4;
                event.detail = (int)index;
                for (int i = 0; i < length; ++i) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getChild(event);
                }
                if (event.accessible != null && (accObject = event.accessible.getAccessibleObject()) != null) {
                    return OS.g_object_ref(accObject.atkHandle);
                }
            }
            object.updateChildren();
            AccessibleObject accObject = object.getChildByIndex((int)index);
            if (accObject != null) {
                return OS.g_object_ref(accObject.atkHandle);
            }
        }
        AtkObjectClass objectClass = AccessibleObject.getParentAtkObjectClass();
        if (objectClass.ref_child == 0L) {
            return 0L;
        }
        return ATK.call(objectClass.ref_child, atkObject, index);
    }

    static long atkObject_ref_state_set(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkObjectClass objectClass = AccessibleObject.getParentAtkObjectClass();
        if (objectClass.ref_state_set != 0L) {
            parentResult = ATK.call(objectClass.ref_state_set, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                long set = parentResult;
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                event.detail = -1;
                for (int i = 0; i < length; ++i) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getState(event);
                }
                if (event.detail != -1) {
                    int state = event.detail;
                    if ((state & 0x800) != 0) {
                        ATK.atk_state_set_add_state(set, 3);
                    }
                    if ((state & 0x10) != 0) {
                        ATK.atk_state_set_add_state(set, 4);
                    }
                    if ((state & 0x200) != 0) {
                        ATK.atk_state_set_add_state(set, 9);
                    }
                    if ((state & 0x100000) != 0) {
                        ATK.atk_state_set_add_state(set, 10);
                    }
                    if ((state & 4) != 0) {
                        ATK.atk_state_set_add_state(set, 11);
                    }
                    if ((state & 0x80) != 0) {
                        ATK.atk_state_set_add_state(set, 2);
                    }
                    if ((state & 0x8000) == 0) {
                        ATK.atk_state_set_add_state(set, 28);
                    }
                    if ((state & 0x1000000) != 0) {
                        ATK.atk_state_set_add_state(set, 16);
                    }
                    if ((state & 0x10000) == 0) {
                        ATK.atk_state_set_add_state(set, 23);
                    }
                    if ((state & 8) != 0) {
                        ATK.atk_state_set_add_state(set, 18);
                    }
                    if ((state & 0x40) == 0) {
                        ATK.atk_state_set_add_state(set, 6);
                    }
                    if ((state & 0x200000) != 0) {
                        ATK.atk_state_set_add_state(set, 20);
                    }
                    if ((state & 2) != 0) {
                        ATK.atk_state_set_add_state(set, 21);
                    }
                    if ((state & 0x20000) != 0) {
                        ATK.atk_state_set_add_state(set, 19);
                    }
                    if ((state & 1) == 0) {
                        ATK.atk_state_set_add_state(set, 7);
                    }
                    if ((state & 0x4000000) != 0) {
                        ATK.atk_state_set_add_state(set, 1);
                    }
                    if ((state & 0x8000000) != 0) {
                        ATK.atk_state_set_add_state(set, 24);
                    }
                    if ((state & 0x10000000) != 0) {
                        ATK.atk_state_set_add_state(set, 15);
                    }
                    if ((state & 0x2000000) != 0) {
                        ATK.atk_state_set_add_state(set, 32);
                    }
                    if ((state & 0x20000000) != 0) {
                        ATK.atk_state_set_add_state(set, 33);
                    }
                    if ((state & 0x40000000) != 0) {
                        ATK.atk_state_set_add_state(set, 34);
                    }
                }
                return set;
            }
        }
        return parentResult;
    }

    static AtkSelectionIface getParentSelectionIface(long atkObject) {
        long type = OS.swt_fixed_accessible_get_type();
        if (OS.g_type_is_a(OS.g_type_parent(type), ATK.ATK_TYPE_SELECTION())) {
            AtkSelectionIface iface = new AtkSelectionIface();
            ATK.memmove(iface, OS.g_type_interface_peek_parent(ATK.ATK_SELECTION_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkSelection_is_child_selected(long atkObject, long index) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkSelectionIface iface = AccessibleObject.getParentSelectionIface(atkObject);
        if (iface != null && iface.is_child_selected != 0L) {
            parentResult = ATK.call(iface.is_child_selected, atkObject, index);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleObject accessibleObject;
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                for (int i = 0; i < length; ++i) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getSelection(event);
                }
                Accessible result = event.accessible;
                AccessibleObject accessibleObject2 = accessibleObject = result != null ? result.getAccessibleObject() : object.getChildByID(event.childID);
                if (accessibleObject != null) {
                    return (long)accessibleObject.index == index ? 1L : 0L;
                }
            }
        }
        return parentResult;
    }

    static long atkSelection_ref_selection(long atkObject, long index) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkSelectionIface iface = AccessibleObject.getParentSelectionIface(atkObject);
        if (iface != null && iface.ref_selection != 0L) {
            parentResult = ATK.call(iface.ref_selection, atkObject, index);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleControlListener> listeners = accessible.accessibleControlListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleControlEvent event = new AccessibleControlEvent(accessible);
                event.childID = object.id;
                for (int i = 0; i < length; ++i) {
                    AccessibleControlListener listener = listeners.get(i);
                    listener.getSelection(event);
                }
                AccessibleObject accObj = object.getChildByID(event.childID);
                if (accObj != null) {
                    if (parentResult != 0L) {
                        OS.g_object_unref(parentResult);
                    }
                    OS.g_object_ref(accObj.atkHandle);
                    return accObj.atkHandle;
                }
            }
        }
        return parentResult;
    }

    static AtkTableIface getParentTableIface(long atkObject) {
        long type = OS.swt_fixed_accessible_get_type();
        if (OS.g_type_is_a(OS.g_type_parent(type), ATK.ATK_TYPE_TABLE())) {
            AtkTableIface iface = new AtkTableIface();
            ATK.memmove(iface, OS.g_type_interface_peek_parent(ATK.ATK_TABLE_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkTable_ref_at(long atkObject, long row, long column) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                event.column = (int)column;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getCell(event);
                }
                Accessible result = event.accessible;
                if (result != null) {
                    AccessibleObject accessibleObject = result.getAccessibleObject();
                    OS.g_object_ref(accessibleObject.atkHandle);
                    return accessibleObject.atkHandle;
                }
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.ref_at != 0L) {
            parentResult = ATK.call(iface.ref_at, atkObject, row, column);
        }
        return parentResult;
    }

    static long atkTable_get_index_at(long atkObject, long row, long column) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                event.column = (int)column;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getCell(event);
                }
                Accessible result = event.accessible;
                if (result == null) {
                    return -1L;
                }
                event = new AccessibleTableEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getColumnCount(event);
                }
                return row * (long)event.count + column;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_index_at != 0L) {
            parentResult = ATK.call(iface.get_index_at, atkObject, row, column);
        }
        return parentResult;
    }

    static long atkTable_get_column_at_index(long atkObject, long index) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getColumnCount(event);
                }
                long result = event.count == 0 ? -1L : index % (long)event.count;
                return result;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_column_at_index != 0L) {
            parentResult = ATK.call(iface.get_column_at_index, atkObject, index);
        }
        return parentResult;
    }

    static long atkTable_get_row_at_index(long atkObject, long index) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getColumnCount(event);
                }
                long result = event.count == 0 ? -1L : index / (long)event.count;
                return result;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_row_at_index != 0L) {
            parentResult = ATK.call(iface.get_row_at_index, atkObject, index);
        }
        return parentResult;
    }

    static long atkTable_get_n_columns(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_n_columns != 0L) {
            parentResult = ATK.call(iface.get_n_columns, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.count = (int)parentResult;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getColumnCount(event);
                    parentResult = event.count;
                }
            }
        }
        return parentResult;
    }

    static long atkTable_get_n_rows(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_n_rows != 0L) {
            parentResult = ATK.call(iface.get_n_rows, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.count = (int)parentResult;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getRowCount(event);
                    parentResult = event.count;
                }
            }
        }
        return parentResult;
    }

    static long atkTable_get_column_extent_at(long atkObject, long row, long column) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_column_extent_at != 0L) {
            parentResult = ATK.call(iface.get_column_extent_at, atkObject, row, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                List<AccessibleTableCellListener> listeners2;
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                event.column = (int)column;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getCell(event);
                }
                Accessible result = event.accessible;
                if (result != null && (length = AccessibleObject.size(listeners2 = result.accessibleTableCellListeners)) > 0) {
                    AccessibleTableCellEvent cellEvent = new AccessibleTableCellEvent(result);
                    cellEvent.count = (int)parentResult;
                    for (int i = 0; i < length; ++i) {
                        AccessibleTableCellListener listener = listeners2.get(i);
                        listener.getColumnSpan(cellEvent);
                    }
                    return cellEvent.count;
                }
            }
        }
        return parentResult;
    }

    static long atkTable_get_row_extent_at(long atkObject, long row, long column) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_row_extent_at != 0L) {
            parentResult = ATK.call(iface.get_row_extent_at, atkObject, row, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                List<AccessibleTableCellListener> listeners2;
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                event.column = (int)column;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getCell(event);
                }
                Accessible result = event.accessible;
                if (result != null && (length = AccessibleObject.size(listeners2 = result.accessibleTableCellListeners)) > 0) {
                    AccessibleTableCellEvent cellEvent = new AccessibleTableCellEvent(result);
                    cellEvent.count = (int)parentResult;
                    for (int i = 0; i < length; ++i) {
                        AccessibleTableCellListener listener = listeners2.get(i);
                        listener.getRowSpan(cellEvent);
                    }
                    return cellEvent.count;
                }
            }
        }
        return parentResult;
    }

    static long atkTable_get_caption(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getCaption(event);
                }
                Accessible result = event.accessible;
                if (result != null) {
                    return result.getAccessibleObject().atkHandle;
                }
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_caption != 0L) {
            parentResult = ATK.call(iface.get_caption, atkObject);
        }
        return parentResult;
    }

    static long atkTable_get_summary(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getSummary(event);
                }
                Accessible result = event.accessible;
                if (result != null) {
                    return result.getAccessibleObject().atkHandle;
                }
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_summary != 0L) {
            parentResult = ATK.call(iface.get_summary, atkObject);
        }
        return parentResult;
    }

    static long atkTable_get_column_description(long atkObject, long column) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_column_description != 0L) {
            parentResult = ATK.call(iface.get_column_description, atkObject, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.column = (int)column;
                if (parentResult != 0L) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getColumnDescription(event);
                }
                if (event.result == null) {
                    return parentResult;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(event.result);
                return descriptionPtr;
            }
        }
        return parentResult;
    }

    static long atkTable_get_column_header(long atkObject, long column) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getRowHeaderCells(event);
                }
                Accessible[] accessibles = event.accessibles;
                if (accessibles != null && 0L <= column && column < (long)accessibles.length) {
                    return accessibles[(int)column].getAccessibleObject().atkHandle;
                }
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_column_header != 0L) {
            parentResult = ATK.call(iface.get_column_header, atkObject, column);
        }
        return parentResult;
    }

    static long atkTable_get_row_description(long atkObject, long row) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_row_description != 0L) {
            parentResult = ATK.call(iface.get_row_description, atkObject, row);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                if (parentResult != 0L) {
                    event.result = AccessibleObject.getString(parentResult);
                }
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getRowDescription(event);
                }
                if (event.result == null) {
                    return parentResult;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(event.result);
                return descriptionPtr;
            }
        }
        return parentResult;
    }

    static long atkTable_get_row_header(long atkObject, long row) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getRowHeaderCells(event);
                }
                Accessible[] accessibles = event.accessibles;
                if (accessibles != null && 0L <= row && row < (long)accessibles.length) {
                    return accessibles[(int)row].getAccessibleObject().atkHandle;
                }
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_row_header != 0L) {
            parentResult = ATK.call(iface.get_row_header, atkObject, row);
        }
        return parentResult;
    }

    static long atkTable_get_selected_columns(long atkObject, long selected) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getSelectedColumns(event);
                }
                int count = event.selected != null ? event.selected.length : 0;
                long result = OS.g_malloc(count * 4);
                if (event.selected != null) {
                    C.memmove(result, event.selected, (long)(count * 4));
                }
                if (selected != 0L) {
                    C.memmove(selected, new long[]{result}, (long)C.PTR_SIZEOF);
                }
                return count;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_selected_columns != 0L) {
            parentResult = ATK.call(iface.get_selected_columns, atkObject, selected);
        }
        return parentResult;
    }

    static long atkTable_get_selected_rows(long atkObject, long selected) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getSelectedRows(event);
                }
                int count = event.selected != null ? event.selected.length : 0;
                long result = OS.g_malloc(count * 4);
                if (event.selected != null) {
                    C.memmove(result, event.selected, (long)(count * 4));
                }
                if (selected != 0L) {
                    C.memmove(selected, new long[]{result}, (long)C.PTR_SIZEOF);
                }
                return count;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.get_selected_rows != 0L) {
            parentResult = ATK.call(iface.get_selected_rows, atkObject, selected);
        }
        return parentResult;
    }

    static long atkTable_is_column_selected(long atkObject, long column) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.is_column_selected != 0L) {
            parentResult = ATK.call(iface.is_column_selected, atkObject, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.isSelected = parentResult != 0L;
                event.column = (int)column;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.isColumnSelected(event);
                }
                return event.isSelected ? 1L : 0L;
            }
        }
        return parentResult;
    }

    static long atkTable_is_row_selected(long atkObject, long row) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.is_row_selected != 0L) {
            parentResult = ATK.call(iface.is_row_selected, atkObject, row);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.isSelected = parentResult != 0L;
                event.row = (int)row;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.isRowSelected(event);
                }
                return event.isSelected ? 1L : 0L;
            }
        }
        return parentResult;
    }

    static long atkTable_is_selected(long atkObject, long row, long column) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.is_selected != 0L) {
            parentResult = ATK.call(iface.is_selected, atkObject, row, column);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                List<AccessibleTableCellListener> listeners2;
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                event.column = (int)column;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.getCell(event);
                }
                Accessible result = event.accessible;
                if (result != null && (length = AccessibleObject.size(listeners2 = result.accessibleTableCellListeners)) > 0) {
                    AccessibleTableCellEvent cellEvent = new AccessibleTableCellEvent(result);
                    cellEvent.isSelected = parentResult != 0L;
                    for (int i = 0; i < length; ++i) {
                        AccessibleTableCellListener listener = listeners2.get(i);
                        listener.isSelected(cellEvent);
                    }
                    return cellEvent.isSelected ? 1L : 0L;
                }
            }
        }
        return parentResult;
    }

    static long atkTable_add_row_selection(long atkObject, long row) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.selectRow(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.add_row_selection != 0L) {
            parentResult = ATK.call(iface.add_row_selection, atkObject, row);
        }
        return parentResult;
    }

    static long atkTable_remove_row_selection(long atkObject, long row) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.row = (int)row;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.deselectRow(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.remove_row_selection != 0L) {
            parentResult = ATK.call(iface.remove_row_selection, atkObject, row);
        }
        return parentResult;
    }

    static long atkTable_add_column_selection(long atkObject, long column) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.column = (int)column;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.selectColumn(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.add_column_selection != 0L) {
            parentResult = ATK.call(iface.add_column_selection, atkObject, column);
        }
        return parentResult;
    }

    static long atkTable_remove_column_selection(long atkObject, long column) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTableListener> listeners = accessible.accessibleTableListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTableEvent event = new AccessibleTableEvent(accessible);
                event.column = (int)column;
                for (int i = 0; i < length; ++i) {
                    AccessibleTableListener listener = listeners.get(i);
                    listener.deselectColumn(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkTableIface iface = AccessibleObject.getParentTableIface(atkObject);
        if (iface != null && iface.remove_column_selection != 0L) {
            parentResult = ATK.call(iface.remove_column_selection, atkObject, column);
        }
        return parentResult;
    }

    static AtkTextIface getParentTextIface(long atkObject) {
        long type = OS.swt_fixed_accessible_get_type();
        if (OS.g_type_is_a(OS.g_type_parent(type), ATK.ATK_TYPE_TEXT())) {
            AtkTextIface iface = new AtkTextIface();
            ATK.memmove(iface, OS.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static String getString(long strPtr) {
        int length = C.strlen(strPtr);
        byte[] buffer = new byte[length];
        C.memmove(buffer, strPtr, (long)length);
        return new String(Converter.mbcsToWcs(buffer));
    }

    static long getStringPtr(String str) {
        byte[] buffer = Converter.wcsToMbcs(str != null ? str : "", true);
        long ptr = OS.g_malloc(buffer.length);
        C.memmove(ptr, buffer, (long)buffer.length);
        return ptr;
    }

    static long atkText_get_character_extents(long atkObject, long offset, long x, long y, long width, long height, long coords) {
        AtkTextIface iface;
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = (int)offset;
                event.end = (int)(offset + 1L);
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getTextBounds(event);
                }
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coords == 1L) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x -= topWindowX[0];
                    event.y -= topWindowY[0];
                }
                C.memmove(x, new int[]{event.x}, 4L);
                C.memmove(y, new int[]{event.y}, 4L);
                C.memmove(width, new int[]{event.width}, 4L);
                C.memmove(height, new int[]{event.height}, 4L);
                return 0L;
            }
        }
        if ((iface = AccessibleObject.getParentTextIface(atkObject)) != null && iface.get_character_extents != 0L) {
            OS.call(iface.get_character_extents, atkObject, offset, x, y, width, height, coords);
        }
        return 0L;
    }

    static long atkText_get_range_extents(long atkObject, long start_offset, long end_offset, long coord_type, long rect) {
        AtkTextIface iface;
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = (int)start_offset;
                event.end = (int)end_offset;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getTextBounds(event);
                }
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coord_type == 1L) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x -= topWindowX[0];
                    event.y -= topWindowY[0];
                }
                AtkTextRectangle atkRect = new AtkTextRectangle();
                atkRect.x = event.x;
                atkRect.y = event.y;
                atkRect.width = event.width;
                atkRect.height = event.height;
                ATK.memmove(rect, atkRect, AtkTextRectangle.sizeof);
                return 0L;
            }
        }
        if ((iface = AccessibleObject.getParentTextIface(atkObject)) != null && iface.get_range_extents != 0L) {
            ATK.call(iface.get_range_extents, atkObject, start_offset, end_offset, coord_type, rect);
        }
        return 0L;
    }

    static long atkText_get_run_attributes(long atkObject, long offset, long start_offset, long end_offset) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleAttributeListener> listeners = accessible.accessibleAttributeListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextAttributeEvent event = new AccessibleTextAttributeEvent(accessible);
                event.offset = (int)offset;
                for (int i = 0; i < length; ++i) {
                    AccessibleAttributeListener listener = listeners.get(i);
                    listener.getTextAttributes(event);
                }
                C.memmove(start_offset, new int[]{event.start}, 4L);
                C.memmove(end_offset, new int[]{event.end}, 4L);
                TextStyle style = event.textStyle;
                long result = 0L;
                AtkAttribute attr = new AtkAttribute();
                if (style != null) {
                    Color color;
                    Font font;
                    long attrPtr;
                    if (style.rise != 0) {
                        attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(10));
                        attr.value = AccessibleObject.getStringPtr(String.valueOf(style.rise));
                        ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr);
                    }
                    if (style.underline) {
                        attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(11));
                        String str = "none";
                        switch (style.underlineStyle) {
                            case 1: {
                                str = "double";
                                break;
                            }
                            case 0: {
                                str = "single";
                                break;
                            }
                            case 2: {
                                str = "error";
                                break;
                            }
                            case 3: {
                                str = "squiggle";
                            }
                        }
                        attr.value = AccessibleObject.getStringPtr(str);
                        ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr);
                    }
                    if (style.strikeout) {
                        attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(12));
                        attr.value = AccessibleObject.getStringPtr("1");
                        ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr);
                    }
                    if ((font = style.font) != null && !font.isDisposed()) {
                        long attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(17));
                        attr.value = OS.g_strdup(OS.pango_font_description_get_family(font.handle));
                        ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr2);
                        attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(13));
                        attr.value = AccessibleObject.getStringPtr(String.valueOf(OS.pango_font_description_get_size(font.handle) / 1024));
                        ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr2);
                        attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(27));
                        attr.value = OS.g_strdup(ATK.atk_text_attribute_get_value(27, OS.pango_font_description_get_style(font.handle)));
                        ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr2);
                        attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(26));
                        attr.value = OS.g_strdup(ATK.atk_text_attribute_get_value(26, OS.pango_font_description_get_variant(font.handle)));
                        ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr2);
                        attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(25));
                        attr.value = OS.g_strdup(ATK.atk_text_attribute_get_value(25, OS.pango_font_description_get_stretch(font.handle)));
                        ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr2);
                        attrPtr2 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(15));
                        attr.value = AccessibleObject.getStringPtr(String.valueOf(OS.pango_font_description_get_weight(font.handle)));
                        ATK.memmove(attrPtr2, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr2);
                    }
                    if ((color = style.foreground) != null && !color.isDisposed()) {
                        long attrPtr3 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(19));
                        attr.value = AccessibleObject.getStringPtr(color.handle.red * 255.0 + "," + color.handle.green * 255.0 + "," + color.handle.blue * 255.0);
                        ATK.memmove(attrPtr3, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr3);
                    }
                    if ((color = style.background) != null && !color.isDisposed()) {
                        long attrPtr4 = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = OS.g_strdup(ATK.atk_text_attribute_get_name(18));
                        attr.value = AccessibleObject.getStringPtr(color.handle.red * 255.0 + "," + color.handle.green * 255.0 + "," + color.handle.blue * 255.0);
                        ATK.memmove(attrPtr4, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr4);
                    }
                }
                if (event.attributes != null) {
                    int end = event.attributes.length / 2 * 2;
                    for (int i = 0; i < end; i += 2) {
                        long attrPtr = OS.g_malloc(AtkAttribute.sizeof);
                        attr.name = AccessibleObject.getStringPtr(event.attributes[i]);
                        attr.value = AccessibleObject.getStringPtr(event.attributes[i + 1]);
                        ATK.memmove(attrPtr, attr, AtkAttribute.sizeof);
                        result = OS.g_slist_append(result, attrPtr);
                    }
                }
                return result;
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getParentTextIface(atkObject);
        if (iface != null && iface.get_run_attributes != 0L) {
            parentResult = OS.call(iface.get_run_attributes, atkObject, offset, start_offset, end_offset);
        }
        return parentResult;
    }

    static long atkText_get_offset_at_point(long atkObject, long x, long y, long coords) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.x = (int)x;
                event.y = (int)y;
                int[] topWindowX = new int[1];
                int[] topWindowY = new int[1];
                if (coords == 1L) {
                    AccessibleObject.windowPoint(object, topWindowX, topWindowY);
                    event.x += topWindowX[0];
                    event.y += topWindowY[0];
                }
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getOffsetAtPoint(event);
                }
                return event.offset;
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getParentTextIface(atkObject);
        if (iface != null && iface.get_offset_at_point != 0L) {
            parentResult = OS.call(iface.get_offset_at_point, atkObject, x, y, coords);
        }
        return parentResult;
    }

    static long atkText_add_selection(long atkObject, long start_offset, long end_offset) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = (int)start_offset;
                event.end = (int)end_offset;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.addSelection(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getParentTextIface(atkObject);
        if (iface != null && iface.add_selection != 0L) {
            parentResult = ATK.call(iface.add_selection, atkObject, start_offset, end_offset);
        }
        return parentResult;
    }

    static long atkText_remove_selection(long atkObject, long selection_num) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.index = (int)selection_num;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.removeSelection(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getParentTextIface(atkObject);
        if (iface != null && iface.remove_selection != 0L) {
            parentResult = ATK.call(iface.remove_selection, atkObject, selection_num);
        }
        return parentResult;
    }

    static long atkText_set_caret_offset(long atkObject, long offset) {
        AtkTextIface iface;
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.offset = (int)offset;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.setCaretOffset(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        if ((iface = AccessibleObject.getParentTextIface(atkObject)) != null && iface.set_caret_offset != 0L) {
            return ATK.call(iface.set_caret_offset, atkObject, offset);
        }
        return 0L;
    }

    static long atkText_set_selection(long atkObject, long selection_num, long start_offset, long end_offset) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.index = (int)selection_num;
                event.start = (int)start_offset;
                event.end = (int)end_offset;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.setSelection(event);
                }
                return "OK".equals(event.result) ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getParentTextIface(atkObject);
        if (iface != null && iface.set_selection != 0L) {
            parentResult = OS.call(iface.set_selection, atkObject, selection_num, start_offset, end_offset);
        }
        return parentResult;
    }

    static long atkText_get_caret_offset(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getParentTextIface(atkObject);
        if (iface != null && iface.get_caret_offset != 0L) {
            parentResult = ATK.call(iface.get_caret_offset, atkObject);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getCaretOffset(event);
                }
                return event.offset;
            }
            List<AccessibleTextListener> listeners2 = accessible.accessibleTextListeners;
            length = AccessibleObject.size(listeners2);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(object.accessible);
                event.childID = object.id;
                event.offset = (int)parentResult;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextListener listener = listeners2.get(i);
                    listener.getCaretOffset(event);
                }
                return event.offset;
            }
        }
        return parentResult;
    }

    static long atkText_get_bounded_ranges(long atkObject, long rect, long coord_type, long x_clip_type, long y_clip_type) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                int end;
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                AtkTextRectangle atkRect = new AtkTextRectangle();
                ATK.memmove(atkRect, rect, AtkTextRectangle.sizeof);
                event.x = atkRect.x;
                event.y = atkRect.y;
                event.width = atkRect.width;
                event.height = atkRect.height;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getRanges(event);
                }
                int[] ranges = event.ranges;
                int size = ranges == null ? 1 : ranges.length / 2;
                long result = C.malloc(size * AtkTextRange.sizeof);
                AtkTextRange range = new AtkTextRange();
                int n = end = ranges != null ? ranges.length / 2 : 1;
                for (int j = 0; j < end; ++j) {
                    AccessibleTextExtendedListener listener;
                    int i;
                    if (ranges != null) {
                        int index = j * 2;
                        event.start = ranges[index];
                        event.end = ranges[index + 1];
                    }
                    event.count = 0;
                    event.type = 5;
                    for (i = 0; i < length; ++i) {
                        listener = listeners.get(i);
                        listener.getText(event);
                    }
                    range.start_offset = event.start;
                    range.end_offset = event.end;
                    range.content = AccessibleObject.getStringPtr(event.result);
                    event.result = null;
                    event.height = 0;
                    event.width = 0;
                    event.y = 0;
                    event.x = 0;
                    event.type = 0;
                    event.count = 0;
                    for (i = 0; i < length; ++i) {
                        listener = listeners.get(i);
                        listener.getTextBounds(event);
                    }
                    range.bounds.x = event.x;
                    range.bounds.y = event.y;
                    range.bounds.width = event.width;
                    range.bounds.height = event.height;
                    ATK.memmove(result + (long)(j * AtkTextRange.sizeof), range, AtkTextRange.sizeof);
                }
                return result;
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getParentTextIface(atkObject);
        if (iface != null && iface.get_bounded_ranges != 0L) {
            parentResult = ATK.call(iface.get_bounded_ranges, atkObject);
        }
        return parentResult;
    }

    static long atkText_get_character_at_offset(long atkObject, long offset) {
        AtkTextIface iface;
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = (int)offset;
                event.end = (int)(offset + 1L);
                event.type = 0;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getText(event);
                }
                String text = event.result;
                return text != null && text.length() > 0 ? (long)text.charAt(0) : 0L;
            }
            String text = object.getText();
            if (text != null && (long)text.length() > offset) {
                return text.charAt((int)offset);
            }
        }
        if ((iface = AccessibleObject.getParentTextIface(atkObject)) != null && iface.get_character_at_offset != 0L) {
            return ATK.call(iface.get_character_at_offset, atkObject, offset);
        }
        return 0L;
    }

    static long atkText_get_character_count(long atkObject) {
        AtkTextIface iface;
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getCharacterCount(event);
                }
                return event.count;
            }
            String text = object.getText();
            if (text != null) {
                return text.length();
            }
        }
        if ((iface = AccessibleObject.getParentTextIface(atkObject)) != null && iface.get_character_count != 0L) {
            return ATK.call(iface.get_character_count, atkObject);
        }
        return 0L;
    }

    static long atkText_get_n_selections(long atkObject) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getSelectionCount(event);
                }
                return event.count;
            }
            List<AccessibleTextListener> listeners2 = accessible.accessibleTextListeners;
            length = AccessibleObject.size(listeners2);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(object.accessible);
                event.childID = object.id;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextListener listener = listeners2.get(i);
                    listener.getSelectionRange(event);
                }
                if (event.length > 0) {
                    return 1L;
                }
            }
        }
        long parentResult = 0L;
        AtkTextIface iface = AccessibleObject.getParentTextIface(atkObject);
        if (iface != null && iface.get_n_selections != 0L) {
            parentResult = ATK.call(iface.get_n_selections, atkObject);
        }
        return parentResult;
    }

    static long atkText_get_selection(long atkObject, long selection_num, long start_offset, long end_offset) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        long parentResult = 0L;
        C.memmove(start_offset, new int[]{0}, 4L);
        C.memmove(end_offset, new int[]{0}, 4L);
        AtkTextIface iface = AccessibleObject.getParentTextIface(atkObject);
        if (iface != null && iface.get_selection != 0L) {
            parentResult = OS.call(iface.get_selection, atkObject, selection_num, start_offset, end_offset);
        }
        if (object != null) {
            List<AccessibleTextListener> listeners2;
            int[] parentStart = new int[1];
            int[] parentEnd = new int[1];
            C.memmove(parentStart, start_offset, 4L);
            C.memmove(parentEnd, end_offset, 4L);
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextExtendedListener listener;
                int i;
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.index = (int)selection_num;
                event.start = parentStart[0];
                event.end = parentEnd[0];
                for (i = 0; i < length; ++i) {
                    listener = listeners.get(i);
                    listener.getSelection(event);
                }
                parentStart[0] = event.start;
                parentEnd[0] = event.end;
                C.memmove(start_offset, parentStart, 4L);
                C.memmove(end_offset, parentEnd, 4L);
                event.index = 0;
                event.count = 0;
                event.type = 5;
                for (i = 0; i < length; ++i) {
                    listener = listeners.get(i);
                    listener.getText(event);
                }
                if (parentResult != 0L) {
                    OS.g_free(parentResult);
                }
                return AccessibleObject.getStringPtr(event.result);
            }
            if (selection_num == 0L && (length = AccessibleObject.size(listeners2 = accessible.accessibleTextListeners)) > 0) {
                String text;
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.childID = object.id;
                event.offset = parentStart[0];
                event.length = parentEnd[0] - parentStart[0];
                for (int i = 0; i < length; ++i) {
                    AccessibleTextListener listener = listeners2.get(i);
                    listener.getSelectionRange(event);
                }
                C.memmove(start_offset, new int[]{event.offset}, 4L);
                C.memmove(end_offset, new int[]{event.offset + event.length}, 4L);
                if (parentResult != 0L) {
                    OS.g_free(parentResult);
                }
                if ((text = object.getText()) != null && text.length() > event.offset && text.length() >= event.offset + event.length) {
                    return AccessibleObject.getStringPtr(text.substring(event.offset, event.offset + event.length));
                }
                if (iface != null && iface.get_text != 0L) {
                    return ATK.call(iface.get_text, atkObject, event.offset, event.offset + event.length);
                }
                return 0L;
            }
        }
        return parentResult;
    }

    static long atkText_get_text(long atkObject, long start_offset, long end_offset) {
        AtkTextIface iface;
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = (int)start_offset;
                event.end = (int)end_offset;
                event.type = 5;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getText(event);
                }
                return AccessibleObject.getStringPtr(event.result);
            }
            String text = object.getText();
            if (text != null && text.length() > 0) {
                end_offset = end_offset == -1L ? (long)text.length() : Math.min(end_offset, (long)text.length());
                start_offset = Math.min(start_offset, end_offset);
                text = text.substring((int)start_offset, (int)end_offset);
                return AccessibleObject.getStringPtr(text);
            }
        }
        if ((iface = AccessibleObject.getParentTextIface(atkObject)) != null && iface.get_text != 0L) {
            return ATK.call(iface.get_text, atkObject, start_offset, end_offset);
        }
        return 0L;
    }

    static long atkText_get_text_after_offset(long atkObject, long offset_value, long boundary_type, long start_offset, long end_offset) {
        AtkTextIface iface;
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                long charCount = AccessibleObject.atkText_get_character_count(atkObject);
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = event.end = (int)offset_value;
                event.count = 1;
                switch ((int)boundary_type) {
                    case 0: {
                        event.type = 0;
                        break;
                    }
                    case 1: {
                        event.type = 1;
                        break;
                    }
                    case 2: {
                        event.type = 1;
                        break;
                    }
                    case 3: {
                        event.type = 2;
                        break;
                    }
                    case 4: {
                        event.type = 2;
                        break;
                    }
                    case 5: {
                        event.type = 4;
                        break;
                    }
                    case 6: {
                        event.type = 4;
                    }
                }
                int eventStart = event.start;
                int eventEnd = event.end;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getText(event);
                }
                switch ((int)boundary_type) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener listener;
                        int i;
                        if ((long)event.end >= charCount) break;
                        int start = event.start;
                        event.start = eventStart;
                        event.end = eventEnd;
                        event.count = 2;
                        for (i = 0; i < length; ++i) {
                            listener = listeners.get(i);
                            listener.getText(event);
                        }
                        event.end = event.start;
                        event.start = start;
                        event.type = 5;
                        event.count = 0;
                        for (i = 0; i < length; ++i) {
                            listener = listeners.get(i);
                            listener.getText(event);
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener listener;
                        int i;
                        if (0 >= event.start) break;
                        int end = event.end;
                        event.start = eventStart;
                        event.end = eventEnd;
                        event.count = 0;
                        for (i = 0; i < length; ++i) {
                            listener = listeners.get(i);
                            listener.getText(event);
                        }
                        event.start = event.end;
                        event.end = end;
                        event.type = 5;
                        event.count = 0;
                        for (i = 0; i < length; ++i) {
                            listener = listeners.get(i);
                            listener.getText(event);
                        }
                        break;
                    }
                }
                C.memmove(start_offset, new int[]{event.start}, 4L);
                C.memmove(end_offset, new int[]{event.end}, 4L);
                return AccessibleObject.getStringPtr(event.result);
            }
            int offset = (int)offset_value;
            String text = object.getText();
            if (text != null && text.length() > 0) {
                length = text.length();
                int startBounds = offset = Math.min(offset, length - 1);
                int endBounds = offset;
                switch ((int)boundary_type) {
                    case 0: {
                        if (length <= offset) break;
                        break;
                    }
                    case 1: {
                        int wordStart1 = AccessibleObject.nextIndexOfChar(text, " !?.\n", offset - 1);
                        if (wordStart1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((wordStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart1)) == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = wordStart1;
                        int wordStart2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordStart1);
                        if (wordStart2 == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart2);
                        break;
                    }
                    case 2: {
                        int previousWordEnd = AccessibleObject.previousIndexOfNotChar(text, " \n", offset);
                        if (previousWordEnd == -1 || previousWordEnd != offset - 1) {
                            offset = AccessibleObject.nextIndexOfNotChar(text, " \n", offset);
                        }
                        if (offset == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        int wordEnd1 = AccessibleObject.nextIndexOfChar(text, " !?.\n", offset);
                        if (wordEnd1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((wordEnd1 = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd1)) == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = wordEnd1;
                        int wordEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", wordEnd1);
                        if (wordEnd2 == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((wordEnd2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd2);
                        break;
                    }
                    case 3: {
                        int previousSentenceEnd = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                        int previousText = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset);
                        int sentenceStart1 = 0;
                        if (previousSentenceEnd >= previousText) {
                            sentenceStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", offset);
                        } else {
                            sentenceStart1 = AccessibleObject.nextIndexOfChar(text, "!?.", offset);
                            if (sentenceStart1 == -1) {
                                startBounds = endBounds = length;
                                break;
                            }
                            sentenceStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart1);
                        }
                        if (sentenceStart1 == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = sentenceStart1;
                        int sentenceStart2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceStart1);
                        if (sentenceStart2 == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart2);
                        break;
                    }
                    case 4: {
                        int sentenceEnd1 = AccessibleObject.nextIndexOfChar(text, "!?.", offset);
                        if (sentenceEnd1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((sentenceEnd1 = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd1)) == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = sentenceEnd1;
                        int sentenceEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", sentenceEnd1);
                        if (sentenceEnd2 == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((sentenceEnd2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd2);
                        break;
                    }
                    case 5: {
                        int lineStart1 = text.indexOf(10, offset - 1);
                        if (lineStart1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        if ((lineStart1 = AccessibleObject.nextIndexOfNotChar(text, "\n", lineStart1)) == length) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = lineStart1;
                        int lineStart2 = text.indexOf(10, lineStart1);
                        if (lineStart2 == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = lineStart2 = AccessibleObject.nextIndexOfNotChar(text, "\n", lineStart2);
                        break;
                    }
                    case 6: {
                        int lineEnd1 = AccessibleObject.nextIndexOfChar(text, "\n", offset);
                        if (lineEnd1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        startBounds = lineEnd1;
                        if (startBounds == length) {
                            endBounds = length;
                            break;
                        }
                        int lineEnd2 = AccessibleObject.nextIndexOfChar(text, "\n", lineEnd1 + 1);
                        if (lineEnd2 == -1) {
                            endBounds = length;
                            break;
                        }
                        endBounds = lineEnd2;
                        break;
                    }
                }
                C.memmove(start_offset, new int[]{startBounds}, 4L);
                C.memmove(end_offset, new int[]{++endBounds}, 4L);
                text = text.substring(startBounds, endBounds);
                return AccessibleObject.getStringPtr(text);
            }
        }
        if ((iface = AccessibleObject.getParentTextIface(atkObject)) != null && iface.get_text_after_offset != 0L) {
            return ATK.call(iface.get_text_after_offset, atkObject, offset_value, boundary_type, start_offset, end_offset);
        }
        return 0L;
    }

    static long atkText_get_text_at_offset(long atkObject, long offset_value, long boundary_type, long start_offset, long end_offset) {
        AtkTextIface iface;
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                long charCount = AccessibleObject.atkText_get_character_count(atkObject);
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = event.end = (int)offset_value;
                event.count = 0;
                switch ((int)boundary_type) {
                    case 0: {
                        event.type = 0;
                        break;
                    }
                    case 1: {
                        event.type = 1;
                        break;
                    }
                    case 2: {
                        event.type = 1;
                        break;
                    }
                    case 3: {
                        event.type = 2;
                        break;
                    }
                    case 4: {
                        event.type = 2;
                        break;
                    }
                    case 5: {
                        event.type = 4;
                        break;
                    }
                    case 6: {
                        event.type = 4;
                    }
                }
                int eventStart = event.start;
                int eventEnd = event.end;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getText(event);
                }
                switch ((int)boundary_type) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener listener;
                        int i;
                        if ((long)event.end >= charCount) break;
                        int start = event.start;
                        event.start = eventStart;
                        event.end = eventEnd;
                        event.count = 1;
                        for (i = 0; i < length; ++i) {
                            listener = listeners.get(i);
                            listener.getText(event);
                        }
                        event.end = event.start;
                        event.start = start;
                        event.type = 5;
                        event.count = 0;
                        for (i = 0; i < length; ++i) {
                            listener = listeners.get(i);
                            listener.getText(event);
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener listener;
                        int i;
                        if (0 >= event.start) break;
                        int end = event.end;
                        event.start = eventStart;
                        event.end = eventEnd;
                        event.count = -1;
                        for (i = 0; i < length; ++i) {
                            listener = listeners.get(i);
                            listener.getText(event);
                        }
                        event.start = event.end;
                        event.end = end;
                        event.type = 5;
                        event.count = 0;
                        for (i = 0; i < length; ++i) {
                            listener = listeners.get(i);
                            listener.getText(event);
                        }
                        break;
                    }
                }
                C.memmove(start_offset, new int[]{event.start}, 4L);
                C.memmove(end_offset, new int[]{event.end}, 4L);
                return AccessibleObject.getStringPtr(event.result);
            }
            int offset = (int)offset_value;
            String text = object.getText();
            if (text != null && text.length() > 0) {
                length = text.length();
                int startBounds = offset = Math.min(offset, length - 1);
                int endBounds = offset;
                switch ((int)boundary_type) {
                    case 0: {
                        if (length <= offset) break;
                        break;
                    }
                    case 1: {
                        int wordStart1 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset);
                        if (wordStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        if ((wordStart1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordStart1) + 1) == -1) {
                            startBounds = 0;
                            break;
                        }
                        startBounds = wordStart1;
                        int wordStart2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordStart1);
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart2);
                        break;
                    }
                    case 2: {
                        int wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, "!?.", offset + 1);
                        wordEnd1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordEnd1);
                        wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd1 + 1);
                        if (wordEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        startBounds = wordEnd1 + 1;
                        int wordEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", startBounds);
                        if (wordEnd2 == length) {
                            endBounds = startBounds;
                            break;
                        }
                        if ((wordEnd2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                            endBounds = startBounds;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd2);
                        break;
                    }
                    case 3: {
                        int sentenceStart1 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset + 1);
                        if (sentenceStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        sentenceStart1 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceStart1) + 1;
                        startBounds = AccessibleObject.nextIndexOfNotChar(text, " \n", sentenceStart1);
                        int sentenceStart2 = AccessibleObject.nextIndexOfChar(text, "!?.", startBounds);
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart2);
                        break;
                    }
                    case 4: {
                        int sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, "!?.", offset + 1);
                        sentenceEnd1 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceEnd1);
                        sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd1 + 1);
                        if (sentenceEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        startBounds = sentenceEnd1 + 1;
                        int sentenceEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", startBounds);
                        if (sentenceEnd2 == length) {
                            endBounds = startBounds;
                            break;
                        }
                        if ((sentenceEnd2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                            endBounds = startBounds;
                            break;
                        }
                        endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd2);
                        break;
                    }
                    case 5: {
                        startBounds = AccessibleObject.previousIndexOfChar(text, "\n", offset) + 1;
                        int lineEnd2 = AccessibleObject.nextIndexOfChar(text, "\n", startBounds);
                        if (lineEnd2 < length) {
                            ++lineEnd2;
                        }
                        endBounds = lineEnd2;
                        break;
                    }
                    case 6: {
                        int lineEnd1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                        if (lineEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        startBounds = lineEnd1;
                        endBounds = AccessibleObject.nextIndexOfChar(text, "\n", lineEnd1 + 1);
                    }
                }
                C.memmove(start_offset, new int[]{startBounds}, 4L);
                C.memmove(end_offset, new int[]{++endBounds}, 4L);
                text = text.substring(startBounds, endBounds);
                return AccessibleObject.getStringPtr(text);
            }
        }
        if ((iface = AccessibleObject.getParentTextIface(atkObject)) != null && iface.get_text_at_offset != 0L) {
            return ATK.call(iface.get_text_at_offset, atkObject, offset_value, boundary_type, start_offset, end_offset);
        }
        return 0L;
    }

    static long atkText_get_text_before_offset(long atkObject, long offset_value, long boundary_type, long start_offset, long end_offset) {
        AtkTextIface iface;
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleTextExtendedListener> listeners = accessible.accessibleTextExtendedListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                long charCount = AccessibleObject.atkText_get_character_count(atkObject);
                AccessibleTextEvent event = new AccessibleTextEvent(accessible);
                event.start = event.end = (int)offset_value;
                event.count = -1;
                switch ((int)boundary_type) {
                    case 0: {
                        event.type = 0;
                        break;
                    }
                    case 1: {
                        event.type = 1;
                        break;
                    }
                    case 2: {
                        event.type = 1;
                        break;
                    }
                    case 3: {
                        event.type = 2;
                        break;
                    }
                    case 4: {
                        event.type = 2;
                        break;
                    }
                    case 5: {
                        event.type = 4;
                        break;
                    }
                    case 6: {
                        event.type = 4;
                    }
                }
                int eventStart = event.start;
                int eventEnd = event.end;
                for (int i = 0; i < length; ++i) {
                    AccessibleTextExtendedListener listener = listeners.get(i);
                    listener.getText(event);
                }
                C.memmove(start_offset, new int[]{event.start}, 4L);
                C.memmove(end_offset, new int[]{event.end}, 4L);
                switch ((int)boundary_type) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener listener;
                        int i;
                        if ((long)event.end >= charCount) break;
                        int start = event.start;
                        event.start = eventStart;
                        event.end = eventEnd;
                        event.count = 0;
                        for (i = 0; i < length; ++i) {
                            listener = listeners.get(i);
                            listener.getText(event);
                        }
                        event.end = event.start;
                        event.start = start;
                        event.type = 5;
                        event.count = 0;
                        for (i = 0; i < length; ++i) {
                            listener = listeners.get(i);
                            listener.getText(event);
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener listener;
                        int i;
                        if (0 >= event.start) break;
                        int end = event.end;
                        event.start = eventStart;
                        event.end = eventEnd;
                        event.count = -2;
                        for (i = 0; i < length; ++i) {
                            listener = listeners.get(i);
                            listener.getText(event);
                        }
                        event.start = event.end;
                        event.end = end;
                        event.type = 5;
                        event.count = 0;
                        for (i = 0; i < length; ++i) {
                            listener = listeners.get(i);
                            listener.getText(event);
                        }
                        break;
                    }
                }
                return AccessibleObject.getStringPtr(event.result);
            }
            int offset = (int)offset_value;
            String text = object.getText();
            if (text != null && text.length() > 0) {
                length = text.length();
                int startBounds = offset = Math.min(offset, length - 1);
                int endBounds = offset;
                switch ((int)boundary_type) {
                    case 0: {
                        if (length < offset || offset <= 0) break;
                        break;
                    }
                    case 1: {
                        int wordStart1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", offset - 1);
                        if (wordStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        int wordStart2 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", wordStart1);
                        if (wordStart2 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = wordStart1 + 1;
                        startBounds = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordStart2) + 1;
                        break;
                    }
                    case 2: {
                        int wordEnd1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", offset);
                        if (wordEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        if ((wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd1 + 1)) == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = wordEnd1 + 1;
                        int wordEnd2 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", endBounds);
                        if ((wordEnd2 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                            startBounds = 0;
                            break;
                        }
                        startBounds = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd2 + 1) + 1;
                        break;
                    }
                    case 3: {
                        int sentenceStart1 = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                        if (sentenceStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        int sentenceStart2 = AccessibleObject.previousIndexOfNotChar(text, "!?.", sentenceStart1);
                        if (sentenceStart2 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = sentenceStart1 + 1;
                        startBounds = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceStart2) + 1;
                        break;
                    }
                    case 4: {
                        int sentenceEnd1 = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                        if (sentenceEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        if ((sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd1 + 1)) == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = sentenceEnd1 + 1;
                        int sentenceEnd2 = AccessibleObject.previousIndexOfNotChar(text, "!?.", endBounds);
                        if ((sentenceEnd2 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                            startBounds = 0;
                            break;
                        }
                        startBounds = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd2 + 1) + 1;
                        break;
                    }
                    case 5: {
                        int lineStart1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                        if (lineStart1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = lineStart1 + 1;
                        startBounds = AccessibleObject.previousIndexOfChar(text, "\n", lineStart1) + 1;
                        break;
                    }
                    case 6: {
                        int lineEnd1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                        if (lineEnd1 == -1) {
                            endBounds = 0;
                            startBounds = 0;
                            break;
                        }
                        endBounds = lineEnd1;
                        startBounds = AccessibleObject.previousIndexOfChar(text, "\n", lineEnd1);
                        if (startBounds != -1) break;
                        startBounds = 0;
                        break;
                    }
                }
                C.memmove(start_offset, new int[]{--startBounds}, 4L);
                C.memmove(end_offset, new int[]{endBounds}, 4L);
                text = text.substring(startBounds, endBounds);
                return AccessibleObject.getStringPtr(text);
            }
        }
        if ((iface = AccessibleObject.getParentTextIface(atkObject)) != null && iface.get_text_before_offset != 0L) {
            return ATK.call(iface.get_text_before_offset, atkObject, offset_value, boundary_type, start_offset, end_offset);
        }
        return 0L;
    }

    static void setGValue(long value, Number number) {
        if (number == null) {
            return;
        }
        if (OS.G_VALUE_TYPE(value) != 0L) {
            OS.g_value_unset(value);
        }
        if (number instanceof Double) {
            OS.g_value_init(value, OS.G_TYPE_DOUBLE());
            OS.g_value_set_double(value, number.doubleValue());
        } else if (number instanceof Float) {
            OS.g_value_init(value, OS.G_TYPE_FLOAT());
            OS.g_value_set_float(value, number.floatValue());
        } else if (number instanceof Long) {
            OS.g_value_init(value, OS.G_TYPE_INT64());
            OS.g_value_set_int64(value, number.longValue());
        } else {
            OS.g_value_init(value, OS.G_TYPE_INT());
            OS.g_value_set_int(value, number.intValue());
        }
    }

    static Number getGValue(long value) {
        long type = OS.G_VALUE_TYPE(value);
        if (type == 0L) {
            return null;
        }
        if (type == OS.G_TYPE_DOUBLE()) {
            return OS.g_value_get_double(value);
        }
        if (type == OS.G_TYPE_FLOAT()) {
            return Float.valueOf(OS.g_value_get_float(value));
        }
        if (type == OS.G_TYPE_INT64()) {
            return OS.g_value_get_int64(value);
        }
        return OS.g_value_get_int(value);
    }

    static AtkValueIface getParentValueIface(long atkObject) {
        long type = OS.swt_fixed_accessible_get_type();
        if (OS.g_type_is_a(OS.g_type_parent(type), ATK.ATK_TYPE_VALUE())) {
            AtkValueIface iface = new AtkValueIface();
            ATK.memmove(iface, OS.g_type_interface_peek_parent(ATK.ATK_VALUE_GET_IFACE(atkObject)));
            return iface;
        }
        return null;
    }

    static long atkValue_get_current_value(long atkObject, long value) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        AtkValueIface iface = AccessibleObject.getParentValueIface(atkObject);
        if (iface != null && iface.get_current_value != 0L) {
            ATK.call(iface.get_current_value, atkObject, value);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleValueListener> listeners = accessible.accessibleValueListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleValueEvent event = new AccessibleValueEvent(accessible);
                event.value = AccessibleObject.getGValue(value);
                for (int i = 0; i < length; ++i) {
                    AccessibleValueListener listener = listeners.get(i);
                    listener.getCurrentValue(event);
                }
                AccessibleObject.setGValue(value, event.value);
            }
        }
        return 0L;
    }

    static long atkValue_get_maximum_value(long atkObject, long value) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        AtkValueIface iface = AccessibleObject.getParentValueIface(atkObject);
        if (iface != null && iface.get_maximum_value != 0L) {
            ATK.call(iface.get_maximum_value, atkObject, value);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleValueListener> listeners = accessible.accessibleValueListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleValueEvent event = new AccessibleValueEvent(accessible);
                event.value = AccessibleObject.getGValue(value);
                for (int i = 0; i < length; ++i) {
                    AccessibleValueListener listener = listeners.get(i);
                    listener.getMaximumValue(event);
                }
                AccessibleObject.setGValue(value, event.value);
            }
        }
        return 0L;
    }

    static long atkValue_get_minimum_value(long atkObject, long value) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        AtkValueIface iface = AccessibleObject.getParentValueIface(atkObject);
        if (iface != null && iface.get_minimum_value != 0L) {
            ATK.call(iface.get_minimum_value, atkObject, value);
        }
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleValueListener> listeners = accessible.accessibleValueListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleValueEvent event = new AccessibleValueEvent(accessible);
                event.value = AccessibleObject.getGValue(value);
                for (int i = 0; i < length; ++i) {
                    AccessibleValueListener listener = listeners.get(i);
                    listener.getMinimumValue(event);
                }
                AccessibleObject.setGValue(value, event.value);
            }
        }
        return 0L;
    }

    static long atkValue_set_current_value(long atkObject, long value) {
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            Accessible accessible = object.accessible;
            List<AccessibleValueListener> listeners = accessible.accessibleValueListeners;
            int length = AccessibleObject.size(listeners);
            if (length > 0) {
                AccessibleValueEvent event = new AccessibleValueEvent(accessible);
                event.value = AccessibleObject.getGValue(value);
                for (int i = 0; i < length; ++i) {
                    AccessibleValueListener listener = listeners.get(i);
                    listener.setCurrentValue(event);
                }
                return event.value != null ? 1L : 0L;
            }
        }
        long parentResult = 0L;
        AtkValueIface iface = AccessibleObject.getParentValueIface(atkObject);
        if (iface != null && iface.set_current_value != 0L) {
            parentResult = ATK.call(iface.set_current_value, atkObject, value);
        }
        return parentResult;
    }

    static AccessibleObject getAccessibleObject(long atkObject) {
        AccessibleObject object = AccessibleObjects.get(new LONG(atkObject));
        if (object == null) {
            return null;
        }
        if (object.accessible == null) {
            return null;
        }
        Control control = object.accessible.control;
        if (control == null || control.isDisposed()) {
            return null;
        }
        return object;
    }

    AccessibleObject getChildByID(int childId) {
        if (childId == -1) {
            return this;
        }
        if (childId == -2 || childId == -3) {
            return null;
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                AccessibleObject child = this.children[i];
                if (child == null || child.id != childId) continue;
                return child;
            }
        }
        return null;
    }

    AccessibleObject getChildByIndex(int childIndex) {
        if (this.children != null && childIndex < this.children.length) {
            return this.children[childIndex];
        }
        return null;
    }

    String getText() {
        List<AccessibleControlListener> listeners = this.accessible.accessibleControlListeners;
        int length = AccessibleObject.size(listeners);
        if (length > 0) {
            long parentResult;
            long characterCount;
            String parentText = "";
            AtkTextIface iface = AccessibleObject.getParentTextIface(this.atkHandle);
            if (iface != null && iface.get_character_count != 0L && (characterCount = ATK.call(iface.get_character_count, this.atkHandle)) > 0L && iface.get_text != 0L && (parentResult = ATK.call(iface.get_text, this.atkHandle, 0L, characterCount)) != 0L) {
                parentText = AccessibleObject.getString(parentResult);
                OS.g_free(parentResult);
            }
            AccessibleControlEvent event = new AccessibleControlEvent(this.accessible);
            event.childID = this.id;
            event.result = parentText;
            for (int i = 0; i < length; ++i) {
                AccessibleControlListener listener = listeners.get(i);
                listener.getValue(event);
            }
            return event.result;
        }
        return null;
    }

    static long gObjectClass_finalize(long atkObject) {
        AccessibleObject object = AccessibleObjects.get(new LONG(atkObject));
        if (object != null) {
            AccessibleObjects.remove(new LONG(atkObject));
        }
        return 0L;
    }

    static int toATKRelation(int relation) {
        switch (relation) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 15;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 10;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 11: {
                return 6;
            }
            case 12: {
                return 13;
            }
            case 13: {
                return 12;
            }
            case 14: {
                return 9;
            }
        }
        return 0;
    }

    static void windowPoint(AccessibleObject object, int[] x, int[] y) {
        long widget = GTK.gtk_accessible_get_widget(object.atkHandle);
        while (widget == 0L && object.parent != null) {
            object = object.parent;
            widget = GTK.gtk_accessible_get_widget(object.atkHandle);
        }
        if (widget == 0L) {
            return;
        }
        long topLevel = GTK.gtk_widget_get_toplevel(widget);
        long window = GTK.gtk_widget_get_window(topLevel);
        GDK.gdk_window_get_origin(window, x, y);
    }

    static int nextIndexOfChar(String string, String searchChars, int startIndex) {
        int result = string.length();
        for (int i = 0; i < searchChars.length(); ++i) {
            char current = searchChars.charAt(i);
            int index = string.indexOf(current, startIndex);
            if (index == -1) continue;
            result = Math.min(result, index);
        }
        return result;
    }

    static int nextIndexOfNotChar(String string, String searchChars, int startIndex) {
        char current;
        int index;
        int length = string.length();
        for (index = startIndex; index < length && searchChars.indexOf(current = string.charAt(index)) != -1; ++index) {
        }
        return index;
    }

    static int previousIndexOfChar(String string, String searchChars, int startIndex) {
        int result = -1;
        if (startIndex < 0) {
            return result;
        }
        string = string.substring(0, startIndex);
        for (int i = 0; i < searchChars.length(); ++i) {
            char current = searchChars.charAt(i);
            int index = string.lastIndexOf(current);
            if (index == -1) continue;
            result = Math.max(result, index);
        }
        return result;
    }

    static int previousIndexOfNotChar(String string, String searchChars, int startIndex) {
        char current;
        int index;
        if (startIndex < 0) {
            return -1;
        }
        for (index = startIndex - 1; index >= 0 && searchChars.indexOf(current = string.charAt(index)) != -1; --index) {
        }
        return index;
    }

    void addRelation(int type, Accessible target) {
        AccessibleObject targetAccessibleObject = target.getAccessibleObject();
        if (targetAccessibleObject != null) {
            ATK.atk_object_add_relationship(this.atkHandle, AccessibleObject.toATKRelation(type), targetAccessibleObject.atkHandle);
        }
    }

    void release() {
        this.accessible = null;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                AccessibleObject child = this.children[i];
                if (child == null) continue;
                OS.g_object_unref(child.atkHandle);
            }
            this.children = null;
        }
        if (this.isLightweight) {
            OS.g_object_unref(this.atkHandle);
        }
    }

    void removeRelation(int type, Accessible target) {
        AccessibleObject targetAccessibleObject = target.getAccessibleObject();
        if (targetAccessibleObject != null) {
            ATK.atk_object_remove_relationship(this.atkHandle, AccessibleObject.toATKRelation(type), targetAccessibleObject.atkHandle);
        }
    }

    void selectionChanged() {
        OS.g_signal_emit_by_name(this.atkHandle, ATK.selection_changed);
    }

    void sendEvent(int event, Object eventData) {
        switch (event) {
            case 32777: {
                OS.g_signal_emit_by_name(this.atkHandle, ATK.selection_changed);
                break;
            }
            case 32788: {
                OS.g_signal_emit_by_name(this.atkHandle, ATK.text_selection_changed);
                break;
            }
            case 32778: {
                if (!(eventData instanceof int[])) break;
                int[] array = (int[])eventData;
                int state = array[0];
                int value = array[1];
                int atkState = -1;
                switch (state) {
                    case 2: {
                        atkState = 21;
                        break;
                    }
                    case 0x200000: {
                        atkState = 20;
                        break;
                    }
                    case 0x1000000: {
                        atkState = 16;
                        break;
                    }
                    case 4: {
                        atkState = 11;
                        break;
                    }
                    case 0x100000: {
                        atkState = 10;
                        break;
                    }
                    case 8: {
                        atkState = 18;
                        break;
                    }
                    case 16: {
                        atkState = 4;
                        break;
                    }
                    case 512: {
                        atkState = 9;
                        break;
                    }
                    case 1024: {
                        atkState = 9;
                        break;
                    }
                    case 128: {
                        atkState = 2;
                        break;
                    }
                    case 2048: {
                        atkState = 3;
                        break;
                    }
                    case 64: {
                        atkState = 6;
                        break;
                    }
                    case 32768: {
                        atkState = 28;
                        break;
                    }
                    case 65536: {
                        atkState = 23;
                        break;
                    }
                    case 131072: {
                        atkState = 19;
                        break;
                    }
                    case 0x400000: {
                        break;
                    }
                    case 1: {
                        atkState = 7;
                        break;
                    }
                    case 0x4000000: {
                        atkState = 1;
                        break;
                    }
                    case 0x8000000: {
                        atkState = 24;
                        break;
                    }
                    case 0x10000000: {
                        atkState = 15;
                        break;
                    }
                    case 0x2000000: {
                        atkState = 32;
                        break;
                    }
                    case 0x20000000: {
                        atkState = 33;
                        break;
                    }
                    case 0x40000000: {
                        atkState = 34;
                    }
                }
                if (atkState == -1) break;
                ATK.atk_object_notify_state_change(this.atkHandle, atkState, value != 0);
                break;
            }
            case 32779: {
                List<AccessibleControlListener> listeners = this.accessible.accessibleControlListeners;
                int length = AccessibleObject.size(listeners);
                GdkRectangle rect = new GdkRectangle();
                if (length > 0) {
                    AccessibleControlEvent e = new AccessibleControlEvent(this.accessible);
                    e.childID = this.id;
                    for (int i = 0; i < length; ++i) {
                        AccessibleControlListener listener = listeners.get(i);
                        listener.getLocation(e);
                    }
                    rect.x = e.x;
                    rect.y = e.y;
                    rect.width = e.width;
                    rect.height = e.height;
                }
                OS.g_signal_emit_by_name(this.atkHandle, ATK.bounds_changed, rect);
                break;
            }
            case 32780: {
                OS.g_object_notify(this.atkHandle, ATK.accessible_name);
                break;
            }
            case 32781: {
                OS.g_object_notify(this.atkHandle, ATK.accessible_description);
                break;
            }
            case 32782: {
                OS.g_object_notify(this.atkHandle, ATK.accessible_value);
                break;
            }
            case 261: {
                OS.g_signal_emit_by_name(this.atkHandle, ATK.load_complete);
                break;
            }
            case 262: {
                OS.g_signal_emit_by_name(this.atkHandle, ATK.load_stopped);
                break;
            }
            case 263: {
                OS.g_signal_emit_by_name(this.atkHandle, ATK.reload);
                break;
            }
            case 273: {
                break;
            }
            case 274: {
                break;
            }
            case 256: {
                break;
            }
            case 264: {
                OS.g_object_notify(this.atkHandle, ATK.end_index);
                break;
            }
            case 265: {
                OS.g_object_notify(this.atkHandle, ATK.number_of_anchors);
                break;
            }
            case 266: {
                OS.g_object_notify(this.atkHandle, ATK.selected_link);
                break;
            }
            case 269: {
                OS.g_object_notify(this.atkHandle, ATK.start_index);
                break;
            }
            case 267: {
                OS.g_signal_emit_by_name(this.atkHandle, ATK.link_activated);
                break;
            }
            case 268: {
                if (!(eventData instanceof Integer)) break;
                int index = (Integer)eventData;
                OS.g_signal_emit_by_name(this.atkHandle, ATK.link_selected, index);
                break;
            }
            case 271: {
                OS.g_object_notify(this.atkHandle, ATK.accessible_hypertext_nlinks);
                break;
            }
            case 512: {
                long gType = OS.G_OBJECT_TYPE(this.atkHandle);
                if (gType == GTK.GTK_TYPE_TEXT_VIEW_ACCESSIBLE()) break;
                OS.g_signal_emit_by_name(this.atkHandle, ATK.attributes_changed);
                break;
            }
            case 515: {
                OS.g_object_notify(this.atkHandle, ATK.accessible_table_caption_object);
                break;
            }
            case 516: {
                OS.g_object_notify(this.atkHandle, ATK.accessible_table_column_description);
                break;
            }
            case 517: {
                OS.g_object_notify(this.atkHandle, ATK.accessible_table_column_header);
                break;
            }
            case 518: {
                if (!(eventData instanceof int[])) break;
                int[] array = (int[])eventData;
                int type = array[0];
                int rowStart = array[1];
                int rowCount = array[2];
                int columnStart = array[3];
                int columnCount = array[4];
                switch (type) {
                    case 1: {
                        if (rowCount > 0) {
                            OS.g_signal_emit_by_name(this.atkHandle, ATK.row_deleted, rowStart, rowCount);
                        }
                        if (columnCount <= 0) break;
                        OS.g_signal_emit_by_name(this.atkHandle, ATK.column_deleted, columnStart, columnCount);
                        break;
                    }
                    case 0: {
                        if (rowCount > 0) {
                            OS.g_signal_emit_by_name(this.atkHandle, ATK.row_inserted, rowStart, rowCount);
                        }
                        if (columnCount <= 0) break;
                        OS.g_signal_emit_by_name(this.atkHandle, ATK.column_inserted, columnStart, columnCount);
                    }
                }
                break;
            }
            case 519: {
                OS.g_object_notify(this.atkHandle, ATK.accessible_table_row_description);
                break;
            }
            case 520: {
                OS.g_object_notify(this.atkHandle, ATK.accessible_table_row_header);
                break;
            }
            case 521: {
                OS.g_object_notify(this.atkHandle, ATK.accessible_table_summary);
                break;
            }
            case 522: {
                OS.g_signal_emit_by_name(this.atkHandle, ATK.text_attributes_changed);
                break;
            }
            case 283: 
            case 285: {
                int offset = 0;
                List<AccessibleTextExtendedListener> listeners = this.accessible.accessibleTextExtendedListeners;
                int length = AccessibleObject.size(listeners);
                AccessibleTextEvent e = new AccessibleTextEvent(this.accessible);
                if (length > 0) {
                    for (int i = 0; i < length; ++i) {
                        AccessibleTextListener listener = listeners.get(i);
                        listener.getCaretOffset(e);
                    }
                } else {
                    List<AccessibleTextListener> listeners2 = this.accessible.accessibleTextListeners;
                    length = AccessibleObject.size(listeners2);
                    if (length > 0) {
                        e.childID = this.id;
                        for (int i = 0; i < length; ++i) {
                            AccessibleTextListener listener = listeners2.get(i);
                            listener.getCaretOffset(e);
                        }
                    }
                }
                offset = e.offset;
                OS.g_signal_emit_by_name(this.atkHandle, ATK.text_caret_moved, offset);
                break;
            }
            case 524: {
                if (!(eventData instanceof Object[])) break;
                Object[] data = (Object[])eventData;
                int type = (Integer)data[0];
                int start = (Integer)data[1];
                int end = (Integer)data[2];
                switch (type) {
                    case 1: {
                        OS.g_signal_emit_by_name(this.atkHandle, ATK.text_changed_delete, start, end - start);
                        break;
                    }
                    case 0: {
                        OS.g_signal_emit_by_name(this.atkHandle, ATK.text_changed_insert, start, end - start);
                    }
                }
                break;
            }
        }
    }

    void sendEvent(int event, Object eventData, int childID) {
        this.updateChildren();
        AccessibleObject accObject = this.getChildByID(childID);
        if (accObject != null) {
            accObject.sendEvent(event, eventData);
        }
    }

    void setFocus(int childID) {
        this.updateChildren();
        AccessibleObject accObject = this.getChildByID(childID);
        if (accObject != null) {
            OS.g_signal_emit_by_name(accObject.atkHandle, ATK.focus_event, 1L, 0L);
            ATK.atk_object_notify_state_change(accObject.atkHandle, 11, true);
        }
    }

    void textCaretMoved(int index) {
        OS.g_signal_emit_by_name(this.atkHandle, ATK.text_caret_moved, index);
    }

    void textChanged(int type, int startIndex, int length) {
        if (type == 1) {
            OS.g_signal_emit_by_name(this.atkHandle, ATK.text_changed_delete, startIndex, length);
        } else {
            OS.g_signal_emit_by_name(this.atkHandle, ATK.text_changed_insert, startIndex, length);
        }
    }

    void textSelectionChanged() {
        OS.g_signal_emit_by_name(this.atkHandle, ATK.text_selection_changed);
    }

    void updateChildren() {
        int i;
        List<AccessibleControlListener> listeners = this.accessible.accessibleControlListeners;
        int length = AccessibleObject.size(listeners);
        AccessibleControlEvent event = new AccessibleControlEvent(this.accessible);
        event.childID = this.id;
        for (int i2 = 0; i2 < length; ++i2) {
            AccessibleControlListener listener = listeners.get(i2);
            listener.getChildren(event);
        }
        Object[] children = event.children;
        AccessibleObject[] oldChildren = this.children;
        int count = children != null ? children.length : 0;
        AccessibleObject[] newChildren = new AccessibleObject[count];
        for (i = 0; i < count; ++i) {
            Object child = children[i];
            AccessibleObject object = null;
            if (child instanceof Integer) {
                int id = (Integer)child;
                AccessibleObject accessibleObject = object = oldChildren != null && i < oldChildren.length ? oldChildren[i] : null;
                if (object == null || object.id != id) {
                    event = new AccessibleControlEvent(this.accessible);
                    event.childID = id;
                    for (int j = 0; j < length; ++j) {
                        AccessibleControlListener listener = listeners.get(j);
                        listener.getChild(event);
                    }
                    if (event.accessible != null) {
                        object = event.accessible.getAccessibleObject();
                        if (object != null) {
                            OS.g_object_ref(object.atkHandle);
                        }
                    } else {
                        long type = OS.G_OBJECT_TYPE(this.accessible.getControlHandle());
                        long widget = this.accessible.getControlHandle();
                        object = new AccessibleObject(type, widget, this.accessible, true);
                    }
                    object.id = id;
                } else {
                    OS.g_object_ref(object.atkHandle);
                }
            } else if (child instanceof Accessible && (object = ((Accessible)child).getAccessibleObject()) != null) {
                OS.g_object_ref(object.atkHandle);
            }
            if (object == null) continue;
            object.index = i;
            object.parent = this;
            newChildren[i] = object;
        }
        if (oldChildren != null) {
            for (i = 0; i < oldChildren.length; ++i) {
                AccessibleObject object = oldChildren[i];
                if (object == null) continue;
                OS.g_object_unref(object.atkHandle);
            }
        }
        this.children = newChildren;
    }
}

