/*
 * Decompiled with CFR 0.152.
 */
package com.apple.misc;

import com.apple.util.PathResourceLocator;
import com.apple.util.ResourceLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;

public class StandardClassLoader
extends ClassLoader
implements Serializable {
    private static int _debuglvl = 0;
    protected static boolean _lisf = true;
    protected Hashtable _hash = new Hashtable();
    protected ResourceLocator _locator = null;

    static void setLookInSystemFirst(boolean bl) {
        if (_debuglvl >= 1) {
            System.err.println("StandardClassLoader: debug: " + (bl ? "" : "don't ") + "look in system first");
        }
        _lisf = bl;
    }

    public StandardClassLoader() {
        this.setResourceLocator(new PathResourceLocator());
    }

    public StandardClassLoader(ResourceLocator resourceLocator) {
        this.setResourceLocator(resourceLocator);
    }

    public void setResourceLocator(ResourceLocator resourceLocator) {
        this._locator = resourceLocator;
    }

    public ResourceLocator getResourceLocator() {
        return this._locator;
    }

    public URL getResource(String string) {
        URL uRL = null;
        if (_lisf && (uRL = ClassLoader.getSystemResource(string)) != null) {
            return uRL;
        }
        uRL = this._locator.getResource(string);
        if (uRL != null) {
            return uRL;
        }
        if (!_lisf) {
            uRL = ClassLoader.getSystemResource(string);
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (_lisf && (inputStream = ClassLoader.getSystemResourceAsStream(string)) != null) {
            return inputStream;
        }
        inputStream = this._locator.getResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        if (!_lisf) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
        }
        return inputStream;
    }

    private byte[] getClassImplementation(String string) {
        byte[] byArray;
        block3: {
            String string2 = string.replace('.', '/') + ".class";
            InputStream inputStream = this.getResourceAsStream(string2);
            if (_debuglvl >= 1) {
                System.err.println(this + ": debug: getClassImplementation(" + string + "), looking for " + string2 + ", got stream " + inputStream);
            }
            byArray = this.getClassImplementation(inputStream);
            if (inputStream == null) break block3;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    protected byte[] getClassImplementation(InputStream inputStream) {
        if (inputStream != null) {
            if (_debuglvl >= 1) {
                System.err.println(this + ": debug: getClassImplementation(" + inputStream + ")");
            }
            int n = 0;
            byte[] byArray = new byte[1024];
            try {
                int n2;
                n = n2 = inputStream.read(byArray);
                byte[] byArray2 = new byte[4096];
                while ((n2 = inputStream.read(byArray2)) > 0) {
                    if (n + n2 > byArray.length) {
                        byte[] byArray3 = new byte[n + n2];
                        System.arraycopy(byArray, 0, byArray3, 0, n);
                        byArray = byArray3;
                    }
                    System.arraycopy(byArray2, 0, byArray, n, n2);
                    n += n2;
                }
            }
            catch (IOException iOException) {
                if (_debuglvl >= 1) {
                    System.err.println(this + ": debug: class implementation cannot be read: " + iOException);
                    iOException.printStackTrace(System.err);
                }
                byArray = null;
            }
            if (byArray != null) {
                if (n < byArray.length) {
                    byte[] byArray4 = new byte[n];
                    System.arraycopy(byArray, 0, byArray4, 0, n);
                    byArray = byArray4;
                }
                if (_debuglvl >= 1) {
                    System.err.println(this + ": debug: class implementation is " + byArray.length + " byte" + (byArray.length != 1 ? "s" : "") + " long");
                }
            }
            return byArray;
        }
        return null;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        block19: {
            clazz = null;
            byte[] byArray = null;
            string = string.replace('/', '.');
            if (_debuglvl >= 1) {
                System.err.println(this + ": debug: request to load " + string + " and " + (bl ? "" : "not ") + "resolve it");
            }
            this.checkSecurity(string, false);
            clazz = this.findLoadedClass(string);
            if (clazz != null) {
                if (_debuglvl >= 2) {
                    System.err.println(this + ": debug: found class " + string + " in loaded classes");
                }
                return clazz;
            }
            if (_lisf) {
                try {
                    Class<?> clazz2 = this.findSystemClass(string);
                    if (_debuglvl >= 1) {
                        System.err.println(this + ": debug: found class " + string + " in system classes");
                    }
                    return clazz2;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            this.checkSecurity(string, true);
            byArray = this.getClassImplementation(string);
            if (byArray == null || byArray.length == 0) {
                if (!_lisf) {
                    try {
                        Class<?> clazz3 = this.findSystemClass(string);
                        if (_debuglvl >= 2) {
                            System.err.println(this + ": debug: found class " + string + " in system classes");
                        }
                        return clazz3;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (_debuglvl >= 2) {
                    System.err.println(this + ": debug: cannot find class " + string + ", raising");
                }
                throw new ClassNotFoundException(string);
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            if (clazz == null) {
                throw new ClassFormatError(string);
            }
            String string2 = string.replace('.', '/') + ".class";
            if (_debuglvl >= 3) {
                System.err.println(this + ": debug: entering class " + this.getResource(string2) + " (" + clazz + ") for name " + string + " into classes cache");
            }
            try {
                this._hash.put(this.getResource(string2).toString(), clazz);
            }
            catch (Exception exception) {
                if (_debuglvl < 1) break block19;
                System.err.println(this + ": couldn't enter class " + this.getResource(string2) + " (" + clazz + ") for name " + string + " into classes cache");
            }
        }
        if (bl) {
            if (_debuglvl >= 3) {
                System.err.println(this + ": debug: resolving " + clazz);
            }
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected void checkSecurity(String string, boolean bl) {
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
            if (bl) {
                securityManager.checkPackageDefinition(string.substring(0, n));
            } else {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
        }
    }

    static {
        try {
            String string;
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(new File(System.getProperty("java.home"), "lib" + File.separator + "javastuff.properties")));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                properties.load(new FileInputStream(new File(System.getProperty("user.home"), "lib" + File.separator + "javastuff.properties")));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                string = properties.getProperty("logfile", "");
                if (!string.equals("")) {
                    File file;
                    File file2 = new File(string = string.replace('/', File.separatorChar));
                    if (!file2.isAbsolute()) {
                        file2 = new File(System.getProperty("user.home"), file2.toString());
                    }
                    if (!(file = new File(file2.getParent())).exists()) {
                        file.mkdirs();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    System.setErr(new PrintStream(fileOutputStream));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = properties.getProperty("standardclassloader.debug", "0");
                _debuglvl = Integer.valueOf(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = properties.getProperty("standardclassloader.lisf", "true");
                _lisf = Boolean.valueOf(string);
            }
            catch (Exception exception) {
            }
        }
        catch (Exception exception) {}
    }
}

