import yoda

# FSR corrections coefficients to be applied as sigma * (1 - fsr / 100.0)
wp_eta_fsr = [ 1.62, 1.75, 2.41, 1.43, 2.01, 1.51, 2.32, 2.05 ]
wm_eta_fsr = [ 1.84, 1.46, 1.03, 7.20, 9.30, 1.71, 1.22, 0.00 ]

# Placeholders for W bosons cross-sections without FSR corrections to be used in ratio and assymetries calculations
h_wp_eta_fsr = None
h_wm_eta_fsr = None

needs_patching_fsr_bw = {
 'd02-x01-y01' : (3, wp_eta_fsr),
 'd02-x01-y02' : (4, wm_eta_fsr),
}

needs_patching_ratio = {
 'd03-x01-y01' : (2),
}

needs_patching_asymm = {
 'd04-x01-y01' : (2),
}

def patch(path, ao):
    hname = path.split('/')[-1]
    ident = hname.split('-')[0]
    global h_wp_eta_fsr, h_wm_eta_fsr
    # Undo FSR corrections and save into new object, devide cross-sections bins by bin width
    if hname in needs_patching_fsr_bw:
        nbin = 1
        yid, fsr = needs_patching_fsr_bw[hname]
        aos = [ ao ]
        newName ='%s-x01-y0%i' % (ident, yid)
        newPath = path.replace(hname, newName)
        newAo = yoda.Estimate1D(ao.xEdges(), newPath)
        for newBin in newAo.bins():
            oldBin = ao.bin(nbin)
            newBin.setVal( oldBin.val() * (1 - fsr[nbin-1] / 100.0) / (ao.xEdges()[nbin]-ao.xEdges()[nbin-1]) )
            oldBin.setVal( oldBin.val() / (ao.xEdges()[nbin]-ao.xEdges()[nbin-1]) )
            sources = oldBin.sources()
            errs = [ (s, oldBin.err(s)) for s in sources ]
            for label, epair in errs:
                newBin.setErr(epair, label)
            nbin = nbin + 1
        if newName == "d02-x01-y03" : h_wp_eta_fsr=newAo
        if newName == "d02-x01-y04" : h_wm_eta_fsr=newAo
        aos.append(newAo)
        return aos
    # Calculate ratios for new cross-sections without FSR corrections
    if hname in needs_patching_ratio:
        nbin = 1
        yid = needs_patching_ratio[hname]
        aos = [ ao ]
        newName ='%s-x01-y0%i' % (ident, yid)
        newPath = path.replace(hname, newName)
        newAo = yoda.Estimate1D(ao.xEdges(), newPath)
        for newBin in newAo.bins():
            oldBin = ao.bin(nbin)
            if (h_wp_eta_fsr and h_wm_eta_fsr): newBin.setVal( h_wp_eta_fsr.bin(nbin).val() / h_wm_eta_fsr.bin(nbin).val() )
            else: newBin.setVal( oldBin.val() )
            sources = oldBin.sources()
            errs = [ (s, oldBin.err(s)) for s in sources ]
            for label, epair in errs:
                newBin.setErr(epair, label)
            nbin = nbin + 1
        aos.append(newAo)
        return aos
    # Calculate asymmetries for new cross-sections without FSR corrections
    if hname in needs_patching_asymm:
        nbin = 1
        yid = needs_patching_asymm[hname]
        aos = [ ao ]
        newName ='%s-x01-y0%i' % (ident, yid)
        newPath = path.replace(hname, newName)
        newAo = yoda.Estimate1D(ao.xEdges(), newPath)
        for newBin in newAo.bins():
            oldBin = ao.bin(nbin)
            if (h_wp_eta_fsr and h_wm_eta_fsr): newBin.setVal( (h_wp_eta_fsr.bin(nbin).val() - h_wm_eta_fsr.bin(nbin).val()) / (h_wp_eta_fsr.bin(nbin).val() + h_wm_eta_fsr.bin(nbin).val()) )
            else: newBin.setVal( oldBin.val() )
            sources = oldBin.sources()
            errs = [ (s, oldBin.err(s)) for s in sources ]
            for label, epair in errs:
                newBin.setErr(epair, label)
            nbin = nbin + 1
        aos.append(newAo)
        return aos
    return [ ao ]
