/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hc.client5.http.cache.CacheControl;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class ResponseCacheControl
implements CacheControl {
    private final long maxAge;
    private final long sharedMaxAge;
    private final boolean noCache;
    private final boolean noStore;
    private final boolean cachePrivate;
    private final boolean mustRevalidate;
    private final boolean proxyRevalidate;
    private final boolean cachePublic;
    private final boolean mustUnderstand;
    private final long staleWhileRevalidate;
    private final long staleIfError;
    private final Set<String> noCacheFields;
    private final boolean undefined;
    private final boolean immutable;
    public static final ResponseCacheControl DEFAULT = ResponseCacheControl.builder().build();

    ResponseCacheControl(long maxAge, long sharedMaxAge, boolean mustRevalidate, boolean noCache, boolean noStore, boolean cachePrivate, boolean proxyRevalidate, boolean cachePublic, long staleWhileRevalidate, long staleIfError, Set<String> noCacheFields, boolean mustUnderstand, boolean immutable) {
        this.maxAge = maxAge;
        this.sharedMaxAge = sharedMaxAge;
        this.noCache = noCache;
        this.noStore = noStore;
        this.cachePrivate = cachePrivate;
        this.mustRevalidate = mustRevalidate;
        this.proxyRevalidate = proxyRevalidate;
        this.cachePublic = cachePublic;
        this.staleWhileRevalidate = staleWhileRevalidate;
        this.staleIfError = staleIfError;
        this.noCacheFields = noCacheFields != null ? Collections.unmodifiableSet(noCacheFields) : Collections.emptySet();
        this.undefined = maxAge == -1L && sharedMaxAge == -1L && !noCache && !noStore && !cachePrivate && !mustRevalidate && !proxyRevalidate && !cachePublic && staleWhileRevalidate == -1L && staleIfError == -1L;
        this.mustUnderstand = mustUnderstand;
        this.immutable = immutable;
    }

    @Override
    public long getMaxAge() {
        return this.maxAge;
    }

    public long getSharedMaxAge() {
        return this.sharedMaxAge;
    }

    @Override
    public boolean isNoCache() {
        return this.noCache;
    }

    @Override
    public boolean isNoStore() {
        return this.noStore;
    }

    public boolean isCachePrivate() {
        return this.cachePrivate;
    }

    public boolean isMustUnderstand() {
        return this.mustUnderstand;
    }

    public boolean isMustRevalidate() {
        return this.mustRevalidate;
    }

    public boolean isProxyRevalidate() {
        return this.proxyRevalidate;
    }

    public boolean isPublic() {
        return this.cachePublic;
    }

    public long getStaleWhileRevalidate() {
        return this.staleWhileRevalidate;
    }

    @Override
    public long getStaleIfError() {
        return this.staleIfError;
    }

    public Set<String> getNoCacheFields() {
        return this.noCacheFields;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        if (this.maxAge >= 0L) {
            buf.append("max-age=").append(this.maxAge).append(",");
        }
        if (this.sharedMaxAge >= 0L) {
            buf.append("shared-max-age=").append(this.sharedMaxAge).append(",");
        }
        if (this.noCache) {
            buf.append("no-cache").append(",");
        }
        if (this.noStore) {
            buf.append("no-store").append(",");
        }
        if (this.cachePrivate) {
            buf.append("private").append(",");
        }
        if (this.cachePublic) {
            buf.append("public").append(",");
        }
        if (this.mustRevalidate) {
            buf.append("must-revalidate").append(",");
        }
        if (this.proxyRevalidate) {
            buf.append("proxy-revalidate").append(",");
        }
        if (this.staleWhileRevalidate >= 0L) {
            buf.append("state-while-revalidate=").append(this.staleWhileRevalidate).append(",");
        }
        if (this.staleIfError >= 0L) {
            buf.append("stale-if-error").append(this.staleIfError).append(",");
        }
        if (this.mustUnderstand) {
            buf.append("must-understand").append(",");
        }
        if (this.immutable) {
            buf.append("immutable").append(",");
        }
        if (buf.charAt(buf.length() - 1) == ',') {
            buf.setLength(buf.length() - 1);
        }
        buf.append("]");
        return buf.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long maxAge = -1L;
        private long sharedMaxAge = -1L;
        private boolean noCache;
        private boolean noStore;
        private boolean cachePrivate;
        private boolean mustRevalidate;
        private boolean proxyRevalidate;
        private boolean cachePublic;
        private long staleWhileRevalidate = -1L;
        private long staleIfError = -1L;
        private Set<String> noCacheFields;
        private boolean mustUnderstand;
        private boolean immutable;

        Builder() {
        }

        public long getMaxAge() {
            return this.maxAge;
        }

        public Builder setMaxAge(long maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public long getSharedMaxAge() {
            return this.sharedMaxAge;
        }

        public Builder setSharedMaxAge(long sharedMaxAge) {
            this.sharedMaxAge = sharedMaxAge;
            return this;
        }

        public boolean isNoCache() {
            return this.noCache;
        }

        public Builder setNoCache(boolean noCache) {
            this.noCache = noCache;
            return this;
        }

        public boolean isNoStore() {
            return this.noStore;
        }

        public Builder setNoStore(boolean noStore) {
            this.noStore = noStore;
            return this;
        }

        public boolean isCachePrivate() {
            return this.cachePrivate;
        }

        public Builder setCachePrivate(boolean cachePrivate) {
            this.cachePrivate = cachePrivate;
            return this;
        }

        public boolean isMustRevalidate() {
            return this.mustRevalidate;
        }

        public Builder setMustRevalidate(boolean mustRevalidate) {
            this.mustRevalidate = mustRevalidate;
            return this;
        }

        public boolean isProxyRevalidate() {
            return this.proxyRevalidate;
        }

        public Builder setProxyRevalidate(boolean proxyRevalidate) {
            this.proxyRevalidate = proxyRevalidate;
            return this;
        }

        public boolean isCachePublic() {
            return this.cachePublic;
        }

        public Builder setCachePublic(boolean cachePublic) {
            this.cachePublic = cachePublic;
            return this;
        }

        public long getStaleWhileRevalidate() {
            return this.staleWhileRevalidate;
        }

        public Builder setStaleWhileRevalidate(long staleWhileRevalidate) {
            this.staleWhileRevalidate = staleWhileRevalidate;
            return this;
        }

        public long getStaleIfError() {
            return this.staleIfError;
        }

        public Builder setStaleIfError(long staleIfError) {
            this.staleIfError = staleIfError;
            return this;
        }

        public Set<String> getNoCacheFields() {
            return this.noCacheFields;
        }

        public Builder setNoCacheFields(Set<String> noCacheFields) {
            this.noCacheFields = noCacheFields;
            return this;
        }

        public Builder setNoCacheFields(String ... noCacheFields) {
            this.noCacheFields = new HashSet<String>();
            this.noCacheFields.addAll(Arrays.asList(noCacheFields));
            return this;
        }

        public boolean isMustUnderstand() {
            return this.mustUnderstand;
        }

        public Builder setMustUnderstand(boolean mustUnderstand) {
            this.mustUnderstand = mustUnderstand;
            return this;
        }

        public boolean isImmutable() {
            return this.immutable;
        }

        public Builder setImmutable(boolean immutable) {
            this.immutable = immutable;
            return this;
        }

        public ResponseCacheControl build() {
            return new ResponseCacheControl(this.maxAge, this.sharedMaxAge, this.mustRevalidate, this.noCache, this.noStore, this.cachePrivate, this.proxyRevalidate, this.cachePublic, this.staleWhileRevalidate, this.staleIfError, this.noCacheFields, this.mustUnderstand, this.immutable);
        }
    }
}

