/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile;

import io.github.dmlloyd.classfile.AnnotationElement;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.AnnotationImpl;
import io.github.dmlloyd.classfile.impl.TemporaryConstantPool;
import io.github.dmlloyd.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Annotation {
    public Utf8Entry className();

    default public ClassDesc classSymbol() {
        return Util.fieldTypeSymbol(this.className());
    }

    public List<AnnotationElement> elements();

    public static Annotation of(Utf8Entry annotationClass, List<AnnotationElement> elements) {
        return new AnnotationImpl(annotationClass, elements);
    }

    public static Annotation of(Utf8Entry annotationClass, AnnotationElement ... elements) {
        return Annotation.of(annotationClass, List.of(elements));
    }

    public static Annotation of(ClassDesc annotationClass, List<AnnotationElement> elements) {
        return Annotation.of(TemporaryConstantPool.INSTANCE.utf8Entry(annotationClass), elements);
    }

    public static Annotation of(ClassDesc annotationClass, AnnotationElement ... elements) {
        return Annotation.of(TemporaryConstantPool.INSTANCE.utf8Entry(annotationClass), elements);
    }
}

